/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.srf;

import it.tidalwave.imageio.io.RAWImageInputStreamImpl;
import it.tidalwave.imageio.srf.SonyDecipher;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.stream.ImageInputStream;

public class SRFImageInputStream
extends RAWImageInputStreamImpl {
    private SonyDecipher decipher;
    private ImageInputStream delegate;
    private ImageInputStream originalDelegate;
    private ByteBuffer byteBuffer;
    private long startOfEncryptedSection;

    public SRFImageInputStream(ImageInputStream delegate) {
        super(delegate);
        this.delegate = this.originalDelegate = delegate;
    }

    public void setDecryptionKey(int key) {
        this.decipher = new SonyDecipher(key);
    }

    public void startEncryptedSection(int size) throws IOException {
        if (this.decipher == null) {
            throw new IllegalArgumentException("The decryption key has not been set");
        }
        this.startOfEncryptedSection = this.delegate.getStreamPosition();
        this.decipher.decrypt(this.originalDelegate, size);
        this.byteBuffer = this.decipher.getByteBuffer();
    }

    public void startEncryptedSection(long pos, ByteBuffer byteBuffer) {
        this.startOfEncryptedSection = pos;
        this.byteBuffer = byteBuffer;
    }

    public void stopEncryptedSection() throws IOException {
        this.originalDelegate.seek(this.getStreamPosition());
        this.byteBuffer = null;
        this.delegate = this.originalDelegate;
    }

    public int read() throws IOException {
        if (this.byteBuffer != null) {
            return this.byteBuffer.get() & 0xFF;
        }
        return this.delegate.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.byteBuffer != null) {
            this.byteBuffer.get(b, off, len);
            return len;
        }
        return this.delegate.read(b, off, len);
    }

    public int skipBytes(int n) throws IOException {
        if (this.byteBuffer != null) {
            this.byteBuffer.position(this.byteBuffer.position() + n);
            return n;
        }
        return this.delegate.skipBytes(n);
    }

    public long skipBytes(long n) throws IOException {
        if (this.byteBuffer != null) {
            this.byteBuffer.position(this.byteBuffer.position() + (int)n);
            return n;
        }
        return this.delegate.skipBytes(n);
    }

    public long getStreamPosition() throws IOException {
        if (this.byteBuffer != null) {
            return this.startOfEncryptedSection + (long)this.byteBuffer.position();
        }
        return this.delegate.getStreamPosition();
    }

    public void seek(long pos) throws IOException {
        if (this.byteBuffer != null) {
            this.byteBuffer.position((int)(pos - this.startOfEncryptedSection));
            return;
        }
        this.delegate.seek(pos);
    }
}

