/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.srf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;

public class SonyDecipher {
    private int key;
    private byte[] data = new byte[0];
    private int[] pad = new int[128];
    private int padScan;
    private boolean initialized = false;
    private ByteBuffer byteBuffer;

    public SonyDecipher(int key) {
        this.key = key;
    }

    public void decrypt(ImageInputStream iis, int size) throws IOException {
        if (size % 4 != 0) {
            throw new IllegalArgumentException("size must be a multiple of 4");
        }
        if (this.data.length < size) {
            this.data = new byte[size];
            this.byteBuffer = ByteBuffer.allocate(size);
            this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
        }
        iis.readFully(this.data);
        if (!this.initialized) {
            this.initialize();
        }
        ByteBuffer tempByteBuffer = ByteBuffer.wrap(this.data);
        tempByteBuffer.order(ByteOrder.BIG_ENDIAN);
        this.byteBuffer.rewind();
        for (int i = 0; i < size / 4; ++i) {
            int mask = this.pad[this.padScan + 1 & 0x7F] ^ this.pad[this.padScan + 65 & 0x7F];
            this.pad[this.padScan++ & 0x7F] = mask;
            int v = tempByteBuffer.getInt() ^ mask;
            this.byteBuffer.putInt(v);
        }
        this.byteBuffer.rewind();
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    private void initialize() {
        int p;
        for (p = 0; p < 4; ++p) {
            this.pad[p] = this.key = (int)(((long)this.key & 0xFFFFFFFFFFFFFFFFL) * 48828125L + 1L);
        }
        this.pad[3] = this.pad[3] << 1 | (this.pad[0] ^ this.pad[2]) >>> 31;
        for (p = 4; p < 127; ++p) {
            this.pad[p] = (this.pad[p - 4] ^ this.pad[p - 2]) << 1 | (this.pad[p - 3] ^ this.pad[p - 1]) >>> 31;
        }
        this.padScan = 127;
        this.initialized = true;
    }
}

