/*
 * Decompiled with CFR 0.152.
 */
package it.tidalwave.imageio.srf;

import it.tidalwave.imageio.io.RAWImageInputStream;
import it.tidalwave.imageio.raw.Directory;
import it.tidalwave.imageio.raw.TagRational;
import it.tidalwave.imageio.srf.SRFImageInputStream;
import it.tidalwave.imageio.srf.SonyDecipher;
import it.tidalwave.imageio.srf.SonySRF0;
import it.tidalwave.imageio.srf.SonySRF1;
import it.tidalwave.imageio.srf.SonySRF2;
import it.tidalwave.imageio.tiff.IFDSupport;
import it.tidalwave.imageio.util.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.imageio.stream.MemoryCacheImageInputStream;

public class SonyMakerNote
extends IFDSupport {
    private static final long serialVersionUID = -3814200534424599307L;
    private static final String CLASS = SonyMakerNote.class.getName();
    private static final Logger logger = Logger.getLogger(CLASS);
    private static final int MAKER_NOTE_KEY_OFFSET = 200896;
    private static final int FIRST_ENCRYPTED_BLOCK_BYTE_COUNT = 36296;
    private static final int SECOND_ENCRYPTED_BLOCK_BYTE_COUNT = 697504;
    private static final int SECOND_ENCRYPTED_BLOCK_OFFSET = 40;
    private static final int MAKER_NOTE_BYTE_COUNT = 697544;

    public void loadAll(@Nonnull RAWImageInputStream iis, @Nonnegative long offset) throws IOException {
        logger.fine("loadAll(%s, %d)", iis, offset);
        int makerNoteKey = this.getMakerNoteKey(iis);
        SonySRF0 srf0 = new SonySRF0();
        this.setSRF(0, srf0);
        logger.finer(">>>> loading plaintext SRF0 AT %d", offset);
        long nextOffset = srf0.load(iis, offset);
        byte[] buffer = new byte[697544];
        iis.seek(nextOffset);
        iis.readFully(buffer);
        MemoryCacheImageInputStream iis2 = new MemoryCacheImageInputStream(new ByteArrayInputStream(buffer));
        iis2.setByteOrder(ByteOrder.BIG_ENDIAN);
        SonyDecipher decipher = new SonyDecipher(makerNoteKey);
        decipher.decrypt(iis2, 36296);
        decipher.getByteBuffer().rewind();
        decipher.getByteBuffer().get(buffer, 0, 36296);
        ByteBuffer bb = ByteBuffer.wrap(buffer);
        bb.order(ByteOrder.BIG_ENDIAN);
        ((SRFImageInputStream)iis).startEncryptedSection(nextOffset, bb);
        SonySRF1 srf1 = new SonySRF1();
        this.setSRF(1, srf1);
        logger.fine("Loading encrypted SRF1 AT %d", nextOffset);
        long srf1Offset = nextOffset;
        nextOffset = srf1.load(iis, nextOffset);
        iis2 = new MemoryCacheImageInputStream(new ByteArrayInputStream(buffer));
        iis2.setByteOrder(ByteOrder.BIG_ENDIAN);
        iis2.seek(40L);
        decipher = new SonyDecipher(srf1.getSRF2Key());
        decipher.decrypt(iis2, 697504);
        decipher.getByteBuffer().get(buffer, 40, 697504);
        bb = ByteBuffer.wrap(buffer);
        bb.order(ByteOrder.BIG_ENDIAN);
        ((SRFImageInputStream)iis).startEncryptedSection(srf1Offset, bb);
        int srfIndex = 2;
        while (nextOffset > 0L) {
            Directory srf;
            try {
                Class<?> srfClass = Class.forName("it.tidalwave.imageio.srf.SonySRF" + srfIndex);
                srf = (Directory)srfClass.newInstance();
            }
            catch (Exception e) {
                throw new IOException(e.toString());
            }
            this.setSRF(srfIndex, srf);
            logger.finer(">>>> loading encrypted SRF%d AT %d", srfIndex, nextOffset);
            nextOffset = srf.load(iis, nextOffset);
            ++srfIndex;
        }
        ((SRFImageInputStream)iis).stopEncryptedSection();
    }

    private void setSRF(int i, Directory srf) {
        this.addNamedDirectory("SRF" + i, srf);
    }

    @Nonnull
    public SonySRF0 getSRF0() {
        return (SonySRF0)this.getNamedDirectory("SRF0");
    }

    @Nonnull
    public SonySRF1 getSRF1() {
        return (SonySRF1)this.getNamedDirectory("SRF1");
    }

    @Nonnull
    public SonySRF2 getSRF2() {
        return (SonySRF2)this.getNamedDirectory("SRF2");
    }

    @Nonnull
    public String getColorMode() {
        return "UNKNOWN";
    }

    @Nonnull
    public String getToneCompensation() {
        return "UNKNOWN";
    }

    public boolean isCompressionDataAvailable() {
        return false;
    }

    public int[] getLinearizationTable() {
        return null;
    }

    public byte[] getCurve() {
        return null;
    }

    @Nonnull
    public String getWhiteBalance() {
        return "SUNNY";
    }

    public boolean isWhiteBalanceFineAvailable() {
        return false;
    }

    public int getWhiteBalanceFine() {
        return 0;
    }

    @Nonnull
    public TagRational[] getWhiteBalanceRBCoefficients() {
        TagRational ONE = new TagRational(1, 1);
        return new TagRational[]{ONE, ONE};
    }

    private int getMakerNoteKey(@Nonnull RAWImageInputStream iis) throws IOException {
        iis.seek(200896L);
        int skip = iis.readByte() & 0xFF;
        iis.skipBytes(skip * 4 - 1);
        ByteOrder byteOrderSave = iis.getByteOrder();
        iis.setByteOrder(ByteOrder.BIG_ENDIAN);
        int ifdKey = iis.readInt();
        iis.setByteOrder(byteOrderSave);
        return ifdKey;
    }
}

