/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.media.jai.ImageJAI;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.MultiResolutionRenderableImage;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.RenderedOp;
import javax.media.jai.WritablePropertySourceImpl;

public class ImageMIPMap
implements ImageJAI {
    protected RenderedImage highestImage;
    protected RenderedImage currentImage;
    protected int currentLevel;
    protected RenderedOp downSampler;
    protected PropertyChangeSupportJAI eventManager;
    protected WritablePropertySourceImpl properties;

    protected ImageMIPMap() {
        this.currentLevel = 0;
        this.eventManager = null;
        this.properties = null;
        this.eventManager = new PropertyChangeSupportJAI(this);
        this.properties = new WritablePropertySourceImpl(null, null, this.eventManager);
    }

    public ImageMIPMap(RenderedImage renderedImage, AffineTransform affineTransform, Interpolation interpolation) {
        this();
        if (renderedImage == null || affineTransform == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(affineTransform);
        parameterBlock.add(interpolation);
        this.downSampler = JAI.create("affine", parameterBlock);
        this.downSampler.removeSources();
        this.currentImage = this.highestImage = renderedImage;
    }

    public ImageMIPMap(RenderedImage renderedImage, RenderedOp renderedOp) {
        this();
        if (renderedImage == null || renderedOp == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.currentImage = this.highestImage = renderedImage;
        this.downSampler = renderedOp;
    }

    public ImageMIPMap(RenderedOp renderedOp) {
        block6: {
            Object object;
            this();
            if (renderedOp == null) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
            if (renderedOp.getNumSources() == 0) {
                throw new IllegalArgumentException(JaiI18N.getString("ImageMIPMap0"));
            }
            RenderedOp renderedOp2 = renderedOp;
            while ((object = renderedOp2.getNodeSource(0)) instanceof RenderedOp) {
                RenderedOp renderedOp3 = (RenderedOp)object;
                if (renderedOp3.getNumSources() == 0) {
                    this.highestImage = renderedOp3;
                    renderedOp2.removeSources();
                    break block6;
                }
                renderedOp2 = renderedOp3;
            }
            if (object instanceof RenderedImage) {
                this.highestImage = (RenderedImage)object;
                renderedOp2.removeSources();
            } else {
                throw new IllegalArgumentException(JaiI18N.getString("ImageMIPMap1"));
            }
        }
        this.currentImage = this.highestImage;
        this.downSampler = renderedOp;
    }

    public String[] getPropertyNames() {
        return this.properties.getPropertyNames();
    }

    public String[] getPropertyNames(String string) {
        return this.properties.getPropertyNames(string);
    }

    public Class getPropertyClass(String string) {
        return this.properties.getPropertyClass(string);
    }

    public Object getProperty(String string) {
        return this.properties.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        this.properties.setProperty(string, object);
    }

    public void removeProperty(String string) {
        this.properties.removeProperty(string);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.eventManager.removePropertyChangeListener(string, propertyChangeListener);
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public RenderedImage getCurrentImage() {
        return this.currentImage;
    }

    public RenderedImage getImage(int n) {
        if (n < 0) {
            return null;
        }
        if (n < this.currentLevel) {
            this.currentImage = this.highestImage;
            this.currentLevel = 0;
        }
        while (this.currentLevel < n) {
            this.getDownImage();
        }
        return this.currentImage;
    }

    public RenderedImage getDownImage() {
        ++this.currentLevel;
        RenderedOp renderedOp = this.duplicate(this.downSampler, this.vectorize(this.currentImage));
        this.currentImage = renderedOp.getRendering();
        return this.currentImage;
    }

    protected RenderedOp duplicate(RenderedOp renderedOp, Vector vector2) {
        if (vector2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        renderedOp = new RenderedOp(renderedOp.getRegistry(), renderedOp.getOperationName(), renderedOp.getParameterBlock(), renderedOp.getRenderingHints());
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.setParameters(renderedOp.getParameters());
        Vector vector3 = renderedOp.getSources();
        int n = vector3.size();
        if (n == 0) {
            parameterBlock.setSources(vector2);
        } else {
            parameterBlock.addSource(this.duplicate((RenderedOp)vector3.elementAt(0), vector2));
            int n2 = 1;
            while (n2 < n) {
                parameterBlock.addSource(vector3.elementAt(n2));
                ++n2;
            }
        }
        renderedOp.setParameterBlock(parameterBlock);
        return renderedOp;
    }

    public RenderableImage getAsRenderable(int n, float f, float f2, float f3) {
        Vector<RenderedImage> vector2 = new Vector<RenderedImage>();
        vector2.add(this.currentImage);
        RenderedImage renderedImage = this.currentImage;
        int n2 = 1;
        while (n2 < n) {
            RenderedOp renderedOp = this.duplicate(this.downSampler, this.vectorize(renderedImage));
            if ((renderedImage = renderedOp.getRendering()).getWidth() <= 1 || renderedImage.getHeight() <= 1) break;
            vector2.add(renderedImage);
            ++n2;
        }
        return new MultiResolutionRenderableImage(vector2, f, f2, f3);
    }

    public RenderableImage getAsRenderable() {
        return this.getAsRenderable(1, 0.0f, 0.0f, 1.0f);
    }

    protected final Vector vectorize(RenderedImage renderedImage) {
        Vector<RenderedImage> vector2 = new Vector<RenderedImage>(1);
        vector2.add(renderedImage);
        return vector2;
    }

    protected final Vector vectorize(RenderedImage renderedImage, RenderedImage renderedImage2) {
        Vector<RenderedImage> vector2 = new Vector<RenderedImage>(2);
        vector2.add(renderedImage);
        vector2.add(renderedImage2);
        return vector2;
    }
}

