/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.RenderingHints;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.media.jai.DeferredData;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.PropertyEnvironment;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.RegistryMode;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;

public class OperationNodeSupport
implements Serializable {
    private static final int PB_EQUAL = 0;
    private static final int PB_SOURCES_DIFFER = 1;
    private static final int PB_PARAMETERS_DIFFER = 2;
    private static final int PB_DIFFER = 3;
    private String registryModeName;
    private String opName;
    private transient OperationRegistry registry;
    private transient ParameterBlock pb;
    private transient RenderingHints hints;
    private PropertyChangeSupportJAI eventManager;
    private transient PropertyEnvironment propertySource = null;
    private Vector localPropEnv = new Vector();
    private Hashtable paramObservers = new Hashtable();

    private static int compare(ParameterBlock parameterBlock, ParameterBlock parameterBlock2) {
        if (parameterBlock == null && parameterBlock2 == null) {
            return 0;
        }
        if (parameterBlock == null && parameterBlock2 != null || parameterBlock != null && parameterBlock2 == null) {
            return 3;
        }
        int n = 0;
        if (!OperationNodeSupport.equals(parameterBlock.getSources(), parameterBlock2.getSources())) {
            n |= 1;
        }
        if (!OperationNodeSupport.equals(parameterBlock.getParameters(), parameterBlock2.getParameters())) {
            n |= 2;
        }
        return n;
    }

    private static boolean equals(ParameterBlock parameterBlock, ParameterBlock parameterBlock2) {
        return parameterBlock == null ? parameterBlock2 == null : OperationNodeSupport.equals(parameterBlock.getSources(), parameterBlock2.getSources()) && OperationNodeSupport.equals(parameterBlock.getParameters(), parameterBlock2.getParameters());
    }

    private static boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public OperationNodeSupport(String string, String string2, OperationRegistry operationRegistry, ParameterBlock parameterBlock, RenderingHints renderingHints, PropertyChangeSupportJAI propertyChangeSupportJAI) {
        if (string == null || string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.registryModeName = string;
        this.opName = string2;
        this.registry = operationRegistry == null ? JAI.getDefaultInstance().getOperationRegistry() : operationRegistry;
        this.pb = parameterBlock;
        this.hints = renderingHints;
        this.eventManager = propertyChangeSupportJAI;
        if (parameterBlock != null) {
            this.updateObserverMap(parameterBlock.getParameters());
        }
    }

    private void updateObserverMap(Vector vector2) {
        if (vector2 == null) {
            return;
        }
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            ParamObserver paramObserver;
            Object e = vector2.get(n2);
            Integer n3 = new Integer(n2);
            if (e instanceof DeferredData) {
                paramObserver = new ParamObserver(n2, (DeferredData)e);
                object = this.paramObservers.put(n3, paramObserver);
            } else {
                object = this.paramObservers.remove(n3);
            }
            if (object != null) {
                paramObserver = (ParamObserver)object;
                paramObserver.dd.deleteObserver(paramObserver);
            }
            ++n2;
        }
    }

    public String getRegistryModeName() {
        return this.registryModeName;
    }

    public String getOperationName() {
        return this.opName;
    }

    public void setOperationName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (string.equalsIgnoreCase(this.opName)) {
            return;
        }
        String string2 = this.opName;
        this.opName = string;
        this.fireEvent("OperationName", string2, string);
        this.resetPropertyEnvironment(false);
    }

    public OperationRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(OperationRegistry operationRegistry) {
        if (operationRegistry == null) {
            operationRegistry = JAI.getDefaultInstance().getOperationRegistry();
        }
        if (operationRegistry != this.registry) {
            OperationRegistry operationRegistry2 = this.registry;
            this.registry = operationRegistry;
            this.fireEvent("OperationRegistry", operationRegistry2, operationRegistry);
            this.resetPropertyEnvironment(false);
        }
    }

    public ParameterBlock getParameterBlock() {
        return this.pb;
    }

    public void setParameterBlock(ParameterBlock parameterBlock) {
        int n = OperationNodeSupport.compare(this.pb, parameterBlock);
        if (n == 0) {
            return;
        }
        ParameterBlock parameterBlock2 = this.pb;
        this.pb = parameterBlock;
        if (parameterBlock != null) {
            this.updateObserverMap(parameterBlock.getParameters());
        }
        if (n == 1) {
            this.fireEvent("Sources", parameterBlock2.getSources(), parameterBlock.getSources());
        } else if (n == 2) {
            this.fireEvent("Parameters", parameterBlock2.getParameters(), parameterBlock.getParameters());
        } else {
            this.fireEvent("ParameterBlock", parameterBlock2, parameterBlock);
        }
        this.resetPropertyEnvironment(false);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        if (OperationNodeSupport.equals(this.hints, renderingHints)) {
            return;
        }
        RenderingHints renderingHints2 = this.hints;
        this.hints = renderingHints;
        this.fireEvent("RenderingHints", renderingHints2, renderingHints);
        this.resetPropertyEnvironment(false);
    }

    public void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        if (propertyGenerator == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.localPropEnv.add(propertyGenerator);
        if (this.propertySource != null) {
            this.propertySource.addPropertyGenerator(propertyGenerator);
        }
    }

    public void copyPropertyFromSource(String string, int n) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.localPropEnv.add(new CopyDirective(string, n));
        if (this.propertySource != null) {
            this.propertySource.copyPropertyFromSource(string, n);
        }
    }

    public void suppressProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.localPropEnv.add(string);
        if (this.propertySource != null) {
            this.propertySource.suppressProperty(string);
        }
    }

    public PropertySource getPropertySource(OperationNode operationNode, PropertySource propertySource) {
        if (operationNode == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.propertySource == null) {
            OperationNodeSupport operationNodeSupport = this;
            synchronized (operationNodeSupport) {
                RegistryMode registryMode = RegistryMode.getMode(this.registryModeName);
                this.propertySource = registryMode != null && registryMode.arePropertiesSupported() ? (PropertyEnvironment)this.registry.getPropertySource(operationNode) : new PropertyEnvironment(this.pb != null ? this.pb.getSources() : null, null, null, null, operationNode);
                this.updatePropertyEnvironment(this.propertySource);
            }
        }
        this.propertySource.setDefaultPropertySource(propertySource);
        return this.propertySource;
    }

    public void resetPropertyEnvironment(boolean bl) {
        this.propertySource = null;
        if (bl) {
            this.localPropEnv.clear();
        }
    }

    private void updatePropertyEnvironment(PropertyEnvironment propertyEnvironment) {
        if (propertyEnvironment != null) {
            OperationNodeSupport operationNodeSupport = this;
            synchronized (operationNodeSupport) {
                int n = this.localPropEnv.size();
                int n2 = 0;
                while (n2 < n) {
                    Object e = this.localPropEnv.get(n2);
                    if (e instanceof String) {
                        propertyEnvironment.suppressProperty((String)e);
                    } else if (e instanceof CopyDirective) {
                        CopyDirective copyDirective = (CopyDirective)e;
                        propertyEnvironment.copyPropertyFromSource(copyDirective.getName(), copyDirective.getIndex());
                    } else if (e instanceof PropertyGenerator) {
                        propertyEnvironment.addPropertyGenerator((PropertyGenerator)e);
                    }
                    ++n2;
                }
            }
        }
    }

    private void fireEvent(String string, Object object, Object object2) {
        if (this.eventManager != null) {
            Object object3 = this.eventManager.getPropertyChangeEventSource();
            PropertyChangeEventJAI propertyChangeEventJAI = new PropertyChangeEventJAI(object3, string, object, object2);
            this.eventManager.firePropertyChange(propertyChangeEventJAI);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        ParameterBlock parameterBlock = this.pb;
        boolean bl = false;
        int n = 0;
        while (n < parameterBlock.getNumSources()) {
            Object object2 = parameterBlock.getSource(n);
            if (object2 != null && !(object2 instanceof Serializable)) {
                if (!bl) {
                    parameterBlock = (ParameterBlock)this.pb.clone();
                    bl = true;
                }
                if (object2 instanceof RenderedImage) {
                    object = SerializerFactory.getState(object2, null);
                    parameterBlock.setSource(object, n);
                } else {
                    throw new RuntimeException(object2.getClass().getName() + JaiI18N.getString("OperationNodeSupport0"));
                }
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < parameterBlock.getNumParameters()) {
            object = parameterBlock.getObjectParameter(n2);
            if (object != null && !(object instanceof Serializable)) {
                if (!bl) {
                    parameterBlock = (ParameterBlock)this.pb.clone();
                    bl = true;
                }
                if (object instanceof Raster) {
                    parameterBlock.set(SerializerFactory.getState(object, null), n2);
                } else if (object instanceof RenderedImage) {
                    RenderedImage renderedImage = (RenderedImage)object;
                    RenderingHints renderingHints = new RenderingHints(null);
                    renderingHints.put(JAI.KEY_SERIALIZE_DEEP_COPY, new Boolean(true));
                    parameterBlock.set(SerializerFactory.getState(renderedImage, renderingHints), n2);
                } else {
                    throw new RuntimeException(object.getClass().getName() + JaiI18N.getString("OperationNodeSupport1"));
                }
            }
            ++n2;
        }
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(parameterBlock);
        objectOutputStream.writeObject(SerializerFactory.getState(this.hints, null));
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.pb = (ParameterBlock)objectInputStream.readObject();
        SerializableState serializableState = (SerializableState)objectInputStream.readObject();
        this.hints = (RenderingHints)serializableState.getObject();
        int n = 0;
        while (n < this.pb.getNumSources()) {
            Object object2 = this.pb.getSource(n);
            if (object2 instanceof SerializableState) {
                serializableState = (SerializableState)object2;
                object = PlanarImage.wrapRenderedImage((RenderedImage)serializableState.getObject());
                this.pb.setSource(object, n);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.pb.getNumParameters()) {
            object = this.pb.getObjectParameter(n2);
            if (object instanceof SerializableState) {
                Object object3 = ((SerializableState)object).getObject();
                if (object3 instanceof Raster) {
                    this.pb.set(object3, n2);
                } else if (object3 instanceof RenderedImage) {
                    this.pb.set(PlanarImage.wrapRenderedImage((RenderedImage)object3), n2);
                } else {
                    this.pb.set(object3, n2);
                }
            }
            ++n2;
        }
        this.registry = JAI.getDefaultInstance().getOperationRegistry();
    }

    private class ParamObserver
    implements Observer {
        final int paramIndex;
        final DeferredData dd;

        ParamObserver(int n, DeferredData deferredData) {
            if (deferredData == null) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
            if (n < 0 || OperationNodeSupport.this.pb != null && n >= OperationNodeSupport.this.pb.getNumParameters()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.paramIndex = n;
            this.dd = deferredData;
            deferredData.addObserver(this);
        }

        public synchronized void update(Observable observable, Object object) {
            if (observable != this.dd) {
                return;
            }
            if (object != null && OperationNodeSupport.this.eventManager != null) {
                Vector<Object> vector2 = OperationNodeSupport.this.pb.getParameters();
                Vector vector3 = (Vector)vector2.clone();
                Vector vector4 = (Vector)vector2.clone();
                vector3.set(this.paramIndex, object);
                vector4.set(this.paramIndex, this.dd.getData());
                OperationNodeSupport.this.fireEvent("Parameters", vector3, vector4);
            }
        }
    }

    private class CopyDirective
    implements Serializable {
        private String name;
        private int index;

        CopyDirective(String string, int n) {
            if (string == null) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
            this.name = string;
            this.index = n;
        }

        String getName() {
            return this.name;
        }

        int getIndex() {
            return this.index;
        }
    }
}

