/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.media.jai.CollectionChangeEvent;
import javax.media.jai.CollectionImage;
import javax.media.jai.CollectionOp;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.OperationNode;
import javax.media.jai.OperationNodeSupport;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.PropertyChangeSupportJAI;
import javax.media.jai.PropertyGenerator;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceChangeEvent;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RegistryMode;
import javax.media.jai.RenderingChangeEvent;
import javax.media.jai.TileCache;
import javax.media.jai.TileComputationListener;
import javax.media.jai.TileRequest;
import javax.media.jai.WritablePropertySourceImpl;
import javax.media.jai.registry.RIFRegistry;
import javax.media.jai.remote.PlanarImageServerProxy;
import javax.media.jai.util.CaselessStringKey;
import javax.media.jai.util.ImagingListener;

public class RenderedOp
extends PlanarImage
implements OperationNode,
PropertyChangeListener,
Serializable {
    protected OperationNodeSupport nodeSupport;
    protected transient PropertySource thePropertySource;
    protected transient PlanarImage theImage;
    private transient RenderingHints oldHints;
    private static List synthProps;
    private Hashtable synthProperties = null;
    private static Set nodeEventNames;
    private boolean isDisposed = false;
    static /* synthetic */ Class class$javax$media$jai$OperationDescriptor;

    public RenderedOp(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        super(new ImageLayout(), null, null);
        parameterBlock = parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone();
        if (renderingHints != null) {
            renderingHints = (RenderingHints)renderingHints.clone();
        }
        this.nodeSupport = new OperationNodeSupport(this.getRegistryModeName(), string, operationRegistry, parameterBlock, renderingHints, this.eventManager);
        this.addPropertyChangeListener("OperationName", this);
        this.addPropertyChangeListener("OperationRegistry", this);
        this.addPropertyChangeListener("ParameterBlock", this);
        this.addPropertyChangeListener("Sources", this);
        this.addPropertyChangeListener("Parameters", this);
        this.addPropertyChangeListener("RenderingHints", this);
        Vector<Object> vector2 = parameterBlock.getSources();
        if (vector2 != null) {
            Iterator iterator = ((AbstractList)vector2).iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof PlanarImage) {
                    ((PlanarImage)e).addSink(this);
                    continue;
                }
                if (!(e instanceof CollectionImage)) continue;
                ((CollectionImage)e).addSink(this);
            }
        }
    }

    public RenderedOp(String string, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        this(null, string, parameterBlock, renderingHints);
    }

    public String getRegistryModeName() {
        return RegistryMode.getMode("rendered").getName();
    }

    public synchronized OperationRegistry getRegistry() {
        return this.nodeSupport.getRegistry();
    }

    public synchronized void setRegistry(OperationRegistry operationRegistry) {
        this.nodeSupport.setRegistry(operationRegistry);
    }

    public synchronized String getOperationName() {
        return this.nodeSupport.getOperationName();
    }

    public synchronized void setOperationName(String string) {
        this.nodeSupport.setOperationName(string);
    }

    public synchronized ParameterBlock getParameterBlock() {
        return (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
    }

    public synchronized void setParameterBlock(ParameterBlock parameterBlock) {
        Object object;
        Object object2;
        Vector<Object> vector2 = this.nodeSupport.getParameterBlock().getSources();
        if (vector2 != null && vector2.size() > 0) {
            object2 = ((AbstractList)vector2).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (object instanceof PlanarImage) {
                    ((PlanarImage)object).removeSink(this);
                    continue;
                }
                if (!(object instanceof CollectionImage)) continue;
                ((CollectionImage)object).removeSink(this);
            }
        }
        if (parameterBlock != null && (object2 = parameterBlock.getSources()) != null && ((Vector)object2).size() > 0) {
            object = ((AbstractList)object2).iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (e instanceof PlanarImage) {
                    ((PlanarImage)e).addSink(this);
                    continue;
                }
                if (!(e instanceof CollectionImage)) continue;
                ((CollectionImage)e).addSink(this);
            }
        }
        this.nodeSupport.setParameterBlock(parameterBlock == null ? new ParameterBlock() : (ParameterBlock)parameterBlock.clone());
    }

    public RenderingHints getRenderingHints() {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        return renderingHints == null ? null : (RenderingHints)renderingHints.clone();
    }

    public synchronized void setRenderingHints(RenderingHints renderingHints) {
        if (renderingHints != null) {
            renderingHints = (RenderingHints)renderingHints.clone();
        }
        this.nodeSupport.setRenderingHints(renderingHints);
    }

    public synchronized PlanarImage createInstance() {
        return this.createInstance(false);
    }

    protected synchronized PlanarImage createInstance(boolean bl) {
        Object object;
        Object object2;
        ParameterBlock parameterBlock = new ParameterBlock();
        Vector<Object> vector2 = this.nodeSupport.getParameterBlock().getParameters();
        parameterBlock.setParameters(ImageUtil.evaluateParameters(vector2));
        int n = this.getNumSources();
        int n2 = 0;
        while (n2 < n) {
            object2 = this.getNodeSource(n2);
            object = null;
            if (object2 instanceof RenderedOp) {
                RenderedOp renderedOp = (RenderedOp)object2;
                object = bl ? renderedOp.getRendering() : renderedOp.createInstance();
            } else {
                object = object2 instanceof CollectionOp ? ((CollectionOp)object2).getCollection() : (object2 instanceof RenderedImage || object2 instanceof Collection ? object2 : object2);
            }
            parameterBlock.addSource(object);
            ++n2;
        }
        object2 = RIFRegistry.create(this.getRegistry(), this.nodeSupport.getOperationName(), parameterBlock, this.nodeSupport.getRenderingHints());
        if (object2 == null) {
            throw new RuntimeException(JaiI18N.getString("RenderedOp0"));
        }
        object = PlanarImage.wrapRenderedImage((RenderedImage)object2);
        this.oldHints = this.nodeSupport.getRenderingHints() == null ? null : (RenderingHints)this.nodeSupport.getRenderingHints().clone();
        return object;
    }

    protected synchronized void createRendering() {
        if (this.theImage == null) {
            this.theImage = this.createInstance(true);
            this.setImageLayout(new ImageLayout(this.theImage));
            if (this.theImage != null) {
                this.theImage.addTileComputationListener(new TCL(this));
            }
        }
    }

    public PlanarImage getRendering() {
        this.createRendering();
        return this.theImage;
    }

    public PlanarImage getCurrentRendering() {
        return this.theImage;
    }

    public PlanarImage getNewRendering() {
        if (this.theImage == null) {
            return this.getRendering();
        }
        PlanarImage planarImage = this.theImage;
        this.theImage = null;
        this.createRendering();
        this.resetProperties(true);
        RenderingChangeEvent renderingChangeEvent = new RenderingChangeEvent(this, planarImage, this.theImage, null);
        this.eventManager.firePropertyChange(renderingChangeEvent);
        Vector vector2 = this.getSinks();
        if (vector2 != null) {
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = vector2.get(n2);
                if (e instanceof PropertyChangeListener) {
                    ((PropertyChangeListener)e).propertyChange(renderingChangeEvent);
                }
                ++n2;
            }
        }
        return this.theImage;
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        block52: {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            Object object7 = propertyChangeEvent.getSource();
            Vector<Object> vector2 = this.nodeSupport.getParameterBlock().getSources();
            String string = propertyChangeEvent.getPropertyName().toLowerCase();
            if (this.theImage == null || (!(propertyChangeEvent instanceof PropertyChangeEventJAI) || object7 != this || propertyChangeEvent instanceof PropertySourceChangeEvent || !nodeEventNames.contains(string)) && (!(propertyChangeEvent instanceof RenderingChangeEvent) && !(propertyChangeEvent instanceof CollectionChangeEvent) && (!(propertyChangeEvent instanceof PropertyChangeEventJAI) || !(object7 instanceof RenderedImage) || !string.equals("invalidregion")) || !vector2.contains(object7))) break block52;
            PlanarImage planarImage = this.theImage;
            boolean bl = false;
            Object object8 = null;
            if (object7 == this && (string.equals("operationname") || string.equals("operationregistry"))) {
                bl = true;
                this.theImage = null;
            } else if (propertyChangeEvent instanceof RenderingChangeEvent || object7 instanceof RenderedImage && string.equals("invalidregion")) {
                bl = true;
                object6 = null;
                if (propertyChangeEvent instanceof RenderingChangeEvent) {
                    object5 = (RenderingChangeEvent)propertyChangeEvent;
                    object6 = ((RenderingChangeEvent)object5).getInvalidRegion();
                    if (object6 == null) {
                        object6 = ((PlanarImage)((PropertyChangeEvent)object5).getOldValue()).getBounds();
                    }
                } else {
                    object6 = (Shape)propertyChangeEvent.getNewValue();
                    if (object6 == null) {
                        object5 = (RenderedImage)object7;
                        object6 = new Rectangle(object5.getMinX(), object5.getMinY(), object5.getWidth(), object5.getHeight());
                    }
                }
                if (!(this.theImage instanceof OpImage)) {
                    this.theImage = null;
                } else {
                    Cloneable cloneable;
                    Object object9;
                    int n;
                    Object object10;
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    object5 = (OpImage)this.theImage;
                    Rectangle rectangle = object6.getBounds();
                    if (rectangle.isEmpty() && !((Rectangle)(object4 = new Rectangle(n5 = ((PlanarImage)object5).tileXToX(((PlanarImage)object5).getMinTileX()), n4 = ((PlanarImage)object5).tileYToY(((PlanarImage)object5).getMinTileY()), n3 = ((PlanarImage)object5).getNumXTiles() * ((PlanarImage)object5).getTileWidth(), n2 = ((PlanarImage)object5).getNumYTiles() * ((PlanarImage)object5).getTileHeight()))).equals(object3 = ((PlanarImage)object5).getBounds())) {
                        object10 = new Area((Shape)object4);
                        object10.subtract(new Area((Shape)object3));
                        object6 = object10;
                        rectangle = object6.getBounds();
                    }
                    n5 = 0;
                    object2 = null;
                    if (rectangle.isEmpty()) {
                        object8 = object6;
                        n5 = 1;
                    } else {
                        n3 = vector2.indexOf(object7);
                        Rectangle rectangle2 = ((OpImage)object5).mapSourceRect(rectangle, n3);
                        if (rectangle2 == null) {
                            rectangle2 = ((PlanarImage)object5).getBounds();
                        }
                        int n6 = (object4 = this.getTileIndices(rectangle2)) != null ? ((Point[])object4).length : 0;
                        object10 = null;
                        n = 0;
                        while (n < n6) {
                            if (n % 1000 == 0 && object10 != null) {
                                object10 = new GeneralPath(new Area((Shape)object10));
                            }
                            if ((object9 = ((OpImage)object5).mapDestRect((Rectangle)(cloneable = this.getTileRect(((Point)object4[n]).x, ((Point)object4[n]).y)), n3)) == null) {
                                object10 = null;
                                break;
                            }
                            if (object6.intersects((Rectangle2D)object9)) {
                                if (object10 == null) {
                                    object10 = new GeneralPath((Shape)((Object)cloneable));
                                } else {
                                    object10.append((Shape)((Object)cloneable), false);
                                }
                            } else {
                                if (object2 == null) {
                                    object2 = new ArrayList<Object>();
                                }
                                ((ArrayList)object2).add(object4[n]);
                            }
                            ++n;
                        }
                        object8 = object10 == null ? null : new Area((Shape)object10);
                    }
                    this.theImage = null;
                    object = ((OpImage)object5).getTileCache();
                    if (object != null && (n5 != 0 || object2 != null)) {
                        this.createRendering();
                        if (this.theImage instanceof OpImage && ((OpImage)this.theImage).getTileCache() != null) {
                            OpImage opImage = (OpImage)this.theImage;
                            object4 = opImage.getTileCache();
                            object3 = opImage.getTileCacheMetric();
                            if (n5 != 0) {
                                object10 = object.getTiles((RenderedImage)object5);
                                n = object10 == null ? 0 : ((Raster[])object10).length;
                                int n7 = 0;
                                while (n7 < n) {
                                    object9 = object10[n7];
                                    int n8 = opImage.XToTileX(((Raster)object9).getMinX());
                                    int n9 = opImage.YToTileY(((Raster)object9).getMinY());
                                    object4.add(opImage, n8, n9, (Raster)object9, object3);
                                    ++n7;
                                }
                            } else {
                                int n10 = ((ArrayList)object2).size();
                                n = 0;
                                while (n < n10) {
                                    cloneable = (Point)((ArrayList)object2).get(n);
                                    object9 = object.getTile((RenderedImage)object5, ((Point)cloneable).x, ((Point)cloneable).y);
                                    if (object9 != null) {
                                        object4.add(opImage, ((Point)cloneable).x, ((Point)cloneable).y, (Raster)object9, object3);
                                    }
                                    ++n;
                                }
                            }
                        }
                    }
                }
            } else {
                Object object11;
                object6 = null;
                object5 = null;
                boolean bl2 = false;
                if (string.equals("parameterblock")) {
                    object6 = (ParameterBlock)propertyChangeEvent.getOldValue();
                    object5 = (ParameterBlock)propertyChangeEvent.getNewValue();
                    bl2 = true;
                } else if (string.equals("sources")) {
                    Vector<Object> vector3 = this.nodeSupport.getParameterBlock().getParameters();
                    object6 = new ParameterBlock((Vector)propertyChangeEvent.getOldValue(), vector3);
                    object5 = new ParameterBlock((Vector)propertyChangeEvent.getNewValue(), vector3);
                    bl2 = true;
                } else if (string.equals("parameters")) {
                    object6 = new ParameterBlock(vector2, (Vector)propertyChangeEvent.getOldValue());
                    object5 = new ParameterBlock(vector2, (Vector)propertyChangeEvent.getNewValue());
                    bl2 = true;
                } else if (string.equals("renderinghints")) {
                    object6 = object5 = this.nodeSupport.getParameterBlock();
                    bl2 = true;
                } else if (propertyChangeEvent instanceof CollectionChangeEvent) {
                    int n = vector2.indexOf(object7);
                    object2 = (Vector)vector2.clone();
                    object = (Vector)vector2.clone();
                    ((Vector)object2).set(n, propertyChangeEvent.getOldValue());
                    ((Vector)object).set(n, propertyChangeEvent.getNewValue());
                    object11 = this.nodeSupport.getParameterBlock().getParameters();
                    object6 = new ParameterBlock((Vector<Object>)object2, (Vector<Object>)object11);
                    object5 = new ParameterBlock((Vector<Object>)object, (Vector<Object>)object11);
                    bl2 = true;
                }
                if (bl2) {
                    bl = true;
                    OperationRegistry operationRegistry = this.nodeSupport.getRegistry();
                    object2 = (OperationDescriptor)operationRegistry.getDescriptor(class$javax$media$jai$OperationDescriptor == null ? (class$javax$media$jai$OperationDescriptor = RenderedOp.class$("javax.media.jai.OperationDescriptor")) : class$javax$media$jai$OperationDescriptor, this.nodeSupport.getOperationName());
                    object8 = (Shape)object2.getInvalidRegion("rendered", (ParameterBlock)(object6 = ImageUtil.evaluateParameters((ParameterBlock)object6)), this.oldHints, (ParameterBlock)(object5 = ImageUtil.evaluateParameters((ParameterBlock)object5)), this.nodeSupport.getRenderingHints(), this);
                    if (object8 == null || !(this.theImage instanceof OpImage)) {
                        this.theImage = null;
                    } else {
                        object = (OpImage)this.theImage;
                        this.theImage = null;
                        this.createRendering();
                        if (this.theImage instanceof OpImage && ((OpImage)object).getTileCache() != null && ((OpImage)this.theImage).getTileCache() != null) {
                            Rectangle rectangle;
                            int n;
                            int n11;
                            int n12;
                            int n13;
                            Rectangle rectangle3;
                            object11 = (OpImage)this.theImage;
                            object4 = ((OpImage)object).getTileCache();
                            object3 = ((OpImage)object11).getTileCache();
                            Object object12 = ((OpImage)object11).getTileCacheMetric();
                            if (object8.getBounds().isEmpty() && !(rectangle3 = new Rectangle(n13 = ((PlanarImage)object).tileXToX(((PlanarImage)object).getMinTileX()), n12 = ((PlanarImage)object).tileYToY(((PlanarImage)object).getMinTileY()), n11 = ((PlanarImage)object).getNumXTiles() * ((PlanarImage)object).getTileWidth(), n = ((PlanarImage)object).getNumYTiles() * ((PlanarImage)object).getTileHeight())).equals(rectangle = ((PlanarImage)object).getBounds())) {
                                Area area = new Area(rectangle3);
                                area.subtract(new Area(rectangle));
                                object8 = area;
                            }
                            if (object8.getBounds().isEmpty()) {
                                Raster[] rasterArray = object4.getTiles((RenderedImage)object);
                                n12 = rasterArray == null ? 0 : rasterArray.length;
                                n11 = 0;
                                while (n11 < n12) {
                                    Raster raster = rasterArray[n11];
                                    int n14 = ((PlanarImage)object11).XToTileX(raster.getMinX());
                                    int n15 = ((PlanarImage)object11).YToTileY(raster.getMinY());
                                    object3.add((RenderedImage)object11, n14, n15, raster, object12);
                                    ++n11;
                                }
                            } else {
                                Raster[] rasterArray = object4.getTiles((RenderedImage)object);
                                n12 = rasterArray == null ? 0 : rasterArray.length;
                                n11 = 0;
                                while (n11 < n12) {
                                    Raster raster = rasterArray[n11];
                                    rectangle3 = raster.getBounds();
                                    if (!object8.intersects(rectangle3)) {
                                        object3.add((RenderedImage)object11, ((PlanarImage)object11).XToTileX(rectangle3.x), ((PlanarImage)object11).YToTileY(rectangle3.y), raster, object12);
                                    }
                                    ++n11;
                                }
                            }
                        }
                    }
                }
            }
            this.createRendering();
            if (bl) {
                this.resetProperties(true);
                object6 = new RenderingChangeEvent(this, planarImage, this.theImage, (Shape)object8);
                this.eventManager.firePropertyChange((PropertyChangeEvent)object6);
                object5 = this.getSinks();
                if (object5 != null) {
                    int n = ((Vector)object5).size();
                    int n16 = 0;
                    while (n16 < n) {
                        object2 = ((Vector)object5).get(n16);
                        if (object2 instanceof PropertyChangeListener) {
                            ((PropertyChangeListener)object2).propertyChange((PropertyChangeEvent)object6);
                        }
                        ++n16;
                    }
                }
            }
        }
    }

    public synchronized void addNodeSource(Object object) {
        this.addSource(object);
    }

    public synchronized void setNodeSource(Object object, int n) {
        this.setSource(object, n);
    }

    public synchronized Object getNodeSource(int n) {
        return this.nodeSupport.getParameterBlock().getSource(n);
    }

    public synchronized int getNumParameters() {
        return this.nodeSupport.getParameterBlock().getNumParameters();
    }

    public synchronized Vector getParameters() {
        Vector<Object> vector2 = this.nodeSupport.getParameterBlock().getParameters();
        return vector2 == null ? null : (Vector)vector2.clone();
    }

    public synchronized byte getByteParameter(int n) {
        return this.nodeSupport.getParameterBlock().getByteParameter(n);
    }

    public synchronized char getCharParameter(int n) {
        return this.nodeSupport.getParameterBlock().getCharParameter(n);
    }

    public synchronized short getShortParameter(int n) {
        return this.nodeSupport.getParameterBlock().getShortParameter(n);
    }

    public synchronized int getIntParameter(int n) {
        return this.nodeSupport.getParameterBlock().getIntParameter(n);
    }

    public synchronized long getLongParameter(int n) {
        return this.nodeSupport.getParameterBlock().getLongParameter(n);
    }

    public synchronized float getFloatParameter(int n) {
        return this.nodeSupport.getParameterBlock().getFloatParameter(n);
    }

    public synchronized double getDoubleParameter(int n) {
        return this.nodeSupport.getParameterBlock().getDoubleParameter(n);
    }

    public synchronized Object getObjectParameter(int n) {
        return this.nodeSupport.getParameterBlock().getObjectParameter(n);
    }

    public synchronized void setParameters(Vector vector2) {
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        parameterBlock.setParameters(vector2);
        this.nodeSupport.setParameterBlock(parameterBlock);
    }

    public synchronized void setParameter(byte by, int n) {
        this.setParameter(new Byte(by), n);
    }

    public synchronized void setParameter(char c, int n) {
        this.setParameter(new Character(c), n);
    }

    public synchronized void setParameter(short s, int n) {
        this.setParameter(new Short(s), n);
    }

    public synchronized void setParameter(int n, int n2) {
        this.setParameter(new Integer(n), n2);
    }

    public synchronized void setParameter(long l, int n) {
        this.setParameter(new Long(l), n);
    }

    public synchronized void setParameter(float f, int n) {
        this.setParameter(new Float(f), n);
    }

    public synchronized void setParameter(double d, int n) {
        this.setParameter(new Double(d), n);
    }

    public synchronized void setParameter(Object object, int n) {
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        parameterBlock.set(object, n);
        this.nodeSupport.setParameterBlock(parameterBlock);
    }

    public synchronized void setRenderingHint(RenderingHints.Key key, Object object) {
        if (key == null || object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        if (renderingHints == null) {
            this.nodeSupport.setRenderingHints(new RenderingHints(key, object));
        } else {
            renderingHints.put(key, object);
            this.nodeSupport.setRenderingHints(renderingHints);
        }
    }

    public synchronized Object getRenderingHint(RenderingHints.Key key) {
        RenderingHints renderingHints = this.nodeSupport.getRenderingHints();
        return renderingHints == null ? null : renderingHints.get(key);
    }

    private synchronized void createPropertySource() {
        if (this.thePropertySource == null) {
            PropertySource propertySource = new PropertySource(){

                public String[] getPropertyNames() {
                    return RenderedOp.this.getRendering().getPropertyNames();
                }

                public String[] getPropertyNames(String string) {
                    return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
                }

                public Class getPropertyClass(String string) {
                    return null;
                }

                public Object getProperty(String string) {
                    return RenderedOp.this.getRendering().getProperty(string);
                }
            };
            this.thePropertySource = this.nodeSupport.getPropertySource(this, propertySource);
            this.properties.addProperties(this.thePropertySource);
        }
    }

    protected synchronized void resetProperties(boolean bl) {
        this.properties.clearCachedProperties();
        if (bl && this.thePropertySource != null) {
            this.synthProperties = null;
            this.properties.removePropertySource(this.thePropertySource);
            this.thePropertySource = null;
        }
    }

    public synchronized String[] getPropertyNames() {
        int n;
        this.createPropertySource();
        Vector<Object> vector2 = new Vector<Object>(synthProps);
        CaselessStringKey caselessStringKey = new CaselessStringKey("");
        String[] stringArray = this.properties.getPropertyNames();
        if (stringArray != null) {
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                caselessStringKey.setName(stringArray[n]);
                if (!vector2.contains(caselessStringKey)) {
                    vector2.add(caselessStringKey.clone());
                }
                ++n;
            }
        }
        String[] stringArray2 = null;
        n = vector2.size();
        if (n > 0) {
            stringArray2 = new String[n];
            int n3 = 0;
            while (n3 < n) {
                stringArray2[n3] = ((CaselessStringKey)vector2.get(n3)).getName();
                ++n3;
            }
        }
        return stringArray2;
    }

    public Class getPropertyClass(String string) {
        this.createPropertySource();
        return this.properties.getPropertyClass(string);
    }

    private synchronized void createSynthProperties() {
        if (this.synthProperties == null) {
            this.synthProperties = new Hashtable();
            this.synthProperties.put(new CaselessStringKey("image_width"), new Integer(this.theImage.getWidth()));
            this.synthProperties.put(new CaselessStringKey("image_height"), new Integer(this.theImage.getHeight()));
            this.synthProperties.put(new CaselessStringKey("image_min_x_coord"), new Integer(this.theImage.getMinX()));
            this.synthProperties.put(new CaselessStringKey("image_min_y_coord"), new Integer(this.theImage.getMinY()));
            if (this.theImage instanceof OpImage) {
                this.synthProperties.put(new CaselessStringKey("tile_cache_key"), this.theImage);
                TileCache tileCache = ((OpImage)this.theImage).getTileCache();
                this.synthProperties.put(new CaselessStringKey("tile_cache"), tileCache == null ? Image.UndefinedProperty : tileCache);
            } else if (this.theImage instanceof PlanarImageServerProxy) {
                this.synthProperties.put(new CaselessStringKey("tile_cache_key"), this.theImage);
                TileCache tileCache = ((PlanarImageServerProxy)this.theImage).getTileCache();
                this.synthProperties.put(new CaselessStringKey("tile_cache"), tileCache == null ? Image.UndefinedProperty : tileCache);
            } else {
                Object object = this.theImage.getProperty("tile_cache_key");
                this.synthProperties.put(new CaselessStringKey("tile_cache_key"), object == null ? Image.UndefinedProperty : object);
                Object object2 = this.theImage.getProperty("tile_cache");
                this.synthProperties.put(new CaselessStringKey("tile_cache"), object2 == null ? Image.UndefinedProperty : object2);
            }
        }
    }

    public synchronized Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        this.createPropertySource();
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        if (synthProps.contains(caselessStringKey)) {
            this.createRendering();
            this.createSynthProperties();
            return this.synthProperties.get(caselessStringKey);
        }
        Object object = this.properties.getProperty(string);
        if (object == Image.UndefinedProperty) {
            object = this.thePropertySource.getProperty(string);
        }
        if (object != Image.UndefinedProperty && string.equalsIgnoreCase("roi") && object instanceof ROI) {
            ROI rOI = (ROI)object;
            Rectangle rectangle = this.getBounds();
            if (!rectangle.contains(rOI.getBounds())) {
                object = rOI.intersect(new ROIShape(rectangle));
            }
        }
        return object;
    }

    public synchronized void setProperty(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (synthProps.contains(new CaselessStringKey(string))) {
            throw new RuntimeException(JaiI18N.getString("RenderedOp4"));
        }
        this.createPropertySource();
        super.setProperty(string, object);
    }

    public void removeProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (synthProps.contains(new CaselessStringKey(string))) {
            throw new RuntimeException(JaiI18N.getString("RenderedOp4"));
        }
        this.createPropertySource();
        this.properties.removeProperty(string);
    }

    public synchronized Object getDynamicProperty(String string) {
        this.createPropertySource();
        return this.thePropertySource.getProperty(string);
    }

    public synchronized void addPropertyGenerator(PropertyGenerator propertyGenerator) {
        this.nodeSupport.addPropertyGenerator(propertyGenerator);
    }

    public synchronized void copyPropertyFromSource(String string, int n) {
        this.nodeSupport.copyPropertyFromSource(string, n);
    }

    public synchronized void suppressProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (synthProps.contains(new CaselessStringKey(string))) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderedOp5"));
        }
        this.nodeSupport.suppressProperty(string);
    }

    public int getMinX() {
        this.createRendering();
        return this.theImage.getMinX();
    }

    public int getMinY() {
        this.createRendering();
        return this.theImage.getMinY();
    }

    public int getWidth() {
        this.createRendering();
        return this.theImage.getWidth();
    }

    public int getHeight() {
        this.createRendering();
        return this.theImage.getHeight();
    }

    public int getTileWidth() {
        this.createRendering();
        return this.theImage.getTileWidth();
    }

    public int getTileHeight() {
        this.createRendering();
        return this.theImage.getTileHeight();
    }

    public int getTileGridXOffset() {
        this.createRendering();
        return this.theImage.getTileGridXOffset();
    }

    public int getTileGridYOffset() {
        this.createRendering();
        return this.theImage.getTileGridYOffset();
    }

    public SampleModel getSampleModel() {
        this.createRendering();
        return this.theImage.getSampleModel();
    }

    public ColorModel getColorModel() {
        this.createRendering();
        return this.theImage.getColorModel();
    }

    public Raster getTile(int n, int n2) {
        this.createRendering();
        return this.theImage.getTile(n, n2);
    }

    public Raster getData() {
        this.createRendering();
        return this.theImage.getData();
    }

    public Raster getData(Rectangle rectangle) {
        this.createRendering();
        return this.theImage.getData(rectangle);
    }

    public WritableRaster copyData() {
        this.createRendering();
        return this.theImage.copyData();
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        this.createRendering();
        return this.theImage.copyData(writableRaster);
    }

    public Raster[] getTiles(Point[] pointArray) {
        this.createRendering();
        return this.theImage.getTiles(pointArray);
    }

    public TileRequest queueTiles(Point[] pointArray) {
        this.createRendering();
        return this.theImage.queueTiles(pointArray);
    }

    public void cancelTiles(TileRequest tileRequest, Point[] pointArray) {
        if (tileRequest == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic4"));
        }
        this.createRendering();
        this.theImage.cancelTiles(tileRequest, pointArray);
    }

    public void prefetchTiles(Point[] pointArray) {
        this.createRendering();
        this.theImage.prefetchTiles(pointArray);
    }

    public synchronized void addSource(PlanarImage planarImage) {
        PlanarImage planarImage2 = planarImage;
        this.addSource((Object)planarImage2);
    }

    public synchronized void setSource(PlanarImage planarImage, int n) {
        PlanarImage planarImage2 = planarImage;
        this.setSource((Object)planarImage2, n);
    }

    public PlanarImage getSource(int n) {
        return (PlanarImage)this.nodeSupport.getParameterBlock().getSource(n);
    }

    public synchronized boolean removeSource(PlanarImage planarImage) {
        PlanarImage planarImage2 = planarImage;
        return this.removeSource((Object)planarImage2);
    }

    public synchronized void addSource(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        parameterBlock.addSource(object);
        this.nodeSupport.setParameterBlock(parameterBlock);
        if (object instanceof PlanarImage) {
            ((PlanarImage)object).addSink(this);
        } else if (object instanceof CollectionImage) {
            ((CollectionImage)object).addSink(this);
        }
    }

    public synchronized void setSource(Object object, int n) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        if (n < parameterBlock.getNumSources()) {
            Object object2 = parameterBlock.getSource(n);
            if (object2 instanceof PlanarImage) {
                ((PlanarImage)object2).removeSink(this);
            } else if (object2 instanceof CollectionImage) {
                ((CollectionImage)object2).removeSink(this);
            }
        }
        parameterBlock.setSource(object, n);
        this.nodeSupport.setParameterBlock(parameterBlock);
        if (object instanceof PlanarImage) {
            ((PlanarImage)object).addSink(this);
        } else if (object instanceof CollectionImage) {
            ((CollectionImage)object).addSink(this);
        }
    }

    public synchronized boolean removeSource(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        Vector<Object> vector2 = parameterBlock.getSources();
        if (vector2.contains(object)) {
            if (object instanceof PlanarImage) {
                ((PlanarImage)object).removeSink(this);
            } else if (object instanceof CollectionImage) {
                ((CollectionImage)object).removeSink(this);
            }
        }
        boolean bl = vector2.remove(object);
        this.nodeSupport.setParameterBlock(parameterBlock);
        return bl;
    }

    public PlanarImage getSourceImage(int n) {
        return (PlanarImage)this.nodeSupport.getParameterBlock().getSource(n);
    }

    public synchronized Object getSourceObject(int n) {
        return this.nodeSupport.getParameterBlock().getSource(n);
    }

    public int getNumSources() {
        return this.nodeSupport.getParameterBlock().getNumSources();
    }

    public synchronized Vector getSources() {
        Vector<Object> vector2 = this.nodeSupport.getParameterBlock().getSources();
        return vector2 == null ? null : (Vector)vector2.clone();
    }

    public synchronized void setSources(List list2) {
        if (list2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        Iterator iterator = ((AbstractList)parameterBlock.getSources()).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (list2.contains(e)) continue;
            if (e instanceof PlanarImage) {
                ((PlanarImage)e).removeSink(this);
                continue;
            }
            if (!(e instanceof CollectionImage)) continue;
            ((CollectionImage)e).removeSink(this);
        }
        parameterBlock.removeSources();
        int n = list2.size();
        int n2 = 0;
        while (n2 < n) {
            Object e = list2.get(n2);
            parameterBlock.addSource(e);
            if (e instanceof PlanarImage) {
                ((PlanarImage)e).addSink(this);
            } else if (e instanceof CollectionImage) {
                ((CollectionImage)e).addSink(this);
            }
            ++n2;
        }
        this.nodeSupport.setParameterBlock(parameterBlock);
    }

    public synchronized void removeSources() {
        ParameterBlock parameterBlock = (ParameterBlock)this.nodeSupport.getParameterBlock().clone();
        Iterator iterator = ((AbstractList)parameterBlock.getSources()).iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof PlanarImage) {
                ((PlanarImage)e).removeSink(this);
            } else if (e instanceof CollectionImage) {
                ((CollectionImage)e).removeSink(this);
            }
            iterator.remove();
        }
        this.nodeSupport.setParameterBlock(parameterBlock);
    }

    public synchronized void addSink(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        super.addSink(planarImage);
    }

    public synchronized boolean removeSink(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return super.removeSink(planarImage);
    }

    public void removeSinks() {
        super.removeSinks();
    }

    public boolean addSink(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return super.addSink(object);
    }

    public boolean removeSink(Object object) {
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return super.removeSink(object);
    }

    public Point2D mapDestPoint(Point2D point2D, int n) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        this.createRendering();
        if (this.theImage != null && this.theImage instanceof OpImage) {
            return ((OpImage)this.theImage).mapDestPoint(point2D, n);
        }
        return point2D;
    }

    public Point2D mapSourcePoint(Point2D point2D, int n) {
        if (point2D == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (n < 0 || n >= this.getNumSources()) {
            throw new IndexOutOfBoundsException(JaiI18N.getString("Generic1"));
        }
        this.createRendering();
        if (this.theImage != null && this.theImage instanceof OpImage) {
            return ((OpImage)this.theImage).mapSourcePoint(point2D, n);
        }
        return point2D;
    }

    public synchronized void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        if (this.theImage != null) {
            this.theImage.dispose();
        }
        super.dispose();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.eventManager);
        objectOutputStream.writeObject(this.properties);
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.eventManager = (PropertyChangeSupportJAI)objectInputStream.readObject();
        this.properties = (WritablePropertySourceImpl)objectInputStream.readObject();
        OperationDescriptor operationDescriptor = (OperationDescriptor)this.getRegistry().getDescriptor("rendered", this.nodeSupport.getOperationName());
        if (operationDescriptor.isImmediate()) {
            this.createRendering();
        }
    }

    void sendExceptionToListener(String string, Exception exception) {
        ImagingListener imagingListener = (ImagingListener)this.getRenderingHints().get(JAI.KEY_IMAGING_LISTENER);
        imagingListener.errorOccurred(string, exception, this, false);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nodeEventNames = null;
        CaselessStringKey[] caselessStringKeyArray = new CaselessStringKey[]{new CaselessStringKey("image_width"), new CaselessStringKey("image_height"), new CaselessStringKey("image_min_x_coord"), new CaselessStringKey("image_min_y_coord"), new CaselessStringKey("tile_cache"), new CaselessStringKey("tile_cache_key")};
        synthProps = Arrays.asList(caselessStringKeyArray);
        nodeEventNames = new HashSet();
        nodeEventNames.add("operationname");
        nodeEventNames.add("operationregistry");
        nodeEventNames.add("parameterblock");
        nodeEventNames.add("sources");
        nodeEventNames.add("parameters");
        nodeEventNames.add("renderinghints");
    }

    private class TCL
    implements TileComputationListener {
        RenderedOp node;

        private TCL(RenderedOp renderedOp2) {
            this.node = renderedOp2;
        }

        public void tileComputed(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2, Raster raster) {
            TileComputationListener[] tileComputationListenerArray;
            if (planarImage == RenderedOp.this.theImage && (tileComputationListenerArray = RenderedOp.this.getTileComputationListeners()) != null) {
                int n3 = tileComputationListenerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    tileComputationListenerArray[n4].tileComputed(this.node, tileRequestArray, planarImage, n, n2, raster);
                    ++n4;
                }
            }
        }

        public void tileCancelled(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2) {
            TileComputationListener[] tileComputationListenerArray;
            if (planarImage == RenderedOp.this.theImage && (tileComputationListenerArray = RenderedOp.this.getTileComputationListeners()) != null) {
                int n3 = tileComputationListenerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    tileComputationListenerArray[n4].tileCancelled(this.node, tileRequestArray, planarImage, n, n2);
                    ++n4;
                }
            }
        }

        public void tileComputationFailure(Object object, TileRequest[] tileRequestArray, PlanarImage planarImage, int n, int n2, Throwable throwable) {
            TileComputationListener[] tileComputationListenerArray;
            if (planarImage == RenderedOp.this.theImage && (tileComputationListenerArray = RenderedOp.this.getTileComputationListeners()) != null) {
                int n3 = tileComputationListenerArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    tileComputationListenerArray[n4].tileComputationFailure(this.node, tileRequestArray, planarImage, n, n2, throwable);
                    ++n4;
                }
            }
        }
    }
}

