/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.PropertyChangeEventJAI;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.RenderingChangeEvent;
import javax.media.jai.TileFactory;
import javax.media.jai.TiledImageGraphics;

public class TiledImage
extends PlanarImage
implements WritableRenderedImage,
PropertyChangeListener {
    protected int tilesX;
    protected int tilesY;
    protected int minTileX;
    protected int minTileY;
    protected WritableRaster[][] tiles;
    protected int[][] writers;
    protected Vector tileObservers = null;
    private boolean areBuffersShared = false;
    private TiledImage parent = null;
    private SampleModel ancestorSampleModel = null;
    private int[] bandList = null;
    private int[] numWritableTiles = null;
    private ROI srcROI = null;
    private Rectangle overlapBounds = null;

    private static SampleModel coerceSampleModel(SampleModel sampleModel, int n, int n2) {
        return sampleModel.getWidth() == n && sampleModel.getHeight() == n2 ? sampleModel : sampleModel.createCompatibleSampleModel(n, n2);
    }

    private void initTileGrid(TiledImage tiledImage) {
        if (tiledImage != null) {
            this.minTileX = tiledImage.minTileX;
            this.minTileY = tiledImage.minTileY;
        } else {
            this.minTileX = this.getMinTileX();
            this.minTileY = this.getMinTileY();
        }
        int n = this.getMaxTileX();
        int n2 = this.getMaxTileY();
        this.tilesX = n - this.minTileX + 1;
        this.tilesY = n2 - this.minTileY + 1;
    }

    public TiledImage(int n, int n2, int n3, int n4, int n5, int n6, SampleModel sampleModel, ColorModel colorModel) {
        this(null, n, n2, n3, n4, n5, n6, sampleModel, colorModel);
    }

    private TiledImage(TiledImage tiledImage, int n, int n2, int n3, int n4, int n5, int n6, SampleModel sampleModel, ColorModel colorModel) {
        super(new ImageLayout(n, n2, n3, n4, n5, n6, sampleModel.getWidth(), sampleModel.getHeight(), sampleModel, colorModel), null, null);
        this.initTileGrid(tiledImage);
        if (tiledImage == null) {
            this.tiles = new WritableRaster[this.tilesX][this.tilesY];
            this.writers = new int[this.tilesX][this.tilesY];
            this.tileObservers = new Vector();
            this.numWritableTiles = new int[1];
            this.numWritableTiles[0] = 0;
            this.ancestorSampleModel = sampleModel;
        } else {
            this.parent = tiledImage;
            this.tiles = tiledImage.tiles;
            this.writers = tiledImage.writers;
            this.tileObservers = tiledImage.tileObservers;
            this.numWritableTiles = tiledImage.numWritableTiles;
            this.ancestorSampleModel = tiledImage.ancestorSampleModel;
        }
        this.tileFactory = (TileFactory)JAI.getDefaultInstance().getRenderingHint(JAI.KEY_TILE_FACTORY);
    }

    public TiledImage(Point point, SampleModel sampleModel, int n, int n2) {
        this(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight(), point.x, point.y, TiledImage.coerceSampleModel(sampleModel, n, n2), PlanarImage.createColorModel(sampleModel));
    }

    public TiledImage(SampleModel sampleModel, int n, int n2) {
        this(0, 0, sampleModel.getWidth(), sampleModel.getHeight(), 0, 0, TiledImage.coerceSampleModel(sampleModel, n, n2), PlanarImage.createColorModel(sampleModel));
    }

    public TiledImage(RenderedImage renderedImage, int n, int n2) {
        this(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight(), renderedImage.getTileGridXOffset(), renderedImage.getTileGridYOffset(), TiledImage.coerceSampleModel(renderedImage.getSampleModel(), n, n2), renderedImage.getColorModel());
        this.set(renderedImage);
    }

    public TiledImage(RenderedImage renderedImage, boolean bl) {
        this(renderedImage, renderedImage.getTileWidth(), renderedImage.getTileHeight());
        this.areBuffersShared = bl;
    }

    public static TiledImage createInterleaved(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        SampleModel sampleModel = RasterFactory.createPixelInterleavedSampleModel(n6, n7, n8, n5, n5 * n7, nArray);
        return new TiledImage(n, n2, n3, n4, n, n2, sampleModel, PlanarImage.createColorModel(sampleModel));
    }

    public static TiledImage createBanded(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray, int[] nArray2) {
        BandedSampleModel bandedSampleModel = new BandedSampleModel(n5, n6, n7, n6, nArray, nArray2);
        return new TiledImage(n, n2, n3, n4, n, n2, bandedSampleModel, PlanarImage.createColorModel(bandedSampleModel));
    }

    private void overlayPixels(WritableRaster writableRaster, RenderedImage renderedImage, Rectangle rectangle) {
        WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.bandList);
        renderedImage.copyData(writableRaster2);
    }

    private void overlayPixels(WritableRaster writableRaster, RenderedImage renderedImage, Area area) {
        ROIShape rOIShape = new ROIShape(area);
        Rectangle rectangle = rOIShape.getBounds();
        LinkedList linkedList = rOIShape.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = linkedList.size();
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle2 = (Rectangle)linkedList.get(n2);
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle2.x, rectangle2.y, this.bandList);
            renderedImage.copyData(writableRaster2);
            ++n2;
        }
    }

    private void overlayPixels(WritableRaster writableRaster, RenderedImage renderedImage, Rectangle rectangle, int[][] nArray) {
        Raster raster = renderedImage.getData(rectangle);
        if (this.bandList != null) {
            writableRaster = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.bandList);
        }
        Object object = raster.getDataElements(rectangle.x, rectangle.y, null);
        int n = rectangle.width % 32;
        int n2 = (rectangle.width + 31) / 32 - (n > 0 ? 1 : 0);
        int n3 = rectangle.y;
        int n4 = 0;
        while (n4 < rectangle.height) {
            int n5;
            int n6;
            int n7;
            int[] nArray2 = nArray[n4];
            int n8 = rectangle.x;
            int n9 = 0;
            while (n9 < n2) {
                n7 = nArray2[n9];
                n6 = Integer.MIN_VALUE;
                n5 = 0;
                while (n5 < 32) {
                    if ((n7 & n6) != 0) {
                        raster.getDataElements(n8, n3, object);
                        writableRaster.setDataElements(n8, n3, object);
                    }
                    n6 >>>= 1;
                    ++n5;
                    ++n8;
                }
                ++n9;
            }
            if (n > 0) {
                n7 = nArray2[n9];
                n6 = Integer.MIN_VALUE;
                n5 = 0;
                while (n5 < n) {
                    if ((n7 & n6) != 0) {
                        raster.getDataElements(n8, n3, object);
                        writableRaster.setDataElements(n8, n3, object);
                    }
                    n6 >>>= 1;
                    ++n5;
                    ++n8;
                }
            }
            ++n4;
            ++n3;
        }
    }

    public void set(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.getNumSources() > 0 && renderedImage == this.getSourceImage(0)) {
            return;
        }
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        if ((rectangle = rectangle.intersection(this.getBounds())).isEmpty()) {
            return;
        }
        this.areBuffersShared = false;
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        int n5 = n2;
        while (n5 <= n4) {
            int n6 = n;
            while (n6 <= n3) {
                WritableRaster writableRaster = this.tiles[n6 - this.minTileX][n5 - this.minTileY];
                if (writableRaster != null && !this.isTileLocked(n6, n5)) {
                    Rectangle rectangle2 = this.getTileRect(n6, n5);
                    if (!(rectangle2 = rectangle2.intersection(rectangle)).isEmpty()) {
                        this.overlayPixels(writableRaster, renderedImage, rectangle2);
                    }
                }
                ++n6;
            }
            ++n5;
        }
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        if (this.getNumSources() == 0) {
            this.addSource(planarImage);
        } else {
            this.setSource(planarImage, 0);
        }
        this.srcROI = null;
        this.overlapBounds = rectangle;
        this.properties.addProperties(planarImage);
    }

    public void set(RenderedImage renderedImage, ROI rOI) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        if (this.getNumSources() > 0 && renderedImage == this.getSourceImage(0)) {
            return;
        }
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = rectangle.intersection(rOI.getBounds());
        if (rectangle2.isEmpty() || (rectangle2 = rectangle2.intersection(this.getBounds())).isEmpty()) {
            return;
        }
        this.areBuffersShared = false;
        int n = this.XToTileX(rectangle2.x);
        int n2 = this.YToTileY(rectangle2.y);
        int n3 = this.XToTileX(rectangle2.x + rectangle2.width - 1);
        int n4 = this.YToTileY(rectangle2.y + rectangle2.height - 1);
        Shape shape = rOI.getAsShape();
        Area area = null;
        if (shape != null) {
            area = new Area(shape);
        }
        int n5 = n2;
        while (n5 <= n4) {
            int n6 = n;
            while (n6 <= n3) {
                Rectangle rectangle3;
                WritableRaster writableRaster = this.tiles[n6 - this.minTileX][n5 - this.minTileY];
                if (writableRaster != null && !this.isTileLocked(n6, n5) && !(rectangle3 = this.getTileRect(n6, n5).intersection(rectangle2)).isEmpty()) {
                    Object object;
                    if (shape != null) {
                        object = new Area(rectangle3);
                        ((Area)object).intersect(area);
                        if (!((Area)object).isEmpty()) {
                            this.overlayPixels(writableRaster, renderedImage, (Area)object);
                        }
                    } else {
                        object = rOI.getAsBitmask(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, null);
                        if (object != null && ((Object)object).length > 0) {
                            this.overlayPixels(writableRaster, renderedImage, rectangle3, (int[][])object);
                        }
                    }
                }
                ++n6;
            }
            ++n5;
        }
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        if (this.getNumSources() == 0) {
            this.addSource(planarImage);
        } else {
            this.setSource(planarImage, 0);
        }
        this.srcROI = rOI;
        this.overlapBounds = rectangle2;
        this.properties.addProperties(planarImage);
    }

    public Graphics getGraphics() {
        return this.createGraphics();
    }

    public Graphics2D createGraphics() {
        int n = this.sampleModel.getDataType();
        if (n != 0 && n != 2 && n != 1 && n != 3) {
            throw new UnsupportedOperationException(JaiI18N.getString("TiledImage0"));
        }
        return new TiledImageGraphics(this);
    }

    public TiledImage getSubImage(int n, int n2, int n3, int n4, int[] nArray, ColorModel colorModel) {
        SampleModel sampleModel;
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (rectangle.isEmpty()) {
            return null;
        }
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        if (rectangle2.isEmpty()) {
            return null;
        }
        SampleModel sampleModel2 = sampleModel = nArray != null ? this.getSampleModel().createSubsetSampleModel(nArray) : this.getSampleModel();
        if (colorModel == null && (nArray == null || nArray.length == this.getSampleModel().getNumBands())) {
            colorModel = this.getColorModel();
        }
        TiledImage tiledImage = new TiledImage(this, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, this.getTileGridXOffset(), this.getTileGridYOffset(), sampleModel, colorModel);
        int[] nArray2 = null;
        if (nArray != null) {
            if (this.bandList != null) {
                nArray2 = new int[nArray.length];
                int n5 = 0;
                while (n5 < nArray.length) {
                    nArray2[n5] = this.bandList[nArray[n5]];
                    ++n5;
                }
            } else {
                nArray2 = nArray;
            }
        } else {
            nArray2 = this.bandList;
        }
        tiledImage.bandList = nArray2;
        return tiledImage;
    }

    public TiledImage getSubImage(int n, int n2, int n3, int n4, int[] nArray) {
        SampleModel sampleModel = nArray != null ? this.getSampleModel().createSubsetSampleModel(nArray) : this.getSampleModel();
        return this.getSubImage(n, n2, n3, n4, nArray, PlanarImage.createColorModel(sampleModel));
    }

    public TiledImage getSubImage(int n, int n2, int n3, int n4) {
        return this.getSubImage(n, n2, n3, n4, null, null);
    }

    public TiledImage getSubImage(int[] nArray, ColorModel colorModel) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.getSubImage(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight(), nArray, colorModel);
    }

    public TiledImage getSubImage(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        return this.getSubImage(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight(), nArray);
    }

    private void createTile(int n, int n2) {
        PlanarImage planarImage;
        PlanarImage planarImage2 = planarImage = this.getNumSources() > 0 ? this.getSourceImage(0) : null;
        if (planarImage == null && this.parent != null) {
            this.parent.createTile(n, n2);
            return;
        }
        WritableRaster[][] writableRasterArray = this.tiles;
        synchronized (writableRasterArray) {
            if (this.tiles[n - this.minTileX][n2 - this.minTileY] == null) {
                if (this.areBuffersShared) {
                    Raster raster = planarImage.getTile(n, n2);
                    if (raster instanceof WritableRaster) {
                        this.tiles[n - this.minTileX][n2 - this.minTileY] = (WritableRaster)raster;
                    } else {
                        Point point = new Point(raster.getMinX(), raster.getMinY());
                        this.tiles[n - this.minTileX][n2 - this.minTileY] = Raster.createWritableRaster(this.sampleModel, raster.getDataBuffer(), point);
                    }
                    return;
                }
                this.tiles[n - this.minTileX][n2 - this.minTileY] = this.createWritableRaster(this.ancestorSampleModel, new Point(this.tileXToX(n), this.tileYToY(n2)));
                WritableRaster writableRaster = this.tiles[n - this.minTileX][n2 - this.minTileY];
                if (planarImage != null) {
                    Rectangle rectangle = this.getTileRect(n, n2);
                    Rectangle rectangle2 = this.overlapBounds.intersection(rectangle);
                    if (rectangle2.isEmpty()) {
                        return;
                    }
                    if (this.srcROI != null) {
                        Shape shape = this.srcROI.getAsShape();
                        if (shape != null) {
                            Area area = new Area(rectangle2);
                            area.intersect(new Area(shape));
                            if (!area.isEmpty()) {
                                this.overlayPixels(writableRaster, (RenderedImage)planarImage, area);
                            }
                        } else {
                            int[][] nArray = this.srcROI.getAsBitmask(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, null);
                            this.overlayPixels(writableRaster, planarImage, rectangle2, nArray);
                        }
                    } else if (!rectangle2.isEmpty()) {
                        if (this.bandList == null && rectangle2.equals(rectangle)) {
                            if (rectangle.equals(writableRaster.getBounds())) {
                                planarImage.copyData(writableRaster);
                            } else {
                                planarImage.copyData(writableRaster.createWritableChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle2.x, rectangle2.y, null));
                            }
                        } else {
                            this.overlayPixels(writableRaster, (RenderedImage)planarImage, rectangle2);
                        }
                    }
                }
            }
        }
    }

    public Raster getTile(int n, int n2) {
        if (n < this.minTileX || n2 < this.minTileY || n > this.getMaxTileX() || n2 > this.getMaxTileY()) {
            return null;
        }
        this.createTile(n, n2);
        if (this.bandList == null) {
            return this.tiles[n - this.minTileX][n2 - this.minTileY];
        }
        WritableRaster writableRaster = this.tiles[n - this.minTileX][n2 - this.minTileY];
        return writableRaster.createChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), this.bandList);
    }

    public WritableRaster getWritableTile(int n, int n2) {
        Object object;
        if (n < this.minTileX || n2 < this.minTileY || n > this.getMaxTileX() || n2 > this.getMaxTileY()) {
            return null;
        }
        if (this.isTileLocked(n, n2)) {
            return null;
        }
        this.createTile(n, n2);
        int[] nArray = this.writers[n - this.minTileX];
        int n3 = n2 - this.minTileY;
        nArray[n3] = nArray[n3] + 1;
        if (this.writers[n - this.minTileX][n2 - this.minTileY] == 1) {
            this.numWritableTiles[0] = this.numWritableTiles[0] + 1;
            object = this.tileObservers.elements();
            while (object.hasMoreElements()) {
                TileObserver tileObserver = (TileObserver)object.nextElement();
                tileObserver.tileUpdate(this, n, n2, true);
            }
        }
        if (this.bandList == null) {
            return this.tiles[n - this.minTileX][n2 - this.minTileY];
        }
        object = this.tiles[n - this.minTileX][n2 - this.minTileY];
        return ((WritableRaster)object).createWritableChild(((Raster)object).getMinX(), ((Raster)object).getMinY(), ((Raster)object).getWidth(), ((Raster)object).getHeight(), ((Raster)object).getMinX(), ((Raster)object).getMinY(), this.bandList);
    }

    public void releaseWritableTile(int n, int n2) {
        if (this.isTileLocked(n, n2)) {
            return;
        }
        int[] nArray = this.writers[n - this.minTileX];
        int n3 = n2 - this.minTileY;
        nArray[n3] = nArray[n3] - 1;
        if (this.writers[n - this.minTileX][n2 - this.minTileY] < 0) {
            throw new RuntimeException(JaiI18N.getString("TiledImage1"));
        }
        if (this.writers[n - this.minTileX][n2 - this.minTileY] == 0) {
            this.numWritableTiles[0] = this.numWritableTiles[0] - 1;
            Enumeration enumeration = this.tileObservers.elements();
            while (enumeration.hasMoreElements()) {
                TileObserver tileObserver = (TileObserver)enumeration.nextElement();
                tileObserver.tileUpdate(this, n, n2, false);
            }
        }
    }

    protected boolean lockTile(int n, int n2) {
        if (n < this.minTileX || n2 < this.minTileY || n > this.getMaxTileX() || n2 > this.getMaxTileY()) {
            return false;
        }
        if (this.isTileWritable(n, n2)) {
            return false;
        }
        this.createTile(n, n2);
        this.writers[n - this.minTileX][n2 - this.minTileY] = -1;
        return true;
    }

    protected boolean isTileLocked(int n, int n2) {
        return this.writers[n - this.minTileX][n2 - this.minTileY] < 0;
    }

    public void setData(Raster raster) {
        Rectangle rectangle = raster.getBounds();
        if ((rectangle = rectangle.intersection(this.getBounds())).isEmpty()) {
            return;
        }
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        int n5 = n2;
        while (n5 <= n4) {
            int n6 = n;
            while (n6 <= n3) {
                WritableRaster writableRaster = this.getWritableTile(n6, n5);
                if (writableRaster != null) {
                    Rectangle rectangle2 = this.getTileRect(n6, n5);
                    if (rectangle2.contains(rectangle)) {
                        JDKWorkarounds.setRect(writableRaster, raster, 0, 0);
                    } else {
                        Rectangle rectangle3 = rectangle.intersection(rectangle2);
                        Raster raster2 = raster.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                        WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                        JDKWorkarounds.setRect(writableRaster2, raster2, 0, 0);
                    }
                    this.releaseWritableTile(n6, n5);
                }
                ++n6;
            }
            ++n5;
        }
    }

    public void setData(Raster raster, ROI rOI) {
        Rectangle rectangle = raster.getBounds();
        if ((rectangle = rectangle.intersection(this.getBounds())).isEmpty() || (rectangle = rectangle.intersection(rOI.getBounds())).isEmpty()) {
            return;
        }
        LinkedList linkedList = rOI.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        int n5 = linkedList.size();
        int n6 = n2;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n3) {
                WritableRaster writableRaster = this.getWritableTile(n7, n6);
                if (writableRaster != null) {
                    Rectangle rectangle2 = this.getTileRect(n7, n6);
                    int n8 = 0;
                    while (n8 < n5) {
                        Rectangle rectangle3 = (Rectangle)linkedList.get(n8);
                        if (!(rectangle3 = rectangle3.intersection(rectangle2)).isEmpty()) {
                            Raster raster2 = raster.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                            JDKWorkarounds.setRect(writableRaster2, raster2, 0, 0);
                        }
                        ++n8;
                    }
                    this.releaseWritableTile(n7, n6);
                }
                ++n7;
            }
            ++n6;
        }
    }

    public void addTileObserver(TileObserver tileObserver) {
        this.tileObservers.addElement(tileObserver);
    }

    public void removeTileObserver(TileObserver tileObserver) {
        this.tileObservers.removeElement(tileObserver);
    }

    public Point[] getWritableTileIndices() {
        Point[] pointArray = null;
        if (this.hasTileWriters()) {
            int n;
            Vector<Point> vector2 = new Vector<Point>();
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.tilesY) {
                n = 0;
                while (n < this.tilesX) {
                    if (this.writers[n][n3] > 0) {
                        vector2.addElement(new Point(n + this.minTileX, n3 + this.minTileY));
                        ++n2;
                    }
                    ++n;
                }
                ++n3;
            }
            pointArray = new Point[n2];
            n = 0;
            while (n < n2) {
                pointArray[n] = (Point)vector2.elementAt(n);
                ++n;
            }
        }
        return pointArray;
    }

    public boolean hasTileWriters() {
        return this.numWritableTiles[0] > 0;
    }

    public boolean isTileWritable(int n, int n2) {
        return this.writers[n - this.minTileX][n2 - this.minTileY] > 0;
    }

    public void clearTiles() {
        if (this.hasTileWriters()) {
            throw new IllegalStateException(JaiI18N.getString("TiledImage2"));
        }
        this.tiles = null;
    }

    public void setSample(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.XToTileX(n);
        WritableRaster writableRaster = this.getWritableTile(n6, n5 = this.YToTileY(n2));
        if (writableRaster != null) {
            writableRaster.setSample(n, n2, n3, n4);
        }
        this.releaseWritableTile(n6, n5);
    }

    public int getSample(int n, int n2, int n3) {
        int n4 = this.XToTileX(n);
        int n5 = this.YToTileY(n2);
        Raster raster = this.getTile(n4, n5);
        return raster.getSample(n, n2, n3);
    }

    public void setSample(int n, int n2, int n3, float f) {
        int n4;
        int n5 = this.XToTileX(n);
        WritableRaster writableRaster = this.getWritableTile(n5, n4 = this.YToTileY(n2));
        if (writableRaster != null) {
            writableRaster.setSample(n, n2, n3, f);
        }
        this.releaseWritableTile(n5, n4);
    }

    public float getSampleFloat(int n, int n2, int n3) {
        int n4 = this.XToTileX(n);
        int n5 = this.YToTileY(n2);
        Raster raster = this.getTile(n4, n5);
        return raster.getSampleFloat(n, n2, n3);
    }

    public void setSample(int n, int n2, int n3, double d) {
        int n4;
        int n5 = this.XToTileX(n);
        WritableRaster writableRaster = this.getWritableTile(n5, n4 = this.YToTileY(n2));
        if (writableRaster != null) {
            writableRaster.setSample(n, n2, n3, d);
        }
        this.releaseWritableTile(n5, n4);
    }

    public double getSampleDouble(int n, int n2, int n3) {
        int n4 = this.XToTileX(n);
        int n5 = this.YToTileY(n2);
        Raster raster = this.getTile(n4, n5);
        return raster.getSampleDouble(n, n2, n3);
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        PlanarImage planarImage;
        PlanarImage planarImage2 = planarImage = this.getNumSources() > 0 ? this.getSourceImage(0) : null;
        if (propertyChangeEvent.getSource() == planarImage && (propertyChangeEvent instanceof RenderingChangeEvent || propertyChangeEvent instanceof PropertyChangeEventJAI && propertyChangeEvent.getPropertyName().equalsIgnoreCase("InvalidRegion"))) {
            Object object;
            Point[] pointArray;
            Shape shape = propertyChangeEvent instanceof RenderingChangeEvent ? ((RenderingChangeEvent)propertyChangeEvent).getInvalidRegion() : (Shape)propertyChangeEvent.getNewValue();
            Rectangle rectangle = shape.getBounds();
            if (rectangle.isEmpty()) {
                return;
            }
            Area area = new Area(shape);
            if (this.srcROI != null) {
                pointArray = this.srcROI.getAsShape();
                if (pointArray != null) {
                    area.intersect(new Area((Shape)pointArray));
                } else {
                    LinkedList linkedList = this.srcROI.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext() && !area.isEmpty()) {
                        area.intersect(new Area((Rectangle)iterator.next()));
                    }
                }
            }
            if (area.isEmpty()) {
                return;
            }
            pointArray = this.getTileIndices(area.getBounds());
            int n = pointArray.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = pointArray[n2].x;
                int n4 = pointArray[n2].y;
                object = this.tiles[n3][n4];
                if (object != null && area.intersects(((Raster)object).getBounds())) {
                    this.tiles[n3][n4] = null;
                }
                ++n2;
            }
            if (this.eventManager.hasListeners("InvalidRegion")) {
                Iterator iterator;
                Shape shape2 = new Rectangle();
                if (this.srcROI != null) {
                    Area area2 = new Area(this.getBounds());
                    object = this.srcROI.getAsShape();
                    if (object != null) {
                        area2.subtract(new Area((Shape)object));
                    } else {
                        Rectangle rectangle2 = area2.getBounds();
                        LinkedList linkedList = this.srcROI.getAsRectangleList(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        iterator = linkedList.iterator();
                        while (iterator.hasNext() && !area2.isEmpty()) {
                            area2.subtract(new Area((Rectangle)iterator.next()));
                        }
                    }
                    shape2 = area2;
                }
                PropertyChangeEventJAI propertyChangeEventJAI = new PropertyChangeEventJAI(this, "InvalidRegion", shape2, shape);
                this.eventManager.firePropertyChange(propertyChangeEventJAI);
                object = this.getSinks();
                if (object != null) {
                    int n5 = ((Vector)object).size();
                    int n6 = 0;
                    while (n6 < n5) {
                        iterator = ((Vector)object).get(n6);
                        if (iterator instanceof PropertyChangeListener) {
                            ((PropertyChangeListener)((Object)iterator)).propertyChange(propertyChangeEventJAI);
                        }
                        ++n6;
                    }
                }
            }
        }
    }
}

