/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.NegotiableCapability;
import javax.media.jai.util.CaselessStringKey;

public class NegotiableCapabilitySet
implements Serializable {
    private Hashtable categories = new Hashtable();
    private boolean isPreference = false;

    public NegotiableCapabilitySet(boolean bl) {
        this.isPreference = bl;
    }

    public boolean isPreference() {
        return this.isPreference;
    }

    public void add(NegotiableCapability negotiableCapability) {
        if (negotiableCapability == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet0"));
        }
        if (this.isPreference != negotiableCapability.isPreference()) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet1"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(negotiableCapability.getCategory());
        sequentialMap.put(negotiableCapability);
    }

    public void remove(NegotiableCapability negotiableCapability) {
        if (negotiableCapability == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet0"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(negotiableCapability.getCategory());
        sequentialMap.remove(negotiableCapability);
    }

    public List get(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        if (string2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet4"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(string);
        return sequentialMap.getNCList(string2);
    }

    public List get(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(string);
        Vector vector2 = sequentialMap.getCapabilityNames();
        Vector vector3 = new Vector();
        Iterator iterator = ((AbstractList)vector2).iterator();
        while (iterator.hasNext()) {
            Vector vector4 = (Vector)sequentialMap.getNCList((String)iterator.next());
            Iterator iterator2 = ((AbstractList)vector4).iterator();
            while (iterator2.hasNext()) {
                Object e = iterator2.next();
                if (vector3.contains(e)) continue;
                vector3.add(e);
            }
        }
        return vector3;
    }

    public List getCategories() {
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = this.categories.keys();
        while (enumeration.hasMoreElements()) {
            CaselessStringKey caselessStringKey = (CaselessStringKey)enumeration.nextElement();
            vector2.add(caselessStringKey.toString());
        }
        return vector2;
    }

    public List getCapabilityNames(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        SequentialMap sequentialMap = this.getCategoryMap(string);
        Vector vector2 = sequentialMap.getCapabilityNames();
        return vector2;
    }

    public NegotiableCapabilitySet negotiate(NegotiableCapabilitySet negotiableCapabilitySet) {
        if (negotiableCapabilitySet == null) {
            return null;
        }
        NegotiableCapabilitySet negotiableCapabilitySet2 = new NegotiableCapabilitySet(this.isPreference & negotiableCapabilitySet.isPreference());
        Vector vector2 = new Vector(this.getCategories());
        vector2.retainAll(negotiableCapabilitySet.getCategories());
        Iterator iterator = ((AbstractList)vector2).iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            List list2 = this.get(string);
            List list3 = negotiableCapabilitySet.get(string);
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                NegotiableCapability negotiableCapability = (NegotiableCapability)iterator2.next();
                Iterator iterator3 = list3.iterator();
                while (iterator3.hasNext()) {
                    NegotiableCapability negotiableCapability2 = (NegotiableCapability)iterator3.next();
                    NegotiableCapability negotiableCapability3 = negotiableCapability.negotiate(negotiableCapability2);
                    if (negotiableCapability3 == null) continue;
                    negotiableCapabilitySet2.add(negotiableCapability3);
                }
            }
        }
        if (negotiableCapabilitySet2.isEmpty()) {
            return null;
        }
        return negotiableCapabilitySet2;
    }

    public NegotiableCapability getNegotiatedValue(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        List list2 = this.get(string);
        if (list2.isEmpty()) {
            return null;
        }
        return (NegotiableCapability)list2.get(0);
    }

    public NegotiableCapability getNegotiatedValue(NegotiableCapabilitySet negotiableCapabilitySet, String string) {
        if (negotiableCapabilitySet == null) {
            return null;
        }
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet3"));
        }
        List list2 = this.get(string);
        List list3 = negotiableCapabilitySet.get(string);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            NegotiableCapability negotiableCapability = (NegotiableCapability)iterator.next();
            Iterator iterator2 = list3.iterator();
            while (iterator2.hasNext()) {
                NegotiableCapability negotiableCapability2 = (NegotiableCapability)iterator2.next();
                NegotiableCapability negotiableCapability3 = negotiableCapability.negotiate(negotiableCapability2);
                if (negotiableCapability3 == null) continue;
                return negotiableCapability3;
            }
        }
        return null;
    }

    public boolean isEmpty() {
        return this.categories.isEmpty();
    }

    private SequentialMap getCategoryMap(String string) {
        CaselessStringKey caselessStringKey = new CaselessStringKey(string);
        SequentialMap sequentialMap = (SequentialMap)this.categories.get(caselessStringKey);
        if (sequentialMap == null) {
            sequentialMap = new SequentialMap();
            this.categories.put(caselessStringKey, sequentialMap);
        }
        return sequentialMap;
    }

    class SequentialMap
    implements Serializable {
        Vector keys = new Vector();
        Vector values = new Vector();

        SequentialMap() {
        }

        void put(NegotiableCapability negotiableCapability) {
            CaselessStringKey caselessStringKey = new CaselessStringKey(negotiableCapability.getCapabilityName());
            int n = this.keys.indexOf(caselessStringKey);
            if (n == -1) {
                this.keys.add(caselessStringKey);
                Vector<NegotiableCapability> vector2 = new Vector<NegotiableCapability>();
                vector2.add(negotiableCapability);
                this.values.add(vector2);
            } else {
                Vector<NegotiableCapability> vector3 = (Vector<NegotiableCapability>)this.values.elementAt(n);
                if (vector3 == null) {
                    vector3 = new Vector<NegotiableCapability>();
                }
                vector3.add(negotiableCapability);
            }
        }

        List getNCList(String string) {
            CaselessStringKey caselessStringKey = new CaselessStringKey(string);
            int n = this.keys.indexOf(caselessStringKey);
            if (n == -1) {
                Vector vector2 = new Vector();
                return vector2;
            }
            Vector vector3 = (Vector)this.values.elementAt(n);
            return vector3;
        }

        void remove(NegotiableCapability negotiableCapability) {
            CaselessStringKey caselessStringKey = new CaselessStringKey(negotiableCapability.getCapabilityName());
            int n = this.keys.indexOf(caselessStringKey);
            if (n == -1) {
                throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet2"));
            }
            Vector vector2 = (Vector)this.values.elementAt(n);
            if (!vector2.remove(negotiableCapability)) {
                throw new IllegalArgumentException(JaiI18N.getString("NegotiableCapabilitySet2"));
            }
            if (vector2.isEmpty()) {
                this.keys.remove(caselessStringKey);
                this.values.remove(n);
            }
            if (this.keys.isEmpty()) {
                NegotiableCapabilitySet.this.categories.remove(new CaselessStringKey(negotiableCapability.getCategory()));
            }
        }

        Vector getCapabilityNames() {
            Vector<String> vector2 = new Vector<String>();
            Iterator iterator = ((AbstractList)this.keys).iterator();
            while (iterator.hasNext()) {
                CaselessStringKey caselessStringKey = (CaselessStringKey)iterator.next();
                vector2.add(caselessStringKey.getName());
            }
            return vector2;
        }
    }
}

