/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.remote;

import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.TileCache;
import javax.media.jai.remote.JaiI18N;
import javax.media.jai.remote.NegotiableCapability;
import javax.media.jai.remote.NegotiableCapabilitySet;
import javax.media.jai.remote.RemoteDescriptor;
import javax.media.jai.remote.RemoteImagingException;
import javax.media.jai.remote.RemoteJAI;
import javax.media.jai.remote.RemoteRIF;
import javax.media.jai.remote.RemoteRenderedImage;
import javax.media.jai.util.ImagingListener;

public abstract class PlanarImageServerProxy
extends PlanarImage
implements RemoteRenderedImage {
    protected int retryInterval;
    protected int numRetries;
    protected transient TileCache cache;
    protected Object tileCacheMetric;
    protected transient OperationRegistry registry;
    protected String serverName;
    protected String protocolName;
    protected String operationName;
    protected ParameterBlock paramBlock;
    protected RenderingHints hints;
    private ImageLayout layout = null;
    protected NegotiableCapabilitySet preferences;
    protected NegotiableCapabilitySet negotiated;
    NegotiableCapabilitySet serverCapabilities;
    NegotiableCapabilitySet clientCapabilities;

    private static void checkLayout(ImageLayout imageLayout) {
        if (imageLayout == null) {
            throw new IllegalArgumentException("layout is null.");
        }
        if (imageLayout.getValidMask() != 1023) {
            throw new Error(JaiI18N.getString("PlanarImageServerProxy3"));
        }
    }

    public PlanarImageServerProxy(String string, String string2, String string3, ParameterBlock parameterBlock, RenderingHints renderingHints) {
        super(null, null, null);
        if (string3 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImageServerProxy1"));
        }
        this.serverName = string;
        this.protocolName = string2;
        this.operationName = string3;
        this.paramBlock = parameterBlock;
        this.hints = renderingHints;
        if (renderingHints == null) {
            this.registry = JAI.getDefaultInstance().getOperationRegistry();
            this.cache = JAI.getDefaultInstance().getTileCache();
            this.retryInterval = 1000;
            this.numRetries = 5;
            this.setNegotiationPreferences(null);
        } else {
            Integer n;
            this.registry = (OperationRegistry)renderingHints.get(JAI.KEY_OPERATION_REGISTRY);
            if (this.registry == null) {
                this.registry = JAI.getDefaultInstance().getOperationRegistry();
            }
            this.cache = (TileCache)renderingHints.get(JAI.KEY_TILE_CACHE);
            if (this.cache == null) {
                this.cache = JAI.getDefaultInstance().getTileCache();
            }
            this.retryInterval = (n = (Integer)renderingHints.get(JAI.KEY_RETRY_INTERVAL)) == null ? 1000 : n;
            n = (Integer)renderingHints.get(JAI.KEY_NUM_RETRIES);
            this.numRetries = n == null ? 5 : n;
            this.tileCacheMetric = renderingHints.get(JAI.KEY_TILE_CACHE_METRIC);
            this.setNegotiationPreferences((NegotiableCapabilitySet)renderingHints.get(JAI.KEY_NEGOTIATION_PREFERENCES));
        }
        if (parameterBlock != null) {
            this.setSources(parameterBlock.getSources());
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public ParameterBlock getParameterBlock() {
        return this.paramBlock;
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public TileCache getTileCache() {
        return this.cache;
    }

    public void setTileCache(TileCache tileCache) {
        if (this.cache != null) {
            this.cache.removeTiles(this);
        }
        this.cache = tileCache;
    }

    public Object getTileCacheMetric() {
        return this.tileCacheMetric;
    }

    public abstract ImageLayout getImageLayout() throws RemoteImagingException;

    public abstract Object getRemoteProperty(String var1) throws RemoteImagingException;

    public abstract String[] getRemotePropertyNames() throws RemoteImagingException;

    public abstract Rectangle mapSourceRect(Rectangle var1, int var2) throws RemoteImagingException;

    public abstract Rectangle mapDestRect(Rectangle var1, int var2) throws RemoteImagingException;

    public abstract Raster computeTile(int var1, int var2) throws RemoteImagingException;

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public void setRetryInterval(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic3"));
        }
        this.retryInterval = n;
    }

    public int getNumRetries() {
        return this.numRetries;
    }

    public void setNumRetries(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic4"));
        }
        this.numRetries = n;
    }

    public int getMinX() {
        this.requestLayout();
        return this.minX;
    }

    public int getMaxX() {
        this.requestLayout();
        return this.minX + this.width;
    }

    public int getMinY() {
        this.requestLayout();
        return this.minY;
    }

    public int getMaxY() {
        this.requestLayout();
        return this.minY + this.height;
    }

    public int getWidth() {
        this.requestLayout();
        return this.width;
    }

    public int getHeight() {
        this.requestLayout();
        return this.height;
    }

    public int getTileWidth() {
        this.requestLayout();
        return this.tileWidth;
    }

    public int getTileHeight() {
        this.requestLayout();
        return this.tileHeight;
    }

    public int getTileGridXOffset() {
        this.requestLayout();
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        this.requestLayout();
        return this.tileGridYOffset;
    }

    public SampleModel getSampleModel() {
        this.requestLayout();
        return this.sampleModel;
    }

    public ColorModel getColorModel() {
        this.requestLayout();
        return this.colorModel;
    }

    private ImageLayout requestLayout() {
        if (this.layout != null) {
            return this.layout;
        }
        RemoteImagingException remoteImagingException = null;
        int n = 0;
        while (n++ < this.numRetries) {
            try {
                this.layout = this.getImageLayout();
                PlanarImageServerProxy.checkLayout(this.layout);
                this.minX = this.layout.getMinX(null);
                this.minY = this.layout.getMinY(null);
                this.width = this.layout.getWidth(null);
                this.height = this.layout.getHeight(null);
                this.tileWidth = this.layout.getTileWidth(null);
                this.tileHeight = this.layout.getTileHeight(null);
                this.tileGridXOffset = this.layout.getTileGridXOffset(null);
                this.tileGridYOffset = this.layout.getTileGridYOffset(null);
                this.sampleModel = this.layout.getSampleModel(null);
                this.colorModel = this.layout.getColorModel(null);
                break;
            }
            catch (RemoteImagingException remoteImagingException2) {
                System.err.println(JaiI18N.getString("PlanarImageServerProxy0"));
                remoteImagingException = remoteImagingException2;
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.layout == null) {
            this.sendExceptionToListener(remoteImagingException);
        }
        return this.layout;
    }

    public Object getProperty(String string) {
        Object object = super.getProperty(string);
        if (object == null || object == Image.UndefinedProperty) {
            RemoteImagingException remoteImagingException = null;
            int n = 0;
            while (n++ < this.numRetries) {
                try {
                    object = this.getRemoteProperty(string);
                    if (object != Image.UndefinedProperty) {
                        this.setProperty(string, object);
                    }
                    return object;
                }
                catch (RemoteImagingException remoteImagingException2) {
                    System.err.println(JaiI18N.getString("PlanarImageServerProxy0"));
                    remoteImagingException = remoteImagingException2;
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.sendExceptionToListener(remoteImagingException);
            return object;
        }
        return object;
    }

    public String[] getPropertyNames() {
        int n;
        String[] stringArray = super.getPropertyNames();
        Vector<String> vector2 = new Vector<String>();
        if (stringArray != null) {
            n = 0;
            while (n < stringArray.length) {
                vector2.add(stringArray[n]);
                ++n;
            }
        }
        n = 0;
        String[] stringArray2 = null;
        RemoteImagingException remoteImagingException = null;
        while (n++ < this.numRetries) {
            try {
                stringArray2 = this.getRemotePropertyNames();
                break;
            }
            catch (RemoteImagingException remoteImagingException2) {
                System.err.println(JaiI18N.getString("PlanarImageServerProxy0"));
                remoteImagingException = remoteImagingException2;
                try {
                    Thread.sleep(this.retryInterval);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (n > this.numRetries) {
            this.sendExceptionToListener(remoteImagingException);
        }
        if (stringArray2 != null) {
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (!vector2.contains(stringArray2[n2])) {
                    vector2.add(stringArray2[n2]);
                }
                ++n2;
            }
        }
        String[] stringArray3 = vector2.size() == 0 ? null : vector2.toArray(new String[vector2.size()]);
        return stringArray3;
    }

    public Raster getTile(int n, int n2) {
        Raster raster = null;
        if (n >= this.getMinTileX() && n <= this.getMaxTileX() && n2 >= this.getMinTileY() && n2 <= this.getMaxTileY()) {
            Raster raster2 = raster = this.cache != null ? this.cache.getTile(this, n, n2) : null;
            if (raster == null) {
                int n3 = 0;
                RemoteImagingException remoteImagingException = null;
                while (n3++ < this.numRetries) {
                    try {
                        raster = this.computeTile(n, n2);
                        break;
                    }
                    catch (RemoteImagingException remoteImagingException2) {
                        System.err.println(JaiI18N.getString("PlanarImageServerProxy0"));
                        remoteImagingException = remoteImagingException2;
                        try {
                            Thread.sleep(this.retryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (n3 > this.numRetries) {
                    this.sendExceptionToListener(remoteImagingException);
                }
                if (this.cache != null) {
                    this.cache.add(this, n, n2, raster, this.tileCacheMetric);
                }
            }
        }
        return raster;
    }

    protected void finalize() throws Throwable {
        if (this.cache != null) {
            this.cache.removeTiles(this);
        }
        super.finalize();
    }

    public NegotiableCapabilitySet getNegotiationPreferences() {
        return this.preferences;
    }

    public void setNegotiationPreferences(NegotiableCapabilitySet negotiableCapabilitySet) {
        this.preferences = negotiableCapabilitySet;
        this.negotiated = null;
        this.getNegotiatedValues();
    }

    public synchronized NegotiableCapabilitySet getNegotiatedValues() throws RemoteImagingException {
        if (this.negotiated == null) {
            this.getCapabilities();
            this.negotiated = RemoteJAI.negotiate(this.preferences, this.serverCapabilities, this.clientCapabilities);
            this.setServerNegotiatedValues(this.negotiated);
        }
        return this.negotiated;
    }

    public NegotiableCapability getNegotiatedValue(String string) throws RemoteImagingException {
        if (this.negotiated == null) {
            this.getCapabilities();
            return RemoteJAI.negotiate(this.preferences, this.serverCapabilities, this.clientCapabilities, string);
        }
        return this.negotiated.getNegotiatedValue(string);
    }

    private void getCapabilities() {
        Object object;
        String string = "remoteRendered";
        if (this.serverCapabilities == null) {
            object = (RemoteDescriptor)this.registry.getDescriptor(string, this.protocolName);
            int n = 0;
            RemoteImagingException remoteImagingException = null;
            while (n++ < this.numRetries) {
                try {
                    this.serverCapabilities = object.getServerCapabilities(this.serverName);
                    break;
                }
                catch (RemoteImagingException remoteImagingException2) {
                    System.err.println(JaiI18N.getString("PlanarImageServerProxy0"));
                    remoteImagingException = remoteImagingException2;
                    try {
                        Thread.sleep(this.retryInterval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            if (n > this.numRetries) {
                this.sendExceptionToListener(remoteImagingException);
            }
        }
        if (this.clientCapabilities == null) {
            object = (RemoteRIF)this.registry.getFactory(string, this.protocolName);
            this.clientCapabilities = object.getClientCapabilities();
        }
    }

    void sendExceptionToListener(Exception exception) {
        ImagingListener imagingListener = null;
        imagingListener = this.hints != null ? (ImagingListener)this.hints.get(JAI.KEY_IMAGING_LISTENER) : JAI.getDefaultInstance().getImagingListener();
        String string = JaiI18N.getString("PlanarImageServerProxy2");
        imagingListener.errorOccurred(string, new RemoteImagingException(string, exception), this, false);
    }

    public abstract void setServerNegotiatedValues(NegotiableCapabilitySet var1) throws RemoteImagingException;
}

