/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.util.ArrayUtil;

public class TagTreeEncoder {
    protected int w;
    protected int h;
    protected int lvls;
    protected int[][] treeV;
    protected int[][] treeS;
    protected int[][] treeVbak;
    protected int[][] treeSbak;
    protected boolean saved;

    public TagTreeEncoder(int n, int n2) {
        if (n2 < 0 || n < 0) {
            throw new IllegalArgumentException();
        }
        this.init(n2, n);
        for (int i = this.treeV.length - 1; i >= 0; --i) {
            ArrayUtil.intArraySet(this.treeV[i], Integer.MAX_VALUE);
        }
    }

    public TagTreeEncoder(int n, int n2, int[] nArray) {
        if (n2 < 0 || n < 0 || nArray.length < n2 * n) {
            throw new IllegalArgumentException();
        }
        this.init(n2, n);
        for (int i = n2 * n - 1; i >= 0; --i) {
            this.treeV[0][i] = nArray[i];
        }
        this.recalcTreeV();
    }

    public final int getWidth() {
        return this.w;
    }

    public final int getHeight() {
        return this.h;
    }

    private void init(int n, int n2) {
        this.w = n;
        this.h = n2;
        if (n == 0 || n2 == 0) {
            this.lvls = 0;
        } else {
            this.lvls = 1;
            while (n2 != 1 || n != 1) {
                n = n + 1 >> 1;
                n2 = n2 + 1 >> 1;
                ++this.lvls;
            }
        }
        this.treeV = new int[this.lvls][];
        this.treeS = new int[this.lvls][];
        n = this.w;
        n2 = this.h;
        for (int i = 0; i < this.lvls; ++i) {
            this.treeV[i] = new int[n2 * n];
            this.treeS[i] = new int[n2 * n];
            n = n + 1 >> 1;
            n2 = n2 + 1 >> 1;
        }
    }

    private void recalcTreeV() {
        for (int i = 0; i < this.lvls - 1; ++i) {
            int n;
            int n2;
            int n3;
            int n4 = this.w + (1 << i) - 1 >> i;
            int n5 = this.h + (1 << i) - 1 >> i;
            for (n3 = (n5 >> 1 << 1) - 2; n3 >= 0; n3 -= 2) {
                for (n2 = (n4 >> 1 << 1) - 2; n2 >= 0; n2 -= 2) {
                    n = n3 * n4 + n2;
                    int n6 = this.treeV[i][n] < this.treeV[i][n + 1] ? this.treeV[i][n] : this.treeV[i][n + 1];
                    int n7 = this.treeV[i][n + n4] < this.treeV[i][n + n4 + 1] ? this.treeV[i][n + n4] : this.treeV[i][n + n4 + 1];
                    this.treeV[i + 1][(n3 >> 1) * (n4 + 1 >> 1) + (n2 >> 1)] = n6 < n7 ? n6 : n7;
                }
                if (n4 % 2 == 0) continue;
                n2 = n4 >> 1 << 1;
                n = n3 * n4 + n2;
                this.treeV[i + 1][(n3 >> 1) * (n4 + 1 >> 1) + (n2 >> 1)] = this.treeV[i][n] < this.treeV[i][n + n4] ? this.treeV[i][n] : this.treeV[i][n + n4];
            }
            if (n5 % 2 == 0) continue;
            n3 = n5 >> 1 << 1;
            for (n2 = (n4 >> 1 << 1) - 2; n2 >= 0; n2 -= 2) {
                n = n3 * n4 + n2;
                this.treeV[i + 1][(n3 >> 1) * (n4 + 1 >> 1) + (n2 >> 1)] = this.treeV[i][n] < this.treeV[i][n + 1] ? this.treeV[i][n] : this.treeV[i][n + 1];
            }
            if (n4 % 2 == 0) continue;
            n2 = n4 >> 1 << 1;
            this.treeV[i + 1][(n3 >> 1) * (n4 + 1 >> 1) + (n2 >> 1)] = this.treeV[i][n3 * n4 + n2];
        }
    }

    public void setValue(int n, int n2, int n3) {
        int n4;
        if (this.lvls == 0 || n2 < 0 || n2 >= this.w || n3 < this.treeS[this.lvls - 1][0] || this.treeV[0][n * this.w + n2] < this.treeS[this.lvls - 1][0]) {
            throw new IllegalArgumentException();
        }
        this.treeV[0][n * this.w + n2] = n3;
        for (int i = 1; i < this.lvls && n3 < this.treeV[i][n4 = (n >> i) * (this.w + (1 << i) - 1 >> i) + (n2 >> i)]; ++i) {
            this.treeV[i][n4] = n3;
        }
    }

    public void setValues(int[] nArray) {
        if (this.lvls == 0) {
            throw new IllegalArgumentException();
        }
        int n = this.treeS[this.lvls - 1][0];
        for (int i = this.w * this.h - 1; i >= 0; --i) {
            if ((this.treeV[0][i] < n || nArray[i] < n) && this.treeV[0][i] != nArray[i]) {
                throw new IllegalArgumentException();
            }
            this.treeV[0][i] = nArray[i];
        }
        this.recalcTreeV();
    }

    public void encode(int n, int n2, int n3, BitOutputBuffer bitOutputBuffer) {
        if (n >= this.h || n2 >= this.w || n3 < 0) {
            throw new IllegalArgumentException();
        }
        int n4 = this.lvls - 1;
        int n5 = this.treeS[n4][0];
        while (true) {
            int n6;
            int n7;
            if ((n7 = this.treeS[n4][n6 = (n >> n4) * (this.w + (1 << n4) - 1 >> n4) + (n2 >> n4)]) < n5) {
                n7 = n5;
            }
            while (n3 > n7) {
                if (this.treeV[n4][n6] > n7) {
                    bitOutputBuffer.writeBit(0);
                } else if (this.treeV[n4][n6] == n7) {
                    bitOutputBuffer.writeBit(1);
                } else {
                    n7 = n3;
                    break;
                }
                ++n7;
            }
            this.treeS[n4][n6] = n7;
            if (n4 <= 0) break;
            n5 = n7 < this.treeV[n4][n6] ? n7 : this.treeV[n4][n6];
            --n4;
        }
    }

    public void save() {
        int n;
        if (this.treeVbak == null) {
            this.treeVbak = new int[this.lvls][];
            this.treeSbak = new int[this.lvls][];
            for (n = this.lvls - 1; n >= 0; --n) {
                this.treeVbak[n] = new int[this.treeV[n].length];
                this.treeSbak[n] = new int[this.treeV[n].length];
            }
        }
        for (n = this.treeV.length - 1; n >= 0; --n) {
            System.arraycopy(this.treeV[n], 0, this.treeVbak[n], 0, this.treeV[n].length);
            System.arraycopy(this.treeS[n], 0, this.treeSbak[n], 0, this.treeS[n].length);
        }
        this.saved = true;
    }

    public void restore() {
        if (!this.saved) {
            throw new IllegalArgumentException();
        }
        for (int i = this.lvls - 1; i >= 0; --i) {
            System.arraycopy(this.treeVbak[i], 0, this.treeV[i], 0, this.treeV[i].length);
            System.arraycopy(this.treeSbak[i], 0, this.treeS[i], 0, this.treeS[i].length);
        }
    }

    public void reset() {
        for (int i = this.lvls - 1; i >= 0; --i) {
            ArrayUtil.intArraySet(this.treeV[i], Integer.MAX_VALUE);
            ArrayUtil.intArraySet(this.treeS[i], 0);
        }
        this.saved = false;
    }

    public void reset(int[] nArray) {
        int n;
        for (n = this.w * this.h - 1; n >= 0; --n) {
            this.treeV[0][n] = nArray[n];
        }
        this.recalcTreeV();
        for (n = this.lvls - 1; n >= 0; --n) {
            ArrayUtil.intArraySet(this.treeS[n], 0);
        }
        this.saved = false;
    }
}

