/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.ico;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.sanselan.ImageFormat;
import org.apache.sanselan.ImageInfo;
import org.apache.sanselan.ImageParser;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.IImageMetadata;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.util.Debug;

public class IcoImageParser
extends ImageParser {
    private static final String DEFAULT_EXTENSION = ".ico";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".ico", ".cur"};

    public IcoImageParser() {
        super.setByteOrder(73);
    }

    public String getName() {
        return "ico-Custom";
    }

    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormat.IMAGE_FORMAT_ICO};
    }

    public boolean embedICCProfile(File src, File dst, byte[] profile) {
        return false;
    }

    public IImageMetadata getMetadata(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    public ImageInfo getImageInfo(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    public Dimension getImageSize(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    public byte[] getICCProfileBytes(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private FileHeader readFileHeader(InputStream is) throws ImageReadException, IOException {
        int Reserved = this.read2Bytes("Reserved", is, "Not a Valid ICO File");
        int IconType = this.read2Bytes("IconType", is, "Not a Valid ICO File");
        int IconCount = this.read2Bytes("IconCount", is, "Not a Valid ICO File");
        return new FileHeader(Reserved, IconType, IconCount);
    }

    private IconInfo readIconInfo(InputStream is) throws ImageReadException, IOException {
        byte Width = this.readByte("Width", is, "Not a Valid ICO File");
        byte Height = this.readByte("Height", is, "Not a Valid ICO File");
        byte ColorCount2 = this.readByte("ColorCount", is, "Not a Valid ICO File");
        byte Reserved = this.readByte("Reserved", is, "Not a Valid ICO File");
        int Planes = this.read2Bytes("Planes", is, "Not a Valid ICO File");
        int BitCount = this.read2Bytes("BitCount", is, "Not a Valid ICO File");
        int ImageSize2 = this.read4Bytes("ImageSize", is, "Not a Valid ICO File");
        int ImageOffset = this.read4Bytes("ImageOffset", is, "Not a Valid ICO File");
        return new IconInfo(Width, Height, ColorCount2, Reserved, Planes, BitCount, ImageSize2, ImageOffset);
    }

    private IconData readIconData(InputStream is, IconInfo fIconInfo) throws ImageReadException, IOException {
        int Size2 = this.read4Bytes("Size", is, "Not a Valid ICO File");
        int Width = this.read4Bytes("Width", is, "Not a Valid ICO File");
        int Height = this.read4Bytes("Height", is, "Not a Valid ICO File");
        int Planes = this.read2Bytes("Planes", is, "Not a Valid ICO File");
        int BitCount = this.read2Bytes("BitCount", is, "Not a Valid ICO File");
        int Compression2 = this.read4Bytes("Compression", is, "Not a Valid ICO File");
        int SizeImage = this.read4Bytes("SizeImage", is, "Not a Valid ICO File");
        int XPelsPerMeter = this.read4Bytes("XPelsPerMeter", is, "Not a Valid ICO File");
        int YPelsPerMeter = this.read4Bytes("YPelsPerMeter", is, "Not a Valid ICO File");
        int ColorsUsed = this.read4Bytes("ColorsUsed", is, "Not a Valid ICO File");
        int ColorsImportant = this.read4Bytes("ColorsImportant", is, "Not a Valid ICO File");
        BitmapHeader header = new BitmapHeader(Size2, Width, Height, Planes, BitCount, Compression2, SizeImage, XPelsPerMeter, YPelsPerMeter, ColorsUsed, ColorsImportant);
        int palette_size = 0;
        byte[] palette = null;
        if (fIconInfo.BitCount == 1 || fIconInfo.BitCount == 4 || fIconInfo.BitCount == 8) {
            palette_size = 4 * (1 << fIconInfo.BitCount);
            palette = this.readByteArray("palette", palette_size, is, "Not a Valid ICO File");
        }
        byte[] color_map = null;
        int scanline_size = (fIconInfo.BitCount * fIconInfo.Width + 7) / 8;
        if (scanline_size % 4 != 0) {
            scanline_size += 4 - scanline_size % 4;
        }
        int color_map_size_bytes = scanline_size * fIconInfo.Height;
        color_map = this.readByteArray("color_map", color_map_size_bytes, is, "Not a Valid ICO File");
        byte[] transparency_map = null;
        int t_scanline_size = (fIconInfo.Width + 7) / 8;
        if (t_scanline_size % 4 != 0) {
            t_scanline_size += 4 - t_scanline_size % 4;
        }
        int tcolor_map_size_bytes = t_scanline_size * fIconInfo.Height;
        transparency_map = this.readByteArray("transparency_map", tcolor_map_size_bytes, is, "Not a Valid ICO File");
        return new IconData(fIconInfo, header, palette, color_map, scanline_size, transparency_map, t_scanline_size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageContents readImage(ByteSource byteSource) throws ImageReadException, IOException {
        InputStream is = null;
        try {
            is = byteSource.getInputStream();
            FileHeader fileHeader = this.readFileHeader(is);
            IconInfo[] fIconInfos = new IconInfo[fileHeader.iconCount];
            for (int i = 0; i < fileHeader.iconCount; ++i) {
                fIconInfos[i] = this.readIconInfo(is);
            }
            IconData[] fIconDatas = new IconData[fileHeader.iconCount];
            for (int i = 0; i < fileHeader.iconCount; ++i) {
                fIconDatas[i] = this.readIconData(is, fIconInfos[i]);
            }
            ImageContents imageContents = new ImageContents(fileHeader, fIconDatas);
            return imageContents;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                Debug.debug(e);
            }
        }
    }

    public final BufferedImage getBufferedImage(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        throw new ImageReadException("Use getAllBufferedImages() instead for .ico images.");
    }

    private BufferedImage readBufferedImage(IconData fIconData) throws ImageReadException {
        IconInfo fIconInfo = fIconData.iconInfo;
        int width = fIconInfo.Width;
        int height = fIconInfo.Height;
        int[] data = new int[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb;
                int rgb;
                int alpha_byte = 0xFF & fIconData.transparency_map[fIconData.t_scanline_size * y + x / 8];
                int alpha = 1 & alpha_byte >> 7 - x % 8;
                int n = alpha = alpha == 0 ? 255 : 0;
                if (fIconInfo.BitCount == 1 || fIconInfo.BitCount == 4 || fIconInfo.BitCount == 8) {
                    int bit_index = fIconData.scanline_size * y * 8 + x * fIconInfo.BitCount;
                    int b = 0xFF & fIconData.color_map[bit_index >> 3];
                    int mask = (1 << fIconInfo.BitCount) - 1;
                    int shift = 8 - bit_index % 8 - fIconInfo.BitCount;
                    int color_index = mask & b >> shift;
                    int red = 0xFF & fIconData.palette[4 * color_index + 2];
                    int green = 0xFF & fIconData.palette[4 * color_index + 1];
                    int blue = 0xFF & fIconData.palette[4 * color_index + 0];
                    rgb = (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
                } else if (fIconInfo.BitCount == 24 || fIconInfo.BitCount == 32) {
                    int byte_count = fIconInfo.BitCount >> 3;
                    int index = fIconData.scanline_size * y + x * byte_count;
                    int red = 0xFF & fIconData.color_map[index + 2];
                    int green = 0xFF & fIconData.color_map[index + 1];
                    int blue = 0xFF & fIconData.color_map[index + 0];
                    rgb = (0xFF & red) << 16 | (0xFF & green) << 8 | (0xFF & blue) << 0;
                } else {
                    throw new ImageReadException("Unknown BitCount: " + fIconInfo.BitCount);
                }
                data[(height - y - 1) * width + x] = argb = (alpha & 0xFF) << 24 | rgb & 0xFFFFFF;
            }
        }
        ColorModel cModel = ColorModel.getRGBdefault();
        DataBufferInt intBuf = new DataBufferInt(data, width * height);
        SampleModel sModel = cModel.createCompatibleSampleModel(width, height);
        WritableRaster raster = Raster.createWritableRaster(sModel, intBuf, null);
        BufferedImage result = new BufferedImage(cModel, raster, false, null);
        return result;
    }

    public ArrayList getAllBufferedImages(ByteSource byteSource) throws ImageReadException, IOException {
        ArrayList<BufferedImage> result = new ArrayList<BufferedImage>();
        ImageContents contents = this.readImage(byteSource);
        FileHeader fileHeader = contents.fileHeader;
        for (int i = 0; i < fileHeader.iconCount; ++i) {
            IconData iconData = contents.iconDatas[i];
            BufferedImage image = this.readBufferedImage(iconData);
            result.add(image);
        }
        return result;
    }

    public String getXmpXml(ByteSource byteSource, Map params) throws ImageReadException, IOException {
        return null;
    }

    private static class ImageContents {
        public final FileHeader fileHeader;
        public final IconData[] iconDatas;

        public ImageContents(FileHeader fileHeader, IconData[] iconDatas) {
            this.fileHeader = fileHeader;
            this.iconDatas = iconDatas;
        }
    }

    private static class IconData {
        public final IconInfo iconInfo;
        public final BitmapHeader header;
        public final byte[] palette;
        public final byte[] color_map;
        public final int scanline_size;
        public final byte[] transparency_map;
        public final int t_scanline_size;

        public IconData(IconInfo iconInfo, BitmapHeader header, byte[] palette, byte[] color_map, int scanline_size, byte[] transparency_map, int t_scanline_size) {
            this.iconInfo = iconInfo;
            this.header = header;
            this.palette = palette;
            this.color_map = color_map;
            this.scanline_size = scanline_size;
            this.transparency_map = transparency_map;
            this.t_scanline_size = t_scanline_size;
        }

        public void dump() {
            System.out.println("IconData");
            this.iconInfo.dump();
            this.header.dump();
            System.out.println("scanline_size: " + this.scanline_size);
            System.out.println("t_scanline_size: " + this.t_scanline_size);
            System.out.println("palette: " + (this.palette == null ? "null" : "" + this.palette.length));
            System.out.println("color_map: " + (this.color_map == null ? "null" : "" + this.color_map.length));
            System.out.println("transparency_map: " + (this.transparency_map == null ? "null" : "" + this.transparency_map.length));
            System.out.println("");
        }
    }

    private static class BitmapHeader {
        public final int Size;
        public final int Width;
        public final int Height;
        public final int Planes;
        public final int BitCount;
        public final int Compression;
        public final int SizeImage;
        public final int XPelsPerMeter;
        public final int YPelsPerMeter;
        public final int ColorsUsed;
        public final int ColorsImportant;

        public BitmapHeader(int size, int width, int height, int planes, int bitCount, int compression, int sizeImage, int pelsPerMeter, int pelsPerMeter2, int colorsUsed, int colorsImportant) {
            this.Size = size;
            this.Width = width;
            this.Height = height;
            this.Planes = planes;
            this.BitCount = bitCount;
            this.Compression = compression;
            this.SizeImage = sizeImage;
            this.XPelsPerMeter = pelsPerMeter;
            this.YPelsPerMeter = pelsPerMeter2;
            this.ColorsUsed = colorsUsed;
            this.ColorsImportant = colorsImportant;
        }

        public void dump() {
            System.out.println("BitmapHeader");
            System.out.println("Size: " + this.Size);
            System.out.println("Width: " + this.Width);
            System.out.println("Height: " + this.Height);
            System.out.println("Planes: " + this.Planes);
            System.out.println("BitCount: " + this.BitCount);
            System.out.println("Compression: " + this.Compression);
            System.out.println("SizeImage: " + this.SizeImage);
            System.out.println("XPelsPerMeter: " + this.XPelsPerMeter);
            System.out.println("YPelsPerMeter: " + this.YPelsPerMeter);
            System.out.println("ColorsUsed: " + this.ColorsUsed);
            System.out.println("ColorsImportant: " + this.ColorsImportant);
            System.out.println("");
        }
    }

    private static class IconInfo {
        public final byte Width;
        public final byte Height;
        public final byte ColorCount;
        public final byte Reserved;
        public final int Planes;
        public final int BitCount;
        public final int ImageSize;
        public final int ImageOffset;

        public IconInfo(byte width, byte height, byte colorCount, byte reserved, int planes, int bitCount, int imageSize, int imageOffset) {
            this.Width = width;
            this.Height = height;
            this.ColorCount = colorCount;
            this.Reserved = reserved;
            this.Planes = planes;
            this.BitCount = bitCount;
            this.ImageSize = imageSize;
            this.ImageOffset = imageOffset;
        }

        public void dump() {
            System.out.println("IconInfo");
            System.out.println("Width: " + this.Width);
            System.out.println("Height: " + this.Height);
            System.out.println("ColorCount: " + this.ColorCount);
            System.out.println("Reserved: " + this.Reserved);
            System.out.println("Planes: " + this.Planes);
            System.out.println("BitCount: " + this.BitCount);
            System.out.println("ImageSize: " + this.ImageSize);
            System.out.println("ImageOffset: " + this.ImageOffset);
            System.out.println("");
        }
    }

    private static class FileHeader {
        public final int reserved;
        public final int iconType;
        public final int iconCount;

        public FileHeader(int reserved, int iconType, int iconCount) {
            this.reserved = reserved;
            this.iconType = iconType;
            this.iconCount = iconCount;
        }

        public void dump() {
            System.out.println("FileHeader");
            System.out.println("Reserved: " + this.reserved);
            System.out.println("IconType: " + this.iconType);
            System.out.println("IconCount: " + this.iconCount);
            System.out.println("");
        }
    }
}

