/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beansbinding;

import java.util.ArrayList;
import java.util.StringTokenizer;

abstract class PropertyPath {
    private PropertyPath() {
    }

    public abstract int length();

    public abstract String get(int var1);

    public String getLast() {
        return this.get(this.length() - 1);
    }

    public abstract String toString();

    public static PropertyPath createPropertyPath(String path) {
        if (path == null) {
            throw new IllegalArgumentException("path must be non-null");
        }
        StringTokenizer tokenizer = new StringTokenizer(path, ".");
        ArrayList<String> list2 = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list2.add(tokenizer.nextToken());
        }
        int size = list2.size();
        if (size == 0) {
            throw new IllegalArgumentException("path must be non-empty");
        }
        if (list2.size() == 1) {
            return new SinglePropertyPath((String)list2.get(0));
        }
        String[] multi = new String[list2.size()];
        return new MultiPropertyPath(list2.toArray(multi));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PropertyPath) {
            PropertyPath oPath = (PropertyPath)o;
            int length = this.length();
            if (length != oPath.length()) {
                return false;
            }
            int i = 0;
            if (i < length) {
                return this.get(i).equals(oPath.get(i));
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        int length = this.length();
        for (int i = 0; i < length; ++i) {
            result = 37 * result + this.get(i).hashCode();
        }
        return result;
    }

    static final class MultiPropertyPath
    extends PropertyPath {
        private final String[] path;

        public MultiPropertyPath(String[] path) {
            this.path = path;
            for (int i = 0; i < path.length; ++i) {
                path[i] = path[i].intern();
            }
            assert (path.length > 0);
        }

        public int length() {
            return this.path.length;
        }

        public String get(int index) {
            return this.path[index];
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.path[0]);
            for (int i = 1; i < this.path.length; ++i) {
                builder.append('.');
                builder.append(this.path[i]);
            }
            return builder.toString();
        }
    }

    static final class SinglePropertyPath
    extends PropertyPath {
        private final String path;

        public SinglePropertyPath(String path) {
            this.path = path.intern();
        }

        public int length() {
            return 1;
        }

        public String get(int index) {
            if (index == 0) {
                return this.path;
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public String getLast() {
            return this.path;
        }

        public String toString() {
            return this.path;
        }
    }
}

