/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.observablecollections;

import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableListListener;
import org.jdesktop.observablecollections.ObservableMap;
import org.jdesktop.observablecollections.ObservableMapListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObservableCollections {
    public static <K, V> ObservableMap<K, V> observableMap(Map<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("Map must be non-null");
        }
        return new ObservableMapImpl<K, V>(map);
    }

    public static <E> ObservableList<E> observableList(List<E> list2) {
        if (list2 == null) {
            throw new IllegalArgumentException("List must be non-null");
        }
        return new ObservableListImpl<E>(list2, false);
    }

    public static <E> ObservableListHelper<E> observableListHelper(List<E> list2) {
        ObservableListImpl<E> oList = new ObservableListImpl<E>(list2, true);
        return new ObservableListHelper<E>(oList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ObservableListHelper<E> {
        private final ObservableListImpl<E> list;

        ObservableListHelper(ObservableListImpl<E> list2) {
            this.list = list2;
        }

        public ObservableList<E> getObservableList() {
            return this.list;
        }

        public void fireElementChanged(int index) {
            if (index < 0 || index >= this.list.size()) {
                throw new ArrayIndexOutOfBoundsException("Illegal index");
            }
            ((ObservableListImpl)this.list).fireElementChanged(index);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObservableListImpl<E>
    extends AbstractList<E>
    implements ObservableList<E> {
        private final boolean supportsElementPropertyChanged;
        private List<E> list;
        private List<ObservableListListener> listeners;

        ObservableListImpl(List<E> list2, boolean supportsElementPropertyChanged) {
            this.list = list2;
            this.listeners = new CopyOnWriteArrayList<ObservableListListener>();
            this.supportsElementPropertyChanged = supportsElementPropertyChanged;
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public E set(int index, E element) {
            E oldValue = this.list.set(index, element);
            for (ObservableListListener listener : this.listeners) {
                listener.listElementReplaced(this, index, oldValue);
            }
            return oldValue;
        }

        @Override
        public void add(int index, E element) {
            this.list.add(index, element);
            ++this.modCount;
            for (ObservableListListener listener : this.listeners) {
                listener.listElementsAdded(this, index, 1);
            }
        }

        @Override
        public E remove(int index) {
            E oldValue = this.list.remove(index);
            ++this.modCount;
            for (ObservableListListener listener : this.listeners) {
                listener.listElementsRemoved(this, index, Collections.singletonList(oldValue));
            }
            return oldValue;
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            return this.addAll(this.size(), c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            if (this.list.addAll(index, c)) {
                ++this.modCount;
                for (ObservableListListener listener : this.listeners) {
                    listener.listElementsAdded(this, index, c.size());
                }
            }
            return false;
        }

        @Override
        public void clear() {
            ArrayList<E> dup = new ArrayList<E>(this.list);
            this.list.clear();
            ++this.modCount;
            if (dup.size() != 0) {
                for (ObservableListListener listener : this.listeners) {
                    listener.listElementsRemoved(this, 0, dup);
                }
            }
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.list.containsAll(c);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.list.toArray(a);
        }

        @Override
        public Object[] toArray() {
            return this.list.toArray();
        }

        private void fireElementChanged(int index) {
            for (ObservableListListener listener : this.listeners) {
                listener.listElementPropertyChanged(this, index);
            }
        }

        @Override
        public void addObservableListListener(ObservableListListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeObservableListListener(ObservableListListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public boolean supportsElementPropertyChanged() {
            return this.supportsElementPropertyChanged;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ObservableMapImpl<K, V>
    extends AbstractMap<K, V>
    implements ObservableMap<K, V> {
        private Map<K, V> map;
        private List<ObservableMapListener> listeners;
        private Set<Map.Entry<K, V>> entrySet;

        ObservableMapImpl(Map<K, V> map) {
            this.map = map;
            this.listeners = new CopyOnWriteArrayList<ObservableMapListener>();
        }

        @Override
        public void clear() {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            EntrySet es = this.entrySet;
            return es != null ? es : (this.entrySet = new EntrySet());
        }

        @Override
        public V get(Object key) {
            return this.map.get(key);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public V put(K key, V value) {
            V lastValue;
            if (this.containsKey(key)) {
                lastValue = this.map.put(key, value);
                for (ObservableMapListener listener : this.listeners) {
                    listener.mapKeyValueChanged(this, key, lastValue);
                }
            } else {
                lastValue = this.map.put(key, value);
                for (ObservableMapListener listener : this.listeners) {
                    listener.mapKeyAdded(this, key);
                }
            }
            return lastValue;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            for (K key : m.keySet()) {
                this.put(key, m.get(key));
            }
        }

        @Override
        public V remove(Object key) {
            if (this.containsKey(key)) {
                V value = this.map.remove(key);
                for (ObservableMapListener listener : this.listeners) {
                    listener.mapKeyRemoved(this, key, value);
                }
                return value;
            }
            return null;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public void addObservableMapListener(ObservableMapListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeObservableMapListener(ObservableMapListener listener) {
            this.listeners.remove(listener);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            private Iterator<Map.Entry<K, V>> realIterator;
            private Map.Entry<K, V> last;

            EntryIterator() {
                this.realIterator = ObservableMapImpl.this.map.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.realIterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                this.last = this.realIterator.next();
                return this.last;
            }

            @Override
            public void remove() {
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                Object toRemove = this.last.getKey();
                this.last = null;
                ObservableMapImpl.this.remove(toRemove);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return ObservableMapImpl.this.containsKey(e.getKey());
            }

            @Override
            public boolean remove(Object o) {
                Object key;
                if (o instanceof Map.Entry && ObservableMapImpl.this.containsKey(key = ((Map.Entry)o).getKey())) {
                    this.remove(key);
                    return true;
                }
                return false;
            }

            @Override
            public int size() {
                return ObservableMapImpl.this.size();
            }

            @Override
            public void clear() {
                ObservableMapImpl.this.clear();
            }
        }
    }
}

