/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import toxi.geom.Vec3D;
import toxi.geom.mesh.DefaultSelector;
import toxi.geom.mesh.Vertex;
import toxi.geom.mesh.VertexSelector;
import toxi.geom.mesh.WEMeshFilterStrategy;
import toxi.geom.mesh.WETriangleMesh;
import toxi.geom.mesh.WEVertex;

public class LaplacianSmooth
implements WEMeshFilterStrategy {
    public void filter(VertexSelector vertexSelector, int n) {
        Collection<Vertex> collection = vertexSelector.getSelection();
        if (!(vertexSelector.getMesh() instanceof WETriangleMesh)) {
            throw new IllegalArgumentException("This filter requires a WETriangleMesh");
        }
        WETriangleMesh wETriangleMesh = (WETriangleMesh)vertexSelector.getMesh();
        HashMap<Vertex, Vec3D> hashMap = new HashMap<Vertex, Vec3D>(collection.size());
        for (int i = 0; i < n; ++i) {
            hashMap.clear();
            for (Vertex vertex : collection) {
                Vec3D vec3D = new Vec3D();
                List<WEVertex> list2 = ((WEVertex)vertex).getNeighbors();
                for (WEVertex wEVertex : list2) {
                    vec3D.addSelf(wEVertex);
                }
                vec3D.scaleSelf(1.0f / (float)list2.size());
                hashMap.put(vertex, vec3D);
            }
            for (Vertex vertex : hashMap.keySet()) {
                ((Vertex)wETriangleMesh.vertices.get(vertex)).set((Vec3D)hashMap.get(vertex));
            }
            wETriangleMesh.rebuildIndex();
        }
        wETriangleMesh.computeFaceNormals();
        wETriangleMesh.computeVertexNormals();
    }

    public void filter(WETriangleMesh wETriangleMesh, int n) {
        this.filter(new DefaultSelector(wETriangleMesh).selectVertices(), n);
    }
}

