/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import toxi.geom.Vec3D;
import toxi.geom.mesh.SurfaceFunction;
import toxi.math.MathUtils;

public class SuperEllipsoid
implements SurfaceFunction {
    private float p1;
    private float p2;

    public SuperEllipsoid(float f, float f2) {
        this.p1 = f;
        this.p2 = f2;
    }

    public Vec3D computeVertexFor(Vec3D vec3D, float f, float f2) {
        float f3 = MathUtils.cos(f -= 1.5707964f);
        float f4 = MathUtils.cos(f2);
        float f5 = MathUtils.sin(f);
        float f6 = MathUtils.sin(f2);
        float f7 = (float)MathUtils.sign(f3) * (float)Math.pow(MathUtils.abs(f3), this.p1);
        vec3D.x = f7 * (float)MathUtils.sign(f4) * (float)Math.pow(MathUtils.abs(f4), this.p2);
        vec3D.y = (float)MathUtils.sign(f5) * (float)Math.pow(MathUtils.abs(f5), this.p1);
        vec3D.z = f7 * (float)MathUtils.sign(f6) * (float)Math.pow(MathUtils.abs(f6), this.p2);
        return vec3D;
    }

    public float getPhiRange() {
        return (float)Math.PI * 2;
    }

    public int getPhiResolutionLimit(int n) {
        return n / 2;
    }

    public float getThetaRange() {
        return (float)Math.PI * 2;
    }

    public int getThetaResolutionLimit(int n) {
        return n;
    }
}

