/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh2d;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import toxi.geom.mesh2d.DelaunayVertex;
import toxi.util.datatypes.ArraySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DelaunayTriangle
extends ArraySet<DelaunayVertex> {
    private int idNumber = idGenerator++;
    private DelaunayVertex circumcenter = null;
    private static int idGenerator = 0;
    public static boolean moreInfo = false;

    public DelaunayTriangle(Collection<? extends DelaunayVertex> collection) {
        super(collection);
        if (this.size() != 3) {
            throw new IllegalArgumentException("DelaunayTriangle must have 3 vertices");
        }
    }

    public DelaunayTriangle(DelaunayVertex ... delaunayVertexArray) {
        this((Collection<? extends DelaunayVertex>)Arrays.asList(delaunayVertexArray));
    }

    @Override
    public boolean add(DelaunayVertex delaunayVertex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object) {
        return this == object;
    }

    public ArraySet<DelaunayVertex> facetOpposite(DelaunayVertex delaunayVertex) {
        ArraySet<DelaunayVertex> arraySet = new ArraySet<DelaunayVertex>(this);
        if (!arraySet.remove(delaunayVertex)) {
            throw new IllegalArgumentException("Vertex not in triangle");
        }
        return arraySet;
    }

    public DelaunayVertex getCircumcenter() {
        if (this.circumcenter == null) {
            this.circumcenter = DelaunayVertex.circumcenter(this.toArray(new DelaunayVertex[0]));
        }
        return this.circumcenter;
    }

    public DelaunayVertex getVertexButNot(DelaunayVertex ... delaunayVertexArray) {
        List<DelaunayVertex> list2 = Arrays.asList(delaunayVertexArray);
        for (DelaunayVertex delaunayVertex : this) {
            if (list2.contains(delaunayVertex)) continue;
            return delaunayVertex;
        }
        throw new NoSuchElementException("No vertex found");
    }

    @Override
    public int hashCode() {
        return this.idNumber ^ this.idNumber >>> 32;
    }

    public boolean isNeighbor(DelaunayTriangle delaunayTriangle) {
        int n = 0;
        for (DelaunayVertex delaunayVertex : this) {
            if (delaunayTriangle.contains(delaunayVertex)) continue;
            ++n;
        }
        return n == 1;
    }

    @Override
    public Iterator<DelaunayVertex> iterator() {
        return new Iterator<DelaunayVertex>(){
            private Iterator<DelaunayVertex> it;
            {
                this.it = DelaunayTriangle.super.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public DelaunayVertex next() {
                return this.it.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public String toString() {
        if (!moreInfo) {
            return "DelaunayTriangle" + this.idNumber;
        }
        return "DelaunayTriangle" + this.idNumber + super.toString();
    }
}

