/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh2d;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import toxi.geom.Polygon2D;
import toxi.geom.Triangle2D;
import toxi.geom.Vec2D;
import toxi.geom.mesh2d.DelaunayTriangle;
import toxi.geom.mesh2d.DelaunayTriangulation;
import toxi.geom.mesh2d.DelaunayVertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Voronoi {
    public static float DEFAULT_SIZE = 10000.0f;
    protected DelaunayTriangulation delaunay;
    protected DelaunayTriangle initialTriangle;
    protected List<Vec2D> sites = new ArrayList<Vec2D>();

    public Voronoi() {
        this(DEFAULT_SIZE);
    }

    public Voronoi(float f) {
        this.initialTriangle = new DelaunayTriangle(new DelaunayVertex(-f, -f), new DelaunayVertex(f, -f), new DelaunayVertex(0.0, f));
        this.delaunay = new DelaunayTriangulation(this.initialTriangle);
    }

    public void addPoint(Vec2D vec2D) {
        this.sites.add(vec2D.copy());
        this.delaunay.delaunayPlace(new DelaunayVertex(vec2D.x, vec2D.y));
    }

    public void addPoints(List<Vec2D> list2) {
        for (Vec2D vec2D : list2) {
            this.addPoint(vec2D);
        }
    }

    public List<Polygon2D> getRegions() {
        LinkedList<Polygon2D> linkedList = new LinkedList<Polygon2D>();
        HashSet<DelaunayVertex> hashSet = new HashSet<DelaunayVertex>(this.initialTriangle);
        for (DelaunayTriangle delaunayTriangle : this.delaunay) {
            for (DelaunayVertex delaunayVertex : delaunayTriangle) {
                if (hashSet.contains(delaunayVertex)) continue;
                hashSet.add(delaunayVertex);
                List<DelaunayTriangle> list2 = this.delaunay.surroundingTriangles(delaunayVertex, delaunayTriangle);
                Polygon2D polygon2D = new Polygon2D();
                for (DelaunayTriangle delaunayTriangle2 : list2) {
                    DelaunayVertex delaunayVertex2 = delaunayTriangle2.getCircumcenter();
                    polygon2D.add(new Vec2D((float)delaunayVertex2.coord(0), (float)delaunayVertex2.coord(1)));
                }
                linkedList.add(polygon2D);
            }
        }
        return linkedList;
    }

    public List<Vec2D> getSites() {
        return this.sites;
    }

    public List<Triangle2D> getTriangles() {
        ArrayList<Triangle2D> arrayList = new ArrayList<Triangle2D>();
        for (DelaunayTriangle delaunayTriangle : this.delaunay) {
            arrayList.add(new Triangle2D(((DelaunayVertex)delaunayTriangle.get(0)).toVec2D(), ((DelaunayVertex)delaunayTriangle.get(1)).toVec2D(), ((DelaunayVertex)delaunayTriangle.get(2)).toVec2D()));
        }
        return arrayList;
    }
}

