/*
 * Decompiled with CFR 0.152.
 */
package toxi.math.waves;

import java.util.Stack;
import toxi.math.waves.WaveState;

public abstract class AbstractWave {
    public static final float PI = (float)Math.PI;
    public static final float TWO_PI = (float)Math.PI * 2;
    public float phase;
    public float frequency;
    public float amp;
    public float offset;
    public float value;
    protected float origPhase;
    protected Stack<WaveState> stateStack;

    public static final float hertzToRadians(float f, float f2) {
        return f / f2 * ((float)Math.PI * 2);
    }

    public static final float radiansToHertz(float f, float f2) {
        return f / ((float)Math.PI * 2) * f2;
    }

    public AbstractWave() {
    }

    public AbstractWave(float f) {
        this(f, 0.0f, 1.0f, 0.0f);
    }

    public AbstractWave(float f, float f2) {
        this(f, f2, 1.0f, 0.0f);
    }

    public AbstractWave(float f, float f2, float f3, float f4) {
        this.setPhase(f);
        this.frequency = f2;
        this.amp = f3;
        this.offset = f4;
    }

    public final float cyclePhase() {
        this.phase %= (float)Math.PI * 2;
        if (this.phase < 0.0f) {
            this.phase += (float)Math.PI * 2;
        }
        return this.phase;
    }

    public final float cyclePhase(float f) {
        this.phase = (this.phase + f) % ((float)Math.PI * 2);
        if (this.phase < 0.0f) {
            this.phase += (float)Math.PI * 2;
        }
        return this.phase;
    }

    public void pop() {
        if (this.stateStack == null || this.stateStack != null && this.stateStack.empty()) {
            throw new IllegalStateException("no wave states on stack");
        }
        WaveState waveState = this.stateStack.pop();
        this.phase = waveState.phase;
        this.frequency = waveState.frequency;
        this.amp = waveState.amp;
        this.offset = waveState.offset;
    }

    public void push() {
        if (this.stateStack == null) {
            this.stateStack = new Stack();
        }
        this.stateStack.push(new WaveState(this.phase, this.frequency, this.amp, this.offset));
    }

    public void reset() {
        this.phase = this.origPhase;
    }

    public void setPhase(float f) {
        this.phase = f;
        this.cyclePhase();
        this.origPhase = f;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append(" phase: ").append(this.phase);
        stringBuffer.append(" frequency: ").append(this.frequency);
        stringBuffer.append(" amp: ").append(this.amp);
        stringBuffer.append(" offset: ").append(this.offset);
        return stringBuffer.toString();
    }

    public abstract float update();
}

