/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.xml.bind.annotation.XmlAttribute;
import toxi.math.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatRange {
    @XmlAttribute
    public float min;
    @XmlAttribute
    public float max;
    @XmlAttribute(name="default")
    public float currValue;
    protected Random random = new Random();

    public static FloatRange fromSamples(List<Float> list2) {
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        for (float f3 : list2) {
            f = MathUtils.min(f, f3);
            f2 = MathUtils.max(f2, f3);
        }
        return new FloatRange(f, f2);
    }

    public FloatRange() {
        this(0.0f, 1.0f);
    }

    public FloatRange(float f, float f2) {
        this.min = f;
        this.max = f2;
        this.currValue = f;
    }

    public float adjustCurrentBy(float f) {
        return this.setCurrent(this.currValue + f);
    }

    public FloatRange copy() {
        FloatRange floatRange = new FloatRange(this.min, this.max);
        floatRange.currValue = this.currValue;
        floatRange.random = this.random;
        return floatRange;
    }

    public float getCurrent() {
        return this.currValue;
    }

    public float getMedian() {
        return (this.min + this.max) * 0.5f;
    }

    public boolean isValueInRange(float f) {
        return f >= this.min && f <= this.max;
    }

    public float pickRandom() {
        this.currValue = MathUtils.random(this.random, this.min, this.max);
        return this.currValue;
    }

    public FloatRange seed(long l) {
        this.random.setSeed(l);
        return this;
    }

    public float setCurrent(float f) {
        this.currValue = MathUtils.clip(f, this.min, this.max);
        return this.currValue;
    }

    public FloatRange setRandom(Random random) {
        this.random = random;
        return this;
    }

    public Float[] toArray(float f) {
        LinkedList<Float> linkedList = new LinkedList<Float>();
        for (double d = (double)this.min; d < (double)this.max; d += (double)f) {
            linkedList.add(Float.valueOf((float)d));
        }
        return linkedList.toArray(new Float[0]);
    }

    public String toString() {
        return "FloatRange: " + this.min + " -> " + this.max;
    }
}

