/*
 * Decompiled with CFR 0.152.
 */
package toxi.util.datatypes;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedProperties
extends Properties {
    public static final String DELIM = "\t\n\r\f\u00a0,";
    private static final Logger logger = Logger.getLogger(TypedProperties.class.getName());

    public boolean getBoolean(String string, boolean bl) {
        return Boolean.parseBoolean(this.getProperty(string, "" + bl));
    }

    public byte[] getByteArray(String string) {
        return this.getByteArray(string, new byte[0]);
    }

    public byte[] getByteArray(String string, byte[] byArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getProperty(string, ""), DELIM);
        byte[] byArray2 = new byte[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                byArray2[n] = Byte.parseByte(stringTokenizer.nextToken());
                ++n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n > 0) {
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray2, 0, byArray3, 0, n);
            return byArray3;
        }
        return byArray;
    }

    public float getFloat(String string, float f) {
        return Float.parseFloat(this.getProperty(string, "" + f));
    }

    public float[] getFloatArray(String string) {
        return this.getFloatArray(string, new float[0]);
    }

    public float[] getFloatArray(String string, float[] fArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getProperty(string, ""), DELIM);
        float[] fArray2 = new float[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                fArray2[n] = Float.parseFloat(stringTokenizer.nextToken());
                ++n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n > 0) {
            float[] fArray3 = new float[n];
            System.arraycopy(fArray2, 0, fArray3, 0, n);
            return fArray3;
        }
        return fArray;
    }

    public int getHexInt(String string, int n) {
        return Integer.parseInt(this.getProperty(string, Integer.toHexString(n)), 16);
    }

    public int getInt(String string, int n) {
        return Integer.parseInt(this.getProperty(string, "" + n));
    }

    public int[] getIntArray(String string) {
        return this.getIntArray(string, new int[0]);
    }

    public int[] getIntArray(String string, int[] nArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getProperty(string, ""), DELIM);
        int[] nArray2 = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            try {
                nArray2[n] = Integer.parseInt(stringTokenizer.nextToken());
                ++n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (n > 0) {
            int[] nArray3 = new int[n];
            System.arraycopy(nArray2, 0, nArray3, 0, n);
            return nArray3;
        }
        return nArray;
    }

    public String[] getStringArray(String string) {
        return this.getStringArray(string, new String[0]);
    }

    public String[] getStringArray(String string, String[] stringArray) {
        String[] stringArray2;
        StringTokenizer stringTokenizer = new StringTokenizer(this.getProperty(string, ""), DELIM);
        int n = 0;
        String[] stringArray3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            if (stringArray3 == null) {
                stringArray3 = new String[stringTokenizer.countTokens()];
            }
            if ((stringArray2 = stringTokenizer.nextToken()).length() <= 0) continue;
            stringArray3[n++] = stringArray2;
        }
        if (n > 0) {
            stringArray2 = new String[n];
            System.arraycopy(stringArray3, 0, stringArray2, 0, n);
            return stringArray2;
        }
        return stringArray;
    }

    public boolean load(String string) {
        try {
            this.load(new FileInputStream(string));
            return true;
        }
        catch (Exception exception) {
            logger.warning("error opening config file: " + string);
            return false;
        }
    }

    public HashMap<String, String> toHashMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (String string : this.stringPropertyNames()) {
            hashMap.put(string, this.getProperty(string));
        }
        return hashMap;
    }
}

