<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" indent="yes"/>

<!-- =========================================================================================== -->

	<xsl:param name="siteTitle" select="/photoCollection/display/metadata/siteInfo/@title"/>
	<xsl:param name="frameWidth" select="round( /photoCollection/display/style/airTight/@frameWidth )"/>
	<xsl:param name="imagePadding" select="round( /photoCollection/display/style/airTight/@imagePadding )"/>
	<xsl:param name="displayTime" select="/photoCollection/display/style/airTight/@displayTime"/>
	<xsl:param name="backgroundColor" select="/photoCollection/display/style/airTight/@backgroundColor"/>
	<xsl:param name="frameColor" select="concat( '0x', /photoCollection/display/style/airTight/@frameColor )"/>
	
<!-- =========================================================================================== -->

	<xsl:template match="/">
<gallery title="{$siteTitle}" 
		frameColor="{$frameColor}" 
		frameWidth="{$frameWidth}" 
		imagePadding="{$imagePadding}" 
		displayTime="{$displayTime}">

	<xsl:for-each select="/photoCollection/samples/img">
	
<image>
	<filename><xsl:value-of select="concat( 'images/', @filename )"/>.jpg</filename>
	<caption><xsl:value-of select="text/caption"/></caption>
	<width><xsl:value-of select="rendition[@size='large']/@width"/></width>
	<height><xsl:value-of select="rendition[@size='large']/@height"/></height>
</image>

	</xsl:for-each>
	
</gallery>

	</xsl:template>

<!-- =========================================================================================== -->

</xsl:stylesheet>

