﻿import flash.external.ExternalInterface;
import flash.net.URLVariables;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.display.Graphics;

if (stage.colorCorrectionSupport == ColorCorrectionSupport.DEFAULT_ON || stage.colorCorrectionSupport == ColorCorrectionSupport.DEFAULT_OFF)
{
	stage.colorCorrection = ColorCorrection.ON;
	trace("Color Correction Enabled");
}
stage.scaleMode = StageScaleMode.NO_SCALE;
stage.align = StageAlign.TOP_LEFT;
stage.addEventListener(Event.RESIZE, resizeStage);

function resizeStage(e:Event)
{
	updateDisplayWithParams(headerColor,
							menuColor,
							backgroundColor,
							startingView,
							thumbTint, thumbTintAlpha,
							thumbBorderTint, thumbBorderAlpha,
							previewTint, previewTintAlpha,
							previewBorderTint, previewBorderAlpha);
}

var ready:String = "no";
 
function readyFunc(...rest):String
{
	return ready;
}

if (ExternalInterface.available)
{
	ExternalInterface.addCallback("ready", readyFunc);
}

var headerColor:Number = 0x5555FF;
var menuColor:Number = 0xFF5555;
var backgroundColor:Number = 0xFFDD00;
var startingView:String = "galleryScrollingLeft"; // one of galleryScrollingBottom, galleryScrollingDefault, galleryScrollingLeft, slideshowOnly
var thumbTint:Number = 0xEEBB00;
var thumbBorderTint:Number = 0xFFAA00;
var previewTint:Number = 0xEEBB00;
var previewBorderTint:Number = 0x000000;
var thumbTintAlpha:Number = 50;
var thumbBorderAlpha:Number = 80;
var previewTintAlpha:Number = 90;
var previewBorderAlpha:Number = 40;

var _root:Object = null;

if (root.loaderInfo.parameters.headerColor != null)
{
	_root = root.loaderInfo.parameters;
}
else if (ExternalInterface.available)
{
	var flashVars:URLVariables = new URLVariables(ExternalInterface.call("GetFlashVars"));
	if (flashVars.headerColor != null)
	{
		_root = flashVars;
	}
}

if (_root != null)
{
	headerColor = parseInt( _root.headerColor, 16 );
	menuColor = parseInt( _root.menuColor, 16 );
	backgroundColor = parseInt( _root.backgroundColor, 16 );
	startingView = _root.startingView;
	thumbTint = parseInt( _root.thumbTint, 16 );
	thumbBorderTint = parseInt( _root.thumbBorderTint, 16 );
	previewBorderTint = parseInt( _root.previewBorderTint, 16 );
	previewTint = parseInt( _root.previewTint, 16 );
	thumbTintAlpha = parseInt( _root.thumbTintAlpha );
	thumbBorderAlpha = parseInt( _root.thumbBorderAlpha );
	previewBorderAlpha = parseInt( _root.previewBorderAlpha );
	previewTintAlpha = parseInt( _root.previewTintAlpha );
}

// There will be no resize event on Mac in APE.
if (Capabilities.os.substr(0, 3) == "Mac")
{
	resizeStage(null);
}

function fitInAspect( movieClip:MovieClip, w:Number, h:Number):void
{
	var targetAspect:Number = w / h;
	var curAspect:Number = movieClip.width / movieClip.height;
	var adjustment:Number = 0;
	
	if (targetAspect < curAspect)
	{
		// currently the movie is too fat
		var targetWidth =  movieClip.height * targetAspect;
		adjustment = ( movieClip.width - targetWidth );
		movieClip.x += adjustment / 2;
		movieClip.width -= adjustment;
	}
	if (targetAspect > curAspect)
	{
		// currently the movie is too tall
		var targetHeight = movieClip.width / targetAspect;
		adjustment = ( movieClip.height - targetHeight );
		movieClip.y += adjustment / 2;
		movieClip.height -= adjustment;
	}
}

function updateDisplayWithParams(headerColor,
								 menuColor,
								 backgroundColor,
								 startingView,
								 thumbBg, thumbTintAlpha,
								 thumbBorderTint, thumbBorderAlpha,
								 previewBg, previewTintAlpha,
								 previewBorderTint, previewBorderAlpha):void
{
	root.flashIcon.x = 0;
	root.flashIcon.y = stage.stageHeight;
	
	if (Capabilities.os.substr(0, 3) == "Win") // On Windows the icon will be too low.
	{
		root.flashIcon.y -= 1;
	}
	
	var canvas:Sprite = new Sprite();
	
	canvas.graphics.beginFill( headerColor, 1.0 );
	canvas.graphics.moveTo( 0, 0 );
	canvas.graphics.lineTo( stage.stageWidth, 0 );
	canvas.graphics.lineTo( stage.stageWidth, 15 );
	canvas.graphics.lineTo( 0, 15 );
	canvas.graphics.endFill();

	canvas.graphics.beginFill( menuColor, 1.0 );
	canvas.graphics.moveTo( 0, 15 );
	canvas.graphics.lineTo( stage.stageWidth, 15 );
	canvas.graphics.lineTo( stage.stageWidth, 21 );
	canvas.graphics.lineTo( 0, 21 );
	canvas.graphics.endFill();
	
	canvas.graphics.beginFill( backgroundColor, 1.0 );
	canvas.graphics.moveTo( 0, 21 );
	canvas.graphics.lineTo( stage.stageWidth, 21 );
	canvas.graphics.lineTo( stage.stageWidth, stage.stageHeight );
	canvas.graphics.lineTo( 0, stage.stageHeight );
	canvas.graphics.endFill();
	
	canvas.graphics.beginFill( backgroundColor, 1.0 );
	canvas.graphics.moveTo( 0, 21 );
	canvas.graphics.lineTo( stage.stageWidth, 21 );
	canvas.graphics.lineTo( stage.stageWidth, stage.stageHeight );
	canvas.graphics.lineTo( 0, stage.stageHeight );
	canvas.graphics.endFill();

	var thumbSize = 34;
	var thumbSpace = 42;
	var thumbX = -1
	var thumbY = -1
	var thumbX2 = -1
	var thumbY2 = -1
	var previewX = -1
	var previewY = -1
	var previewX2 = -1
	var previewY2 = -1

	if( startingView == 'galleryScrollingLeft' ) {
		thumbX = 4
		thumbY = 25
		thumbX2 = 35
		thumbY2 = stage.stageHeight - 4;
		previewX = 39
		previewY = 25
		previewX2 = stage.stageWidth - 4
		previewY2 = stage.stageHeight - 4;
	}
	else if( startingView == 'galleryScrollingBottom' ) {
		thumbX = 4
		thumbY = stage.stageHeight - 35
		thumbX2 = stage.stageWidth - 4
		thumbY2 = stage.stageHeight - 4;
		previewX = 4
		previewY = 25
		previewX2 = stage.stageWidth - 4
		previewY2 = stage.stageHeight - 39;
	}
	else if( startingView == 'slideshowOnly' ) {
		previewX = 4
		previewY = 25
		previewX2 = stage.stageWidth - 4
		previewY2 = stage.stageHeight - 4;
	}
	else if( startingView == 'galleryDefault' ) {
		thumbX = 4
		thumbY = 25
		thumbX2 = stage.stageWidth * 0.4 - 2
		thumbY2 = stage.stageHeight - 4;
		previewX = stage.stageWidth * 0.4 + 2
		previewY = 25
		previewX2 = stage.stageWidth - 4
		previewY2 = stage.stageHeight - 4;
	}
	
	var w = Math.floor( Math.min( previewX2 - previewX, previewY2 - previewY ) / 2 - 20 )
	var h = Math.floor( w * 3 / 4 )
	var previewImgX = ( previewX + previewX2 ) / 2 - w
	var previewImgX2 = previewImgX + w + w
	var previewImgY = ( previewY + previewY2 ) / 2 - h
	var previewImgY2 = previewImgY + h + h

	canvas.graphics.beginFill( 0x888888, 0.4 );
	canvas.graphics.moveTo( previewImgX, previewImgY );
	canvas.graphics.lineTo( previewImgX2, previewImgY );
	canvas.graphics.lineTo( previewImgX2, previewImgY2 );
	canvas.graphics.lineTo( previewImgX, previewImgY2 );

	canvas.graphics.lineStyle( 1, thumbBorderTint, thumbBorderAlpha / 100 )
	canvas.graphics.beginFill( thumbBg, thumbTintAlpha );
	canvas.graphics.moveTo( thumbX, thumbY );
	canvas.graphics.lineTo( thumbX2, thumbY );
	canvas.graphics.lineTo( thumbX2, thumbY2 );
	canvas.graphics.lineTo( thumbX, thumbY2 );
	canvas.graphics.endFill();

	canvas.graphics.lineStyle( 1, previewBorderTint, previewBorderAlpha / 100 )
	canvas.graphics.beginFill( previewBg, previewTintAlpha );
	canvas.graphics.moveTo( previewX, previewY );
	canvas.graphics.lineTo( previewX2, previewY );
	canvas.graphics.lineTo( previewX2, previewY2 );
	canvas.graphics.lineTo( previewX, previewY2 );
	canvas.graphics.endFill();
	
	stage.addChildAt(canvas, 0);
}
