﻿// draw iconic preview for jardine template
import flash.external.ExternalInterface;
import flash.net.URLVariables;
import flash.display.MovieClip;
import flash.display.Sprite;
import flash.display.Graphics;
import flash.text.TextField;

if (stage.colorCorrectionSupport == ColorCorrectionSupport.DEFAULT_ON || stage.colorCorrectionSupport == ColorCorrectionSupport.DEFAULT_OFF)
{
	stage.colorCorrection = ColorCorrection.ON;
	trace("Color Correction Enabled");
}
stage.scaleMode = StageScaleMode.NO_SCALE; 
stage.align = StageAlign.TOP_LEFT;
stage.addEventListener(Event.RESIZE, resizeStage);

function resizeStage(e:Event)
{
	updateDisplayWithParams(wid, 
							ht, 
							bgcolor, 
							cellColor, 
							cellBorderColor,
							foregroundColor,
							cellRolloverColor,
							showLogo );
}

var ready:String = "no";

function readyFunc(...rest):String
{
  return ready;
}

if (ExternalInterface.available)
{
	ExternalInterface.addCallback("ready", readyFunc);
}

var wid:Number = 7;
var ht:Number = 4;
var bgcolor:Number = 0x5555FF;
var cellColor:Number = 0x558855;
var cellBorderColor:Number = 0x555555;
var foregroundColor:Number = 0xFFDD00;
var cellRolloverColor:Number = 0xFF8888;
var showLogo:Boolean = true;

var _root:Object = null;

if (root.loaderInfo.parameters.numCols != null)
{
	_root = root.loaderInfo.parameters;
}
else if (ExternalInterface.available)
{
	var flashVars:URLVariables = new URLVariables(ExternalInterface.call("GetFlashVars"));
	if (flashVars.numCols != null)
	{
		_root = flashVars;
	}
}

if (_root != null)
{
	wid = parseInt( _root.numCols );
	ht = parseInt( _root.numRows );
	bgcolor = parseInt( _root.bodyBackgroundColor, 16 );
	cellColor = parseInt( _root.cellBackgroundColor, 16 );
	cellBorderColor = parseInt( _root.cellBorderColor, 16 );
	foregroundColor = parseInt( _root.foregroundColor, 16 );
	cellRolloverColor = parseInt( _root.cellRolloverColor, 16 );
	showLogo = _root.showLogo == 'true';
}

// There will be no resize event on Mac in APE.
if (Capabilities.os.substr(0, 3) == "Mac")
{
	resizeStage(null);
}

function updateDisplayWithParams(wid,
								 ht,
								 bgcolor,
								 cellColor,
								 cellBorderColor,
								 foregroundColor,
								 cellRolloverColor,
								 showLogo ):void
{
	root.htmlIcon.x = 0;
	root.htmlIcon.y = stage.stageHeight - 4;
	if (Capabilities.os.substr(0, 3) == "Win") // On Windows the icon will be too low.
	{
		root.htmlIcon.x -= 2;
		root.htmlIcon.y -= 4;
	}

	var canvas:Sprite = new Sprite();

	canvas.graphics.beginFill( bgcolor, 1.0 );
	canvas.graphics.moveTo( 0, 0 );
	canvas.graphics.lineTo( stage.stageWidth, 0 );
	canvas.graphics.lineTo( stage.stageWidth, stage.stageHeight );
	canvas.graphics.lineTo( 0, stage.stageHeight );
	canvas.graphics.lineTo( 0, 0 );
	canvas.graphics.endFill();

	var gridInsetY = 45;
	var cellWidth = 35;
	var cellHeight = 35;
	var gridInsetX = ( stage.stageWidth - cellWidth * wid ) / 2;
	if( gridInsetX < 15 )
		gridInsetX = 15;

	if( !showLogo ) {
		root.idplate.x = stage.stageWidth;
		gridInsetY = gridInsetY - root.idplate.height;
	}
	else {
		root.idplate.x = gridInsetX;
	}

	var needsRightSidePinking = false
	var needsBottomPinking = false

	var bottomChromeY
	var rightChromeX
	
	for( x = 0; x < wid; x++ ) {
		rightChromeX = gridInsetX + x*cellWidth
		if( rightChromeX <= stage.stageWidth ) {
			for( y = 0; y < ht; y++ ) {
				bottomChromeY = gridInsetY + y*cellHeight
				
				if( bottomChromeY <= stage.stageHeight ) {
					canvas.graphics.lineStyle( 1, cellBorderColor)
					if ( x == 0 && y == 0 )
					{
						canvas.graphics.beginFill( cellRolloverColor, 1.0 );
					}
					else
					{
						canvas.graphics.beginFill( cellColor, 1.0 );
					}

					canvas.graphics.moveTo( gridInsetX + x*cellWidth, gridInsetY + y*cellHeight );
					canvas.graphics.lineTo( gridInsetX + (x+1)*cellWidth, gridInsetY + y*cellHeight );
					canvas.graphics.lineTo( gridInsetX + (x+1)*cellWidth, gridInsetY + (y+1)*cellHeight );
					canvas.graphics.lineTo( gridInsetX + x*cellWidth, gridInsetY + (y+1)*cellHeight );
					canvas.graphics.endFill();
				}
			}
		}
	}

	rightChromeX = rightChromeX + cellWidth
	if( rightChromeX > stage.stageWidth ) {
		needsRightSidePinking = true
	}

	bottomChromeY = bottomChromeY + cellHeight + 5
	if( bottomChromeY > stage.stageHeight ) {
		needsBottomPinking = true
	}

	var kPinking = 8
	if( needsRightSidePinking ) {
		canvas.graphics.beginFill( 0x000000, 1.0 );
		canvas.graphics.moveTo( stage.stageWidth, stage.stageHeight )
		for( y = 0; y <= stage.stageHeight + kPinking; y+= kPinking*2 ) {
			canvas.graphics.lineTo( stage.stageWidth - kPinking, stage.stageHeight - y )
			canvas.graphics.lineTo( stage.stageWidth, stage.stageHeight - y - kPinking )
		}
		canvas.graphics.lineTo( stage.stageWidth, 0 )
		canvas.graphics.endFill();
	}
	if( needsBottomPinking ) {
		canvas.graphics.beginFill( 0x000000, 1.0 );
		canvas.graphics.moveTo( stage.stageWidth, stage.stageHeight )
		for( x = 0; x <= stage.stageWidth + kPinking; x+= kPinking*2 ) {
			canvas.graphics.lineTo( stage.stageWidth - x, stage.stageHeight - kPinking )
			canvas.graphics.lineTo( stage.stageWidth - x - kPinking, stage.stageHeight )
		}
		canvas.graphics.lineTo( 0, stage.stageHeight )
		canvas.graphics.endFill();
	}

	var my_fmt0:TextFormat = new TextFormat();
	my_fmt0.color = foregroundColor;
	my_fmt0.underline = false;
	my_fmt0.size = 6;
	var txt0:TextField = new TextField();
	txt0.x = gridInsetX;
	txt0.y = gridInsetY - 23;
	txt0.width = 300;
	txt0.height = 100;
	txt0.multiline = true;
	txt0.wordWrap = false;
	txt0.defaultTextFormat = my_fmt0;
	txt0.text = "Site Title";
	txt0.selectable = false;
	stage.addChild(txt0);
	
	var my_fmt:TextFormat = new TextFormat();
	my_fmt.color = foregroundColor;
	my_fmt.underline = false;
	my_fmt.size = 3;
	var txt:TextField = new TextField();
	txt.x = gridInsetX;
	txt.y = gridInsetY - 10;
	txt.width = 300;
	txt.height = 100;
	txt.multiline = true;
	txt.wordWrap = false;
	txt.defaultTextFormat = my_fmt;
	txt.text = "My Photographs Photographs\nThese are my photographs taken by me by me, they were taken by me o me";
	txt.selectable = false;
	stage.addChild(txt);

	var my_fmt2:TextFormat = new TextFormat();
	my_fmt2.color = foregroundColor;
	my_fmt2.underline = false;
	my_fmt2.size = 5;
	var txt2:TextField = new TextField();
	txt2.x = gridInsetX;
	txt2.y = bottomChromeY;
	txt2.width = 300;
	txt2.height = 100;
	txt2.multiline = true;
	txt2.wordWrap = false;
	txt2.defaultTextFormat = my_fmt2;
	txt2.text = "Contact Info";
	txt2.selectable = false;
	stage.addChild(txt2);

	bottomChromeY = bottomChromeY + 10

	stage.addChildAt(canvas, 0);
}
