<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" indent="yes"/>

<!-- =========================================================================================== -->

	<xsl:param name="siteTitle" select="/photoCollection/display/metadata/siteInfo/@title"/>
	<xsl:param name="frameWidth" select="round( /photoCollection/display/style/airTight/@frameWidth )"/>
	<xsl:param name="stagePadding" select="round( /photoCollection/display/style/airTight/@stagePadding )"/>
	<xsl:param name="thumbnailColumns" select="round( /photoCollection/display/style/airTight/@thumbnailColumns )"/>
	<xsl:param name="zoomOutPerc" select="round( /photoCollection/display/style/airTight/@zoomOutPerc )"/>
	<xsl:param name="zoomInPerc" select="round( /photoCollection/display/style/airTight/@zoomInPerc )"/>
	<xsl:param name="backgroundColor" select="/photoCollection/display/style/airTight/@backgroundColor"/>
	<xsl:param name="frameColor" select="concat( '0x', substring( /photoCollection/display/style/airTight/@frameColor, 2 ) )"/>
	<xsl:param name="imageWidth" select="round( /photoCollection/head/sizes/size[@name='large']/@width )"/>
	<xsl:param name="cellDimension" select="$imageWidth + $stagePadding"/>
	
<!-- =========================================================================================== -->

	<xsl:template match="/">
<gallery 

		cellDimension="{$cellDimension}" 
		columns="{$thumbnailColumns}" 
		zoomOutPerc="{$zoomOutPerc}" 
		zoomInPerc="{$zoomInPerc}" 
		frameWidth="{$frameWidth}"
		captionColor="0xFFFFFF"
		enableRightClickOpen="true" >

	<xsl:for-each select="/photoCollection/samples/img">
	
<image>
	<url>images/<xsl:value-of select="@filename"/>.jpg</url>
        <caption><xsl:value-of select="text/caption/text()" /></caption>
</image>

	</xsl:for-each>
	
</gallery>
	</xsl:template>

<!-- =========================================================================================== -->

</xsl:stylesheet>

