<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

<xsl:output method="xml" indent="yes"/>
<!-- =========================================================================================== -->

	<xsl:param name="siteTitle" select="/photoCollection/display/metadata/siteInfo/@title"/>
	<xsl:param name="frameWidth" select="round( /photoCollection/display/style/airTight/@frameWidth )"/>
	<xsl:param name="stagePadding" select="round( /photoCollection/display/style/airTight/@stagePadding )"/>
	<xsl:param name="navPosition" select="/photoCollection/display/style/airTight/@navPosition"/>
	<xsl:param name="enableRightClickOpen" select="/photoCollection/display/style/airTight/@enableRightClickOpen"/>
	<xsl:param name="thumbnailColumns" select="round( /photoCollection/display/style/airTight/@thumbnailColumns )"/>
	<xsl:param name="thumbnailRows" select="round( /photoCollection/display/style/airTight/@thumbnailRows )"/>
	<xsl:param name="backgroundColor" select="/photoCollection/display/style/airTight/@backgroundColor"/>
	<xsl:param name="frameColor" select="concat( '0x', /photoCollection/display/style/airTight/@frameColor )"/>
	<xsl:param name="textColor" select="concat( '0x', /photoCollection/display/style/airTight/@textColor )"/>
	<xsl:param name="imageWidth" select="round( /photoCollection/head/sizes/size[@name='large']/@width )"/>
	<xsl:param name="imageHeight" select="round( /photoCollection/head/sizes/size[@name='large']/@height )"/>
	
<!-- =========================================================================================== -->

	<xsl:template match="/">

<simpleviewerGallery 
		maxImageWidth="{$imageWidth}" maxImageHeight="{$imageHeight}" 
		textColor="{$textColor}" 
		frameColor="{$frameColor}" 
		frameWidth="{$frameWidth}" 
		stagePadding="{$stagePadding}" 
		thumbnailColumns="{$thumbnailColumns}" thumbnailRows="{$thumbnailRows}" 
		navPosition="{$navPosition}" 
		title="{$siteTitle}" 
		enableRightClickOpen="{$enableRightClickOpen}" 
		backgroundImagePath="" 
		imagePath="images/" 
		thumbPath="thumb/">
		<xsl:for-each select="/photoCollection/samples/img">

<image>
	<filename><xsl:value-of select="@filename" />.jpg</filename>
	<caption><xsl:value-of select="text/caption/text()" /></caption>	
</image>

		</xsl:for-each>

	
</simpleviewerGallery>

	</xsl:template>

<!-- =========================================================================================== -->

</xsl:stylesheet>
