/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons;

import com.yungnickyoung.minecraft.betterdungeons.config.BDConfig;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModConfig;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModConfiguredStructures;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModProcessors;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModStructurePieces;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModStructures;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.skeleton_dungeon.SkeletonDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.small_dungeon.SmallDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.SpiderDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.zombie_dungeon.ZombieDungeonStructure;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2897;
import net.minecraft.class_3195;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BetterDungeons
implements ModInitializer,
DedicatedServerModInitializer,
ClientModInitializer {
    public static final String MOD_ID = "betterdungeons";
    public static final Logger LOGGER = LogManager.getLogger((String)"betterdungeons");
    public static BDConfig CONFIG;
    public static final boolean DEBUG_MODE = false;

    public void onInitialize() {
        BDModConfig.init();
        BDModProcessors.init();
        BDModStructures.init();
        BDModConfiguredStructures.init();
        BDModStructurePieces.init();
    }

    public void onInitializeServer() {
        BetterDungeons.enforceDimensionWhitelist();
    }

    public void onInitializeClient() {
        BetterDungeons.enforceDimensionWhitelist();
    }

    public static void enforceDimensionWhitelist() {
        ServerWorldEvents.LOAD.register((minecraftServer, serverWorld) -> {
            HashMap tempMap = new HashMap(serverWorld.method_14178().method_12129().method_12109().method_28598());
            String dimensionName = serverWorld.method_27983().method_29177().toString();
            BiConsumer<List, class_3195> whitelistHandler = (whitelist, structure) -> {
                if (!whitelist.contains(dimensionName) || serverWorld.method_14178().method_12129() instanceof class_2897 && serverWorld.method_27983().equals(class_1937.field_25179)) {
                    tempMap.keySet().remove(structure);
                }
            };
            whitelistHandler.accept(SmallDungeonStructure.whitelistedDimensions, BDModStructures.SMALL_DUNGEON);
            whitelistHandler.accept(SpiderDungeonStructure.whitelistedDimensions, BDModStructures.SPIDER_DUNGEON);
            whitelistHandler.accept(SkeletonDungeonStructure.whitelistedDimensions, BDModStructures.SKELETON_DUNGEON);
            whitelistHandler.accept(ZombieDungeonStructure.whitelistedDimensions, BDModStructures.ZOMBIE_DUNGEON);
            serverWorld.method_14178().method_12129().method_12109().field_24824 = tempMap;
        });
    }
}

