/*
 * Decompiled with CFR 0.152.
 */
package tennox.bacteriamod;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import tennox.bacteriamod.Bacteria;
import tennox.bacteriamod.Food;
import tennox.bacteriamod.ItemBacteriaJammer;

public class TileEntityBacteria
extends TileEntity {
    Block bacteria;
    ArrayList<Food> food;
    Random rand = new Random();
    int colony;
    boolean jammed;
    int tick = 0;
    boolean startInstantly;
    Food grass = new Food((Block)Blocks.field_150349_c, 0);
    Food dirt = new Food(Blocks.field_150346_d, 0);
    Food water = new Food(Blocks.field_150355_j, 0);
    Food flowing_water = new Food((Block)Blocks.field_150358_i, 0);

    public TileEntityBacteria() {
        if (this.food == null) {
            this.food = new ArrayList();
        }
        this.bacteria = Bacteria.bacteria;
        do {
            this.colony = this.rand.nextInt();
        } while (Bacteria.jamcolonies.contains(this.colony));
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (Bacteria.jamcolonies.contains(this.colony) || Bacteria.jam_all) {
            this.jammed = true;
            this.die();
            return;
        }
        if (this.food.size() == 0) {
            if (!this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                return;
            }
            this.selectFood();
            if (this.food.size() == 0) {
                return;
            }
            if (this.shouldStartInstantly()) {
                this.startInstantly = true;
            }
        }
        if (!this.startInstantly) {
            if (Bacteria.randomize) {
                this.tick = this.rand.nextInt(Bacteria.speed + 1);
            }
            if (this.tick < Bacteria.speed) {
                ++this.tick;
                return;
            }
            this.tick = 0;
        }
        this.eatEverything();
    }

    public boolean shouldStartInstantly() {
        return true;
    }

    public void selectFood() {
        Block b;
        int i = this.field_145851_c;
        int j = this.field_145848_d + 1;
        int k = this.field_145849_e;
        while ((b = this.field_145850_b.func_147439_a(i, j, k)) != Blocks.field_150350_a) {
            this.addFood(b, this.field_145850_b.func_72805_g(i, j, k));
            ++j;
        }
    }

    public void addFood(Block block, int meta) {
        if (TileEntityBacteria.isValidFood(block, meta)) {
            this.food.add(new Food(block, meta));
        }
    }

    public static boolean isValidFood(Block block, int meta) {
        return block != Blocks.field_150357_h && block != Bacteria.bacteria;
    }

    public void eatEverything() {
        int i = this.field_145851_c;
        int j = this.field_145848_d;
        int k = this.field_145849_e;
        this.maybeEat(i + 1, j, k);
        this.maybeEat(i, j + 1, k);
        this.maybeEat(i - 1, j, k);
        this.maybeEat(i, j - 1, k);
        this.maybeEat(i, j, k + 1);
        this.maybeEat(i, j, k - 1);
        this.die();
    }

    public void maybeEat(int i, int j, int k) {
        if (this.isAtBorder(i, j, k)) {
            return;
        }
        if (this.isFood(this.field_145850_b.func_147439_a(i, j, k), this.field_145850_b.func_72805_g(i, j, k))) {
            this.field_145850_b.func_147449_b(i, j, k, this.bacteria);
            ((TileEntityBacteria)this.field_145850_b.func_147438_o((int)i, (int)j, (int)k)).food = this.food;
            ((TileEntityBacteria)this.field_145850_b.func_147438_o((int)i, (int)j, (int)k)).colony = this.colony;
        }
    }

    public boolean isAtBorder(int i, int j, int k) {
        while (this.field_145850_b.func_147439_a(i, j, k) != Block.func_149684_b((String)Bacteria.isolation)) {
            if (j >= this.field_145850_b.func_72940_L()) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public boolean isFood(Block block, int meta) {
        if (Bacteria.jamcolonies.contains(this.colony)) {
            return false;
        }
        if (block == Bacteria.jammer) {
            Bacteria.jamcolonies.add(this.colony);
            this.jammed = true;
            return false;
        }
        for (Food f : this.food) {
            if (!this.isFood2(f, block, meta)) continue;
            return true;
        }
        if (block == Blocks.field_150349_c) {
            return this.food.contains(this.dirt);
        }
        if (block == Blocks.field_150346_d) {
            return this.food.contains(this.grass);
        }
        if (block == Blocks.field_150358_i || block == Blocks.field_150355_j) {
            for (Food f : this.food) {
                if (f.block != Blocks.field_150355_j && f.block != Blocks.field_150358_i) continue;
                return true;
            }
        }
        if (block == Blocks.field_150356_k || block == Blocks.field_150353_l) {
            for (Food f : this.food) {
                if (f.block != Blocks.field_150353_l && f.block != Blocks.field_150356_k) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isFood2(Food f, Block block, int meta) {
        if (!block.equals(f.block)) {
            return false;
        }
        if (Item.func_150898_a((Block)block) != null && !Item.func_150898_a((Block)block).func_77614_k()) {
            return true;
        }
        return meta == f.meta;
    }

    public void die() {
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.jammed) {
            ++ItemBacteriaJammer.num;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (this.food == null) {
            this.food = new ArrayList();
        }
        if (Bacteria.savefood) {
            this.colony = nbt.func_74762_e("colony");
            int i = nbt.func_74762_e("numfood");
            for (int j = 0; j < i; ++j) {
                int id = nbt.func_74762_e("food" + j);
                int meta = nbt.func_74762_e("food_meta" + j + "");
                this.food.add(new Food(Block.func_149729_e((int)id), meta));
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (Bacteria.savefood) {
            nbt.func_74768_a("colony", this.colony);
            nbt.func_74768_a("numfood", this.food.size());
            for (int j = 0; j < this.food.size(); ++j) {
                int id = Block.func_149682_b((Block)this.food.get((int)j).block);
                nbt.func_74768_a("food" + j, id);
                nbt.func_74768_a("food_meta" + j, this.food.get((int)j).meta);
            }
        }
    }
}

