/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.toposort.ModSortingException;
import cpw.mods.fml.relauncher.CoreModManager;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.Collections;
import net.minecraft.block.BlockDispenser;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.oredict.RecipeSorter;
import ruby.bamboo.BambooInit;
import ruby.bamboo.Config;
import ruby.bamboo.EnchantHandler;
import ruby.bamboo.UpdateNotify;
import ruby.bamboo.dispenser.DispenserBehaviorBambooSpear;
import ruby.bamboo.dispenser.DispenserBehaviorDirtySnowball;
import ruby.bamboo.dispenser.DispenserBehaviorFireCracker;
import ruby.bamboo.gui.GuiHandler;
import ruby.bamboo.item.crafting.CookingManager;
import ruby.bamboo.proxy.CommonProxy;
import ruby.bamboo.world.WorldProviderBamboo;

@Mod(modid="BambooMod", name="BambooMod", version="Minecraft1.7.10 var2.6.8.3", guiFactory="ruby.bamboo.BambooConfigGuiFactory", dependencies="required-after:Forge@[10.13.2.1230,)")
public class BambooCore {
    public static final String MODID = "BambooMod";
    public static final String MC_VER = "1.7.10";
    public static final String BAMBOO_VER = "2.6.8.3";
    public static final String resourceDomain = "bamboo:";
    public static final boolean DEBUGMODE = BambooCore.isDevelopment();
    @SidedProxy(serverSide="ruby.bamboo.proxy.CommonProxy", clientSide="ruby.bamboo.proxy.ClientProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="BambooMod")
    public static BambooCore instance;
    private int provideId;

    @Mod.EventHandler
    public void preLoad(FMLPreInitializationEvent e) {
        proxy.preInit();
        if (Config.updateNotify) {
            new Thread(new UpdateNotify()).run();
        }
        new EnchantHandler();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent e) {
        proxy.init();
        proxy.registerTESTileEntity();
        this.registDispencer();
        if (DEBUGMODE) {
            System.out.println("DEBUG MODE Enable");
        }
    }

    @Mod.EventHandler
    public void postLoad(FMLPostInitializationEvent e) {
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartedEvent event) {
        Config.reloadWorldConfig();
        if (DEBUGMODE) {
            this.provideId = 0;
            while (!DimensionManager.registerProviderType((int)(++this.provideId), WorldProviderBamboo.class, (boolean)false)) {
            }
            DimensionManager.registerDimension((int)Config.dimensionId, (int)this.provideId);
        }
    }

    @Mod.EventHandler
    public void serverStoped(FMLServerStoppedEvent event) {
        if (DEBUGMODE) {
            DimensionManager.unregisterDimension((int)Config.dimensionId);
            DimensionManager.unregisterProviderType((int)this.provideId);
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)BambooCore.getInstance(), (IGuiHandler)new GuiHandler());
    }

    @Mod.EventHandler
    public void onAvalible(FMLLoadCompleteEvent event) {
        try {
            Collections.sort(CookingManager.getInstance().getRecipeList(), RecipeSorter.INSTANCE);
        }
        catch (ModSortingException e) {
            FMLLog.warning((String)"OreDict sort exception!!", (Object[])new Object[]{e});
        }
    }

    private void registDispencer() {
        BlockDispenser.field_149943_a.func_82595_a((Object)BambooInit.snowBall, (Object)new DispenserBehaviorDirtySnowball());
        BlockDispenser.field_149943_a.func_82595_a((Object)BambooInit.firecracker, (Object)new DispenserBehaviorFireCracker());
        BlockDispenser.field_149943_a.func_82595_a((Object)BambooInit.bambooSpear, (Object)new DispenserBehaviorBambooSpear());
    }

    public static BambooCore getInstance() {
        return instance;
    }

    private static boolean isDevelopment() {
        boolean result;
        try {
            result = (Boolean)ReflectionHelper.getPrivateValue(CoreModManager.class, null, (String[])new String[]{"deobfuscatedEnvironment"});
        }
        catch (ReflectionHelper.UnableToAccessFieldException e) {
            FMLLog.warning((String)"Debug mode forced false!", (Object[])new Object[0]);
            result = false;
        }
        return result;
    }
}

