/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockGrowableBase
extends BlockBush
implements IGrowable {
    private IIcon[] icons;

    public BlockGrowableBase() {
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(field_149779_h);
        float f = 0.5f;
        this.func_149676_a(0.5f - f, 0.0f, 0.5f - f, 0.5f + f, 0.25f, 0.5f + f);
        this.func_149649_H();
    }

    public void tryBonemealGrow(World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z) + MathHelper.func_76136_a((Random)world.field_73012_v, (int)2, (int)5);
        if (meta > this.getMaxGrowthStage() - 1) {
            meta = this.getMaxGrowthStage() - 1;
        }
        world.func_72921_c(x, y, z, meta, 2);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (meta < 0 || meta > this.getMaxGrowthStage() - 1) {
            meta = this.getMaxGrowthStage() - 1;
        }
        return this.icons[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.icons = new IIcon[this.getMaxGrowthStage()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = p_149651_1_.func_94245_a(this.func_149641_N() + "_stage_" + i);
        }
    }

    public abstract Item getSeed();

    public abstract Item getProduct();

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        float f;
        int l;
        super.func_149674_a(world, x, y, z, rand);
        if (world.func_72957_l(x, y + 1, z) >= 9 && (l = world.func_72805_g(x, y, z)) < this.getMaxGrowthStage() - 1 && rand.nextInt((int)(25.0f / (f = this.getGrowRate(world, x, y, z))) + 1) == 0) {
            world.func_72921_c(x, y, z, ++l, 2);
        }
    }

    public float getGrowRate(World world, int x, int y, int z) {
        float f = 1.0f;
        Block block = world.func_147439_a(x, y, z - 1);
        Block block1 = world.func_147439_a(x, y, z + 1);
        Block block2 = world.func_147439_a(x - 1, y, z);
        Block block3 = world.func_147439_a(x + 1, y, z);
        Block block4 = world.func_147439_a(x - 1, y, z - 1);
        Block block5 = world.func_147439_a(x + 1, y, z - 1);
        Block block6 = world.func_147439_a(x + 1, y, z + 1);
        Block block7 = world.func_147439_a(x - 1, y, z + 1);
        boolean flag = block2 == this || block3 == this;
        boolean flag1 = block == this || block1 == this;
        boolean flag2 = block4 == this || block5 == this || block6 == this || block7 == this;
        for (int l = x - 1; l <= x + 1; ++l) {
            for (int i1 = z - 1; i1 <= z + 1; ++i1) {
                float f1 = 0.0f;
                if (world.func_147439_a(l, y - 1, i1).canSustainPlant((IBlockAccess)world, l, y - 1, i1, ForgeDirection.UP, (IPlantable)this)) {
                    f1 = 1.0f;
                    if (world.func_147439_a(l, y - 1, i1).isFertile(world, l, y - 1, i1)) {
                        f1 = 3.0f;
                    }
                }
                if (l != x || i1 != z) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        if (flag2 || flag && flag1) {
            f /= 2.0f;
        }
        return f;
    }

    public void func_149690_a(World world, int x, int y, int z, int meta, float dropRate, int fortune) {
        super.func_149690_a(world, x, y, z, meta, dropRate, 0);
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return p_149650_1_ == this.getMaxGrowthStage() - 1 ? this.getProduct() : this.getSeed();
    }

    public int func_149745_a(Random rand) {
        return 1;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList ret = super.getDrops(world, x, y, z, metadata, fortune);
        if (metadata >= this.getMaxGrowthStage() - 1) {
            for (int i = 0; i < 3 + fortune; ++i) {
                if (world.field_73012_v.nextInt(this.getMaxGrowthStage() * 2 + 1) > metadata) continue;
                ret.add(new ItemStack(this.getSeed(), 1, 0));
            }
        }
        return ret;
    }

    public abstract int getMaxGrowthStage();

    public abstract boolean func_149854_a(Block var1);

    public boolean func_149851_a(World world, int x, int y, int z, boolean var5) {
        return world.func_72805_g(x, y, z) != this.getMaxGrowthStage() - 1;
    }

    public boolean func_149852_a(World world, Random rand, int x, int y, int z) {
        return true;
    }

    public void func_149853_b(World world, Random rand, int x, int y, int z) {
        this.tryBonemealGrow(world, x, y, z);
    }
}

