/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import ruby.bamboo.CustomRenderHandler;
import ruby.bamboo.block.BlockLiangBase;
import ruby.bamboo.block.IPillarRender;

public class BlockPillar
extends Block
implements IPillarRender {
    private final float minWidth;
    private final float maxWidth;
    private final float minHeight;
    private final float maxHeight;
    private final Block iconBlock;
    private final int iconMeta;
    private int renderSide;

    public BlockPillar(Block block, int meta, float minWidth, float maxWidth, float height) {
        super(Material.field_151575_d);
        this.func_149711_c(0.2f);
        this.func_149752_b(1.0f);
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.minHeight = height;
        this.maxHeight = 1.0f - height;
        this.iconBlock = block;
        this.iconMeta = meta;
    }

    public int func_149660_a(World par1World, int par2, int par3, int par4, int side, float hitX, float hitY, float hitZ, int metadata) {
        return side;
    }

    public IIcon func_149673_e(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        return this.iconBlock.func_149691_a(2, this.iconMeta);
    }

    public IIcon func_149691_a(int par1, int par2) {
        return this.iconBlock.func_149691_a(2, this.iconMeta);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return CustomRenderHandler.pillarUID;
    }

    @Override
    public void setRenderSide(int side) {
        this.renderSide = side;
    }

    public boolean func_149646_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, int par5) {
        Block block = par1IBlockAccess.func_147439_a(par2, par3, par4);
        if (this.renderSide == par5) {
            return true;
        }
        if (block != null) {
            ForgeDirection fd = ForgeDirection.getOrientation((int)par5).getOpposite();
            int meta = par1IBlockAccess.func_72805_g(par2 + fd.offsetX, par3 + fd.offsetY, par4 + fd.offsetZ);
            if (meta == fd.ordinal() && block.func_149662_c() && block.func_149686_d()) {
                return false;
            }
            if (block instanceof BlockPillar && par1IBlockAccess.func_72805_g(par2, par3, par4) == meta && ((BlockPillar)par1IBlockAccess.func_147439_a(par2, par3, par4)).getSize() > this.getSize()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean setUpBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.UP, par2, par3, par4) : this);
        switch (ForgeDirection.getOrientation((int)par1IBlockAccess.func_72805_g(par2, par3, par4))) {
            case NORTH: {
                this.func_149676_a(block.getMinWidth(), block.getMaxWidth(), block.getMaxHeight(), block.getMaxWidth(), 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(block.getMinWidth(), block.getMaxWidth(), 0.0f, block.getMaxWidth(), 1.0f, block.getMinHeight());
                break;
            }
            case WEST: {
                this.func_149676_a(block.getMaxHeight(), block.getMaxWidth(), block.getMinWidth(), 1.0f, 1.0f, block.getMaxWidth());
                break;
            }
            case EAST: {
                this.func_149676_a(0.0f, block.getMaxWidth(), block.getMinWidth(), block.getMinHeight(), 1.0f, block.getMaxWidth());
                break;
            }
        }
        return true;
    }

    @Override
    public boolean setDownBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.DOWN, par2, par3, par4) : this);
        switch (ForgeDirection.getOrientation((int)par1IBlockAccess.func_72805_g(par2, par3, par4))) {
            case NORTH: {
                this.func_149676_a(block.getMinWidth(), 0.0f, block.getMaxHeight(), block.getMaxWidth(), block.getMinWidth(), 1.0f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(block.getMinWidth(), 0.0f, 0.0f, block.getMaxWidth(), block.getMinWidth(), block.getMinHeight());
                break;
            }
            case WEST: {
                this.func_149676_a(block.getMaxHeight(), 0.0f, block.getMinWidth(), 1.0f, block.getMinWidth(), block.getMaxWidth());
                break;
            }
            case EAST: {
                this.func_149676_a(0.0f, 0.0f, block.getMinWidth(), block.getMinHeight(), block.getMinWidth(), block.getMaxWidth());
                break;
            }
        }
        return true;
    }

    @Override
    public boolean setSouthBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.SOUTH, par2, par3, par4) : this);
        switch (ForgeDirection.getOrientation((int)par1IBlockAccess.func_72805_g(par2, par3, par4))) {
            case UP: {
                this.func_149676_a(block.getMinWidth(), 0.0f, block.getMaxWidth(), block.getMaxWidth(), block.getMinHeight(), 1.0f);
                break;
            }
            case DOWN: {
                this.func_149676_a(block.getMinWidth(), block.getMaxHeight(), block.getMaxWidth(), block.getMaxWidth(), 1.0f, 1.0f);
                break;
            }
            case WEST: {
                this.func_149676_a(block.getMaxHeight(), block.getMinWidth(), block.getMaxWidth(), 1.0f, block.getMaxWidth(), 1.0f);
                break;
            }
            case EAST: {
                this.func_149676_a(0.0f, block.getMinWidth(), block.getMaxWidth(), block.getMinHeight(), block.getMaxWidth(), 1.0f);
                break;
            }
        }
        return true;
    }

    @Override
    public boolean setNorthBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.NORTH, par2, par3, par4) : this);
        switch (ForgeDirection.getOrientation((int)par1IBlockAccess.func_72805_g(par2, par3, par4))) {
            case UP: {
                this.func_149676_a(block.getMinWidth(), 0.0f, 0.0f, block.getMaxWidth(), block.getMinHeight(), block.getMinWidth());
                break;
            }
            case DOWN: {
                this.func_149676_a(block.getMinWidth(), block.getMaxHeight(), 0.0f, block.getMaxWidth(), 1.0f, block.getMinWidth());
                break;
            }
            case WEST: {
                this.func_149676_a(block.getMaxHeight(), block.getMinWidth(), 0.0f, 1.0f, block.getMaxWidth(), block.getMinWidth());
                break;
            }
            case EAST: {
                this.func_149676_a(0.0f, block.getMinWidth(), 0.0f, block.getMinHeight(), block.getMaxWidth(), block.getMinWidth());
                break;
            }
        }
        return true;
    }

    @Override
    public boolean setEastBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.EAST, par2, par3, par4) : this);
        switch (ForgeDirection.getOrientation((int)par1IBlockAccess.func_72805_g(par2, par3, par4))) {
            case NORTH: {
                this.func_149676_a(block.getMaxWidth(), block.getMinWidth(), block.getMaxHeight(), 1.0f, block.getMaxWidth(), 1.0f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(block.getMaxWidth(), block.getMinWidth(), 0.0f, 1.0f, block.getMaxWidth(), block.getMinHeight());
                break;
            }
            case UP: {
                this.func_149676_a(block.getMaxWidth(), 0.0f, block.getMinWidth(), 1.0f, block.getMinHeight(), block.getMaxWidth());
                break;
            }
            case DOWN: {
                this.func_149676_a(block.getMaxWidth(), block.getMaxHeight(), block.getMinWidth(), 1.0f, 1.0f, block.getMaxWidth());
                break;
            }
        }
        return true;
    }

    @Override
    public boolean setWestBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, boolean isSmallScale) {
        IPillarRender block = (IPillarRender)(isSmallScale ? this.getOffsettedBlock(par1IBlockAccess, ForgeDirection.WEST, par2, par3, par4) : this);
        switch (ForgeDirection.getOrientation((int)par1IBlockAccess.func_72805_g(par2, par3, par4))) {
            case NORTH: {
                this.func_149676_a(0.0f, block.getMinWidth(), block.getMaxHeight(), block.getMinWidth(), block.getMaxWidth(), 1.0f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.0f, block.getMinWidth(), 0.0f, block.getMinWidth(), block.getMaxWidth(), block.getMinHeight());
                break;
            }
            case UP: {
                this.func_149676_a(0.0f, 0.0f, block.getMinWidth(), block.getMinWidth(), block.getMinHeight(), block.getMaxWidth());
                break;
            }
            case DOWN: {
                this.func_149676_a(0.0f, block.getMaxHeight(), block.getMinWidth(), block.getMinWidth(), 1.0f, block.getMaxWidth());
                break;
            }
        }
        return true;
    }

    @Override
    public void setCoreBoundsBox(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        switch (ForgeDirection.getOrientation((int)par1IBlockAccess.func_72805_g(par2, par3, par4))) {
            case DOWN: {
                this.func_149676_a(this.minWidth, 1.0f - this.minHeight, this.minWidth, this.maxWidth, 1.0f, this.maxWidth);
                break;
            }
            case EAST: {
                this.func_149676_a(0.0f, this.minWidth, this.minWidth, this.minHeight, this.maxWidth, this.maxWidth);
                break;
            }
            case NORTH: {
                this.func_149676_a(this.minWidth, this.minWidth, 1.0f - this.minHeight, this.maxWidth, this.maxWidth, 1.0f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(this.minWidth, this.minWidth, 0.0f, this.maxWidth, this.maxWidth, this.minHeight);
                break;
            }
            case UP: {
                this.func_149676_a(this.minWidth, 0.0f, this.minWidth, this.maxWidth, this.minHeight, this.maxWidth);
                break;
            }
            case WEST: {
                this.func_149676_a(1.0f - this.minHeight, this.minWidth, this.minWidth, 1.0f, this.maxWidth, this.maxWidth);
                break;
            }
        }
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        switch (ForgeDirection.getOrientation((int)par1IBlockAccess.func_72805_g(par2, par3, par4))) {
            case DOWN: {
                this.func_149676_a(0.0f, 1.0f - this.minHeight, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case EAST: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, this.minHeight, 1.0f, 1.0f);
                break;
            }
            case NORTH: {
                this.func_149676_a(0.0f, 0.0f, 1.0f - this.minHeight, 1.0f, 1.0f, 1.0f);
                break;
            }
            case SOUTH: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, this.minHeight);
                break;
            }
            case UP: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, this.minHeight, 1.0f);
                break;
            }
            case WEST: {
                this.func_149676_a(1.0f - this.minHeight, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
        }
    }

    @Override
    public boolean isLink(IBlockAccess par1IBlockAccess, int par2, int par3, int par4, ForgeDirection fd) {
        Block offsetBlock = par1IBlockAccess.func_147439_a(par2 + fd.offsetX, par3 + fd.offsetY, par4 + fd.offsetZ);
        return offsetBlock.func_149688_o() == Material.field_151575_d && !(offsetBlock instanceof BlockLiangBase);
    }

    public boolean canBlockPlace(World world, int posX, int posY, int posZ, int side) {
        return this.canStay(world, posX, posY, posZ, side);
    }

    public void func_149695_a(World par1World, int par2, int par3, int par4, Block par5) {
        if (!this.canStay(par1World, par2, par3, par4, par1World.func_72805_g(par2, par3, par4))) {
            par1World.func_147480_a(par2, par3, par4, true);
        }
    }

    private boolean canStay(World world, int posX, int posY, int posZ, int side) {
        ForgeDirection fd = ForgeDirection.getOrientation((int)side).getOpposite();
        return !this.isAirBlockOffset(world, fd, posX, posY, posZ) && !(this.getOffsettedBlock((IBlockAccess)world, fd, posX, posY, posZ) instanceof BlockPillar);
    }

    private boolean isAirBlockOffset(World world, ForgeDirection fd, int posX, int posY, int posZ) {
        return world.func_147437_c(posX + fd.offsetX, posY + fd.offsetY, posZ + fd.offsetZ);
    }

    private Block getOffsettedBlock(IBlockAccess iBlockAccess, ForgeDirection fd, int posX, int posY, int posZ) {
        return iBlockAccess.func_147439_a(posX + fd.offsetX, posY + fd.offsetY, posZ + fd.offsetZ);
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
    }

    public void func_149683_g() {
        this.func_149676_a(0.5f, this.minWidth * 0.7f, this.minWidth * 0.7f, 0.5f + this.minHeight, this.maxWidth * 1.3f, this.maxWidth * 1.3f);
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
    }

    @Override
    public float getSize() {
        return this.maxWidth - this.minWidth;
    }

    @Override
    public float getMinWidth() {
        return this.minWidth;
    }

    @Override
    public float getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public float getMinHeight() {
        return this.minHeight;
    }

    @Override
    public float getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public boolean isLinkSkipp() {
        return true;
    }

    @Override
    public boolean canDifferentMetaLink(int meta1, int meta2) {
        return meta1 != meta2;
    }
}

