/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.item;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockOre;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import ruby.bamboo.item.enchant.BambooEnchantment;
import ruby.bamboo.item.enchant.EnchantBase;
import ruby.bamboo.item.magatama.BambooChestContent;

public class ItemBambooPickaxe
extends ItemPickaxe {
    public static final int MAX_DMG = 10000;
    public static final int MAX_LEVEL = 30;
    public static final byte MAX_ENCHANTNUM = 10;
    public static final Enchantment[] enchs = new Enchantment[]{Enchantment.field_77349_p, Enchantment.field_77346_s, Enchantment.field_77348_q, Enchantment.field_77347_r};
    private IIcon[] icons = new IIcon[7];
    private static Random rand = new Random();

    public ItemBambooPickaxe() {
        super(Item.ToolMaterial.EMERALD);
        this.setNoRepair();
        this.func_77656_e(10000);
        BambooChestContent content = new BambooChestContent((Item)this, 0, 1, 1, 1){

            @Override
            public float getLotteryRate() {
                return 0.1f;
            }
        };
        ChestGenHooks.addItem((String)"pyramidDesertyChest", (WeightedRandomChestContent)content);
        ChestGenHooks.addItem((String)"pyramidJungleChest", (WeightedRandomChestContent)content);
        ChestGenHooks.addItem((String)"strongholdCorridor", (WeightedRandomChestContent)content);
        ChestGenHooks.addItem((String)"strongholdCrossing", (WeightedRandomChestContent)content);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase) {
        return true;
    }

    public boolean func_150894_a(ItemStack itemStack, World world, Block block, int posX, int posY, int posZ, EntityLivingBase entity) {
        if ((double)block.func_149712_f(world, posX, posY, posZ) != 0.0 && !world.field_72995_K) {
            if (rand.nextInt(this.getUnbreaking(itemStack) + 1) == 0) {
                int exp = 30 - this.getLevel(itemStack);
                float hardness = block.func_149712_f(world, posX, posY, posZ);
                if (1.0f < hardness) {
                    exp = (int)((float)exp * hardness);
                }
                if (block instanceof BlockOre) {
                    exp += block.getExpDrop((IBlockAccess)world, world.func_72805_g(posX, posY, posZ), 0);
                }
                this.addExp(exp, itemStack, entity);
            }
            BambooEnchantment.activate(itemStack, world, entity, posX, posY, posZ);
        }
        return true;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (par5) {
            BambooEnchantment.onUpdate(itemStack, world, entity);
        }
    }

    private void addExp(int exp, ItemStack is, EntityLivingBase entity) {
        if (exp + is.func_77960_j() < 10000) {
            is.func_77972_a(exp, entity);
            return;
        }
        exp = exp + is.func_77960_j() - 10000;
        if (this.hasLevelup(is)) {
            this.setLevel(this.getLevel(is) + 1, is);
            HashMap<Enchantment, Short> nomalEnchmap = new HashMap<Enchantment, Short>();
            for (Enchantment e : enchs) {
                if (!(rand.nextFloat() < (float)e.func_77324_c() / 20.0f) || !rand.nextBoolean()) continue;
                nomalEnchmap.put(e, (short)(rand.nextBoolean() ? 1 : -1));
            }
            HashMap<EnchantBase, Short> specialEnchmap = new HashMap<EnchantBase, Short>();
            for (EnchantBase e : BambooEnchantment.idToEnchantMap.values()) {
                if (!(rand.nextFloat() < e.getWeight()) || !rand.nextBoolean()) continue;
                specialEnchmap.put(e, (short)(rand.nextBoolean() ? 1 : -1));
            }
            if (this.getLevel(is) % 10 == 0) {
                if (nomalEnchmap.isEmpty()) {
                    nomalEnchmap.put(enchs[rand.nextInt(enchs.length)], (short)1);
                }
                if (specialEnchmap.isEmpty()) {
                    specialEnchmap.put(BambooEnchantment.idToEnchantMap.get(rand.nextInt(BambooEnchantment.idToEnchantMap.size())), (short)1);
                }
            }
            if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText("LevelUp!!:" + this.getLevel(is)));
            }
            this.addNomalEnchLevel(is, nomalEnchmap, (Entity)entity);
            this.addSpecialEnchLevel(is, specialEnchmap, (Entity)entity);
            is.func_77964_b(0);
            this.addExp(exp, is, entity);
        }
    }

    private void addNomalEnchLevel(ItemStack is, HashMap<Enchantment, Short> map, Entity entity) {
        if (is.func_77942_o() && !map.isEmpty()) {
            if (!is.field_77990_d.func_150297_b("ench", 9)) {
                is.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
            }
            NBTTagList nbttaglist = is.func_77986_q();
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                Enchantment ench = Enchantment.field_77331_b[short1];
                String s = StatCollector.func_74838_a((String)ench.func_77320_a()) + ":";
                String s2 = "MAX";
                if (!map.containsKey(ench)) continue;
                if (map.get(ench) > 0 && short2 < 10) {
                    s2 = map.get(ench) > 0 ? "UP" : "DOWN";
                    nbttaglist.func_150305_b(i).func_74777_a("lvl", (short)(short2 + map.get(ench)));
                } else if (0 > map.get(ench) && short2 == 1) {
                    s2 = "REMOVE";
                    nbttaglist.func_74744_a(i);
                }
                map.remove(ench);
                if (!(entity instanceof EntityPlayer)) continue;
                ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(s + s2));
            }
            if (!map.isEmpty() && this.hasNewEnchant(is)) {
                for (Map.Entry<Enchantment, Short> entry : map.entrySet()) {
                    if (entry.getValue() <= 0) continue;
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74777_a("id", (short)entry.getKey().field_77352_x);
                    nbt.func_74777_a("lvl", entry.getValue().shortValue());
                    nbttaglist.func_74742_a((NBTBase)nbt);
                    if (!(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)entry.getKey().func_77320_a()) + ":ADD"));
                }
            }
        }
    }

    private void addSpecialEnchLevel(ItemStack is, HashMap<EnchantBase, Short> map, Entity entity) {
        if (is.func_77942_o() && !map.isEmpty()) {
            if (!is.field_77990_d.func_150297_b("spench", 9)) {
                is.field_77990_d.func_74782_a("spench", (NBTBase)new NBTTagList());
            }
            NBTTagList nbttaglist = is.field_77990_d.func_150295_c("spench", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                short short1 = nbttaglist.func_150305_b(i).func_74765_d("id");
                short short2 = nbttaglist.func_150305_b(i).func_74765_d("lvl");
                EnchantBase ench = BambooEnchantment.idToEnchantMap.get(short1);
                if (!map.containsKey(ench)) continue;
                String s = StatCollector.func_74838_a((String)("bambooEnch." + ench.getName())) + ":";
                String s2 = "MAX";
                if (map.get(ench) > 0 && short2 < 10 && short2 < ench.getMaxLevel()) {
                    s2 = map.get(ench) > 0 ? "UP" : "DOWN";
                    nbttaglist.func_150305_b(i).func_74777_a("lvl", (short)(short2 + map.get(ench)));
                } else if (0 > map.get(ench) && short2 == 1) {
                    s2 = "REMOVE";
                    nbttaglist.func_74744_a(i);
                }
                if (entity instanceof EntityPlayer) {
                    ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(s + s2));
                }
                map.remove(ench);
            }
            if (!map.isEmpty() && this.hasNewEnchant(is)) {
                for (Map.Entry<EnchantBase, Short> entry : map.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() <= 0) continue;
                    NBTTagCompound nbt = new NBTTagCompound();
                    nbt.func_74777_a("id", (short)entry.getKey().getId());
                    nbt.func_74777_a("lvl", entry.getValue().shortValue());
                    nbttaglist.func_74742_a((NBTBase)nbt);
                    if (!(entity instanceof EntityPlayer)) continue;
                    ((EntityPlayer)entity).func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)("bambooEnch." + entry.getKey().getName())) + ":ADD"));
                }
            }
        }
    }

    private boolean hasNewEnchant(ItemStack is) {
        return is.field_77990_d.func_150295_c("spench", 10).func_74745_c() + is.func_77986_q().func_74745_c() < 10;
    }

    private int getSPEnchaLevel(ItemStack is, int enchId) {
        if (is.field_77990_d != null) {
            NBTTagList nbttaglist = is.field_77990_d.func_150295_c("spench", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                if (nbttaglist.func_150305_b(i).func_74765_d("id") != enchId) continue;
                return nbttaglist.func_150305_b(i).func_74765_d("lvl");
            }
        }
        return 0;
    }

    private boolean hasLevelup(ItemStack is) {
        return this.getLevel(is) < 30;
    }

    private void setLevel(int level, ItemStack is) {
        if (is.field_77990_d == null) {
            this.initTagCompound(is);
        }
        is.field_77990_d.func_74768_a("toolLevel", level);
    }

    private int getLevel(ItemStack is) {
        if (is.field_77990_d == null) {
            this.initTagCompound(is);
        }
        return is.field_77990_d.func_74762_e("toolLevel");
    }

    private int getUnbreaking(ItemStack is) {
        if (is.field_77990_d == null) {
            this.initTagCompound(is);
        }
        if (!is.field_77990_d.func_150297_b("ench", 9)) {
            is.field_77990_d.func_74782_a("ench", (NBTBase)new NBTTagList());
        }
        NBTTagList nbttaglist = is.func_77986_q();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            if (nbttaglist.func_150305_b(i).func_74765_d("id") != Enchantment.field_77347_r.field_77352_x) continue;
            return nbttaglist.func_150305_b(i).func_74765_d("lvl");
        }
        return 0;
    }

    private NBTTagCompound getTagCompound(ItemStack is) {
        return is.field_77990_d != null ? is.field_77990_d : this.initTagCompound(is);
    }

    private NBTTagCompound initTagCompound(ItemStack is) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("toolLevel", 0);
        is.field_77990_d = nbt;
        return is.field_77990_d;
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)stack.func_77952_i() / (double)stack.func_77958_k();
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent e) {
        ItemStack is = e.itemStack;
        if (is.func_77973_b() == this) {
            String s = (String)e.toolTip.get(0);
            e.toolTip.set(0, s + " Level:" + this.getLevel(is));
            if (is.func_77942_o()) {
                NBTTagList nbttaglist = is.field_77990_d.func_150295_c("spench", 10);
                for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                    e.toolTip.add(e.toolTip.size() - 1, StatCollector.func_74838_a((String)("bambooEnch." + BambooEnchantment.idToEnchantMap.get(nbttaglist.func_150305_b(i).func_74765_d("id")).getName())) + " " + StatCollector.func_74838_a((String)("enchantment.level." + nbttaglist.func_150305_b(i).func_74765_d("lvl"))));
                }
            }
        }
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return this.getSPEnchaLevel(par1ItemStack, BambooEnchantment.eat.getId()) != 0 ? EnumAction.eat : EnumAction.none;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return this.getSPEnchaLevel(par1ItemStack, BambooEnchantment.eat.getId()) != 0 ? 32 : 0;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (this.getSPEnchaLevel(par1ItemStack, BambooEnchantment.eat.getId()) != 0) {
            par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        }
        return par1ItemStack;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        --par1ItemStack.field_77994_a;
        par3EntityPlayer.func_71024_bL().func_151686_a(new ItemFood(2, false), par1ItemStack);
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.burp", 0.5f, par2World.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return par1ItemStack;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean hasEffect(ItemStack par1ItemStack, int pass) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = par1IconRegister.func_94245_a("bamboo:pickaxe_" + i);
        }
    }

    public IIcon func_77650_f(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("iconNum")) {
            return this.icons[stack.field_77990_d.func_74771_c("iconNum")];
        }
        return this.icons[0];
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("iconNum")) {
            return this.icons[stack.field_77990_d.func_74771_c("iconNum")];
        }
        return this.icons[0];
    }
}

