/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.entity.magatama;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import ruby.bamboo.BambooUtil;
import ruby.bamboo.entity.magatama.EntityThunderEffect;

public class EntityGravityHole
extends Entity {
    private boolean isFirstUpdate;
    private List<EntityThunderEffect> effectList;
    private int timer;
    private float scale = 0.0f;
    private static final int EXPLODE_SIZE = 75;
    private static final TreeMap<Float, ArrayList<Position>> matrixMap = new TreeMap();
    private Iterator<Map.Entry<Float, ArrayList<Position>>> iterator;
    private int blockX;
    private int blockY;
    private int blockZ;
    private List<Entity> hooks;

    public EntityGravityHole(World par1World) {
        super(par1World);
        this.func_70105_a(20.0f, 20.0f);
        this.effectList = new ArrayList<EntityThunderEffect>();
        this.hooks = new LinkedList<Entity>();
        this.iterator = matrixMap.entrySet().iterator();
        this.isFirstUpdate = true;
        this.timer = 1300;
        this.scale = 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        if (this.isFirstUpdate) {
            if (this.field_70170_p.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    EntityThunderEffect tp = new EntityThunderEffect(this.field_70170_p);
                    tp.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
                    this.effectList.add(tp);
                    this.field_70170_p.func_72897_h((Entity)tp);
                }
            }
            this.blockX = (int)Math.floor(this.field_70165_t) - 75;
            this.blockY = (int)Math.floor(this.field_70163_u) - 75;
            this.blockZ = (int)Math.floor(this.field_70161_v) - 75;
            this.isFirstUpdate = false;
        }
        if (this.iterator.hasNext() && this.timer < 100) {
            this.timer = 100;
        }
        if (this.iterator.hasNext()) {
            Map.Entry<Float, ArrayList<Position>> entry = this.iterator.next();
            for (Position pos : entry.getValue()) {
                if (BambooUtil.isUnbreakBlock(this.field_70170_p, this.blockX + pos.getPosX(), this.blockY + pos.getPosY(), this.blockZ + pos.getPosZ())) continue;
                this.setToAirBlock(this.field_70170_p, this.blockX + pos.getPosX(), this.blockY + pos.getPosY(), this.blockZ + pos.getPosZ());
            }
        }
        if (this.field_70170_p.field_72995_K) {
            Iterator<Entity> blocksIterator = this.hooks.iterator();
            while (blocksIterator.hasNext()) {
                Entity entity = blocksIterator.next();
                entity.field_70159_w = entity.field_70159_w + (this.field_70165_t - entity.field_70165_t < 0.0 ? -0.1 : 0.1);
                entity.field_70181_x = entity.field_70181_x + (this.field_70163_u + (double)(this.field_70131_O / 2.0f) - entity.field_70163_u < 0.0 ? -0.15 : 0.15);
                entity.field_70179_y = entity.field_70179_y + (this.field_70161_v - entity.field_70161_v < 0.0 ? -0.1 : 0.1);
                if (this.func_70068_e(entity) < (double)(this.scale * 8.0f)) {
                    entity.func_70106_y();
                }
                if (!entity.field_70128_L) continue;
                blocksIterator.remove();
            }
        }
        if (this.timer-- > 0) {
            if (this.timer < 10) {
                this.scale = this.scale > 0.5f ? (this.scale = this.scale - this.scale / 10.0f) : 0.0f;
            } else if (this.timer < 1250) {
                this.scale = (float)((double)this.scale + (this.scale < 5.0f ? 0.01 : 0.002));
            }
        } else {
            this.func_70106_y();
        }
    }

    public double func_70068_e(Entity par1Entity) {
        double d0 = this.field_70165_t - par1Entity.field_70165_t;
        double d1 = this.field_70163_u + (double)(this.field_70131_O / 2.0f) - par1Entity.field_70163_u;
        double d2 = this.field_70161_v - par1Entity.field_70161_v;
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public void func_70106_y() {
        if (!this.effectList.isEmpty()) {
            for (EntityThunderEffect e : this.effectList) {
                e.func_70106_y();
            }
            this.effectList.clear();
        }
        if (!this.hooks.isEmpty()) {
            for (Entity entity : this.hooks) {
                entity.func_70106_y();
            }
            this.hooks.clear();
        }
        super.func_70106_y();
    }

    private void setToAirBlock(World world, int posX, int posY, int posZ) {
        if (world.field_72995_K && (double)this.field_70146_Z.nextFloat() < 0.02) {
            EntityFallingBlock entityfallingsand = new EntityFallingBlock(world, (double)((float)posX + 0.5f), (double)((float)posY + 0.5f), (double)((float)posZ + 0.5f), world.func_147439_a(posX, posY, posZ), world.func_72805_g(posX, posY, posZ));
            entityfallingsand.field_145812_b = 2;
            entityfallingsand.field_145813_c = false;
            this.hooks.add((Entity)entityfallingsand);
            world.func_72897_h((Entity)entityfallingsand);
        }
        this.field_70170_p.func_147465_d(posX, posY, posZ, Blocks.field_150350_a, 0, 4);
    }

    public float getScale() {
        return this.scale;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        this.func_70106_y();
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public void func_70091_d(double par1, double par3, double par5) {
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double par1, double par3, double par5, float par7, float par8, int par9) {
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    static {
        for (int i = 0; i < 150; ++i) {
            for (int j = 0; j < 150; ++j) {
                for (int k = 0; k < 150; ++k) {
                    float key = BambooUtil.getInnerCircleCollision(0, 0, 0, 75 - i, 75 - j, 75 - k);
                    if (!(key <= 75.0f)) continue;
                    if (!matrixMap.containsKey(Float.valueOf(key))) {
                        matrixMap.put(Float.valueOf(key), new ArrayList());
                    }
                    matrixMap.get(Float.valueOf(key)).add(new Position(i, j, k));
                }
            }
        }
    }

    private static class Position {
        private final int posX;
        private final int posY;
        private final int posZ;

        Position(int posX, int posY, int posZ) {
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
        }

        public int getPosX() {
            return this.posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public int getPosZ() {
            return this.posZ;
        }
    }
}

