/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.tileentity;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;
import ruby.bamboo.item.crafting.CookingManager;
import ruby.bamboo.tileentity.TileEntityEnergyUser;

public class TileEntityCampfire
extends TileEntityEnergyUser
implements ISidedInventory {
    private int meatroll;
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{9, 10};
    private static final int[] slotsSides = new int[]{9};
    private ItemStack[] slots = new ItemStack[11];
    private ItemStack[] copyMatrix = new ItemStack[9];
    private static final byte SLOT_FUEL = 9;
    private static final byte SLOT_RESULT = 10;
    private static final int MAX_FUEL = 102400;
    public int fuel;
    public int cookTime = 200;
    private boolean isBurn = false;
    public ItemStack nowCookingResult;
    public int fuelRatio;
    public int cookRatio = 100;

    public TileEntityCampfire() {
        this.meatroll = new Random().nextInt(360);
    }

    public int getMeatroll() {
        return this.meatroll;
    }

    public void func_145845_h() {
        this.updateFuel();
        this.updateCooking();
        this.updateRender();
    }

    void updateCooking() {
        if (!this.field_145850_b.field_72995_K) {
            if (199 < this.fuel && !this.isBurn && !this.isEmpty()) {
                if (this.slots[10] != null && this.slots[10].field_77994_a == this.slots[10].func_77976_d()) {
                    return;
                }
                if (this.canCooking() && this.nowCookingResult != null) {
                    if (this.slots[10] == null) {
                        this.isBurn = true;
                        this.cookTime = 200;
                        this.setMatrix();
                    } else if (this.nowCookingResult.func_77969_a(this.slots[10]) && this.slots[10].field_77994_a + this.nowCookingResult.field_77994_a <= this.slots[10].func_77976_d()) {
                        this.isBurn = true;
                        this.cookTime = 200;
                        this.setMatrix();
                    }
                }
            } else {
                this.updateBurn();
            }
        }
    }

    private boolean isEmpty() {
        for (int i = 0; i < 9; ++i) {
            if (this.slots[i] == null) continue;
            return false;
        }
        return true;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    private boolean canCooking() {
        this.nowCookingResult = CookingManager.getInstance().findMatchingRecipe(this.slots, this.func_145831_w());
        return this.nowCookingResult != null;
    }

    private void updateBurn() {
        if (this.isBurn) {
            if (--this.cookTime <= 0) {
                ItemStack nowMatrix;
                if (this.nowCookingResult != null && (nowMatrix = CookingManager.getInstance().findMatchingRecipe(this.slots, this.func_145831_w())) != null && nowMatrix.func_77969_a(this.nowCookingResult)) {
                    if (this.slots[10] == null) {
                        this.materialConsumption();
                        this.slots[10] = this.nowCookingResult.func_77946_l();
                    } else if (this.nowCookingResult.func_77969_a(this.slots[10]) && this.slots[10].field_77994_a + this.nowCookingResult.field_77994_a <= this.slots[10].func_77976_d()) {
                        this.materialConsumption();
                        this.slots[10].field_77994_a += this.nowCookingResult.field_77994_a;
                    }
                }
                this.nowCookingResult = null;
                this.isBurn = false;
                this.cookTime = 200;
            }
            if ((this.cookTime & 1) == 0 && !this.chkMtrix()) {
                this.nowCookingResult = null;
                this.isBurn = false;
                this.cookTime = 200;
            }
        }
    }

    private void setMatrix() {
        for (int i = 0; i < 9; ++i) {
            this.copyMatrix[i] = this.func_70301_a(i);
        }
    }

    private boolean chkMtrix() {
        for (int i = 0; i < 9; ++i) {
            if (this.copyMatrix[i] == this.slots[i]) continue;
            return false;
        }
        return true;
    }

    private void materialConsumption() {
        for (int i = 0; i < 9; ++i) {
            if (this.slots[i] == null || --this.slots[i].field_77994_a != 0) continue;
            this.slots[i] = null;
        }
        this.fuel -= 200;
    }

    void updateFuel() {
        if (!this.field_145850_b.field_72995_K) {
            int slotFuel;
            if (TileEntityFurnace.func_145954_b((ItemStack)this.slots[9]) && this.fuel + (slotFuel = TileEntityFurnace.func_145952_a((ItemStack)this.slots[9])) <= 102400) {
                this.fuel += slotFuel;
                if (--this.slots[9].field_77994_a == 0) {
                    this.slots[9] = this.slots[9].func_77973_b().getContainerItem(this.slots[9]);
                }
            }
            if (this.getMinUseEnergy() < this.innerEnerygy) {
                int fuelEnergy = this.innerEnerygy / this.getMinUseEnergy();
                this.innerEnerygy -= fuelEnergy * this.getMinUseEnergy();
                if (this.fuel + fuelEnergy <= 102400) {
                    this.fuel += fuelEnergy;
                } else {
                    this.fuel = 102400;
                    this.innerEnerygy += (fuelEnergy -= 102400 - this.fuel) * this.getMinUseEnergy();
                }
            }
        }
    }

    public ItemStack[] getSlots() {
        return this.slots;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fuel = nbt.func_74762_e("fuel");
        this.cookTime = nbt.func_74762_e("cookTime");
        if (nbt.func_74764_b("nowItem")) {
            this.nowCookingResult = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("nowItem")));
        }
        NBTTagList nbtList = new NBTTagList();
        if (!nbt.func_150297_b("slotsNBT", 9)) {
            nbt.func_74782_a("slotsNBT", (NBTBase)new NBTTagList());
        }
        NBTTagList list = nbt.func_150295_c("slotsNBT", 10);
        for (int i = 0; i < this.slots.length && i < list.func_74745_c(); ++i) {
            NBTTagCompound nbtCompound = list.func_150305_b(i);
            if (!nbtCompound.func_74764_b("itemNBT")) continue;
            this.slots[i] = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbtCompound.func_74781_a("itemNBT")));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("fuel", this.fuel);
        nbt.func_74768_a("cookTime", this.cookTime);
        if (this.nowCookingResult != null) {
            nbt.func_74782_a("nowItem", (NBTBase)this.nowCookingResult.func_77955_b(new NBTTagCompound()));
        }
        if (!nbt.func_150297_b("slotsNBT", 9)) {
            nbt.func_74782_a("slotsNBT", (NBTBase)new NBTTagList());
        }
        NBTTagList list = nbt.func_150295_c("slotsNBT", 10);
        for (int i = 0; i < this.slots.length; ++i) {
            NBTTagCompound nbtCompound = new NBTTagCompound();
            if (this.slots[i] != null) {
                NBTTagCompound itemCompound = new NBTTagCompound();
                this.slots[i].func_77955_b(itemCompound);
                nbtCompound.func_74782_a("itemNBT", (NBTBase)itemCompound);
            }
            list.func_74742_a((NBTBase)nbtCompound);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 5, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    void updateRender() {
        int n = this.meatroll = this.meatroll < 360 ? (this.meatroll = this.meatroll + 1) : 0;
        if (!this.field_145850_b.field_72995_K) {
            int meta = 0;
            if (this.func_70301_a(10) != null) {
                meta = this.func_70301_a(10).func_77973_b() == Items.field_151101_aQ ? 1 : (this.func_70301_a(10).func_77973_b() == Items.field_151157_am || this.func_70301_a(10).func_77973_b() == Items.field_151083_be ? 2 : 3);
            }
            if (meta != this.func_145832_p() >> 2) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta << 2 | this.func_145832_p() & 3, 3);
            }
        }
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.slots[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        if (this.slots[var1] != null) {
            if (this.slots[var1].field_77994_a <= var2) {
                ItemStack itemstack = this.slots[var1];
                this.slots[var1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.slots[var1].func_77979_a(var2);
            if (this.slots[var1].field_77994_a == 0) {
                this.slots[var1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        if (this.slots[var1] != null) {
            ItemStack itemstack = this.slots[var1];
            this.slots[var1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.slots[var1] = var2;
        if (var2 != null && var2.field_77994_a > this.func_70297_j_()) {
            var2.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return "bamboo.container.campfire";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : var1.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int var1, ItemStack var2) {
        return var1 == 2 ? false : (var1 == 9 ? TileEntityFurnace.func_145954_b((ItemStack)var2) : true);
    }

    public int[] func_94128_d(int var1) {
        return var1 == 0 ? slotsBottom : (var1 == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int var1, ItemStack var2, int var3) {
        return this.func_94041_b(var1, var2);
    }

    public boolean func_102008_b(int var1, ItemStack var2, int var3) {
        return var3 != 0 || var1 != 9 || var2.func_77973_b() == Items.field_151133_ar;
    }

    public int getCookAmount() {
        return this.getRatio(this.cookTime, 200.0f, 100);
    }

    public int getFuelAmount() {
        return this.getRatio(this.fuel, 102400.0f, 100);
    }

    private int getRatio(float par0, float par1, int par3) {
        return Math.round(par0 / par1 * (float)par3);
    }

    @Override
    int getMinUseEnergy() {
        return 4;
    }

    @Override
    int getMaxUseEnergy() {
        return 7200;
    }
}

