/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.tileentity.spa;

import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import ruby.bamboo.tileentity.spa.BoilManager;
import ruby.bamboo.tileentity.spa.ITileEntitySpa;

public class TileEntitySpaParent
extends TileEntity
implements ITileEntitySpa {
    private EntityLivingBase bathingEntity = null;
    private short bathingTime;
    private short lastBathingTime;
    private boolean stay;
    private int color = 0xFFFFFF;

    @Override
    public void addColor(int deycolor) {
        int i = (deycolor & 0xFF0000) >> 16;
        int j = (deycolor & 0xFF00) >> 8;
        int k = deycolor & 0xFF;
        j &= 0xFF;
        k &= 0xFF;
        if ((this.color & 0xFF0000) - ((i &= 0xFF) << 16) >= 0) {
            this.color -= i << 16;
        } else if (i > 0) {
            this.color &= 0xFFFF;
        }
        if ((this.color & 0xFF00) - (j << 8) >= 0) {
            this.color -= j << 8;
        } else if (j < 0) {
            this.color &= 0xFF00FF;
        }
        if ((this.color & 0xFF) - k >= 0) {
            this.color -= k;
        } else if (j < 0) {
            this.color &= 0xFFFF00;
        }
    }

    @Override
    public void colorUpdate() {
        int meta = (this.func_145832_p() & 4) != 0 ? this.func_145832_p() - 4 : this.func_145832_p() + 4;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, meta, 3);
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public boolean isStay() {
        return this.stay;
    }

    public void setStay(boolean flg) {
        this.stay = flg;
    }

    @Override
    public int[] getParentPosition() {
        return new int[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    public void func_145845_h() {
        if (this.bathingEntity != null) {
            if (!this.bathingEntity.func_70090_H()) {
                this.bathingEntity = null;
            }
            this.lastBathingTime = this.bathingTime;
        }
    }

    @Override
    public void onEntityLivingCollision(EntityLivingBase entity) {
        if (this.bathingEntity == null) {
            this.bathingEntity = entity;
            this.bathingTime = 0;
            this.lastBathingTime = 0;
        } else if (this.lastBathingTime == this.bathingTime && (this.bathingTime = (short)(this.bathingTime + 1)) > 200) {
            int effectNum = this.getEffectNum();
            if (effectNum == 0) {
                entity.func_70691_i(1.0f);
                this.bathingTime = (short)180;
            } else if (effectNum == 1) {
                this.onFoodEaten(new ItemStack((Item)Items.field_151068_bn, 1, 8289), entity.field_70170_p, entity);
                this.bathingTime = 0;
            } else if (effectNum == 2) {
                this.onFoodEaten(new ItemStack((Item)Items.field_151068_bn, 1, 8297), entity.field_70170_p, entity);
                this.bathingTime = 0;
            } else if (effectNum == 4) {
                this.onFoodEaten(new ItemStack((Item)Items.field_151068_bn, 1, 8195), entity.field_70170_p, entity);
                this.bathingTime = 0;
            } else if (effectNum == 8) {
                this.onFoodEaten(new ItemStack((Item)Items.field_151068_bn, 1, 8290), entity.field_70170_p, entity);
                this.bathingTime = 0;
            } else if (effectNum == 15) {
                this.onFoodEaten(new ItemStack((Item)Items.field_151068_bn, 1, 8292), entity.field_70170_p, entity);
            }
        }
    }

    @Override
    public void onEntityItemCollision(EntityItem entity) {
        BoilManager.boil(this, entity);
    }

    private void onFoodEaten(ItemStack par1ItemStack, World par2World, EntityLivingBase par3EntityPlayer) {
        List var4 = Items.field_151068_bn.func_77832_l(par1ItemStack);
        if (var4 != null) {
            for (PotionEffect var6 : var4) {
                par3EntityPlayer.func_70690_d(new PotionEffect(var6));
            }
        }
    }

    private int getEffectNum() {
        int result = 0;
        int wc = this.getColor();
        int r = (wc & 0xFF0000) >> 16;
        int g = (wc & 0xFF00) >> 8;
        int b = wc & 0xFF;
        if (r < 175 && g < 175 && b < 175) {
            result = 1;
        }
        if (g < 127 && b < 127) {
            result += 2;
        }
        if (r < 127 && b < 127) {
            result += 4;
        }
        if (r < 127 && g < 127) {
            result += 8;
        }
        return result;
    }

    public Packet func_145844_m() {
        NBTTagCompound var1 = new NBTTagCompound();
        this.func_145841_b(var1);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, var1);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.stay = nbttagcompound.func_74767_n("stay");
        this.color = nbttagcompound.func_74762_e("color");
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        this.writeToParentNBT(nbttagcompound);
        nbttagcompound.func_74757_a("stay", this.stay);
    }

    private void writeToParentNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("color", this.color);
    }

    @Override
    public boolean isTickScheduled() {
        return false;
    }

    @Override
    public void setTickSchedule(boolean flg) {
    }

    @Override
    public int getLastTickMeta() {
        return -1;
    }

    @Override
    public void setLastTickMeta(int meta) {
    }
}

