/*
 * Decompiled with CFR 0.152.
 */
package ruby.bamboo.worldgen;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import ruby.bamboo.BambooInit;
import ruby.bamboo.block.BlockSakura;
import ruby.bamboo.worldgen.WorldGenBamboo;

public class GeneraterHandler
implements IWorldGenerator {
    private static GeneraterHandler instance = new GeneraterHandler();
    private static final byte BAMBOO = 0;
    private static final byte SAKURA = 1;

    public static void init() {
        GameRegistry.registerWorldGenerator((IWorldGenerator)instance, (int)1);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        WorldChunkManager worldchunkmanager = world.func_72959_q();
        if (worldchunkmanager != null) {
            BiomeGenBase biome = worldchunkmanager.func_76935_a(chunkX * 16, chunkZ * 16);
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
                if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FROZEN)) {
                    switch (random.nextInt(4)) {
                        case 0: {
                            this.generateBambooshoot(random, world, chunkX, chunkZ, 60);
                            break;
                        }
                        case 1: {
                            this.generateSakura(random, world, chunkX, chunkZ, 60);
                        }
                    }
                }
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
                switch (random.nextInt(4)) {
                    case 0: {
                        this.generateSeaweed(random, world, chunkX, chunkZ, 80);
                    }
                }
            }
        }
    }

    private void generateSeaweed(Random random, World world, int chunkX, int chunkZ, int maxHeight) {
        for (int l = random.nextInt(20); 0 < l; --l) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = random.nextInt(maxHeight);
            int z = chunkZ * 16 + random.nextInt(16);
            for (int var6 = 0; var6 < 20; ++var6) {
                int posX = x + random.nextInt(8) - random.nextInt(8);
                int posY = y + random.nextInt(4) - random.nextInt(4);
                int posZ = z + random.nextInt(8) - random.nextInt(8);
                Block blockid = world.func_147439_a(posX, posY - 1, posZ);
                if (!world.func_147437_c(posX, posY, posZ) || !BambooInit.seaWeedPlant.func_149718_j(world, posX, posY, posZ)) continue;
                world.func_147465_d(posX, posY, posZ, BambooInit.seaWeedPlant, 0, 0);
            }
        }
    }

    private void generateBambooshoot(Random random, World world, int chunkX, int chunkZ, int maxHeight) {
        for (int l = random.nextInt(10); 0 < l; --l) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = random.nextInt(maxHeight) + 60;
            int z = chunkZ * 16 + random.nextInt(16);
            WorldGenBamboo.instance.func_76484_a(world, random, x, y, z);
        }
    }

    private void generateSakura(Random random, World world, int chunkX, int chunkZ, int maxHeight) {
        for (int l = random.nextInt(5); 0 < l; --l) {
            int x = chunkX * 16 + random.nextInt(16);
            int y = random.nextInt(maxHeight) + 60;
            int z = chunkZ * 16 + random.nextInt(16);
            for (int var6 = 0; var6 < 10; ++var6) {
                int var9;
                int var8;
                int var7 = x + random.nextInt(8) - random.nextInt(8);
                if (!world.func_147437_c(var7, var8 = y + random.nextInt(4) - random.nextInt(4), var9 = z + random.nextInt(8) - random.nextInt(8)) || world.func_147439_a(var7, var8 - 1, var9) != Blocks.field_150349_c || !Blocks.field_150423_aK.func_149742_c(world, var7, var8, var9)) continue;
                ((BlockSakura)BambooInit.sakura).growTree(world, var7, var8, var9, random, 15);
                return;
            }
        }
    }
}

