/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.items;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.BlockLoader;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.blocks.BiblioBlock;
import jds.bibliocraft.blocks.BlockSeat;
import jds.bibliocraft.helpers.EnumRelativeLocation;
import jds.bibliocraft.helpers.EnumShiftPosition;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.tileentities.BiblioLightTileEntity;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityArmorStand;
import jds.bibliocraft.tileentities.TileEntityBookcase;
import jds.bibliocraft.tileentities.TileEntityCase;
import jds.bibliocraft.tileentities.TileEntityClock;
import jds.bibliocraft.tileentities.TileEntityDesk;
import jds.bibliocraft.tileentities.TileEntityDinnerPlate;
import jds.bibliocraft.tileentities.TileEntityDiscRack;
import jds.bibliocraft.tileentities.TileEntityFancySign;
import jds.bibliocraft.tileentities.TileEntityFancyWorkbench;
import jds.bibliocraft.tileentities.TileEntityFramedChest;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import jds.bibliocraft.tileentities.TileEntityPainting;
import jds.bibliocraft.tileentities.TileEntityPotionShelf;
import jds.bibliocraft.tileentities.TileEntityPrintPress;
import jds.bibliocraft.tileentities.TileEntitySeat;
import jds.bibliocraft.tileentities.TileEntityShelf;
import jds.bibliocraft.tileentities.TileEntitySwordPedestal;
import jds.bibliocraft.tileentities.TileEntityTable;
import jds.bibliocraft.tileentities.TileEntityToolRack;
import jds.bibliocraft.tileentities.TileEntityTypeMachine;
import jds.bibliocraft.tileentities.TileEntityTypewriter;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityComparator;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class ItemDrill
extends Item {
    public static final String name = "BiblioDrill";
    public static final ItemDrill instance = new ItemDrill("BiblioDrill");
    public int useMode = 0;
    private TileEntity tile1;
    private TileEntity tile2;
    private static String sSelectedPainting1 = I18n.func_74838_a((String)"screwgun.selected.painting1");
    private static String sSelectedPainting2 = I18n.func_74838_a((String)"screwgun.selected.painting2");
    private static String sSelectedClock1 = I18n.func_74838_a((String)"screwgun.selected.clock1");
    private static String sSelectedClock2 = I18n.func_74838_a((String)"screwgun.selected.clock2");
    private static String sSelectedSeat1 = I18n.func_74838_a((String)"screwgun.firstSeat");
    private static String sSelectedSeat2 = I18n.func_74838_a((String)"screwgun.secondSeat");
    private static String sSelectedDesk1 = I18n.func_74838_a((String)"screwgun.selected.desk1");
    private static String sSelectedDesk2 = I18n.func_74838_a((String)"screwgun.selected.desk2");
    private static String sSelectedChest1 = I18n.func_74838_a((String)"screwgun.selected.chest1");
    private static String sSelectedChest2 = I18n.func_74838_a((String)"screwgun.selected.chest2");
    private static String sFailed = I18n.func_74838_a((String)"drill.failed");
    public boolean showText = false;
    public boolean showTextChanged = false;
    public String showTextString = "";

    public ItemDrill(String regName) {
        this.func_77637_a(BlockLoader.biblioTab);
        this.func_77655_b(name);
        this.field_77777_bU = 1;
        this.setRegistryName(regName);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            this.playSound(player);
        }
        boolean returnValue = false;
        if (!world.field_72995_K) {
            TileEntity tile;
            if (player.func_70093_af() && (world.func_180495_p(pos).func_177230_c() == Blocks.field_150331_J || world.func_180495_p(pos).func_177230_c() == Blocks.field_150320_F || world.func_180495_p(pos).func_177230_c() == Blocks.field_150442_at || world.func_180495_p(pos).func_177230_c() == Blocks.field_150413_aR || world.func_180495_p(pos).func_177230_c() == Blocks.field_150467_bQ || world.func_180495_p(pos).func_177230_c() == Blocks.field_150454_av || world.func_180495_p(pos).func_177230_c() == Blocks.field_180410_as || world.func_180495_p(pos).func_177230_c() == Blocks.field_180409_at || world.func_180495_p(pos).func_177230_c() == Blocks.field_180413_ao || world.func_180495_p(pos).func_177230_c() == Blocks.field_180412_aq || world.func_180495_p(pos).func_177230_c() == Blocks.field_180411_ar || world.func_180495_p(pos).func_177230_c() == Blocks.field_180414_ap || world.func_180495_p(pos).func_177230_c() == Blocks.field_150415_aT || world.func_180495_p(pos).func_177230_c() == Blocks.field_180400_cw)) {
                returnValue = this.rotateBlockState(world, pos);
            }
            if ((tile = world.func_175625_s(pos)) != null) {
                if (tile instanceof TileEntityDispenser || tile instanceof TileEntityComparator || tile instanceof TileEntityChest || tile instanceof TileEntityFurnace || tile instanceof TileEntityEnderChest) {
                    returnValue = this.rotateBlockState(world, pos);
                }
                if (player.func_70093_af()) {
                    if (tile instanceof TileEntityDiscRack || tile instanceof TileEntityFancySign || tile instanceof TileEntityToolRack || tile instanceof TileEntityCase || tile instanceof TileEntityPotionShelf || tile instanceof TileEntityMapFrame || tile instanceof BiblioLightTileEntity || tile instanceof TileEntityShelf || tile instanceof TileEntityBookcase || tile instanceof TileEntityMapFrame || tile instanceof TileEntityDinnerPlate || tile instanceof TileEntitySwordPedestal || tile instanceof TileEntityTypewriter || tile instanceof TileEntityFancyWorkbench || tile instanceof TileEntityTypeMachine || tile instanceof TileEntityPrintPress) {
                        returnValue = this.rotateBiblioBlock(world, (BiblioTileEntity)tile);
                    }
                    if (!returnValue && tile instanceof TileEntitySeat) {
                        returnValue = face == EnumFacing.UP ? this.connectChairs(player, world, pos) : this.rotateBiblioBlock(world, (BiblioTileEntity)tile);
                    }
                    if (!returnValue && tile instanceof TileEntityDesk) {
                        returnValue = this.connectTwoDesks(world, tile, player);
                    }
                    if (!returnValue && tile instanceof TileEntityArmorStand) {
                        returnValue = this.rotateArmorStand(world, (BiblioTileEntity)tile);
                    }
                    if (!returnValue && tile instanceof TileEntityTable) {
                        returnValue = this.removeTableCarpet(world, tile, pos);
                    }
                    if (!returnValue && tile instanceof TileEntityClock) {
                        returnValue = this.connectTwoClocks(world, tile, player);
                    }
                    if (!returnValue && tile instanceof TileEntityPainting) {
                        returnValue = this.connectTwoPaintings(world, tile, player);
                    }
                    if (!returnValue && tile instanceof TileEntityFramedChest) {
                        returnValue = this.connectTwoChests(world, tile, player);
                    }
                } else {
                    if (!returnValue && tile instanceof BiblioLightTileEntity) {
                        returnValue = this.setVertPosition((BiblioTileEntity)tile, true, true, true);
                    }
                    if (!returnValue && tile instanceof TileEntityCase) {
                        returnValue = this.setVertPosition((BiblioTileEntity)tile, true, false, true);
                    }
                    if (tile instanceof TileEntityFancySign || tile instanceof TileEntityShelf || tile instanceof TileEntityPotionShelf || tile instanceof TileEntityToolRack || tile instanceof TileEntityBookcase) {
                        returnValue = this.setShiftPosition((BiblioTileEntity)tile, true);
                    }
                    if (!returnValue && tile instanceof TileEntityClock) {
                        returnValue = this.setClockShift(world, (TileEntityClock)tile);
                    }
                    if (!returnValue && tile instanceof TileEntityFramedChest) {
                        returnValue = this.rotateBiblioBlock(world, (BiblioTileEntity)tile);
                    }
                    if (!returnValue && tile instanceof TileEntityDiscRack) {
                        returnValue = this.rotateDiscRackOnWall((TileEntityDiscRack)tile);
                    }
                    if (!returnValue && tile instanceof TileEntityPainting) {
                        returnValue = this.rotatePaintingCanvas((TileEntityPainting)tile);
                    }
                    if (!returnValue && tile instanceof TileEntitySeat) {
                        returnValue = this.removeStuffFromSeat((TileEntitySeat)tile, player, face);
                    }
                }
                if (returnValue) {
                    // empty if block
                }
            }
        }
        EnumActionResult result = EnumActionResult.FAIL;
        if (returnValue) {
            result = EnumActionResult.SUCCESS;
        }
        return result;
    }

    private boolean rotateBlockState(World world, BlockPos pos) {
        boolean output = false;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != null) {
            block.rotateBlock(world, pos, EnumFacing.UP);
            output = true;
        }
        return output;
    }

    private boolean removeStuffFromSeat(TileEntitySeat tile, EntityPlayer player, EnumFacing face) {
        boolean output = false;
        if (face == EnumFacing.UP && tile.func_70301_a(0) != null) {
            tile.removeStackFromInventoryFromWorld(0, player, BlockSeat.instance);
            tile.removeCover();
            output = true;
        }
        if (!output && tile.hasBack > 0) {
            tile.removeStackFromInventoryFromWorld(1, player, BlockSeat.instance);
            tile.removeBack();
            output = true;
        }
        if (!output && face != EnumFacing.UP && tile.isCarpetFull()) {
            tile.removeStackFromInventoryFromWorld(2, player, BlockSeat.instance);
            output = true;
        }
        return output;
    }

    private boolean rotateBiblioBlock(World world, BiblioTileEntity tile) {
        if (tile != null) {
            switch (tile.getAngle()) {
                case SOUTH: {
                    tile.setAngle(EnumFacing.WEST);
                    break;
                }
                case WEST: {
                    tile.setAngle(EnumFacing.NORTH);
                    break;
                }
                case NORTH: {
                    tile.setAngle(EnumFacing.EAST);
                    break;
                }
                case EAST: {
                    tile.setAngle(EnumFacing.SOUTH);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private boolean setVertPosition(BiblioTileEntity tile, boolean canWall, boolean canCeiling, boolean canFloor) {
        if (tile != null) {
            EnumVertPosition currAngle = tile.getVertPosition();
            switch (currAngle) {
                case FLOOR: {
                    if (canWall) {
                        tile.setVertPosition(EnumVertPosition.WALL);
                        break;
                    }
                    if (!canCeiling) break;
                    tile.setVertPosition(EnumVertPosition.CEILING);
                    break;
                }
                case WALL: {
                    if (canCeiling) {
                        tile.setVertPosition(EnumVertPosition.CEILING);
                        break;
                    }
                    if (!canFloor) break;
                    tile.setVertPosition(EnumVertPosition.FLOOR);
                    break;
                }
                case CEILING: {
                    if (canFloor) {
                        tile.setVertPosition(EnumVertPosition.FLOOR);
                        break;
                    }
                    if (!canWall) break;
                    tile.setVertPosition(EnumVertPosition.WALL);
                }
            }
            return true;
        }
        return false;
    }

    private boolean setShiftPosition(BiblioTileEntity tile, boolean canHalfShift) {
        if (tile != null) {
            switch (tile.getShiftPosition()) {
                case NO_SHIFT: {
                    if (canHalfShift) {
                        tile.setShiftPosition(EnumShiftPosition.HALF_SHIFT);
                        break;
                    }
                    tile.setShiftPosition(EnumShiftPosition.FULL_SHIFT);
                    break;
                }
                case HALF_SHIFT: {
                    tile.setShiftPosition(EnumShiftPosition.FULL_SHIFT);
                    break;
                }
                case FULL_SHIFT: {
                    tile.setShiftPosition(EnumShiftPosition.NO_SHIFT);
                }
            }
            return true;
        }
        return false;
    }

    private boolean rotatePaintingCanvas(TileEntityPainting painting) {
        if (painting.getPaintingRotation() < 3) {
            painting.setPaintingRotation(painting.getPaintingRotation() + 1);
        } else {
            painting.setPaintingRotation(0);
        }
        return true;
    }

    private boolean rotateDiscRackOnWall(TileEntityDiscRack tile) {
        if (tile != null) {
            tile.setWallRotation();
            return true;
        }
        return false;
    }

    private boolean rotateArmorStand(World world, BiblioTileEntity tile) {
        if (tile != null) {
            TileEntity otherStand = null;
            if (tile.getVertPosition() == EnumVertPosition.FLOOR) {
                otherStand = world.func_175625_s(new BlockPos(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o() + 1, tile.func_174877_v().func_177952_p()));
            } else if (tile.getVertPosition() == EnumVertPosition.CEILING) {
                otherStand = world.func_175625_s(new BlockPos(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o() - 1, tile.func_174877_v().func_177952_p()));
            }
            if (otherStand != null && otherStand instanceof TileEntityArmorStand) {
                BiblioTileEntity otherTile = (BiblioTileEntity)otherStand;
                this.rotateBiblioBlock(world, tile);
                this.rotateBiblioBlock(world, otherTile);
                return true;
            }
        }
        return false;
    }

    private boolean connectTwoChests(World world, TileEntity tile, EntityPlayer player) {
        if (this.tile1 == null || !(this.tile1 instanceof TileEntityFramedChest)) {
            this.tile1 = tile;
            this.sendPacketToClient(sSelectedChest1, (EntityPlayerMP)player);
            return true;
        }
        if (this.tile2 == null || !(this.tile2 instanceof TileEntityFramedChest)) {
            this.tile2 = tile;
            this.sendPacketToClient(sSelectedChest2, (EntityPlayerMP)player);
        }
        if (this.tile1 != null && this.tile1 instanceof TileEntityFramedChest && this.tile2 != null && this.tile2 instanceof TileEntityFramedChest) {
            TileEntityFramedChest chest1 = (TileEntityFramedChest)this.tile1;
            TileEntityFramedChest chest2 = (TileEntityFramedChest)this.tile2;
            if (chest1.getAngle() == chest2.getAngle()) {
                int test = this.isValidChestConnect(chest1.getAngle(), chest1.func_174877_v().func_177958_n(), chest1.func_174877_v().func_177956_o(), chest1.func_174877_v().func_177952_p(), chest2.func_174877_v().func_177958_n(), chest2.func_174877_v().func_177956_o(), chest2.func_174877_v().func_177952_p());
                if (test == 1) {
                    if (chest1.getIsDouble() && chest1.getIsLeft() && chest2.getIsDouble() && !chest2.getIsLeft()) {
                        chest1.setIsDouble(false, false, null);
                        chest2.setIsDouble(false, false, null);
                    } else if (!chest1.getIsDouble() && !chest2.getIsDouble()) {
                        chest1.setIsDouble(true, true, chest2);
                        chest2.setIsDouble(true, false, chest1);
                    } else {
                        this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
                    }
                } else if (test == 2) {
                    if (chest1.getIsDouble() && !chest1.getIsLeft() && chest2.getIsDouble() && chest2.getIsLeft()) {
                        chest1.setIsDouble(false, false, null);
                        chest2.setIsDouble(false, false, null);
                    } else if (!chest1.getIsDouble() && !chest2.getIsDouble()) {
                        chest1.setIsDouble(true, false, chest2);
                        chest2.setIsDouble(true, true, chest1);
                    } else {
                        this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
                    }
                } else {
                    this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
                }
            } else {
                this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
            }
            this.tile1 = null;
            this.tile2 = null;
            return true;
        }
        return false;
    }

    private int isValidChestConnect(EnumFacing angle, int x1, int y1, int z1, int x2, int y2, int z2) {
        if (y1 == y2) {
            switch (angle) {
                case SOUTH: {
                    if (x1 == x2 && z1 == z2 + 1) {
                        return 2;
                    }
                    if (x1 == x2 && z1 == z2 - 1) {
                        return 1;
                    }
                }
                case WEST: {
                    if (z1 == z2 && x1 == x2 - 1) {
                        return 2;
                    }
                    if (z1 == z2 && x1 == x2 + 1) {
                        return 1;
                    }
                }
                case NORTH: {
                    if (x1 == x2 && z1 == z2 - 1) {
                        return 2;
                    }
                    if (x1 == x2 && z1 == z2 + 1) {
                        return 1;
                    }
                }
                case EAST: {
                    if (z1 == z2 && x1 == x2 + 1) {
                        return 2;
                    }
                    if (z1 != z2 || x1 != x2 - 1) break;
                    return 1;
                }
            }
        }
        return 0;
    }

    private boolean setClockShift(World world, BiblioTileEntity tile) {
        if (tile != null) {
            this.setShiftPosition(tile, true);
            TileEntity otherClock = null;
            if (tile.getVertPosition() == EnumVertPosition.CEILING) {
                otherClock = world.func_175625_s(new BlockPos(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o() - 1, tile.func_174877_v().func_177952_p()));
            } else if (tile.getVertPosition() == EnumVertPosition.FLOOR) {
                otherClock = world.func_175625_s(new BlockPos(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o() + 1, tile.func_174877_v().func_177952_p()));
            }
            if (otherClock != null && otherClock instanceof TileEntityClock) {
                BiblioTileEntity otherTile = (BiblioTileEntity)otherClock;
                this.setShiftPosition(otherTile, true);
            }
            return true;
        }
        return false;
    }

    private boolean connectTwoDesks(World world, TileEntity tile, EntityPlayer player) {
        if (this.tile1 == null || !(this.tile1 instanceof TileEntityDesk)) {
            this.tile1 = tile;
            this.sendPacketToClient(sSelectedDesk1, (EntityPlayerMP)player);
            return true;
        }
        if (this.tile2 == null || !(this.tile2 instanceof TileEntityDesk)) {
            this.tile2 = tile;
            this.sendPacketToClient(sSelectedDesk2, (EntityPlayerMP)player);
        }
        if (this.tile1 != null && this.tile1 instanceof TileEntityDesk && this.tile2 != null && this.tile2 instanceof TileEntityDesk) {
            TileEntityDesk desk1 = (TileEntityDesk)this.tile1;
            TileEntityDesk desk2 = (TileEntityDesk)this.tile2;
            if (desk1.getAngle() == desk2.getAngle()) {
                if (this.isDeskOnRight(desk1, desk2)) {
                    this.connectDeskToRight(desk1);
                    this.connectDeskToLeft(desk2);
                } else if (this.isDeskOnLeft(desk1, desk2)) {
                    this.connectDeskToLeft(desk1);
                    this.connectDeskToRight(desk2);
                } else {
                    this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
                }
            } else {
                this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
            }
            this.tile1 = null;
            this.tile2 = null;
            return true;
        }
        return false;
    }

    private void connectDeskToRight(TileEntityDesk desk) {
        switch (desk.getSingleLeftRightCenter()) {
            case SINGLE: {
                desk.setSingleLeftRightCenter(EnumRelativeLocation.LEFT);
                break;
            }
            case LEFT: {
                desk.setSingleLeftRightCenter(EnumRelativeLocation.SINGLE);
                break;
            }
            case RIGHT: {
                desk.setSingleLeftRightCenter(EnumRelativeLocation.CENTER);
                break;
            }
            case CENTER: {
                desk.setSingleLeftRightCenter(EnumRelativeLocation.RIGHT);
                break;
            }
        }
    }

    private void connectDeskToLeft(TileEntityDesk desk) {
        switch (desk.getSingleLeftRightCenter()) {
            case SINGLE: {
                desk.setSingleLeftRightCenter(EnumRelativeLocation.RIGHT);
                break;
            }
            case LEFT: {
                desk.setSingleLeftRightCenter(EnumRelativeLocation.CENTER);
                break;
            }
            case RIGHT: {
                desk.setSingleLeftRightCenter(EnumRelativeLocation.SINGLE);
                break;
            }
            case CENTER: {
                desk.setSingleLeftRightCenter(EnumRelativeLocation.LEFT);
                break;
            }
        }
    }

    private boolean isDeskOnRight(TileEntityDesk desk1, TileEntityDesk desk2) {
        switch (desk1.getAngle()) {
            case SOUTH: {
                if (desk1.func_174877_v().func_177952_p() != desk2.func_174877_v().func_177952_p() - 1 || desk1.func_174877_v().func_177958_n() != desk2.func_174877_v().func_177958_n() || desk1.func_174877_v().func_177956_o() != desk2.func_174877_v().func_177956_o()) break;
                return true;
            }
            case WEST: {
                if (desk1.func_174877_v().func_177958_n() != desk2.func_174877_v().func_177958_n() + 1 || desk1.func_174877_v().func_177952_p() != desk2.func_174877_v().func_177952_p() || desk1.func_174877_v().func_177956_o() != desk2.func_174877_v().func_177956_o()) break;
                return true;
            }
            case NORTH: {
                if (desk1.func_174877_v().func_177952_p() != desk2.func_174877_v().func_177952_p() + 1 || desk1.func_174877_v().func_177958_n() != desk2.func_174877_v().func_177958_n() || desk1.func_174877_v().func_177956_o() != desk2.func_174877_v().func_177956_o()) break;
                return true;
            }
            case EAST: {
                if (desk1.func_174877_v().func_177958_n() != desk2.func_174877_v().func_177958_n() - 1 || desk1.func_174877_v().func_177952_p() != desk2.func_174877_v().func_177952_p() || desk1.func_174877_v().func_177956_o() != desk2.func_174877_v().func_177956_o()) break;
                return true;
            }
        }
        return false;
    }

    private boolean isDeskOnLeft(TileEntityDesk desk1, TileEntityDesk desk2) {
        switch (desk1.getAngle()) {
            case SOUTH: {
                if (desk1.func_174877_v().func_177952_p() != desk2.func_174877_v().func_177952_p() + 1 || desk1.func_174877_v().func_177958_n() != desk2.func_174877_v().func_177958_n() || desk1.func_174877_v().func_177956_o() != desk2.func_174877_v().func_177956_o()) break;
                return true;
            }
            case WEST: {
                if (desk1.func_174877_v().func_177958_n() != desk2.func_174877_v().func_177958_n() - 1 || desk1.func_174877_v().func_177952_p() != desk2.func_174877_v().func_177952_p() || desk1.func_174877_v().func_177956_o() != desk2.func_174877_v().func_177956_o()) break;
                return true;
            }
            case NORTH: {
                if (desk1.func_174877_v().func_177952_p() != desk2.func_174877_v().func_177952_p() - 1 || desk1.func_174877_v().func_177958_n() != desk2.func_174877_v().func_177958_n() || desk1.func_174877_v().func_177956_o() != desk2.func_174877_v().func_177956_o()) break;
                return true;
            }
            case EAST: {
                if (desk1.func_174877_v().func_177958_n() != desk2.func_174877_v().func_177958_n() + 1 || desk1.func_174877_v().func_177952_p() != desk2.func_174877_v().func_177952_p() || desk1.func_174877_v().func_177956_o() != desk2.func_174877_v().func_177956_o()) break;
                return true;
            }
        }
        return false;
    }

    private boolean connectTwoPaintings(World world, TileEntity tile, EntityPlayer player) {
        if (this.tile1 == null || !(this.tile1 instanceof TileEntityPainting)) {
            this.tile1 = tile;
            this.sendPacketToClient(sSelectedPainting1, (EntityPlayerMP)player);
            return true;
        }
        if (this.tile2 == null || !(this.tile2 instanceof TileEntityPainting)) {
            this.tile2 = tile;
            this.sendPacketToClient(sSelectedPainting2, (EntityPlayerMP)player);
        }
        if (this.tile1 != null && this.tile1 instanceof TileEntityPainting && this.tile2 != null && this.tile2 instanceof TileEntityPainting) {
            TileEntityPainting painting1 = (TileEntityPainting)this.tile1;
            TileEntityPainting painting2 = (TileEntityPainting)this.tile2;
            if (painting1.getAngle() == painting2.getAngle()) {
                if (this.tile1.func_174877_v().func_177956_o() == this.tile2.func_174877_v().func_177956_o() + 1) {
                    if (painting1.getConnectBottom() && painting2.getConnectTop()) {
                        painting1.setConnectBottom(false);
                        painting2.setConnectTop(false);
                    } else {
                        painting1.setConnectBottom(true);
                        painting2.setConnectTop(true);
                    }
                    this.completedPaintingConnect(player);
                } else if (this.tile1.func_174877_v().func_177956_o() == this.tile2.func_174877_v().func_177956_o() - 1) {
                    if (painting1.getConnectTop() && painting2.getConnectBottom()) {
                        painting1.setConnectTop(false);
                        painting2.setConnectBottom(false);
                    } else {
                        painting1.setConnectTop(true);
                        painting2.setConnectBottom(true);
                    }
                    this.completedPaintingConnect(player);
                } else if (this.checkLeftSidePainting(painting1, painting2)) {
                    if (painting1.getConnectLeft() && painting2.getConnectRight()) {
                        painting1.setConnectLeft(false);
                        painting2.setConnectRight(false);
                    } else {
                        painting1.setConnectLeft(true);
                        painting2.setConnectRight(true);
                    }
                    this.completedPaintingConnect(player);
                } else if (this.checkRightSidePainting(painting1, painting2)) {
                    if (painting1.getConnectRight() && painting2.getConnectLeft()) {
                        painting1.setConnectRight(false);
                        painting2.setConnectLeft(false);
                    } else {
                        painting1.setConnectRight(true);
                        painting2.setConnectLeft(true);
                    }
                    this.completedPaintingConnect(player);
                } else {
                    this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
                    this.tile1 = null;
                    this.tile2 = null;
                }
            } else {
                this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
                this.tile1 = null;
                this.tile2 = null;
            }
        }
        return false;
    }

    private void completedPaintingConnect(EntityPlayer player) {
        this.tile1 = null;
        this.tile2 = null;
    }

    private boolean checkLeftSidePainting(TileEntityPainting centerPainting, TileEntityPainting otherPainting) {
        switch (centerPainting.getAngle()) {
            case SOUTH: {
                if (centerPainting.func_174877_v().func_177952_p() != otherPainting.func_174877_v().func_177952_p() + 1) break;
                return true;
            }
            case WEST: {
                if (centerPainting.func_174877_v().func_177958_n() != otherPainting.func_174877_v().func_177958_n() - 1) break;
                return true;
            }
            case NORTH: {
                if (centerPainting.func_174877_v().func_177952_p() != otherPainting.func_174877_v().func_177952_p() - 1) break;
                return true;
            }
            case EAST: {
                if (centerPainting.func_174877_v().func_177958_n() != otherPainting.func_174877_v().func_177958_n() + 1) break;
                return true;
            }
        }
        return false;
    }

    private boolean checkRightSidePainting(TileEntityPainting centerPainting, TileEntityPainting otherPainting) {
        switch (centerPainting.getAngle()) {
            case SOUTH: {
                if (centerPainting.func_174877_v().func_177952_p() != otherPainting.func_174877_v().func_177952_p() - 1) break;
                return true;
            }
            case WEST: {
                if (centerPainting.func_174877_v().func_177958_n() != otherPainting.func_174877_v().func_177958_n() + 1) break;
                return true;
            }
            case NORTH: {
                if (centerPainting.func_174877_v().func_177952_p() != otherPainting.func_174877_v().func_177952_p() + 1) break;
                return true;
            }
            case EAST: {
                if (centerPainting.func_174877_v().func_177958_n() != otherPainting.func_174877_v().func_177958_n() - 1) break;
                return true;
            }
        }
        return false;
    }

    private boolean connectTwoClocks(World world, TileEntity tile, EntityPlayer player) {
        if (this.tile1 == null || !(this.tile1 instanceof TileEntityClock)) {
            this.tile1 = tile;
            this.sendPacketToClient(sSelectedClock1, (EntityPlayerMP)player);
            return true;
        }
        if (this.tile2 == null || !(this.tile2 instanceof TileEntityClock)) {
            this.tile2 = tile;
            this.sendPacketToClient(sSelectedClock2, (EntityPlayerMP)player);
        }
        if (this.tile1 != null && this.tile1 instanceof TileEntityClock && this.tile2 != null && this.tile2 instanceof TileEntityClock) {
            if (this.tile1.func_174877_v().func_177956_o() == this.tile2.func_174877_v().func_177956_o() + 1) {
                TileEntityClock clockTop = (TileEntityClock)this.tile1;
                TileEntityClock clockBottom = (TileEntityClock)this.tile2;
                if (!this.configureClocks(clockTop, clockBottom)) {
                    this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
                }
                this.tile1 = null;
                this.tile2 = null;
                return true;
            }
            if (this.tile1.func_174877_v().func_177956_o() == this.tile2.func_174877_v().func_177956_o() - 1) {
                TileEntityClock clockTop = (TileEntityClock)this.tile2;
                TileEntityClock clockBottom = (TileEntityClock)this.tile1;
                if (!this.configureClocks(clockTop, clockBottom)) {
                    this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
                }
                this.tile1 = null;
                this.tile2 = null;
                return true;
            }
            this.sendPacketToClient(sFailed, (EntityPlayerMP)player);
            this.tile1 = null;
            this.tile2 = null;
        }
        return false;
    }

    public boolean configureClocks(TileEntityClock top, TileEntityClock bottom) {
        if (top.getVertPosition() == EnumVertPosition.WALL && bottom.getVertPosition() == EnumVertPosition.WALL && top.getShiftPosition() == bottom.getShiftPosition()) {
            top.setVertPosition(EnumVertPosition.CEILING);
            bottom.setVertPosition(EnumVertPosition.FLOOR);
            return true;
        }
        if (top.getVertPosition() == EnumVertPosition.CEILING && bottom.getVertPosition() == EnumVertPosition.FLOOR && top.getShiftPosition() == bottom.getShiftPosition()) {
            top.setVertPosition(EnumVertPosition.WALL);
            bottom.setVertPosition(EnumVertPosition.WALL);
            return true;
        }
        return false;
    }

    public void playSound(EntityPlayer player) {
        player.func_184185_a(CommonProxy.SOUND_ITEM_SCREWGUN, 0.7f, 1.0f);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (!(player.func_70093_af() || this.tile1 == null && this.tile2 == null)) {
            this.tile1 = null;
            this.tile2 = null;
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean removeTableCarpet(World world, TileEntity tile, BlockPos pos) {
        TileEntityTable tableTile = (TileEntityTable)world.func_175625_s(pos);
        if (tableTile != null) {
            Object nullPlayer = null;
            tableTile.removeStackFromInventoryFromWorld(2, null, (BiblioBlock)world.func_180495_p(pos).func_177230_c());
            return true;
        }
        return false;
    }

    private void dropCarpet(World world, BlockPos pos, int slot) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        TileEntityTable tableTile = (TileEntityTable)tileEntity;
        Object stuff = tableTile.isSlotFull() && slot == 0 ? inventory.func_70301_a(0) : (tableTile.isClothSlotFull() && slot == 1 ? inventory.func_70301_a(1) : (tableTile.isCarpetFull() && slot == 2 ? inventory.func_70301_a(2) : null));
        if (stuff != null && stuff.field_77994_a > 0) {
            float iAdjust = 0.0f;
            EntityItem entityItem = new EntityItem(world, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 1.4f), (double)((float)pos.func_177952_p() + 0.5f), new ItemStack(stuff.func_77973_b(), stuff.field_77994_a, stuff.func_77952_i()));
            if (stuff.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)stuff.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
            stuff.field_77994_a = 0;
        }
    }

    public boolean connectChairs(EntityPlayer player, World world, BlockPos pos) {
        if (player.func_70093_af()) {
            if (this.tile1 == null) {
                this.tile1 = world.func_175625_s(pos);
                if (this.tile1 != null) {
                    if (this.tile1 instanceof TileEntitySeat) {
                        this.sendPacketToClient(sSelectedSeat1, (EntityPlayerMP)player);
                        return true;
                    }
                    this.tile1 = null;
                    this.tile2 = null;
                    return false;
                }
            }
            if (this.tile1 != null && this.tile1 instanceof TileEntitySeat) {
                if (this.tile1.func_174877_v().func_177958_n() != pos.func_177958_n() || this.tile1.func_174877_v().func_177956_o() != pos.func_177956_o() || this.tile1.func_174877_v().func_177952_p() != pos.func_177952_p()) {
                    this.tile2 = world.func_175625_s(pos);
                    if (this.tile2 != null) {
                        if (this.tile2 instanceof TileEntitySeat) {
                            this.sendPacketToClient(sSelectedSeat2, (EntityPlayerMP)player);
                            int diffX = this.tile1.func_174877_v().func_177958_n() - this.tile2.func_174877_v().func_177958_n();
                            int diffY = this.tile1.func_174877_v().func_177956_o() - this.tile2.func_174877_v().func_177956_o();
                            int diffZ = this.tile1.func_174877_v().func_177952_p() - this.tile2.func_174877_v().func_177952_p();
                            this.setChairConnects((TileEntitySeat)this.tile1, (TileEntitySeat)this.tile2, diffX, diffY, diffZ);
                            this.tile1 = null;
                            this.tile2 = null;
                            return true;
                        }
                        this.tile1 = null;
                        this.tile2 = null;
                        return false;
                    }
                }
            } else {
                this.tile1 = null;
                this.tile2 = null;
            }
        }
        return false;
    }

    public void setChairConnects(TileEntitySeat seatTile1, TileEntitySeat seatTile2, int diffX, int diffY, int diffZ) {
        if (diffY != 0) {
            return;
        }
        if (diffX == 1 && diffZ == 0) {
            if (!seatTile1.getWestConnect()) {
                seatTile1.setWestConnect(true);
            } else {
                seatTile1.setWestConnect(false);
            }
            if (!seatTile2.getEastConnect()) {
                seatTile2.setEastConnect(true);
            } else {
                seatTile2.setEastConnect(false);
            }
        } else if (diffX == -1 && diffZ == 0) {
            if (!seatTile1.getEastConnect()) {
                seatTile1.setEastConnect(true);
            } else {
                seatTile1.setEastConnect(false);
            }
            if (!seatTile2.getWestConnect()) {
                seatTile2.setWestConnect(true);
            } else {
                seatTile2.setWestConnect(false);
            }
        } else if (diffZ == 1 && diffX == 0) {
            if (!seatTile1.getNorthConnect()) {
                seatTile1.setNorthConnect(true);
            } else {
                seatTile1.setNorthConnect(false);
            }
            if (!seatTile2.getSouthConnect()) {
                seatTile2.setSouthConnect(true);
            } else {
                seatTile2.setSouthConnect(false);
            }
        } else if (diffZ == -1 && diffX == 0) {
            if (!seatTile1.getSouthConnect()) {
                seatTile1.setSouthConnect(true);
            } else {
                seatTile1.setSouthConnect(false);
            }
            if (!seatTile2.getNorthConnect()) {
                seatTile2.setNorthConnect(true);
            } else {
                seatTile2.setNorthConnect(false);
            }
        }
    }

    public void setMode() {
        this.useMode = this.useMode >= 2 ? 0 : ++this.useMode;
    }

    private void sendPacketToClient(String displayString, EntityPlayerMP player) {
        ByteBuf buffer = Unpooled.buffer();
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)displayString);
        BiblioCraft.ch_BiblioDrillText.sendTo(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioDrillText"), player);
    }

    public void updateFromPacket(String displayString) {
        this.showText = true;
        this.showTextChanged = true;
        this.showTextString = displayString;
    }
}

