/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.helpers.ModelCache;
import jds.bibliocraft.states.TextureProperty;
import jds.bibliocraft.states.TextureState;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BiblioModelWood
implements IPerspectiveAwareModel {
    private IModel model = null;
    private IBakedModel baseModel;
    private String modelLocation = " ";
    private String textureLocation = "none";
    private String customTextureLocation = "none";
    private BiblioWoodBlock.EnumWoodType wood = BiblioWoodBlock.EnumWoodType.FRAME;
    private CustomItemOverrideList overrides = new CustomItemOverrideList();
    public IPerspectiveAwareModel wrapper;
    private ModelCache cache;
    private boolean gotOBJ = false;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(BiblioModelWood.this.getTextureLocation(location.toString(), BiblioModelWood.this.textureLocation));
        }
    };

    public BiblioModelWood(String modelLoc) {
        this.modelLocation = modelLoc;
        this.wrapper = this;
        this.cache = new ModelCache();
    }

    private void getModel(IBlockState state, boolean isBlock, int attempt) {
        if (this.model == null || this.model != null && !this.model.toString().contains("obj.OBJModel")) {
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(this.modelLocation));
                this.model = ((IModelCustomData)this.model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                this.gotOBJ = true;
            }
            catch (Exception e) {
                this.model = ModelLoaderRegistry.getMissingModel();
                this.gotOBJ = false;
                if (attempt < 6) {
                    this.getModel(state, isBlock, attempt + 1);
                    return;
                }
                System.out.println("Failed to load model. " + e);
            }
        }
        OBJModel.OBJState modelState = new OBJModel.OBJState(this.getDefaultVisiableModelParts(), true);
        if (state != null && state instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)state;
            if (exState.getUnlistedNames().contains(OBJModel.OBJProperty.INSTANCE)) {
                modelState = (OBJModel.OBJState)exState.getValue((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE);
            }
            if (exState.getUnlistedNames().contains((Object)TextureProperty.instance)) {
                TextureState texString = (TextureState)exState.getValue((IUnlistedProperty)TextureProperty.instance);
                this.loadAdditionalTextureStateStuff(texString);
                if (texString != null) {
                    this.customTextureLocation = texString.getTextureString();
                }
            }
            this.getAdditionalBlockStateStuff(exState);
            this.wood = (BiblioWoodBlock.EnumWoodType)((Object)state.func_177229_b((IProperty)BiblioWoodBlock.WOOD_TYPE));
        } else {
            this.loadAdditionalTextureStateStuff(null);
        }
        try {
            switch (this.wood) {
                case OAK: {
                    this.textureLocation = "minecraft:blocks/planks_oak";
                    break;
                }
                case SPRUCE: {
                    this.textureLocation = "minecraft:blocks/planks_spruce";
                    break;
                }
                case BIRCH: {
                    this.textureLocation = "minecraft:blocks/planks_birch";
                    break;
                }
                case JUNGLE: {
                    this.textureLocation = "minecraft:blocks/planks_jungle";
                    break;
                }
                case ACACIA: {
                    this.textureLocation = "minecraft:blocks/planks_acacia";
                    break;
                }
                case DARKOAK: {
                    this.textureLocation = "minecraft:blocks/planks_big_oak";
                    break;
                }
                case FRAME: {
                    if (this.customTextureLocation.contains("none") || this.customTextureLocation.contains("minecraft:white") || this.customTextureLocation.length() == 0) {
                        this.textureLocation = "bibliocraft:blocks/frame";
                        break;
                    }
                    this.textureLocation = this.customTextureLocation;
                    break;
                }
                default: {
                    this.textureLocation = "minecraft:blocks/planks_oak";
                    break;
                }
            }
        }
        catch (NullPointerException e) {
            System.out.println("Null pointer thrown on obtaining the texture " + e);
        }
        try {
            IBakedModel bakedModel;
            if (state != null && state instanceof IExtendedBlockState) {
                this.baseModel = bakedModel = this.model.bake((IModelState)modelState, DefaultVertexFormats.field_176599_b, this.textureGetter);
            } else if (this.cache.hasModel(this.textureLocation)) {
                this.baseModel = this.cache.getCurrentMatch();
            } else {
                bakedModel = this.model.bake((IModelState)modelState, DefaultVertexFormats.field_176599_b, this.textureGetter);
                if (this.gotOBJ) {
                    this.cache.addToCache(bakedModel, this.textureLocation);
                }
                this.baseModel = bakedModel;
            }
        }
        catch (NullPointerException e) {
            System.out.println("null pointer exception thrown in attempt bake model(s) " + e);
        }
    }

    public void loadAdditionalTextureStateStuff(TextureState state) {
    }

    public void getAdditionalBlockStateStuff(IExtendedBlockState state) {
    }

    public abstract String getTextureLocation(String var1, String var2);

    public List<String> getDefaultVisiableModelParts() {
        return Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"});
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
        switch (cameraTransformType) {
            case FIRST_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.1f, -0.1f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(0.65f, 0.65f, 0.65f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f));
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.1f, -0.1f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.65f, 0.65f, 0.65f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                transform = this.getTweakedLeftHandTransform(transform);
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: {
                transform = new TRSRTransformation(new Vector3f(-0.15f, 0.15f, -0.05f), new Quat4f(0.0f, -1.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                transform = new TRSRTransformation(new Vector3f(-0.15f, 0.15f, -0.05f), new Quat4f(0.0f, 0.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                transform = this.getTweakedLeftHandTransform(transform);
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(0.1f, -0.05f, 0.0f), new Quat4f(0.0f, -0.42f, 0.0f, 1.0f), new Vector3f(0.7f, 0.7f, 0.7f), new Quat4f(0.2f, -0.0f, -0.2f, 1.0f));
                transform = this.getTweakedGUITransform(transform);
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.15f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(0.45f, 0.45f, 0.45f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.1f, -0.2f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(0.7f, 0.7f, 0.7f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case NONE: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
            }
        }
        transform = this.getTweakedMasterTransform(transform);
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public TRSRTransformation getTweakedMasterTransform(TRSRTransformation transform) {
        return transform;
    }

    public TRSRTransformation getTweakedLeftHandTransform(TRSRTransformation transform) {
        return transform;
    }

    public TRSRTransformation getTweakedGUITransform(TRSRTransformation transform) {
        return transform;
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        this.getModel(state, true, 0);
        if (this.baseModel != null) {
            return this.baseModel.func_188616_a(state, side, rand);
        }
        ArrayList<BakedQuad> blankList = new ArrayList<BakedQuad>();
        return blankList;
    }

    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private void setCustomTextureString(String input) {
        this.customTextureLocation = input;
    }

    private class CustomItemOverrideList
    extends ItemOverrideList {
        private CustomItemOverrideList() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            NBTTagCompound tags;
            BiblioModelWood.this.wood = BiblioWoodBlock.EnumWoodType.getEnum(stack.func_77952_i());
            BiblioModelWood.this.customTextureLocation = "none";
            if (stack != null && (tags = stack.func_77978_p()) != null && tags.func_74764_b("renderTexture")) {
                BiblioModelWood.this.customTextureLocation = tags.func_74779_i("renderTexture");
            }
            BiblioModelWood.this.getModel(null, false, 0);
            return BiblioModelWood.this.wrapper;
        }
    }
}

