/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.tileentities;

import jds.bibliocraft.Config;
import jds.bibliocraft.helpers.FileUtil;
import jds.bibliocraft.items.ItemAtlas;
import jds.bibliocraft.items.ItemAtlasPlate;
import jds.bibliocraft.items.ItemBigBook;
import jds.bibliocraft.items.ItemEnchantedPlate;
import jds.bibliocraft.items.ItemPlate;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.items.ItemStockroomCatalog;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityPrintPress
extends BiblioTileEntity
implements ITickable,
ISidedInventory {
    public int furnaceCookTime = 0;
    public int furnaceBurnTime = 0;
    public int currentItemBurnTime = 0;
    public boolean animate = false;
    private boolean bed = false;
    private boolean arm = true;
    public float armAngle = -5.0f;
    public float bedAngle = 0.0f;
    public float prevArmAngle = -5.0f;
    private float armspeed = 10.0f;
    private float bedspeed = 3.0f;
    private boolean showPlateText = false;
    private boolean showInkText = false;
    private boolean showEmptyBookText = false;
    private boolean showNewBookText = false;

    public TileEntityPrintPress() {
        super(4, false);
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public void setShowPlateText(boolean show) {
        this.showPlateText = show;
    }

    public void setShowInkText(boolean show) {
        this.showInkText = show;
    }

    public void setShowEmptyBookText(boolean show) {
        this.showEmptyBookText = show;
    }

    public void setShowNewBookText(boolean show) {
        this.showNewBookText = show;
    }

    public boolean getShowPlateText() {
        return this.showPlateText;
    }

    public boolean getShowInkText() {
        return this.showInkText;
    }

    public boolean getShowEmptyBookText() {
        return this.showEmptyBookText;
    }

    public boolean getShowNewBookText() {
        return this.showNewBookText;
    }

    public boolean hasPlate() {
        Item isplate;
        ItemStack stack = this.func_70301_a(1);
        return stack != null && ((isplate = stack.func_77973_b()) instanceof ItemPlate || isplate instanceof ItemEnchantedPlate || isplate instanceof ItemAtlasPlate);
    }

    public boolean hasEnchantedPlate() {
        Item isplate;
        ItemStack stack = this.func_70301_a(1);
        if (stack != null && (isplate = stack.func_77973_b()) instanceof ItemEnchantedPlate) {
            NBTTagList taglist = this.getEnchantmentTagList(stack);
            int tagscount = 0;
            if (taglist != null && (tagscount = taglist.func_74745_c()) > 0) {
                return true;
            }
        }
        return false;
    }

    public boolean hasAtlasPlate() {
        Item test;
        ItemStack stack = this.func_70301_a(1);
        return stack != null && (test = stack.func_77973_b()) instanceof ItemAtlasPlate;
    }

    public boolean hasAtlasInput() {
        Item test;
        ItemStack stack = this.func_70301_a(2);
        return stack != null && (test = stack.func_77973_b()) instanceof ItemAtlas;
    }

    public String plateName() {
        String bookname = "";
        if (this.hasPlate()) {
            ItemStack stack = this.func_70301_a(1);
            NBTTagCompound tag = stack.func_77978_p();
            if (tag != null) {
                bookname = tag.func_74779_i("bookName");
            }
            if (this.hasEnchantedPlate()) {
                NBTTagList taglist = this.getEnchantmentTagList(stack);
                int tagscount = 0;
                if (taglist != null) {
                    tagscount = taglist.func_74745_c();
                }
                if (tagscount > 0) {
                    short id = taglist.func_150305_b(0).func_74765_d("id");
                    short lvl = taglist.func_150305_b(0).func_74765_d("lvl");
                    bookname = Enchantment.func_185262_c((int)id) != null ? Enchantment.func_185262_c((int)id).func_77316_c((int)lvl) : "Unregistered";
                }
            }
            if (this.hasAtlasPlate()) {
                bookname = "Atlas Copy";
            }
        } else {
            bookname = "none";
        }
        return bookname;
    }

    public NBTTagList getEnchantmentTagList(ItemStack stack) {
        return stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("StoredEnchantments") ? (NBTTagList)stack.func_77978_p().func_74781_a("StoredEnchantments") : new NBTTagList();
    }

    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.furnaceBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    public void func_73660_a() {
        boolean burnCheck = this.furnaceBurnTime > 0;
        boolean isDirty = false;
        if (this.furnaceBurnTime > 0) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityPrintPress.getItemBurnTime(this.inventory[0]);
                if (this.furnaceBurnTime > 0) {
                    isDirty = true;
                    if (this.inventory[0] != null) {
                        this.setPressAnimation(true);
                        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                        --this.inventory[0].field_77994_a;
                        if (this.inventory[0].field_77994_a == 0) {
                            this.inventory[0] = this.inventory[0].func_77973_b().getContainerItem(this.inventory[0]);
                            this.func_70299_a(0, null);
                        }
                    }
                }
            }
            if (this.isBurning() && this.canSmelt()) {
                ++this.furnaceCookTime;
                if (this.furnaceCookTime == 200) {
                    this.furnaceCookTime = 0;
                    this.smeltItem();
                    this.setPressAnimation(false);
                    isDirty = true;
                }
            } else {
                this.furnaceCookTime = 0;
            }
            if (burnCheck != this.furnaceBurnTime > 0) {
                isDirty = true;
            }
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.animate) {
                if (this.armAngle <= this.prevArmAngle && this.armAngle > -115.0f) {
                    this.prevArmAngle = this.armAngle;
                    this.armAngle -= this.armspeed;
                    if (this.bedAngle >= 0.0f) {
                        this.bedAngle -= this.bedspeed;
                    }
                } else {
                    this.prevArmAngle = this.armAngle;
                    this.armAngle += this.armspeed;
                    this.bedAngle += this.bedspeed;
                }
                if (this.armAngle == -5.0f && this.prevArmAngle == -5.0f - this.armspeed) {
                    this.prevArmAngle = this.armAngle;
                }
            } else {
                if (this.bedAngle > 0.0f) {
                    this.bedAngle -= this.bedspeed;
                }
                if (this.armAngle < -5.0f) {
                    this.armAngle += this.armspeed;
                }
            }
        }
        if (isDirty) {
            this.func_70296_d();
        }
    }

    private boolean canSmelt() {
        if (this.inventory[3] == null && this.hasPlate() && this.inventory[2] != null) {
            return (!this.hasAtlasPlate() || this.hasAtlasInput()) && (!this.hasAtlasInput() || this.hasAtlasPlate());
        }
        return false;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            FileUtil util = new FileUtil();
            int booknum = util.getBookNumber(this.field_145850_b, this.plateName());
            if (booknum == -1 && !this.hasEnchantedPlate() && !this.hasAtlasPlate()) {
                System.out.println("This is not a valid book name!");
                this.setPressAnimation(false);
                this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
                return;
            }
            ItemStack newstack = null;
            if (booknum == -1 && this.hasEnchantedPlate()) {
                ItemStack plate = this.func_70301_a(1);
                if (plate.func_77942_o()) {
                    ItemStack blankenchbook = new ItemStack((Item)Items.field_151134_bR, 1, 0);
                    blankenchbook.func_77982_d((NBTTagCompound)plate.func_77978_p().func_74737_b());
                    newstack = blankenchbook.func_77946_l();
                    int damage = plate.func_77952_i();
                    plate.func_77964_b(damage + 1);
                    if (plate.func_77952_i() > Config.enchPlateMaxUses - 1) {
                        this.func_70299_a(1, null);
                    }
                } else {
                    return;
                }
            }
            if (booknum == -1 && this.hasAtlasPlate()) {
                newstack = this.inventory[2].func_77946_l();
                newstack.func_77982_d(this.inventory[1].func_77978_p());
                this.inventory[1] = null;
            }
            if (booknum != -1) {
                ItemStack blankbook;
                int checkBookType = util.getBookType(this.field_145850_b, booknum);
                if (checkBookType == 0) {
                    blankbook = new ItemStack((Item)ItemBigBook.instance, 1, 0);
                    newstack = util.loadBookNBT(this.field_145850_b, blankbook, booknum);
                } else if (checkBookType == 1) {
                    blankbook = new ItemStack((Item)ItemRecipeBook.instance, 1, 0);
                    newstack = util.loadBookNBT(this.field_145850_b, blankbook, booknum);
                } else if (checkBookType == 2) {
                    blankbook = new ItemStack((Item)ItemStockroomCatalog.instance, 1, 0);
                    newstack = util.loadBookNBT(this.field_145850_b, blankbook, booknum);
                } else {
                    blankbook = new ItemStack(Items.field_151122_aG, 1, 0);
                    newstack = util.loadBook(this.field_145850_b, blankbook, booknum);
                }
            }
            if (this.inventory[3] == null) {
                this.inventory[3] = newstack.func_77946_l();
            }
            --this.inventory[2].field_77994_a;
            if (this.inventory[2].field_77994_a <= 0) {
                this.inventory[2] = null;
            }
            this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
        }
    }

    public static int getItemBurnTime(ItemStack par0ItemStack) {
        if (par0ItemStack == null) {
            return 0;
        }
        Item var2 = par0ItemStack.func_77973_b();
        if (var2 instanceof ItemDye) {
            return 200;
        }
        return 0;
    }

    public void setPressAnimation(boolean ison) {
        this.animate = ison;
        this.prevArmAngle = -5.0f;
        this.armAngle = -5.0f;
        this.bedAngle = 0.0f;
        this.func_145831_w().func_184138_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()), this.func_145831_w().func_180495_p(this.func_174877_v()), 3);
    }

    public boolean getPressAntimation() {
        return this.animate;
    }

    public boolean isInk(ItemStack stack) {
        boolean output = false;
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        if (oreIDs.length > 0) {
            for (int i = 0; i < oreIDs.length; ++i) {
                String oreName = OreDictionary.getOreName((int)oreIDs[i]);
                if (!oreName.equals("dyeBlack")) continue;
                output = true;
            }
        }
        return output;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        if (itemstack != null) {
            int metacheck;
            Item stackitem = itemstack.func_77973_b();
            if (slot == 0 && this.isInk(itemstack) && (metacheck = itemstack.func_77952_i()) == 0) {
                return true;
            }
            if (slot == 1 && stackitem instanceof ItemPlate) {
                return true;
            }
            if (slot == 2 && stackitem instanceof ItemBook) {
                return true;
            }
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            int[] sides = new int[]{3};
            return sides;
        }
        int[] sides = new int[]{0, 1, 2};
        return sides;
    }

    public boolean func_180462_a(int slot, ItemStack itemstack, EnumFacing side) {
        if (side != EnumFacing.DOWN && itemstack != null) {
            Item stackItem = itemstack.func_77973_b();
            if (stackItem instanceof ItemDye && itemstack.func_77952_i() == 0 && slot == 0) {
                return true;
            }
            if (stackItem instanceof ItemBook && slot == 2) {
                return true;
            }
            if ((stackItem instanceof ItemPlate || stackItem instanceof ItemEnchantedPlate) && slot == 1) {
                return true;
            }
        }
        return false;
    }

    public boolean func_180461_b(int slot, ItemStack itemstack, EnumFacing side) {
        return side == EnumFacing.DOWN && slot == 3;
    }

    public String func_70005_c_() {
        return "PrintingPress";
    }

    @Override
    public void setInventorySlotContentsAdditionalCommands(int slot, ItemStack stack) {
        if (slot >= 0 && slot <= 2 && stack == null && this.animate) {
            this.setPressAnimation(false);
        }
    }

    @Override
    public void loadCustomNBTData(NBTTagCompound nbt) {
        boolean prevAnimationState = this.animate;
        this.furnaceBurnTime = nbt.func_74765_d("BurnTime");
        this.furnaceCookTime = nbt.func_74765_d("CookTime");
        this.currentItemBurnTime = TileEntityPrintPress.getItemBurnTime(this.inventory[0]);
        this.animate = nbt.func_74767_n("animate");
        if (this.animate != prevAnimationState) {
            this.prevArmAngle = -5.0f;
            this.armAngle = -5.0f;
            this.bedAngle = 0.0f;
        }
    }

    @Override
    public NBTTagCompound writeCustomNBTData(NBTTagCompound nbt) {
        nbt.func_74777_a("BurnTime", (short)this.furnaceBurnTime);
        nbt.func_74777_a("CookTime", (short)this.furnaceCookTime);
        nbt.func_74757_a("animate", this.animate);
        return nbt;
    }

    public ITextComponent func_145748_c_() {
        TextComponentString chat = new TextComponentString(this.func_70005_c_());
        return chat;
    }
}

