/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityArmorStand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class BlockArmorStand
extends BiblioWoodBlock {
    public static final BlockArmorStand instance = new BlockArmorStand();
    public static final String name = "ArmorStand";

    public BlockArmorStand() {
        super(name, false);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te != null && te instanceof TileEntityArmorStand) {
            Item stackItem;
            boolean isPoweredBottom;
            boolean isPowerTop;
            TileEntityArmorStand tile = (TileEntityArmorStand)te;
            ItemStack playerhand = player.func_184586_b(EnumHand.MAIN_HAND);
            int yCheck = (int)(hitY * 2.0f);
            if (!tile.getIsBottomStand()) {
                tile = (TileEntityArmorStand)world.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
                if (tile == null) {
                    return false;
                }
                isPowerTop = world.func_175687_A(pos) > 0;
                isPoweredBottom = world.func_175687_A(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p())) > 0;
                yCheck += 2;
            } else {
                isPoweredBottom = world.func_175687_A(pos) > 0;
                boolean bl = isPowerTop = world.func_175687_A(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p())) > 0;
            }
            if (player.func_70093_af()) {
                if (isPoweredBottom || isPowerTop) {
                    this.handleArmorTransation(player, tile, 0);
                    this.handleArmorTransation(player, tile, 1);
                    this.handleArmorTransation(player, tile, 2);
                    this.handleArmorTransation(player, tile, 3);
                    return true;
                }
                if (yCheck >= 0 && yCheck <= 3) {
                    this.handleArmorTransation(player, tile, yCheck);
                }
                return true;
            }
            if (playerhand != ItemStack.field_190927_a && (stackItem = playerhand.func_77973_b()) instanceof ItemArmor) {
                ItemArmor armorItem = (ItemArmor)stackItem;
                EntityEquipmentSlot armorType = armorItem.field_77881_a;
                if ((yCheck == 0 && armorType == EntityEquipmentSlot.FEET || yCheck == 1 && armorType == EntityEquipmentSlot.LEGS || yCheck == 2 && armorType == EntityEquipmentSlot.CHEST || yCheck == 3 && armorType == EntityEquipmentSlot.HEAD) && tile.addArmor(playerhand, armorType)) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    return true;
                }
            }
            player.openGui((Object)BiblioCraft.instance, 1, world, tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p());
        }
        return true;
    }

    private void handleArmorTransation(EntityPlayer player, TileEntityArmorStand armorTile, int armortype) {
        ItemStack playerArmor = (ItemStack)player.field_71071_by.field_70460_b.get(armortype);
        int atilearmor = -1;
        switch (armortype) {
            case 0: {
                atilearmor = 3;
                break;
            }
            case 1: {
                atilearmor = 2;
                break;
            }
            case 2: {
                atilearmor = 1;
                break;
            }
            case 3: {
                atilearmor = 0;
                break;
            }
        }
        if (atilearmor != -1 && armortype >= 0 && armortype < 4) {
            ItemStack standArmor = armorTile.func_70301_a(atilearmor);
            if (standArmor != ItemStack.field_190927_a) {
                player.field_71071_by.field_70460_b.set(armortype, (Object)standArmor);
            } else {
                player.field_71071_by.field_70460_b.set(armortype, (Object)ItemStack.field_190927_a);
            }
            if (playerArmor != ItemStack.field_190927_a) {
                armorTile.func_70299_a(atilearmor, playerArmor);
            } else {
                armorTile.func_70299_a(atilearmor, ItemStack.field_190927_a);
            }
        }
    }

    private void sendPlayerArmorPacket(EntityPlayer player, ItemStack armor, int armorslot) {
        ByteBuf buffer = Unpooled.buffer();
        try {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)armor);
            buffer.writeInt(armorslot);
            BiblioCraft.ch_BiblioAStand.sendTo(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioAStand"), (EntityPlayerMP)player);
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityArmorStand();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        TileEntityArmorStand te;
        ArrayList<String> modelParts = new ArrayList<String>();
        if (tile != null && tile instanceof TileEntityArmorStand && (te = (TileEntityArmorStand)tile).getIsBottomStand()) {
            modelParts.add("bottomStand");
            modelParts.add("topStand");
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity tile, EntityLivingBase player) {
        IBlockState state = tile.func_145831_w().func_180495_p(tile.func_174877_v());
        BlockPos pos = new BlockPos(tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o() + 1, tile.func_174877_v().func_177952_p());
        tile.func_145831_w().func_175656_a(pos, state);
        TileEntity te = tile.func_145831_w().func_175625_s(pos);
        if (te != null && te instanceof TileEntityArmorStand) {
            TileEntityArmorStand stand = (TileEntityArmorStand)te;
            stand.setCustomTexureString(tile.getCustomTextureString());
            stand.setIsBottomStand(false);
            stand.setAngle(tile.getAngle());
        }
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
        return transform;
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return world.func_175623_d(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity t = world.func_175625_s(pos);
        if (t != null && t instanceof TileEntityArmorStand) {
            BlockPos newPos;
            TileEntityArmorStand tile = (TileEntityArmorStand)t;
            if (tile.getIsBottomStand()) {
                newPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            } else {
                newPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
                BiblioTileEntity top = (BiblioTileEntity)t;
                BiblioTileEntity bottom = (BiblioTileEntity)world.func_175625_s(newPos);
                top.setCustomTexureString(bottom.getCustomTextureString());
            }
            TileEntity sTile = world.func_175625_s(newPos);
            if (sTile != null && sTile instanceof TileEntityArmorStand) {
                this.dropItems(world, newPos);
                world.func_175698_g(newPos);
            }
        }
        this.dropItems(world, pos);
        super.func_180663_b(world, pos, state);
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        AxisAlignedBB output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile != null && tile instanceof BiblioTileEntity) {
            BiblioTileEntity caseTile = (BiblioTileEntity)tile;
            output = caseTile.getAngle() == EnumFacing.SOUTH || caseTile.getAngle() == EnumFacing.NORTH ? this.getBlockBounds(0.3f, 0.0f, 0.0f, 0.7f, 1.0f, 1.0f) : this.getBlockBounds(0.0f, 0.0f, 0.3f, 1.0f, 1.0f, 0.7f);
        }
        return output;
    }
}

