/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.events;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.items.ItemAtlas;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderAtlasFace {
    private IBakedModel[] pinModels;
    private IBakedModel atlasModel;
    private Tessellator tessellator;
    private VertexBuffer worldRenderer;
    private int color = 0;
    private boolean init = false;
    private ResourceLocation modelLocation = new ResourceLocation("bibliocraft:item/atlascover.obj");
    private static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");
    protected Function<ResourceLocation, TextureAtlasSprite> getModelTexture = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(RenderAtlasFace.this.getColorTexture(RenderAtlasFace.this.color));
        }
    };

    @SubscribeEvent
    public void renderItem(RenderSpecificHandEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        boolean is1stperson = mc.field_71474_y.field_74320_O == 0;
        ItemStack stack = mc.field_71439_g.func_184586_b(event.getHand());
        if (Config.enableAtlas && stack.func_77973_b() == ItemAtlas.instance && is1stperson) {
            if (!this.init) {
                this.initVariables(event);
                this.init = true;
            }
            boolean isSmallLeft = false;
            boolean isSmallRight = false;
            if (event.getHand() == EnumHand.OFF_HAND) {
                isSmallLeft = true;
            }
            if (event.getHand() == EnumHand.MAIN_HAND && mc.field_71439_g.func_184586_b(EnumHand.OFF_HAND) != ItemStack.field_190927_a) {
                isSmallRight = true;
            }
            float swing = event.getSwingProgress();
            float equip = event.getEquipProgress();
            float mapPitch = this.getMapAngleFromPitch(event.getInterpolatedPitch());
            this.draw(this.atlasModel, mapPitch, swing, equip, isSmallLeft, isSmallRight, 0.0, 0.0, stack, true, CommonProxy.ATLASCOVER);
            this.renderPins(stack, mapPitch, swing, equip, isSmallLeft, isSmallRight);
        }
    }

    private void initVariables(RenderSpecificHandEvent event) {
        if (this.tessellator == null || this.worldRenderer == null) {
            this.tessellator = Tessellator.func_178181_a();
            this.worldRenderer = this.tessellator.func_178180_c();
        }
        this.pinModels = new IBakedModel[16];
        ArrayList<String> pinString = new ArrayList<String>();
        pinString.add("pin");
        for (int i = 0; i < 16; ++i) {
            this.color = i;
            this.pinModels[i] = this.initModel(pinString);
        }
        ArrayList<String> atlasString = new ArrayList<String>();
        atlasString.add("atlascover");
        this.color = 16;
        this.atlasModel = this.initModel(atlasString);
    }

    private void renderMapFirstPerson(ItemStack stack) {
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemMap) {
            Minecraft mc = Minecraft.func_71410_x();
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            mc.func_110434_K().func_110577_a(RES_MAP_BACKGROUND);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer vertexbuffer = tessellator.func_178180_c();
            GlStateManager.func_179152_a((float)0.0078125f, (float)0.0078125f, (float)0.0078125f);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_181662_b(-7.0, 135.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(135.0, 135.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
            vertexbuffer.func_181662_b(135.0, -7.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
            vertexbuffer.func_181662_b(-7.0, -7.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            MapData mapdata = Items.field_151098_aY.func_77873_a(stack, (World)mc.field_71441_e);
            if (mapdata != null) {
                mc.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
            }
            GlStateManager.func_179145_e();
        }
    }

    private void draw(IBakedModel model, float pitch, float swing, float equip, boolean smallLeft, boolean smallRight, double pinx, double piny, ItemStack stack, boolean withMap, ResourceLocation texture) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179140_f();
        if (smallLeft || smallRight) {
            pitch = 0.0f;
        }
        float f = MathHelper.func_76129_c((float)swing);
        float f1 = -0.2f * MathHelper.func_76126_a((float)(swing * (float)Math.PI));
        float f2 = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179109_b((float)0.0f, (float)(-f1 / 2.0f), (float)f2);
        GlStateManager.func_179109_b((float)0.0f, (float)(0.04f + equip * -1.2f + pitch * -0.5f), (float)-0.72f);
        GlStateManager.func_179114_b((float)(pitch * -85.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.38, (double)0.38, (double)-0.019999999999999907);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)-1.0f, (float)0.0f);
        if (smallLeft || smallRight) {
            double scaler = 0.489;
            GlStateManager.func_179139_a((double)scaler, (double)scaler, (double)scaler);
            if (smallRight) {
                GlStateManager.func_179137_b((double)0.0, (double)-0.885, (double)-0.865);
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)-0.885, (double)1.66);
            }
        }
        GlStateManager.func_179139_a((double)0.76, (double)0.76, (double)0.76);
        GlStateManager.func_179137_b((double)0.0, (double)piny, (double)pinx);
        TextureManager textureManager = Minecraft.func_71410_x().func_110434_K();
        Minecraft.func_71410_x().func_147117_R();
        textureManager.func_110577_a(TextureMap.field_110575_b);
        this.worldRenderer.func_181668_a(7, Attributes.DEFAULT_BAKED_FORMAT);
        for (BakedQuad quad : model.func_188616_a(null, null, 0L)) {
            LightUtil.renderQuadColor((VertexBuffer)this.worldRenderer, (BakedQuad)quad, (int)-1);
        }
        this.tessellator.func_78381_a();
        GlStateManager.func_179145_e();
        GlStateManager.func_179121_F();
    }

    private void renderPins(ItemStack stack, float pitch, float swing, float equip, boolean isSmallLeft, boolean isSmallRight) {
        ItemStack map = this.getAtlasCurrentMap(stack);
        NBTTagCompound tags = stack.func_77978_p();
        if (map.func_77973_b() == Items.field_151098_aY && tags != null && tags.func_74764_b("maps")) {
            NBTTagList mapList = tags.func_150295_c("maps", 10);
            for (int i = 0; i < mapList.func_74745_c(); ++i) {
                NBTTagCompound mapTag = mapList.func_150305_b(i);
                if (!mapTag.func_74764_b("mapName") || !mapTag.func_74779_i("mapName").contentEquals("Map_" + map.func_77952_i()) || !mapTag.func_74764_b("xMapWaypoints") || !mapTag.func_74764_b("yMapWaypoints") || !mapTag.func_74764_b("MapWaypointColors")) continue;
                NBTTagList mapXPins = mapTag.func_150295_c("xMapWaypoints", 5);
                NBTTagList mapYPins = mapTag.func_150295_c("yMapWaypoints", 5);
                NBTTagList mapPinColors = mapTag.func_150295_c("MapWaypointColors", 5);
                float x = 0.0f;
                float y = 0.0f;
                float color = 0.0f;
                for (int n = 0; n < mapXPins.func_74745_c(); ++n) {
                    x = mapXPins.func_150308_e(n);
                    y = mapYPins.func_150308_e(n);
                    color = mapPinColors.func_150308_e(n);
                    this.draw(this.pinModels[(int)color], pitch, swing, equip, isSmallLeft, isSmallRight, 1.0 - (double)x, 1.0 - (double)y, stack, false, this.getColorResource((int)color));
                }
            }
        }
    }

    private ItemStack getAtlasCurrentMap(ItemStack stack) {
        int mapSlot;
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null && (mapSlot = tags.func_74762_e("mapSlot")) >= 0) {
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", false, 216);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = new ItemStack(tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            ItemStack invStack = atlasInventory.func_70301_a(mapSlot);
            return invStack;
        }
        return ItemStack.field_190927_a;
    }

    private IBakedModel initModel(List<String> parts) {
        IModel model = null;
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)this.modelLocation);
            model = ((IModelCustomData)model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        }
        catch (Exception e) {
            System.out.println("model failed to load");
            model = ModelLoaderRegistry.getMissingModel();
        }
        OBJModel.OBJState state = new OBJModel.OBJState(parts, true);
        return model.bake((IModelState)state, Attributes.DEFAULT_BAKED_FORMAT, this.getModelTexture);
    }

    private String getColorTexture(int color) {
        switch (color) {
            case 0: {
                return "minecraft:blocks/wool_colored_black";
            }
            case 1: {
                return "minecraft:blocks/wool_colored_red";
            }
            case 2: {
                return "minecraft:blocks/wool_colored_green";
            }
            case 3: {
                return "minecraft:blocks/wool_colored_lime";
            }
            case 4: {
                return "minecraft:blocks/wool_colored_brown";
            }
            case 5: {
                return "minecraft:blocks/wool_colored_blue";
            }
            case 6: {
                return "minecraft:blocks/wool_colored_cyan";
            }
            case 7: {
                return "minecraft:blocks/wool_colored_light_blue";
            }
            case 8: {
                return "minecraft:blocks/wool_colored_purple";
            }
            case 9: {
                return "minecraft:blocks/wool_colored_magenta";
            }
            case 10: {
                return "minecraft:blocks/wool_colored_pink";
            }
            case 11: {
                return "minecraft:blocks/wool_colored_yellow";
            }
            case 12: {
                return "minecraft:blocks/wool_colored_orange";
            }
            case 13: {
                return "minecraft:blocks/wool_colored_gray";
            }
            case 14: {
                return "minecraft:blocks/wool_colored_silver";
            }
            case 15: {
                return "minecraft:blocks/wool_colored_white";
            }
            case 16: {
                return "bibliocraft:gui/atlas_cover";
            }
            case 17: {
                return "bibliocraft:gui/atlas_cover";
            }
        }
        return "minecraft:blocks/wool_colored_white";
    }

    public ResourceLocation getColorResource(int color) {
        switch (color) {
            case 0: {
                return CommonProxy.BLACKWOOL;
            }
            case 1: {
                return CommonProxy.REDWOOL;
            }
            case 2: {
                return CommonProxy.GREENWOOL;
            }
            case 3: {
                return CommonProxy.LIMEWOOL;
            }
            case 4: {
                return CommonProxy.BROWNWOOL;
            }
            case 5: {
                return CommonProxy.BLUEWOOL;
            }
            case 6: {
                return CommonProxy.CYANWOOL;
            }
            case 7: {
                return CommonProxy.LBLUEWOOL;
            }
            case 8: {
                return CommonProxy.PURPLEWOOL;
            }
            case 9: {
                return CommonProxy.MAGENTAWOOL;
            }
            case 10: {
                return CommonProxy.PINKWOOL;
            }
            case 11: {
                return CommonProxy.YELOOWWOOL;
            }
            case 12: {
                return CommonProxy.ORANGEWOOL;
            }
            case 13: {
                return CommonProxy.GRAYWOOL;
            }
            case 14: {
                return CommonProxy.LGRAYWOOL;
            }
            case 15: {
                return CommonProxy.WHITEWOOL;
            }
        }
        return CommonProxy.REDWOOL;
    }

    private float getMapAngleFromPitch(float pitch) {
        float f = 1.0f - pitch / 45.0f + 0.1f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        f = -MathHelper.func_76134_b((float)(f * (float)Math.PI)) * 0.5f + 0.5f;
        return f;
    }
}

