/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.gui;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.containers.ContainerAtlas;
import jds.bibliocraft.gui.GuiButtonAddSubtract;
import jds.bibliocraft.gui.GuiButtonAtlasControls;
import jds.bibliocraft.items.ItemAtlas;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiAtlas
extends GuiContainer {
    private static int guiWidth = 256;
    private static int guiHeight = 241;
    private ItemStack atlasStack;
    private ItemStack selectedMapStack = ItemStack.field_190927_a;
    private GuiButtonAddSubtract bzoomPos;
    private GuiButtonAddSubtract bzoomNeg;
    private GuiButton btoggleAutoCenter;
    private GuiButton btoggleAutoCreate;
    private GuiButtonAtlasControls bAtlasMode;
    private GuiButtonAtlasControls bInventoryMode;
    private boolean autoCenter = false;
    private boolean autoCreate = false;
    private int zoomLevel = 0;
    private int selectedSlot = -1;
    private int hoveredSlot = -1;
    private int mapX = 0;
    private int mapZ = 0;
    private int mapZoom = 0;
    private boolean changeGui = false;
    private int slotMapNorth = -1;
    private int slotMapSouth = -1;
    private int slotMapEast = -1;
    private int slotMapWest = -1;
    private World world;
    private EntityPlayer player;
    private ContainerAtlas container;

    public GuiAtlas(InventoryPlayer inventoryPlayer, World worldy, EntityPlayer playa) {
        super((Container)new ContainerAtlas(inventoryPlayer, worldy));
        this.world = worldy;
        this.field_146999_f = guiWidth;
        this.field_147000_g = guiHeight;
        this.atlasStack = inventoryPlayer.func_70448_g();
        this.player = playa;
        NBTTagCompound tags = this.atlasStack.func_77978_p();
        if (tags != null) {
            this.selectedSlot = tags.func_74762_e("mapSlot");
            this.autoCenter = tags.func_74767_n("autoCenter");
            this.autoCreate = tags.func_74767_n("autoCreate");
            this.zoomLevel = tags.func_74762_e("zoomLevel");
            this.setSelectedSlot(this.selectedSlot);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int w = (this.field_146294_l - guiWidth) / 2;
        int h = (this.field_146295_m - guiHeight) / 2;
        this.field_146292_n.clear();
        this.btoggleAutoCenter = new GuiButton(1, w + 85, h + 45, 30, 20, this.autoCenter ? I18n.func_74838_a((String)"gui.atlas.yes") : I18n.func_74838_a((String)"gui.atlas.no"));
        this.field_146292_n.add(this.btoggleAutoCenter);
        this.btoggleAutoCreate = new GuiButton(2, w + 85, h + 70, 30, 20, this.autoCreate ? I18n.func_74838_a((String)"gui.atlas.yes") : I18n.func_74838_a((String)"gui.atlas.no"));
        this.field_146292_n.add(this.btoggleAutoCreate);
        this.bzoomNeg = new GuiButtonAddSubtract(3, w + 65, h + 25, 1, 1.0f);
        this.field_146292_n.add(this.bzoomNeg);
        this.bzoomPos = new GuiButtonAddSubtract(4, w + 100, h + 25, 0, 1.0f);
        this.field_146292_n.add(this.bzoomPos);
        this.bAtlasMode = new GuiButtonAtlasControls(10, w + 216, h + 157, 5);
        this.field_146292_n.add(this.bAtlasMode);
        this.bInventoryMode = new GuiButtonAtlasControls(11, w + 216, h + 177, 6);
        this.field_146292_n.add(this.bInventoryMode);
        this.bInventoryMode.mouseMode = 11;
    }

    protected void func_146284_a(GuiButton click) {
        switch (click.field_146127_k) {
            case 0: {
                break;
            }
            case 1: {
                boolean bl = this.autoCenter = !this.autoCenter;
                if (!this.autoCenter) {
                    this.autoCreate = false;
                }
                this.func_73866_w_();
                break;
            }
            case 2: {
                boolean bl = this.autoCreate = !this.autoCreate;
                if (this.autoCreate) {
                    this.autoCenter = true;
                }
                this.func_73866_w_();
                break;
            }
            case 3: {
                if (this.zoomLevel <= 0) break;
                this.bzoomNeg.pressed = true;
                --this.zoomLevel;
                break;
            }
            case 4: {
                if (this.zoomLevel >= 4) break;
                this.bzoomPos.pressed = true;
                ++this.zoomLevel;
                break;
            }
            case 10: {
                this.changeGui = true;
                this.sendUpdatePacket();
            }
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        if (!this.changeGui) {
            this.sendUpdatePacket();
        }
    }

    public void sendUpdatePacket() {
        ByteBuf buffer = Unpooled.buffer();
        buffer.writeBoolean(this.autoCenter);
        buffer.writeBoolean(this.autoCreate);
        buffer.writeInt(this.zoomLevel);
        buffer.writeInt(this.selectedSlot);
        buffer.writeBoolean(this.changeGui);
        BiblioCraft.ch_BiblioAtlas.sendToServer(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioAtlas"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void func_73864_a(int mousex, int mousey, int click) {
        int w = (this.field_146294_l - guiWidth) / 2;
        int h = (this.field_146295_m - guiHeight) / 2;
        if (click != 2) {
            if (this.func_146271_m()) {
            } else {
                int heldSlot = this.player.field_71071_by.field_70461_c;
                if (mousex >= w + 47 + heldSlot * 18 && mousex <= w + 49 + (heldSlot + 1) * 18 && mousey >= h + 216 && mousey <= h + 218 + 18) {
                    return;
                }
                try {
                    super.func_73864_a(mousex, mousey, click);
                    return;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
        }
        int i = 0;
        while (i < 7) {
            for (int j = 0; j < 6; ++j) {
                if (mousex < w + 138 + j * 18 || mousex >= w + 138 + 18 + j * 18 || mousey < h + 15 + i * 18 || mousey >= h + 15 + 18 + i * 18) continue;
                this.selectedSlot = 6 + (j + i * 6);
                this.setSelectedSlot(this.selectedSlot);
            }
            ++i;
        }
    }

    private void setSelectedSlot(int selSlot) {
        NBTTagCompound tags;
        ItemStack stack = this.player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemAtlas) {
            this.atlasStack = stack;
        }
        if ((tags = this.atlasStack.func_77978_p()) != null) {
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", true, 48);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = new ItemStack(tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            this.mapX = 0;
            this.mapZ = 0;
            this.mapZoom = 0;
            this.slotMapNorth = -1;
            this.slotMapEast = -1;
            this.slotMapSouth = -1;
            this.slotMapWest = -1;
            ItemStack selectedStack = atlasInventory.func_70301_a(selSlot);
            if (selectedStack != ItemStack.field_190927_a && tags.func_74764_b("maps")) {
                NBTTagList mapTags = tags.func_150295_c("maps", 10);
                for (int i = 0; i < mapTags.func_74745_c(); ++i) {
                    NBTTagCompound newTags = mapTags.func_150305_b(i);
                    if (!newTags.func_74764_b("mapName") || !newTags.func_74779_i("mapName").contentEquals("Map_" + selectedStack.func_77952_i())) continue;
                    this.mapX = newTags.func_74762_e("xCenter");
                    this.mapZ = newTags.func_74762_e("zCenter");
                    this.mapZoom = newTags.func_74762_e("mapScale");
                }
                this.searchForNearbyMaps(0, mapTags, atlasInventory);
                this.searchForNearbyMaps(1, mapTags, atlasInventory);
                this.searchForNearbyMaps(2, mapTags, atlasInventory);
                this.searchForNearbyMaps(3, mapTags, atlasInventory);
            }
        }
    }

    private void searchForNearbyMaps(int direction, NBTTagList maps, InventoryBasic inventory) {
        block6: for (int i = 0; i < maps.func_74745_c(); ++i) {
            int newZoom;
            NBTTagCompound newTags = maps.func_150305_b(i);
            if (!newTags.func_74764_b("mapName") || (newZoom = newTags.func_74762_e("mapScale")) != this.zoomLevel) continue;
            int mapSize = 128 * (int)Math.pow(2.0, this.zoomLevel);
            int newX = newTags.func_74762_e("xCenter");
            int newZ = newTags.func_74762_e("zCenter");
            switch (direction) {
                case 0: {
                    if (this.mapZ - mapSize != newZ || this.mapX != newX) continue block6;
                    this.findMatchingMap(newTags.func_74779_i("mapName"), inventory, 0);
                    continue block6;
                }
                case 1: {
                    if (this.mapX + mapSize != newX || this.mapZ != newZ) continue block6;
                    this.findMatchingMap(newTags.func_74779_i("mapName"), inventory, 1);
                    continue block6;
                }
                case 2: {
                    if (this.mapZ + mapSize != newZ || this.mapX != newX) continue block6;
                    this.findMatchingMap(newTags.func_74779_i("mapName"), inventory, 2);
                    continue block6;
                }
                case 3: {
                    if (this.mapX - mapSize != newX || this.mapZ != newZ) continue block6;
                    this.findMatchingMap(newTags.func_74779_i("mapName"), inventory, 3);
                }
            }
        }
    }

    private void findMatchingMap(String mapName, InventoryBasic inventory, int direction) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack map = inventory.func_70301_a(i);
            if (map == ItemStack.field_190927_a || map.func_77973_b() != Items.field_151098_aY || !mapName.contentEquals("Map_" + map.func_77952_i())) continue;
            switch (direction) {
                case 0: {
                    this.slotMapNorth = i;
                    return;
                }
                case 1: {
                    this.slotMapEast = i;
                    return;
                }
                case 2: {
                    this.slotMapSouth = i;
                    return;
                }
                case 3: {
                    this.slotMapWest = i;
                    return;
                }
            }
        }
    }

    public void func_73876_c() {
        boolean testContainerUpdate;
        NBTTagCompound tags;
        super.func_73876_c();
        ItemStack stack = this.player.func_184586_b(EnumHand.MAIN_HAND);
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemAtlas) {
            this.atlasStack = stack;
        }
        if ((tags = this.atlasStack.func_77978_p()) != null && (testContainerUpdate = tags.func_74767_n("containerUpdate"))) {
            tags.func_74757_a("containerUpdate", false);
            this.atlasStack.func_77982_d(tags);
            this.setSelectedSlot(this.selectedSlot);
        }
    }

    protected void func_73869_a(char par1, int key) {
        if (key == 1) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else if (key == 57 && this.hoveredSlot != -1) {
            this.selectedSlot = this.hoveredSlot;
            this.setSelectedSlot(this.hoveredSlot);
        }
    }

    public void func_146276_q_() {
    }

    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.ATLASGUI);
        int w = (this.field_146294_l - this.field_146999_f) / 2;
        int h = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(w, h, 0, 0, this.field_146999_f, this.field_147000_g);
        this.hoveredSlot = -1;
        this.field_146297_k.func_110434_K().func_110577_a(CommonProxy.ATLASGUIBUTTONS);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 6; ++j) {
                if (x >= w + 138 + j * 18 && x < w + 138 + 18 + j * 18 && y >= h + 15 + i * 18 && y < h + 15 + 18 + i * 18) {
                    this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 20, 0, 18, 18);
                    this.hoveredSlot = 6 + (j + i * 6);
                }
                if (6 + (j + i * 6) == this.selectedSlot) {
                    this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 0, 0, 18, 18);
                    if (this.slotMapNorth != -1) {
                        this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 41, 20, 18, 18);
                    }
                    if (this.slotMapEast != -1) {
                        this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 21, 20, 18, 18);
                    }
                    if (this.slotMapSouth != -1) {
                        this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 1, 20, 18, 18);
                    }
                    if (this.slotMapWest != -1) {
                        this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 61, 20, 18, 18);
                    }
                }
                if (this.slotMapNorth - 6 == j + i * 6) {
                    this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 1, 20, 18, 18);
                }
                if (this.slotMapEast - 6 == j + i * 6) {
                    this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 61, 20, 18, 18);
                }
                if (this.slotMapSouth - 6 == j + i * 6) {
                    this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 41, 20, 18, 18);
                }
                if (this.slotMapWest - 6 != j + i * 6) continue;
                this.func_73729_b(w + 137 + j * 18, h + 14 + i * 18, 21, 20, 18, 18);
            }
        }
        this.bAtlasMode.func_146112_a(this.field_146297_k, 0, 0);
        this.bInventoryMode.func_146112_a(this.field_146297_k, 0, 0);
        this.field_146289_q.func_175065_a(I18n.func_74838_a((String)"gui.atlas.atlas"), (float)(w + 39), (float)(h + 12), 0, false);
        this.field_146289_q.func_175065_a(I18n.func_74838_a((String)"gui.atlas.zoom"), (float)(w + 12), (float)(h + 28), 0, false);
        this.field_146289_q.func_175065_a(I18n.func_74838_a((String)"gui.atlas.center"), (float)(w + 12), (float)(h + 52), 0, false);
        this.field_146289_q.func_175065_a(I18n.func_74838_a((String)"gui.atlas.create"), (float)(w + 12), (float)(h + 78), 0, false);
        this.field_146289_q.func_175065_a(this.zoomLevel + 1 + "", (float)(w + 86), (float)(h + 28), 187, false);
        this.field_146289_q.func_175065_a(I18n.func_74838_a((String)"gui.atlas.mapXcenter"), (float)(w + 12), (float)(h + 94), 0, false);
        this.field_146289_q.func_175065_a(I18n.func_74838_a((String)"gui.atlas.mapZcenter"), (float)(w + 12), (float)(h + 103), 0, false);
        this.field_146289_q.func_175065_a(I18n.func_74838_a((String)"gui.atlas.mapZoom"), (float)(w + 12), (float)(h + 112), 0, false);
        this.field_146289_q.func_175065_a("" + this.mapX, (float)(w + 84), (float)(h + 94), 187, false);
        this.field_146289_q.func_175065_a("" + this.mapZ, (float)(w + 84), (float)(h + 103), 187, false);
        this.field_146289_q.func_175065_a("" + (this.mapZoom + 1), (float)(w + 90), (float)(h + 112), 187, false);
    }

    protected void func_146979_b(int x, int y) {
    }

    public void func_73863_a(int x, int y, float f) {
        super.func_73863_a(x, y, f);
        if (GuiAtlas.func_146271_m()) {
            ArrayList<String> lst;
            if (x >= this.btoggleAutoCenter.field_146128_h && x < this.btoggleAutoCenter.field_146128_h + this.btoggleAutoCenter.field_146120_f && y >= this.btoggleAutoCenter.field_146129_i && y < this.btoggleAutoCenter.field_146129_i + this.btoggleAutoCenter.field_146121_g) {
                lst = new ArrayList<String>();
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocenter.tt1"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocenter.tt2"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocenter.tt3"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocenter.tt4"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocenter.tt5"));
                this.drawHoveringText(lst, x, y + 15, this.field_146289_q);
            }
            if (x >= this.btoggleAutoCreate.field_146128_h && x < this.btoggleAutoCreate.field_146128_h + this.btoggleAutoCreate.field_146120_f && y >= this.btoggleAutoCreate.field_146129_i && y < this.btoggleAutoCreate.field_146129_i + this.btoggleAutoCreate.field_146121_g) {
                lst = new ArrayList();
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocreate.tt1"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocreate.tt2"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocreate.tt3"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocreate.tt4"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocreate.tt5"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocreate.tt6"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocreate.tt7"));
                lst.add(" ");
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocreate.tt8"));
                lst.add(I18n.func_74838_a((String)"gui.atlas.autocreate.tt9"));
                this.drawHoveringText(lst, x, y + 15, this.field_146289_q);
            }
            if (x >= this.bAtlasMode.field_146128_h && x < this.bAtlasMode.field_146128_h + this.bAtlasMode.field_146120_f && y >= this.bAtlasMode.field_146129_i && y < this.bAtlasMode.field_146129_i + this.bAtlasMode.field_146121_g) {
                lst = new ArrayList();
                lst.add(I18n.func_74838_a((String)"gui.atlas.switchtoatlas"));
                this.drawHoveringText(lst, x, y + 15, this.field_146289_q);
            }
        }
    }
}

