/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.items;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Random;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.BlockLoader;
import jds.bibliocraft.gui.GuiAtlasMap;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.tileentities.TileEntityMapFrame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemAtlas
extends ItemMap {
    public static final String name = "AtlasBook";
    public static final ItemAtlas instance = new ItemAtlas();

    public ItemAtlas() {
        this.func_77655_b(name);
        this.func_77625_d(1);
        this.func_77637_a(BlockLoader.biblioTab);
        this.setRegistryName(name);
    }

    private int createUniqueID() {
        Random rando = new Random();
        return Math.abs((int)(rando.nextLong() * MinecraftServer.func_130071_aq()));
    }

    public int func_77619_b() {
        return 15;
    }

    public boolean func_77643_m_() {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return 36000;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (player.func_70093_af() && hand != EnumHand.OFF_HAND && (tile = world.func_175625_s(pos)) != null && tile instanceof TileEntityMapFrame) {
            if (!world.field_72995_K) {
                ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
                TileEntityMapFrame mapFrame = (TileEntityMapFrame)tile;
                if (mapFrame.getHasMap()) {
                    int matchingMapSlot = this.findMatchingMapSlot(stack, mapFrame);
                    if (matchingMapSlot == -1) {
                        this.addnewMapToAtlasFromFrame(stack, mapFrame, player);
                    } else {
                        boolean alreadySetToMap = false;
                        NBTTagCompound tags = stack.func_77978_p();
                        if (tags != null && tags.func_74764_b("mapSlot") && tags.func_74762_e("mapSlot") == matchingMapSlot) {
                            alreadySetToMap = true;
                        }
                        if (!alreadySetToMap) {
                            this.saveMapSlotToNBT(stack, player, matchingMapSlot);
                        } else {
                            ByteBuf buffer = Unpooled.buffer();
                            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)stack);
                            buffer.writeInt(pos.func_177958_n());
                            buffer.writeInt(pos.func_177956_o());
                            buffer.writeInt(pos.func_177952_p());
                            BiblioCraft.ch_BiblioAtlas.sendTo(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioAtlasTGUI"), (EntityPlayerMP)player);
                        }
                    }
                } else if (this.checkForAndRemoveStackedEmptyMap(stack, player)) {
                    ItemStack atlasMapStack = this.getCurrentMapStack(stack);
                    NBTTagCompound mapData = this.getAtlasMapNBTdata(stack);
                    if (mapData != null && atlasMapStack != ItemStack.field_190927_a) {
                        mapFrame.addMap(atlasMapStack.func_77946_l());
                        mapFrame.addMapPinDataFromAtlas(mapData);
                    }
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean isAutoCenterActive(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null && tags.func_74764_b("autoCenter")) {
            return tags.func_74767_n("autoCenter");
        }
        return false;
    }

    private boolean addnewMapToAtlasFromFrame(ItemStack stack, TileEntityMapFrame tile, EntityPlayer player) {
        InventoryBasic inv = this.getInventory(stack);
        int newMapSlot = this.findMapSlotForNewMap(stack);
        ItemStack newMap = tile.func_70301_a(0);
        NBTTagCompound tags = stack.func_77978_p();
        if (inv != null && newMapSlot != -1 && newMap != ItemStack.field_190927_a && tags != null) {
            String newMapName = "Map_" + newMap.func_77952_i();
            if (inv.func_70301_a(newMapSlot) == ItemStack.field_190927_a) {
                int emptyMapsSlot = this.getEmptyStackedMapSlot(stack);
                if (emptyMapsSlot != -1) {
                    boolean tfcTest;
                    ItemStack currentSlot = inv.func_70301_a(emptyMapsSlot);
                    boolean vanillaTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151148_bJ;
                    boolean bl = tfcTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151121_aF && Loader.isModLoaded((String)"terrafirmacraft") && Loader.isModLoaded((String)"BiblioWoodsTFC");
                    if (vanillaTest || tfcTest) {
                        currentSlot.func_190920_e(currentSlot.func_190916_E() - 1);
                        if (currentSlot.func_190916_E() == 0) {
                            currentSlot = ItemStack.field_190927_a;
                        }
                        inv.func_70299_a(emptyMapsSlot, currentSlot);
                    }
                } else {
                    return false;
                }
            }
            boolean foundMapData = false;
            NBTTagList atlasMapsDatas = new NBTTagList();
            int hasCurrentMapDatas = -1;
            if (tags.func_74764_b("maps")) {
                atlasMapsDatas = tags.func_150295_c("maps", 10);
                for (int i = 0; i < atlasMapsDatas.func_74745_c(); ++i) {
                    String oldMap;
                    NBTTagCompound testTag = atlasMapsDatas.func_150305_b(i);
                    if (testTag == null || !testTag.func_74764_b("mapName") || !(oldMap = testTag.func_74779_i("mapName")).contentEquals(newMapName)) continue;
                    atlasMapsDatas.func_74744_a(i);
                    foundMapData = true;
                }
            }
            newMap = newMap.func_77946_l();
            inv.func_70299_a(newMapSlot, newMap);
            NBTTagList itemList = new NBTTagList();
            for (int n = 0; n < inv.func_70302_i_(); ++n) {
                ItemStack invSlot = inv.func_70301_a(n);
                if (invSlot == ItemStack.field_190927_a) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("Slot", (byte)n);
                invSlot.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            tags.func_74782_a("Inventory", (NBTBase)itemList);
            atlasMapsDatas.func_74742_a((NBTBase)this.getNewMapDataCompound(tile, newMapName));
            tags.func_74782_a("maps", (NBTBase)atlasMapsDatas);
            if (!this.isAutoCenterActive(stack)) {
                tags.func_74768_a("mapSlot", newMapSlot);
            }
            stack.func_77982_d(tags);
            EnumHand hand = this.getHandWithAtlas(stack, player);
            if (hand != null) {
                if (hand == EnumHand.MAIN_HAND) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack.func_77946_l());
                } else {
                    player.field_71071_by.field_184439_c.set(0, (Object)stack.func_77946_l());
                }
            }
            return true;
        }
        return false;
    }

    private NBTTagCompound getNewMapDataCompound(TileEntityMapFrame tile, String newMapName) {
        NBTTagCompound newMapData = new NBTTagCompound();
        newMapData.func_74778_a("mapName", newMapName);
        newMapData.func_74768_a("xCenter", tile.mapXCenter);
        newMapData.func_74768_a("zCenter", tile.mapZCenter);
        newMapData.func_74768_a("mapScale", tile.mapScale);
        NBTTagList mapXPins = new NBTTagList();
        for (int i = 0; i < tile.xPin.size(); ++i) {
            float xpin = ((Float)tile.xPin.get(i)).floatValue();
            if (tile.getVertPosition() == EnumVertPosition.WALL && (tile.getAngle() == EnumFacing.WEST || tile.getAngle() == EnumFacing.NORTH)) {
                xpin = 1.0f - xpin;
            }
            mapXPins.func_74742_a((NBTBase)new NBTTagFloat(xpin));
        }
        newMapData.func_74782_a("xMapWaypoints", (NBTBase)mapXPins);
        NBTTagList mapYPins = new NBTTagList();
        for (int i = 0; i < tile.yPin.size(); ++i) {
            float ypin = ((Float)tile.yPin.get(i)).floatValue();
            if (tile.getVertPosition() == EnumVertPosition.CEILING || tile.getVertPosition() == EnumVertPosition.WALL) {
                ypin = 1.0f - ypin;
            }
            mapYPins.func_74742_a((NBTBase)new NBTTagFloat(ypin));
        }
        newMapData.func_74782_a("yMapWaypoints", (NBTBase)mapYPins);
        NBTTagList mapPinNames = new NBTTagList();
        for (int i = 0; i < tile.pinStrings.size(); ++i) {
            mapPinNames.func_74742_a((NBTBase)new NBTTagString((String)tile.pinStrings.get(i)));
        }
        newMapData.func_74782_a("MapWaypointNames", (NBTBase)mapPinNames);
        NBTTagList mapPinColors = new NBTTagList();
        for (int i = 0; i < tile.pinColors.size(); ++i) {
            mapPinColors.func_74742_a((NBTBase)new NBTTagFloat(((Float)tile.pinColors.get(i)).floatValue()));
        }
        newMapData.func_74782_a("MapWaypointColors", (NBTBase)mapPinColors);
        return newMapData;
    }

    private int findMapSlotForNewMap(ItemStack stack) {
        InventoryBasic inv = this.getInventory(stack);
        if (inv != null) {
            int i;
            for (i = 6; i < inv.func_70302_i_(); ++i) {
                boolean tfcTest;
                ItemStack mapStack = inv.func_70301_a(i);
                boolean vanillaTest = mapStack != ItemStack.field_190927_a && mapStack.func_77973_b() == Items.field_151148_bJ;
                boolean bl = tfcTest = mapStack != ItemStack.field_190927_a && mapStack.func_77973_b() == Items.field_151121_aF && Loader.isModLoaded((String)"terrafirmacraft") && Loader.isModLoaded((String)"BiblioWoodsTFC");
                if (!vanillaTest && !tfcTest) continue;
                return i;
            }
            for (i = 6; i < inv.func_70302_i_(); ++i) {
                ItemStack emptyStack = inv.func_70301_a(i);
                if (emptyStack != ItemStack.field_190927_a) continue;
                return i;
            }
        }
        return -1;
    }

    private int findMatchingMapSlot(ItemStack stack, TileEntityMapFrame tile) {
        ItemStack frameMap = tile.func_70301_a(0);
        InventoryBasic inv = this.getInventory(stack);
        NBTTagCompound atlasTags = stack.func_77978_p();
        if (frameMap != ItemStack.field_190927_a && frameMap.func_77973_b() == Items.field_151098_aY && inv != null && atlasTags != null) {
            NBTTagList maps = atlasTags.func_150295_c("maps", 10);
            Object mapTag = null;
            String mapName = "Map_" + frameMap.func_77952_i();
            for (int n = 6; n < inv.func_70302_i_(); ++n) {
                ItemStack atlasStack = inv.func_70301_a(n);
                if (atlasStack == ItemStack.field_190927_a || atlasStack.func_77973_b() != Items.field_151098_aY || atlasStack.func_77952_i() != frameMap.func_77952_i()) continue;
                return n;
            }
        }
        return -1;
    }

    private NBTTagCompound getAtlasMapNBTdata(ItemStack stack) {
        InventoryBasic inv = this.getInventory(stack);
        NBTTagCompound atlasTags = stack.func_77978_p();
        ItemStack mapStack = this.getCurrentMapStack(stack);
        if (atlasTags != null && inv != null && mapStack != ItemStack.field_190927_a && atlasTags.func_74764_b("maps")) {
            NBTTagList maps = atlasTags.func_150295_c("maps", 10);
            NBTTagCompound mapTag = null;
            String mapName = "Map_" + mapStack.func_77952_i();
            for (int n = 0; n < maps.func_74745_c(); ++n) {
                mapTag = maps.func_150305_b(n);
                if (mapTag == null || !mapTag.func_74764_b("mapName") || !mapTag.func_74779_i("mapName").contentEquals(mapName)) continue;
                return mapTag;
            }
        }
        return null;
    }

    private ItemStack getCurrentMapStack(ItemStack stack) {
        ItemStack mapStack;
        int mapSlot;
        InventoryBasic inv = this.getInventory(stack);
        NBTTagCompound atlasTags = stack.func_77978_p();
        if (atlasTags != null && (mapSlot = atlasTags.func_74762_e("mapSlot")) != -1 && (mapStack = inv.func_70301_a(mapSlot)) != ItemStack.field_190927_a && mapStack.func_77973_b() == Items.field_151098_aY) {
            return mapStack;
        }
        return ItemStack.field_190927_a;
    }

    private boolean checkForAndRemoveStackedEmptyMap(ItemStack stack, EntityPlayer player) {
        InventoryBasic inv = this.getInventory(stack);
        int emptyMapsSlot = this.getEmptyStackedMapSlot(stack);
        NBTTagCompound tags = stack.func_77978_p();
        if (inv != null && emptyMapsSlot != -1 && tags != null) {
            boolean tfcTest;
            ItemStack currentSlot = inv.func_70301_a(emptyMapsSlot);
            boolean vanillaTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151148_bJ;
            boolean bl = tfcTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151121_aF && Loader.isModLoaded((String)"terrafirmacraft") && Loader.isModLoaded((String)"BiblioWoodsTFC");
            if (vanillaTest || tfcTest) {
                currentSlot.func_190920_e(currentSlot.func_190916_E() - 1);
                if (currentSlot.func_190916_E() == 0) {
                    currentSlot = ItemStack.field_190927_a;
                }
                inv.func_70299_a(emptyMapsSlot, currentSlot);
                NBTTagList itemList = new NBTTagList();
                for (int n = 0; n < inv.func_70302_i_(); ++n) {
                    ItemStack invSlot = inv.func_70301_a(n);
                    if (invSlot == ItemStack.field_190927_a) continue;
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74774_a("Slot", (byte)n);
                    invSlot.func_77955_b(tag);
                    itemList.func_74742_a((NBTBase)tag);
                }
                tags.func_74782_a("Inventory", (NBTBase)itemList);
                stack.func_77982_d(tags);
                EnumHand hand = this.getHandWithAtlas(stack, player);
                if (hand != null) {
                    if (hand == EnumHand.MAIN_HAND) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack.func_77946_l());
                    } else {
                        player.field_71071_by.field_184439_c.set(0, (Object)stack.func_77946_l());
                    }
                }
                return true;
            }
        }
        return false;
    }

    private int getEmptyStackedMapSlot(ItemStack stack) {
        InventoryBasic inv = this.getInventory(stack);
        if (inv != null) {
            for (int i = 0; i < 6; ++i) {
                boolean tfcTest;
                ItemStack currentSlot = inv.func_70301_a(i);
                boolean vanillaTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151148_bJ;
                boolean bl = tfcTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151121_aF && Loader.isModLoaded((String)"terrafirmacraft") && Loader.isModLoaded((String)"BiblioWoodsTFC");
                if (!vanillaTest && !tfcTest) continue;
                return i;
            }
        }
        return -1;
    }

    private InventoryBasic getInventory(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", true, 48);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = new ItemStack(tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            return atlasInventory;
        }
        return null;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (player.func_184586_b(EnumHand.OFF_HAND) == ItemStack.field_190927_a) {
            NBTTagCompound tags = player.func_184586_b(hand).func_77978_p();
            int gui = 0;
            if (tags != null && tags.func_74764_b("lastGUImode")) {
                gui = tags.func_74762_e("lastGUImode");
            }
            if (gui == 0) {
                if (!world.field_72995_K) {
                    player.openGui((Object)BiblioCraft.instance, 100, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
                }
            } else {
                player.field_70125_A = 50.0f;
                if (world.field_72995_K) {
                    this.openMapGUI(world, player, player.func_184586_b(hand));
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void openMapGUI(World world, EntityPlayer player, ItemStack stack) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAtlasMap(world, player, stack));
    }

    public boolean getAtlasInventory(ItemStack stack, World world, EntityPlayer player, boolean autoCreate, boolean autoCenter, int zoomLevel, int selectedSlot) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", true, 48);
            NBTTagList tagList = tags.func_150295_c("Inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
                ItemStack invStack = new ItemStack(tag);
                atlasInventory.func_70299_a((int)slot, invStack);
            }
            ItemStack currentSlot = ItemStack.field_190927_a;
            if (autoCenter) {
                for (int i = 6; i < atlasInventory.func_70302_i_(); ++i) {
                    MapData mapdata;
                    currentSlot = atlasInventory.func_70301_a(i);
                    if (currentSlot == ItemStack.field_190927_a || !(currentSlot.func_77973_b() instanceof ItemMap) || (mapdata = Items.field_151098_aY.func_77873_a(currentSlot, world)) == null || !this.isPlayerWithinMapData(mapdata, player, zoomLevel)) continue;
                    stack.func_77964_b(currentSlot.func_77952_i());
                    this.saveMapSlotToNBT(stack, player, i);
                    return true;
                }
            } else {
                currentSlot = atlasInventory.func_70301_a(selectedSlot);
                if (currentSlot != ItemStack.field_190927_a) {
                    stack.func_77964_b(currentSlot.func_77952_i());
                    this.saveMapSlotToNBT(stack, player, selectedSlot);
                }
                return true;
            }
            if (autoCreate) {
                boolean tfcTest;
                boolean vanillaTest;
                int i;
                boolean foundBlankMap = false;
                int newMapSlot = -1;
                for (i = 6; i < atlasInventory.func_70302_i_(); ++i) {
                    currentSlot = atlasInventory.func_70301_a(i);
                    vanillaTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151148_bJ;
                    boolean bl = tfcTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151121_aF && Loader.isModLoaded((String)"terrafirmacraft") && Loader.isModLoaded((String)"BiblioWoodsTFC");
                    if (!vanillaTest && !tfcTest || currentSlot.func_190916_E() != 1) continue;
                    foundBlankMap = true;
                    newMapSlot = i;
                }
                if (!foundBlankMap) {
                    for (i = 0; i < 6; ++i) {
                        currentSlot = atlasInventory.func_70301_a(i);
                        vanillaTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151148_bJ;
                        boolean bl = tfcTest = currentSlot != ItemStack.field_190927_a && currentSlot.func_77973_b() == Items.field_151121_aF && Loader.isModLoaded((String)"terrafirmacraft") && Loader.isModLoaded((String)"BiblioWoodsTFC");
                        if (!vanillaTest && !tfcTest) continue;
                        ItemStack testBlankSlot = ItemStack.field_190927_a;
                        for (int n = 6; n < atlasInventory.func_70302_i_(); ++n) {
                            testBlankSlot = atlasInventory.func_70301_a(n);
                            if (testBlankSlot != ItemStack.field_190927_a || foundBlankMap) continue;
                            foundBlankMap = true;
                            newMapSlot = n;
                        }
                        if (!foundBlankMap) continue;
                        currentSlot.func_190920_e(currentSlot.func_190916_E() - 1);
                        if (currentSlot.func_190916_E() == 0) {
                            currentSlot = ItemStack.field_190927_a;
                        }
                        atlasInventory.func_70299_a(i, currentSlot);
                        break;
                    }
                }
                if (foundBlankMap && newMapSlot != -1) {
                    EnumHand hand;
                    ItemStack newmap = this.makeNewMap(world, player, zoomLevel, stack);
                    atlasInventory.func_70299_a(newMapSlot, newmap);
                    NBTTagCompound ntags = stack.func_77978_p();
                    if (ntags == null) {
                        ntags = new NBTTagCompound();
                    }
                    ntags.func_74768_a("mapSlot", -1);
                    NBTTagList itemList = new NBTTagList();
                    for (int n = 0; n < atlasInventory.func_70302_i_(); ++n) {
                        ItemStack invSlot = atlasInventory.func_70301_a(n);
                        if (invSlot == ItemStack.field_190927_a) continue;
                        NBTTagCompound tag = new NBTTagCompound();
                        tag.func_74774_a("Slot", (byte)n);
                        invSlot.func_77955_b(tag);
                        itemList.func_74742_a((NBTBase)tag);
                    }
                    ntags.func_74782_a("Inventory", (NBTBase)itemList);
                    NBTTagList maps = this.getUpdatedMapTagList(atlasInventory, ntags, world);
                    ntags.func_74782_a("maps", (NBTBase)maps);
                    stack.func_77982_d(ntags);
                    stack.func_77964_b(newmap.func_77952_i());
                    if (this.checkIfPlayerIsHoldingAtlas(player) && (hand = this.getHandWithAtlas(stack, player)) != null) {
                        if (hand == EnumHand.MAIN_HAND) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack.func_77946_l());
                        } else {
                            player.field_71071_by.field_184439_c.set(0, (Object)stack.func_77946_l());
                        }
                    }
                    return true;
                }
            }
            this.saveMapSlotToNBT(stack, player, -1);
        }
        return false;
    }

    private boolean checkIfPlayerIsHoldingAtlas(EntityPlayer player) {
        ItemStack hand = player.func_184586_b(EnumHand.MAIN_HAND);
        ItemStack offHand = player.func_184586_b(EnumHand.OFF_HAND);
        return hand.func_77973_b() instanceof ItemAtlas || offHand.func_77973_b() instanceof ItemAtlas;
    }

    private EnumHand getHandWithAtlas(ItemStack stack, EntityPlayer player) {
        EnumHand hand = null;
        NBTTagCompound currTags = stack.func_77978_p();
        if (currTags.func_74764_b("atlasID")) {
            int id = currTags.func_74762_e("atlasID");
            ItemStack mainHand = player.func_184586_b(EnumHand.MAIN_HAND);
            NBTTagCompound mainTags = mainHand.func_77978_p();
            ItemStack offHand = player.func_184586_b(EnumHand.OFF_HAND);
            NBTTagCompound offTags = offHand.func_77978_p();
            if (mainHand.func_77973_b() instanceof ItemAtlas && mainTags.func_74764_b("atlasID") && id == mainTags.func_74762_e("atlasID")) {
                return EnumHand.MAIN_HAND;
            }
            if (offHand.func_77973_b() instanceof ItemAtlas && offTags.func_74764_b("atlasID") && id == offTags.func_74762_e("atlasID")) {
                return EnumHand.OFF_HAND;
            }
        }
        return hand;
    }

    private void saveMapSlotToNBT(ItemStack stack, EntityPlayer player, int slot) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            EnumHand hand;
            tags.func_74768_a("mapSlot", slot);
            stack.func_77982_d(tags);
            stack.func_77964_b(ItemAtlas.setAtlasDamage(stack, slot));
            if (this.checkIfPlayerIsHoldingAtlas(player) && (hand = this.getHandWithAtlas(stack, player)) != null) {
                if (hand == EnumHand.MAIN_HAND) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, stack.func_77946_l());
                } else {
                    player.field_71071_by.field_184439_c.set(0, (Object)stack.func_77946_l());
                }
            }
        }
    }

    public static int setAtlasDamage(ItemStack atlas, int newslot) {
        NBTTagCompound tags = atlas.func_77978_p();
        InventoryBasic atlasInventory = new InventoryBasic("AtlasInventory", false, 48);
        NBTTagList tagList = tags.func_150295_c("Inventory", 10);
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag = tagList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= atlasInventory.func_70302_i_()) continue;
            ItemStack invStack = new ItemStack(tag);
            atlasInventory.func_70299_a((int)slot, invStack);
        }
        ItemStack newmap = atlasInventory.func_70301_a(newslot);
        if (newmap != ItemStack.field_190927_a && newmap.func_77973_b() instanceof ItemMap) {
            return newmap.func_77952_i();
        }
        return 0;
    }

    public ItemStack makeNewMap(World world, EntityPlayer player, int scale, ItemStack oldMap) {
        MapData oldmapdata = Items.field_151098_aY.func_77873_a(oldMap, world);
        double mx = 0.0;
        double mz = 0.0;
        int newXcenter = 0;
        int newZcenter = 0;
        ItemStack itemstack = new ItemStack((Item)Items.field_151098_aY, 1, world.func_72841_b("map"));
        String s = "map_" + itemstack.func_77952_i();
        MapData mapdata = new MapData(s);
        world.func_72823_a(s, (WorldSavedData)mapdata);
        mapdata.field_76197_d = (byte)scale;
        int i = 128 * (1 << mapdata.field_76197_d);
        if (oldmapdata != null) {
            mx = oldmapdata.field_76201_a;
            mz = oldmapdata.field_76199_b;
            switch (this.playerDirection(world, player, oldmapdata)) {
                case 0: {
                    newXcenter = (int)(mx + 128.0 * Math.pow(2.0, scale));
                    newZcenter = (int)mz;
                    break;
                }
                case 1: {
                    newXcenter = (int)(mx - 128.0 * Math.pow(2.0, scale));
                    newZcenter = (int)mz;
                    break;
                }
                case 2: {
                    newXcenter = (int)mx;
                    newZcenter = (int)(mz - 128.0 * Math.pow(2.0, scale));
                    break;
                }
                case 3: {
                    newXcenter = (int)mx;
                    newZcenter = (int)(mz + 128.0 * Math.pow(2.0, scale));
                    break;
                }
                default: {
                    newXcenter = (int)(Math.round(player.field_70165_t / (double)i) * (long)i);
                    newZcenter = (int)(Math.round(player.field_70161_v / (double)i) * (long)i);
                    break;
                }
            }
        } else {
            newXcenter = (int)(Math.round(player.field_70165_t / (double)i) * (long)i);
            newZcenter = (int)(Math.round(player.field_70161_v / (double)i) * (long)i);
        }
        mapdata.field_76201_a = newXcenter;
        mapdata.field_76199_b = newZcenter;
        mapdata.field_76200_c = world.field_73011_w.getDimension();
        mapdata.func_76185_a();
        return itemstack;
    }

    private NBTTagList getUpdatedMapTagList(InventoryBasic atlasInventory, NBTTagCompound tags, World world) {
        NBTTagList maps = null;
        NBTTagList newMaps = new NBTTagList();
        if (tags.func_74764_b("maps")) {
            maps = tags.func_150295_c("maps", 10);
        }
        for (int i = 6; i < atlasInventory.func_70302_i_(); ++i) {
            MapData mapdata;
            ItemStack currentMap = atlasInventory.func_70301_a(i);
            if (currentMap == ItemStack.field_190927_a) continue;
            String mapName = "Map_" + currentMap.func_77952_i();
            boolean foundMap = false;
            NBTTagCompound mapTag = new NBTTagCompound();
            if (maps != null) {
                for (int n = 0; n < maps.func_74745_c(); ++n) {
                    mapTag = maps.func_150305_b(n);
                    if (mapTag == null || !mapTag.func_74764_b("mapName") || !mapTag.func_74779_i("mapName").contentEquals(mapName)) continue;
                    foundMap = true;
                    break;
                }
            }
            if (!foundMap && (mapdata = this.getMyMapData(currentMap, world)) != null) {
                foundMap = true;
                mapTag = new NBTTagCompound();
                mapTag.func_74778_a("mapName", mapName);
                mapTag.func_74768_a("xCenter", mapdata.field_76201_a);
                mapTag.func_74768_a("zCenter", mapdata.field_76199_b);
                mapTag.func_74768_a("mapScale", (int)mapdata.field_76197_d);
            }
            if (!foundMap) continue;
            newMaps.func_74742_a((NBTBase)mapTag);
        }
        return newMaps;
    }

    private MapData getMyMapData(ItemStack stack, World world) {
        MapData mapdata;
        if (stack != ItemStack.field_190927_a && stack.func_77973_b() instanceof ItemMap && (mapdata = Items.field_151098_aY.func_77873_a(stack, world)) != null) {
            return mapdata;
        }
        return null;
    }

    private int playerDirection(World world, EntityPlayer player, MapData mapdata) {
        double px = player.field_70165_t;
        double pz = player.field_70161_v;
        double mx = mapdata.field_76201_a;
        double mz = mapdata.field_76199_b;
        byte scale = mapdata.field_76197_d;
        double factor = 64.0 * Math.pow(2.0, scale);
        if (px > mx + factor && px < mx + factor + 2.0 * factor) {
            return 0;
        }
        if (px < mx - factor && px > mx - factor - 2.0 * factor) {
            return 1;
        }
        if (pz < mz + factor && pz > mz + factor + 2.0 * factor) {
            return 2;
        }
        if (pz > mz - factor && pz < mz - factor - 2.0 * factor) {
            return 3;
        }
        return -1;
    }

    public boolean isPlayerWithinMapData(MapData map, EntityPlayer player, int zoomLevel) {
        if (map == null || player == null) {
            return false;
        }
        double px = player.field_70165_t;
        double pz = player.field_70161_v;
        double mx = map.field_76201_a;
        double mz = map.field_76199_b;
        byte scale = map.field_76197_d;
        if (scale != zoomLevel) {
            return false;
        }
        double factor = 64.0 * Math.pow(2.0, scale);
        return px < mx + factor && px > mx - factor && pz < mz + factor && pz > mz - factor;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean inhand) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            tags = new NBTTagCompound();
            stack.func_77982_d(tags);
        }
        if (!world.field_72995_K) {
            if (!tags.func_74764_b("atlasID")) {
                int id = this.createUniqueID();
                tags.func_74768_a("atlasID", this.createUniqueID());
                stack.func_77982_d(tags);
            }
            if (inhand || slot == 0) {
                MapData mapdata = Items.field_151098_aY.func_77873_a(stack, world);
                if (entity instanceof EntityPlayer) {
                    EntityPlayer entityplayer = (EntityPlayer)entity;
                    mapdata.field_186210_e = true;
                    mapdata.func_76191_a(entityplayer, stack);
                    if (this.checkIfPlayerIsHoldingAtlas(entityplayer)) {
                        boolean autoCenter = tags.func_74767_n("autoCenter");
                        boolean autoCreate = tags.func_74767_n("autoCreate");
                        int zoomLevel = tags.func_74762_e("zoomLevel");
                        int selectedSlot = tags.func_74762_e("mapSlot");
                        if (this.getMapSlot(stack) == -1) {
                            this.getAtlasInventory(stack, world, entityplayer, autoCreate, autoCenter, zoomLevel, selectedSlot);
                        }
                        if (autoCenter && !this.isPlayerWithinMapData(mapdata, entityplayer, zoomLevel)) {
                            this.getAtlasInventory(stack, world, entityplayer, autoCreate, autoCenter, zoomLevel, selectedSlot);
                        }
                        this.func_77872_a(world, entity, mapdata);
                    }
                }
            }
        }
        if (world.field_72995_K && entity != null && entity instanceof EntityPlayer && tags.func_74764_b("savedCompass") && tags.func_74762_e("savedCompass") != -1) {
            int sX = 0;
            int sZ = 0;
            double time = 0.0;
            double prevAngle = 0.0;
            if (tags != null) {
                sX = tags.func_74762_e("compassX");
                sZ = tags.func_74762_e("compassZ");
                time = tags.func_74769_h("time");
                prevAngle = tags.func_74769_h("prevAngle");
            }
            EntityPlayer player = (EntityPlayer)entity;
            double yaw = (double)MathHelper.func_76142_g((float)player.field_70177_z) + 90.0;
            double dx = (double)sX - player.field_70165_t;
            double dz = (double)sZ - player.field_70161_v;
            double newAngle = yaw - Math.atan2(dz, dx) * 57.29577951308232;
            double angleDelta = Math.abs(prevAngle - newAngle);
            prevAngle = newAngle;
            double delta = 0.0;
            boolean runDelta = false;
            if (angleDelta > 8.0) {
                time -= 0.25;
                if (angleDelta > 40.0) {
                    time -= 0.2;
                }
            } else {
                runDelta = true;
                time = time <= 5.25 ? (time += 0.06) : 5.25;
            }
            if (time > 5.25) {
                time = 5.25;
            }
            if (time <= 1.309) {
                time = 1.309;
            }
            if (runDelta) {
                delta = Math.exp(-time) * (64.0 * Math.sin(3.0 * time) - 64.0 * Math.cos(3.0 * time));
            }
            float theta = (float)(newAngle + delta);
            tags.func_74776_a("needleAngle", theta);
            tags.func_74780_a("prevAngle", prevAngle);
            tags.func_74780_a("time", time);
        }
    }

    private int getMapSlot(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            return tags.func_74762_e("mapSlot");
        }
        return -1;
    }
}

