/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.items;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDeathCompass
extends Item {
    public static final String name = "DeathCompass";
    public static final ItemDeathCompass instance = new ItemDeathCompass();

    public ItemDeathCompass() {
        this.func_77655_b(name);
        this.func_77656_e(1);
        this.setRegistryName(name);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer playerIn, EnumHand handIn) {
        if (world.field_72995_K) {
            NBTTagCompound tags = playerIn.func_184586_b(handIn).func_77978_p();
            if (tags == null) {
                // empty if block
            }
            if (tags != null) {
                int sX = tags.func_74762_e("XCoord");
                int sZ = tags.func_74762_e("ZCoord");
                String waypoint = tags.func_74779_i("WaypointName");
                String tooltip = waypoint + "  @  X = " + sX + "   Z = " + sZ;
                playerIn.func_145747_a((ITextComponent)new TextComponentString(tooltip));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    public ItemStack writeNBT(ItemStack compass, int xset, int zset, String waypointName) {
        NBTTagCompound tags = new NBTTagCompound();
        tags.func_74768_a("XCoord", xset);
        tags.func_74768_a("ZCoord", zset);
        tags.func_74778_a("WaypointName", waypointName);
        compass.func_77982_d(tags);
        return compass;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer plater, List list, boolean whatsthis) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            int sX = tags.func_74762_e("XCoord");
            int sZ = tags.func_74762_e("ZCoord");
            String waypoint = tags.func_74779_i("WaypointName");
            String tooltip = waypoint + " @ X=" + sX + " Z=" + sZ;
            list.add(tooltip);
        } else {
            this.createNewNBT(stack);
        }
    }

    public void updateTheta(float angle, double prevAngle, double time, ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags.func_74776_a("needleAngle", angle);
            tags.func_74780_a("prevAngle", prevAngle);
            tags.func_74780_a("time", time);
        } else {
            this.createNewNBT(stack);
        }
    }

    public void createNewNBT(ItemStack compass) {
        NBTTagCompound newTags = new NBTTagCompound();
        newTags.func_74768_a("XCoord", 0);
        newTags.func_74768_a("ZCoord", 0);
        newTags.func_74778_a("WaypointName", "World Origin");
        newTags.func_74776_a("needleAngle", 0.0f);
        newTags.func_74780_a("time", 5.25);
        newTags.func_74780_a("prevAngle", 0.0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (entity != null && entity instanceof EntityPlayer) {
            int sX = 0;
            int sZ = 0;
            double time = 0.0;
            double prevAngle = 0.0;
            NBTTagCompound tags = stack.func_77978_p();
            if (tags == null) {
                this.createNewNBT(stack);
            }
            if (tags != null) {
                sX = tags.func_74762_e("XCoord");
                sZ = tags.func_74762_e("ZCoord");
                time = tags.func_74769_h("time");
                prevAngle = tags.func_74769_h("prevAngle");
            }
            EntityPlayer player = (EntityPlayer)entity;
            double yaw = (double)MathHelper.func_76142_g((float)player.field_70177_z) + 90.0;
            double dx = (double)sX - player.field_70165_t;
            double dz = (double)sZ - player.field_70161_v;
            double newAngle = yaw - Math.atan2(dz, dx) * 57.29577951308232;
            double angleDelta = Math.abs(prevAngle - newAngle);
            prevAngle = newAngle;
            double delta = 0.0;
            boolean runDelta = false;
            if (angleDelta > 8.0) {
                time -= 0.25;
                if (angleDelta > 40.0) {
                    time -= 0.2;
                }
            } else {
                runDelta = true;
                time = time <= 5.25 ? (time += 0.06) : 5.25;
            }
            if (time > 5.25) {
                time = 5.25;
            }
            if (time <= 1.309) {
                time = 1.309;
            }
            if (runDelta) {
                delta = Math.exp(-time) * (64.0 * Math.sin(3.0 * time) - 64.0 * Math.cos(3.0 * time));
            }
            float theta = (float)(newAngle + delta);
            this.updateTheta(theta, prevAngle, time, stack);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return false;
    }
}

