/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.helpers.EnumColor;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.states.TextureState;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityCase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.TRSRTransformation;

public class BlockCase
extends BiblioWoodBlock {
    public static final String name = "Case";
    public static final BlockCase instance = new BlockCase();

    public BlockCase() {
        super(name, true);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityCase tile = (TileEntityCase)world.func_175625_s(pos);
            ItemStack playerHand = player.func_70694_bm();
            if (tile != null) {
                if (player.func_70093_af()) {
                    tile.setOpenLid(!tile.getOpenLid());
                    if (tile.getOpenLid()) {
                        world.func_72956_a((Entity)player, "bibliocraft:copen", 1.0f, 1.0f);
                    } else {
                        world.func_72956_a((Entity)player, "bibliocraft:cclose", 1.0f, 1.0f);
                    }
                } else if (tile.getOpenLid()) {
                    if (tile.isSlotFull()) {
                        tile.removeStackFromInventoryFromWorld(0, player, this);
                    } else if (playerHand != null) {
                        if (Block.func_149634_a((Item)playerHand.func_77973_b()) instanceof BlockCarpet) {
                            tile.setInnerCover(playerHand, player);
                        } else {
                            tile.addStackToInventoryFromWorld(playerHand, 0, player);
                        }
                    } else {
                        player.openGui((Object)BiblioCraft.instance, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    }
                }
            }
        }
        return true;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCase();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("case_inside");
        modelParts.add("case_bottom");
        if (tile instanceof TileEntityCase) {
            TileEntityCase casetile = (TileEntityCase)tile;
            if (casetile.getOpenLid()) {
                modelParts.add("case_lid_glass_open");
                modelParts.add("case_lid_latch_open");
                modelParts.add("case_lid_wood_open");
            } else {
                modelParts.add("case_lid_glass");
                modelParts.add("case_lid_latch");
                modelParts.add("case_lid_wood");
            }
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
        int pitch = MathHelper.func_76128_c((double)((double)(player.field_70125_A * 3.0f / 180.0f) + 0.5)) & 3;
        ++pitch;
        if ((pitch %= 2) == 1) {
            biblioTile.setVertPosition(EnumVertPosition.WALL);
        } else {
            biblioTile.setVertPosition(EnumVertPosition.FLOOR);
        }
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        if (tile.getVertPosition() == EnumVertPosition.FLOOR) {
            transform = transform.compose(new TRSRTransformation(new Vector3f(1.0f, 0.0f, 1.0f), new Quat4f(0.0f, -1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 1.0f, 1.0f)));
        }
        return transform;
    }

    @Override
    public void func_180654_a(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile != null && tile instanceof BiblioTileEntity) {
            BiblioTileEntity caseTile = (BiblioTileEntity)tile;
            switch (caseTile.getAngle()) {
                case SOUTH: {
                    if (caseTile.getVertPosition() == EnumVertPosition.FLOOR) {
                        this.func_149676_a(0.06f, 0.0f, 0.0f, 0.94f, 0.5f, 1.0f);
                        break;
                    }
                    this.func_149676_a(0.5f, 0.0f, 0.06f, 1.0f, 1.0f, 0.94f);
                    break;
                }
                case WEST: {
                    if (caseTile.getVertPosition() == EnumVertPosition.FLOOR) {
                        this.func_149676_a(0.0f, 0.0f, 0.06f, 1.0f, 0.5f, 0.94f);
                        break;
                    }
                    this.func_149676_a(0.06f, 0.0f, 0.5f, 0.94f, 1.0f, 1.0f);
                    break;
                }
                case NORTH: {
                    if (caseTile.getVertPosition() == EnumVertPosition.FLOOR) {
                        this.func_149676_a(0.06f, 0.0f, 0.0f, 0.94f, 0.5f, 1.0f);
                        break;
                    }
                    this.func_149676_a(0.0f, 0.0f, 0.06f, 0.5f, 1.0f, 0.94f);
                    break;
                }
                case EAST: {
                    if (caseTile.getVertPosition() == EnumVertPosition.FLOOR) {
                        this.func_149676_a(0.0f, 0.0f, 0.06f, 1.0f, 0.5f, 0.94f);
                        break;
                    }
                    this.func_149676_a(0.06f, 0.0f, 0.0f, 0.94f, 1.0f, 0.5f);
                    break;
                }
            }
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public TextureState addAdditionTextureStateInformation(BiblioTileEntity tile, TextureState state) {
        ItemStack stack = tile.func_70301_a(1);
        if (stack != null) {
            state.setColorOne(EnumColor.getColorFromCarpetOrWool(stack));
        } else {
            state.setColorOne(EnumColor.WHITE);
        }
        return state;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_180656_a(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        int output = 0;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCase) {
            TileEntityCase tile = (TileEntityCase)te;
            ItemStack stack = tile.func_70301_a(0);
            Item testItem = Item.func_150898_a((Block)Blocks.field_150451_bX);
            if (stack != null && stack.func_77977_a().contains(testItem.func_77658_a())) {
                output = 15;
            }
        }
        return output;
    }

    public int func_176211_b(IBlockAccess worldIn, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.func_180656_a(worldIn, pos, state, side);
    }
}

