/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.items.ItemRecipeBook;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityFancyWorkbench;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBook;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.TRSRTransformation;

public class BlockFancyWorkbench
extends BiblioWoodBlock {
    public static final String name = "Workbench";
    public static final BlockFancyWorkbench instance = new BlockFancyWorkbench();

    public BlockFancyWorkbench() {
        super(name, false);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && tile instanceof TileEntityFancyWorkbench) {
            TileEntityFancyWorkbench bench = (TileEntityFancyWorkbench)tile;
            ItemStack playerhand = player.func_70694_bm();
            if (BlockFancyWorkbench.isBackOfBlock(bench.getAngle(), side) && hitY > 0.22f && hitY < 0.74f) {
                int booknum = this.isWhatBook(bench.getAngle(), hitX, hitZ) + 1;
                if (playerhand != null) {
                    if ((playerhand.func_77973_b() instanceof ItemBook || playerhand.func_77973_b() instanceof ItemRecipeBook && booknum != -1) && bench.addStackToInventoryFromWorld(playerhand, booknum, player)) {
                        return true;
                    }
                } else if (player.func_70093_af()) {
                    if (bench.func_70301_a(booknum) != null && booknum != -1) {
                        bench.removeStackFromInventoryFromWorld(booknum, player, this);
                    }
                    return true;
                }
            }
            if (!bench.isTooManyPlayers()) {
                player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public int isWhatBook(EnumFacing angle, float hitX, float hitZ) {
        int xt = (int)(hitX * 8.0f);
        int zt = (int)(hitZ * 8.0f);
        switch (angle) {
            case SOUTH: {
                return zt;
            }
            case WEST: {
                switch (xt) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 6;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return 0;
                    }
                }
            }
            case NORTH: {
                switch (zt) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 6;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return 0;
                    }
                }
            }
            case EAST: {
                return xt;
            }
        }
        return -1;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFancyWorkbench();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("bench");
        modelParts.add("top");
        modelParts.add("sides");
        if (tile instanceof TileEntityFancyWorkbench) {
            TileEntityFancyWorkbench bench = (TileEntityFancyWorkbench)tile;
            int[] books = bench.getBookArray();
            for (int i = 0; i < books.length; ++i) {
                if (books[i] != 1) continue;
                int j = i + 1;
                String bookName = "book" + j;
                modelParts.add(bookName);
            }
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        return transform;
    }
}

