/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.blocks.BlockPaintingFrameBorderless;
import jds.bibliocraft.helpers.EnumPaintingFrame;
import jds.bibliocraft.helpers.PaintingUtil;
import jds.bibliocraft.items.ItemPaintingCanvas;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityPainting;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public abstract class BlockPainting
extends BiblioWoodBlock {
    private EnumPaintingFrame frameType = EnumPaintingFrame.BORDERLESS;

    public BlockPainting(String name, EnumPaintingFrame frameID) {
        super(name, false);
        this.frameType = frameID;
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack playerhand = player.func_70694_bm();
        if (!world.field_72995_K) {
            TileEntityPainting painting = (TileEntityPainting)world.func_175625_s(pos);
            if (playerhand != null && playerhand.func_77973_b() instanceof ItemPaintingCanvas) {
                painting.addStackToInventoryFromWorldSingleStackSize(playerhand, 0, player);
                painting.resetPaintingData();
                return true;
            }
            if (player.func_70093_af() && painting.hasPainting()) {
                painting.removeStackFromInventoryFromWorld(0, player, this);
                return true;
            }
            player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else if (playerhand != null && playerhand.func_77973_b() instanceof ItemPaintingCanvas) {
            String name;
            int paintingNum;
            NBTTagCompound paintingTags = playerhand.func_77978_p();
            if (paintingTags == null || paintingTags.func_74764_b("paintingType")) {
                // empty if block
            }
            if (paintingTags.func_74762_e("paintingType") == 2 && PaintingUtil.customArtNames != null && (paintingNum = this.getCustomPaintingNum(name = paintingTags.func_74779_i("paintingTitle"))) >= 0) {
                int resx = PaintingUtil.customArtWidths[paintingNum];
                int resy = PaintingUtil.customArtHeights[paintingNum];
                int aspectX = 1;
                int aspectY = 1;
                if (resx <= resy) {
                    aspectX = this.roundNum((float)resx * 1.0f / (float)resx * 1.0f);
                    aspectY = this.roundNum((float)resy * 1.0f / (float)resx * 1.0f);
                } else {
                    aspectX = this.roundNum((float)resx * 1.0f / (float)resy * 1.0f);
                    aspectY = this.roundNum((float)resy * 1.0f / (float)resy * 1.0f);
                }
                ByteBuf buffer = Unpooled.buffer();
                buffer.writeInt(pos.func_177958_n());
                buffer.writeInt(pos.func_177956_o());
                buffer.writeInt(pos.func_177952_p());
                buffer.writeInt(aspectX);
                buffer.writeInt(aspectY);
                BiblioCraft.ch_BiblioPaintingC.sendToServer(new FMLProxyPacket(new PacketBuffer(buffer), "BiblioPaintingC"));
            }
        }
        return true;
    }

    private int getCustomPaintingNum(String paintingName) {
        for (int i = 0; i < PaintingUtil.customArtNames.length; ++i) {
            if (!PaintingUtil.customArtNames[i].contentEquals(paintingName)) continue;
            return i;
        }
        return -1;
    }

    private int roundNum(float num) {
        int roundDown = (int)num;
        float roundTest = num - (float)roundDown;
        if (roundTest >= 0.5f || roundDown == 0) {
            return roundDown + 1;
        }
        return roundDown;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPainting();
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        return transform;
    }

    @Override
    public void func_180654_a(IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof BiblioTileEntity) {
            BiblioTileEntity tile = (BiblioTileEntity)te;
            switch (tile.getAngle()) {
                case SOUTH: {
                    this.func_149676_a(0.92f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case WEST: {
                    this.func_149676_a(0.0f, 0.0f, 0.92f, 1.0f, 1.0f, 1.0f);
                    break;
                }
                case NORTH: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.08f, 1.0f, 1.0f);
                    break;
                }
                case EAST: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.08f);
                    break;
                }
                default: {
                    this.func_149676_a(0.0f, 0.0f, 0.0f, 0.05f, 1.0f, 1.0f);
                }
            }
        }
    }

    public AxisAlignedBB func_180640_a(World world, BlockPos pos, IBlockState state) {
        TileEntityPainting tile;
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityPainting && (tile = (TileEntityPainting)te).getHideFrame()) {
            return null;
        }
        return new AxisAlignedBB((double)pos.func_177958_n() + this.field_149759_B, (double)pos.func_177956_o() + this.field_149760_C, (double)pos.func_177952_p() + this.field_149754_D, (double)pos.func_177958_n() + this.field_149755_E, (double)pos.func_177956_o() + this.field_149756_F, (double)pos.func_177952_p() + this.field_149757_G);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropItems(world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityPainting) {
            this.disconnectFrame(world, tile.func_174877_v().func_177958_n(), tile.func_174877_v().func_177956_o(), tile.func_174877_v().func_177952_p());
        }
        super.func_180663_b(world, pos, state);
    }

    private void disconnectFrame(World world, int x, int y, int z) {
        TileEntityPainting tile = (TileEntityPainting)world.func_175625_s(new BlockPos(x, y, z));
        if (!world.field_72995_K && tile != null) {
            TileEntity tup = world.func_175625_s(new BlockPos(x, y + 1, z));
            TileEntity tdown = world.func_175625_s(new BlockPos(x, y - 1, z));
            TileEntity tleft = null;
            TileEntity tright = null;
            switch (tile.getAngle()) {
                case SOUTH: {
                    tleft = world.func_175625_s(new BlockPos(x, y, z - 1));
                    tright = world.func_175625_s(new BlockPos(x, y, z + 1));
                    break;
                }
                case WEST: {
                    tleft = world.func_175625_s(new BlockPos(x + 1, y, z));
                    tright = world.func_175625_s(new BlockPos(x - 1, y, z));
                    break;
                }
                case NORTH: {
                    tleft = world.func_175625_s(new BlockPos(x, y, z + 1));
                    tright = world.func_175625_s(new BlockPos(x, y, z - 1));
                    break;
                }
                case EAST: {
                    tleft = world.func_175625_s(new BlockPos(x - 1, y, z));
                    tright = world.func_175625_s(new BlockPos(x + 1, y, z));
                    break;
                }
                default: {
                    return;
                }
            }
            if (tup != null && tup instanceof TileEntityPainting) {
                TileEntityPainting pup = (TileEntityPainting)tup;
                if (tile.getAngle() == pup.getAngle()) {
                    pup.setConnectBottom(false);
                }
            }
            if (tdown != null && tdown instanceof TileEntityPainting) {
                TileEntityPainting pdown = (TileEntityPainting)tdown;
                if (tile.getAngle() == pdown.getAngle()) {
                    pdown.setConnectTop(false);
                }
            }
            if (tleft != null && tleft instanceof TileEntityPainting) {
                TileEntityPainting pleft = (TileEntityPainting)tleft;
                if (tile.getAngle() == pleft.getAngle()) {
                    pleft.setConnectRight(false);
                }
            }
            if (tright != null && tright instanceof TileEntityPainting) {
                TileEntityPainting pright = (TileEntityPainting)tright;
                if (tile.getAngle() == pright.getAngle()) {
                    pright.setConnectLeft(false);
                }
            }
            tile.setConnectBottom(false);
            tile.setConnectLeft(false);
            tile.setConnectRight(false);
            tile.setConnectTop(false);
            if (tile.getAngle() == EnumFacing.SOUTH || tile.getAngle() == EnumFacing.NORTH) {
                world.func_180496_d(new BlockPos(x, y + 1, z - 1), (Block)BlockPaintingFrameBorderless.instance);
                world.func_180496_d(new BlockPos(x, y + 1, z + 1), (Block)BlockPaintingFrameBorderless.instance);
                world.func_180496_d(new BlockPos(x, y - 1, z - 1), (Block)BlockPaintingFrameBorderless.instance);
                world.func_180496_d(new BlockPos(x, y - 1, z + 1), (Block)BlockPaintingFrameBorderless.instance);
            } else {
                world.func_180496_d(new BlockPos(x + 1, y + 1, z), (Block)BlockPaintingFrameBorderless.instance);
                world.func_180496_d(new BlockPos(x - 1, y + 1, z), (Block)BlockPaintingFrameBorderless.instance);
                world.func_180496_d(new BlockPos(x + 1, y - 1, z), (Block)BlockPaintingFrameBorderless.instance);
                world.func_180496_d(new BlockPos(x - 1, y - 1, z), (Block)BlockPaintingFrameBorderless.instance);
            }
        }
    }

    public void onBlockPlacedConnect(World world, int x, int y, int z, TileEntityPainting tile, boolean recurse) {
        if (!world.field_72995_K) {
            TileEntity tup = world.func_175625_s(new BlockPos(x, y + 1, z));
            TileEntity tdown = world.func_175625_s(new BlockPos(x, y - 1, z));
            TileEntity tleft = null;
            TileEntity tright = null;
            switch (tile.getAngle()) {
                case SOUTH: {
                    tleft = world.func_175625_s(new BlockPos(x, y, z - 1));
                    tright = world.func_175625_s(new BlockPos(x, y, z + 1));
                    break;
                }
                case WEST: {
                    tleft = world.func_175625_s(new BlockPos(x + 1, y, z));
                    tright = world.func_175625_s(new BlockPos(x - 1, y, z));
                    break;
                }
                case NORTH: {
                    tleft = world.func_175625_s(new BlockPos(x, y, z + 1));
                    tright = world.func_175625_s(new BlockPos(x, y, z - 1));
                    break;
                }
                case EAST: {
                    tleft = world.func_175625_s(new BlockPos(x - 1, y, z));
                    tright = world.func_175625_s(new BlockPos(x + 1, y, z));
                    break;
                }
                default: {
                    return;
                }
            }
            if (tup != null && tup instanceof TileEntityPainting) {
                TileEntityPainting pup = (TileEntityPainting)tup;
                if (tile.getAngle() == pup.getAngle()) {
                    pup.setConnectBottom(true);
                    tile.setConnectTop(true);
                    if (recurse) {
                        this.onBlockPlacedConnect(world, x, y + 1, z, pup, false);
                    }
                }
            }
            if (tdown != null && tdown instanceof TileEntityPainting) {
                TileEntityPainting pdown = (TileEntityPainting)tdown;
                if (tile.getAngle() == pdown.getAngle()) {
                    pdown.setConnectTop(true);
                    tile.setConnectBottom(true);
                    if (recurse) {
                        this.onBlockPlacedConnect(world, x, y - 1, z, pdown, false);
                    }
                }
            }
            if (tleft != null && tleft instanceof TileEntityPainting) {
                TileEntityPainting pleft = (TileEntityPainting)tleft;
                if (tile.getAngle() == pleft.getAngle()) {
                    pleft.setConnectRight(true);
                    tile.setConnectLeft(true);
                    if (recurse) {
                        switch (tile.getAngle()) {
                            case SOUTH: {
                                this.onBlockPlacedConnect(world, x, y, z - 1, pleft, false);
                                break;
                            }
                            case WEST: {
                                this.onBlockPlacedConnect(world, x + 1, y, z, pleft, false);
                                break;
                            }
                            case NORTH: {
                                this.onBlockPlacedConnect(world, x, y, z + 1, pleft, false);
                                break;
                            }
                            case EAST: {
                                this.onBlockPlacedConnect(world, x - 1, y, z, pleft, false);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                }
            }
            if (tright != null && tright instanceof TileEntityPainting) {
                TileEntityPainting pright = (TileEntityPainting)tright;
                if (tile.getAngle() == pright.getAngle()) {
                    pright.setConnectLeft(true);
                    tile.setConnectRight(true);
                    if (recurse) {
                        switch (tile.getAngle()) {
                            case SOUTH: {
                                this.onBlockPlacedConnect(world, x, y, z + 1, pright, false);
                                break;
                            }
                            case WEST: {
                                this.onBlockPlacedConnect(world, x - 1, y, z, pright, false);
                                break;
                            }
                            case NORTH: {
                                this.onBlockPlacedConnect(world, x, y, z - 1, pright, false);
                                break;
                            }
                            case EAST: {
                                this.onBlockPlacedConnect(world, x + 1, y, z, pright, false);
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                    }
                }
            }
        }
    }
}

