/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityPotionShelf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.TRSRTransformation;

public class BlockPotionShelf
extends BiblioWoodBlock {
    public static final String name = "PotionShelf";
    public static final BlockPotionShelf instance = new BlockPotionShelf();

    public BlockPotionShelf() {
        super(name, true);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            ItemStack playerhand = player.func_70694_bm();
            BiblioTileEntity tile = (BiblioTileEntity)world.func_175625_s(pos);
            if (tile != null) {
                int potionSlot = BlockPotionShelf.getPotionShelfSlot(tile.getAngle(), side, hitX, hitY, hitZ);
                if (potionSlot >= 0 && player.func_70093_af() && tile.func_70301_a(potionSlot) != null && tile.removeStackFromInventoryFromWorld(potionSlot, player, this)) {
                    return true;
                }
                if (potionSlot >= 0 && playerhand != null && Config.testPotionValidity(playerhand.func_77977_a(), playerhand.func_82833_r(), playerhand.func_77973_b()) && tile.addStackToInventoryFromWorld(playerhand, potionSlot, player)) {
                    return true;
                }
            }
            player.openGui((Object)BiblioCraft.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public static int getPotionShelfSlot(EnumFacing angle, EnumFacing hitSide, float hitX, float hitY, float hitZ) {
        int output = -1;
        if (BlockPotionShelf.isFrontOfBlock(hitSide, angle)) {
            output = BlockPotionShelf.isWhatShelf(hitY) + BlockPotionShelf.isWhatPot(hitSide, hitX, hitZ);
        } else if (BlockPotionShelf.isBackOfBlock(hitSide, angle)) {
            EnumFacing invertedSide = hitSide;
            switch (hitSide) {
                case SOUTH: {
                    invertedSide = EnumFacing.NORTH;
                    break;
                }
                case WEST: {
                    invertedSide = EnumFacing.EAST;
                    break;
                }
                case NORTH: {
                    invertedSide = EnumFacing.SOUTH;
                    break;
                }
                case EAST: {
                    invertedSide = EnumFacing.WEST;
                    break;
                }
            }
            output = BlockPotionShelf.isWhatShelf(hitY) + BlockPotionShelf.isWhatPot(invertedSide, hitX, hitZ);
        }
        return output;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPotionShelf();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList modelParts = Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"});
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(-0.0f, 0.0f, -0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        return transform;
    }

    private static int isWhatShelf(float hitY) {
        int yt = (int)(hitY * 3.0f);
        switch (yt) {
            case 0: {
                return 8;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    private static int isWhatPot(EnumFacing angle, float hitX, float hitZ) {
        int xt = (int)(hitX * 4.0f);
        int zt = (int)(hitZ * 4.0f);
        switch (angle) {
            case WEST: {
                return zt;
            }
            case NORTH: {
                switch (xt) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
            }
            case EAST: {
                switch (zt) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 0;
                    }
                }
            }
            case SOUTH: {
                return xt;
            }
        }
        return 0;
    }
}

