/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.helpers.EnumColor;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.states.TextureState;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityTable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.TRSRTransformation;

public class BlockTable
extends BiblioWoodBlock {
    public static final String name = "Table";
    public static final BlockTable instance = new BlockTable();

    public BlockTable() {
        super(name, false);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            String itemname;
            ItemStack playerhand = player.func_70694_bm();
            TileEntityTable tabletile = (TileEntityTable)world.func_175625_s(pos);
            if (side == EnumFacing.UP) {
                if (player.func_70093_af()) {
                    player.openGui((Object)BiblioCraft.instance, 9, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                if (tabletile != null) {
                    if (playerhand != null) {
                        if (playerhand.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
                            int additem = tabletile.setTableCloth(playerhand);
                            if (additem != -1) {
                                if (additem == 0) {
                                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                                } else {
                                    playerhand.field_77994_a = additem;
                                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerhand);
                                }
                            }
                            return true;
                        }
                        Item drilltest = playerhand.func_77973_b();
                        if (drilltest != null && drilltest instanceof ItemDrill) {
                            this.dropStackInSlot(world, pos, 1, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
                            tabletile.setTableCloth(null);
                            return false;
                        }
                    }
                    if (playerhand != null && !tabletile.isSlotFull()) {
                        tabletile.addStackToInventoryFromWorld(playerhand, 0, player);
                        return true;
                    }
                    if (tabletile.isSlotFull()) {
                        this.dropStackInSlot(world, pos, 0, new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
                        tabletile.setTableSlot(null);
                        return true;
                    }
                }
                return true;
            }
            if (playerhand != null && playerhand.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150404_cg)) {
                int additem = tabletile.setCarpet(playerhand);
                if (additem != -1) {
                    if (additem == 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    } else {
                        playerhand.field_77994_a = additem;
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, playerhand);
                    }
                }
                return true;
            }
            if (playerhand != null && tabletile != null && ((itemname = playerhand.toString().toLowerCase()).contains("measure") || itemname.contains("wrench") || itemname.contains("screwdriver") || itemname.contains("crowbar") || itemname.contains("bibliodrill") || itemname.contains("handdrill"))) {
                if (side == EnumFacing.NORTH || side == EnumFacing.SOUTH) {
                    int xangle = tabletile.getSlotX();
                    switch (xangle) {
                        case 0: {
                            tabletile.setSlotX(1);
                            break;
                        }
                        case 1: {
                            tabletile.setSlotX(2);
                            break;
                        }
                        case 2: {
                            tabletile.setSlotX(3);
                            break;
                        }
                        default: {
                            tabletile.setSlotX(0);
                        }
                    }
                }
                if (side == EnumFacing.EAST || side == EnumFacing.WEST) {
                    int yangle = tabletile.getSlotY();
                    switch (yangle) {
                        case 0: {
                            tabletile.setSlotY(1);
                            break;
                        }
                        case 1: {
                            tabletile.setSlotY(2);
                            break;
                        }
                        case 2: {
                            tabletile.setSlotY(3);
                            break;
                        }
                        default: {
                            tabletile.setSlotY(0);
                        }
                    }
                }
            }
        }
        return true;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityTable();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("monoleg");
        modelParts.add("tableBevel01");
        modelParts.add("tableBevel02");
        modelParts.add("tableBevel03");
        modelParts.add("tableBevel04");
        if (tile instanceof TileEntityTable) {
            TileEntityTable table = (TileEntityTable)tile;
            modelParts = new ArrayList();
            if (table.getMonoleg()) {
                modelParts.add("monoleg");
            }
            if (table.getLeg1()) {
                modelParts.add("leg01");
            }
            if (table.getLeg2()) {
                modelParts.add("leg02");
            }
            if (table.getLeg3()) {
                modelParts.add("leg03");
            }
            if (table.getLeg4()) {
                modelParts.add("leg04");
            }
            if (table.getTop1()) {
                modelParts.add("tableBevel01");
                if (table.isClothSlotFull()) {
                    modelParts.add("bevCloth001");
                }
            } else {
                modelParts.add("tableSquare01");
                if (table.isClothSlotFull()) {
                    modelParts.add("squareCloth01");
                    if (table.getExpSide1()) {
                        modelParts.add("squareClothSide001a");
                    }
                    if (table.getExpSide4()) {
                        modelParts.add("squareClothSide001b");
                    }
                }
            }
            if (table.getTop2()) {
                modelParts.add("tableBevel02");
                if (table.isClothSlotFull()) {
                    modelParts.add("bevCloth004");
                }
            } else {
                modelParts.add("tableSquare02");
                if (table.isClothSlotFull()) {
                    modelParts.add("squareCloth004");
                    if (table.getExpSide1()) {
                        modelParts.add("squareClothSide004b");
                    }
                    if (table.getExpSide3()) {
                        modelParts.add("squareClothSide004a");
                    }
                }
            }
            if (table.getTop3()) {
                modelParts.add("tableBevel03");
                if (table.isClothSlotFull()) {
                    modelParts.add("bevCloth003");
                }
            } else {
                modelParts.add("tableSquare03");
                if (table.isClothSlotFull()) {
                    modelParts.add("squareCloth003");
                    if (table.getExpSide2()) {
                        modelParts.add("squareClothSide003a");
                    }
                    if (table.getExpSide3()) {
                        modelParts.add("squareClothSide003b");
                    }
                }
            }
            if (table.getTop4()) {
                modelParts.add("tableBevel04");
                if (table.isClothSlotFull()) {
                    modelParts.add("bevCloth002");
                }
            } else {
                modelParts.add("tableSquare04");
                if (table.isClothSlotFull()) {
                    modelParts.add("squareCloth002");
                    if (table.getExpSide2()) {
                        modelParts.add("squareClothSide002b");
                    }
                    if (table.getExpSide4()) {
                        modelParts.add("squareClothSide002a");
                    }
                }
            }
            if (table.isCarpetFull()) {
                modelParts.add("carpet");
            }
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
        biblioTile.setAngle(EnumFacing.SOUTH);
        if (biblioTile instanceof TileEntityTable) {
            this.checkNeighborTables(biblioTile.func_145831_w(), biblioTile.func_174877_v().func_177958_n(), biblioTile.func_174877_v().func_177956_o(), biblioTile.func_174877_v().func_177952_p(), (TileEntityTable)biblioTile);
        }
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(-0.0f, 0.0f, -0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f)));
        return transform;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP;
    }

    @Override
    public void func_180654_a(IBlockAccess blockAccess, BlockPos pos) {
        TileEntity tilee = blockAccess.func_175625_s(pos);
        if (tilee != null && tilee instanceof TileEntityTable) {
            TileEntityTable tile = (TileEntityTable)tilee;
            boolean leg1 = tile.getLeg1();
            boolean leg2 = tile.getLeg2();
            boolean leg3 = tile.getLeg3();
            boolean leg4 = tile.getLeg4();
            boolean legMono = tile.getMonoleg();
            if (!(leg1 || leg2 || leg3 || leg4 || legMono)) {
                this.func_149676_a(0.0f, 0.88f, 0.0f, 1.0f, 1.0f, 1.0f);
                return;
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityTable) {
            TileEntityTable tabletile = (TileEntityTable)world.func_175625_s(pos);
            this.checkNeighborTables(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), tabletile);
            world.func_175689_h(pos);
        }
    }

    public void checkNeighborTables(World world, int x, int y, int z, TileEntityTable table) {
        Block blockid1 = world.func_180495_p(new BlockPos(x + 1, y, z)).func_177230_c();
        Block blockid2 = world.func_180495_p(new BlockPos(x - 1, y, z)).func_177230_c();
        Block blockid3 = world.func_180495_p(new BlockPos(x, y, z + 1)).func_177230_c();
        Block blockid4 = world.func_180495_p(new BlockPos(x, y, z - 1)).func_177230_c();
        if (blockid1 instanceof BlockTable || blockid2 instanceof BlockTable || blockid3 instanceof BlockTable || blockid4 instanceof BlockTable) {
            boolean l1 = true;
            boolean l2 = true;
            boolean l3 = true;
            boolean l4 = true;
            boolean t1 = true;
            boolean t2 = true;
            boolean t3 = true;
            boolean t4 = true;
            boolean ml = false;
            boolean expside1 = false;
            boolean expside2 = false;
            boolean expside3 = false;
            boolean expside4 = false;
            if (blockid1 instanceof BlockTable) {
                l1 = false;
                l2 = false;
                t1 = false;
                t2 = false;
            } else {
                expside1 = true;
            }
            if (blockid2 instanceof BlockTable) {
                l3 = false;
                l4 = false;
                t3 = false;
                t4 = false;
            } else {
                expside2 = true;
            }
            if (blockid3 instanceof BlockTable) {
                l2 = false;
                l3 = false;
                t2 = false;
                t3 = false;
            } else {
                expside3 = true;
            }
            if (blockid4 instanceof BlockTable) {
                l1 = false;
                l4 = false;
                t1 = false;
                t4 = false;
            } else {
                expside4 = true;
            }
            table.setLegs(l1, l2, l3, l4, ml);
            table.setTops(t1, t2, t3, t4);
            table.setExposeSides(expside1, expside2, expside3, expside4);
        } else {
            table.setLegs(false, false, false, false, true);
            table.setTops(true, true, true, true);
        }
    }

    @Override
    public TextureState addAdditionTextureStateInformation(BiblioTileEntity tile, TextureState state) {
        ItemStack cloth = tile.func_70301_a(1);
        ItemStack carpet = tile.func_70301_a(2);
        if (cloth != null) {
            state.setColorOne(EnumColor.getColorFromCarpetOrWool(cloth));
        }
        if (carpet != null) {
            state.setColorTwo(EnumColor.getColorFromCarpetOrWool(carpet));
        }
        return state;
    }
}

