/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.events;

import java.util.ArrayList;
import jds.bibliocraft.blocks.BiblioBlock;
import jds.bibliocraft.blocks.BlockBookcase;
import jds.bibliocraft.blocks.BlockDiscRack;
import jds.bibliocraft.blocks.BlockFurniturePaneler;
import jds.bibliocraft.blocks.BlockPotionShelf;
import jds.bibliocraft.blocks.BlockPrintingPress;
import jds.bibliocraft.blocks.BlockTypesettingTable;
import jds.bibliocraft.entity.EntityCatalogFX;
import jds.bibliocraft.helpers.BiblioSortingHelper;
import jds.bibliocraft.items.ItemReadingGlasses;
import jds.bibliocraft.items.ItemStockroomCatalog;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityArmorStand;
import jds.bibliocraft.tileentities.TileEntityBookcase;
import jds.bibliocraft.tileentities.TileEntityCase;
import jds.bibliocraft.tileentities.TileEntityDesk;
import jds.bibliocraft.tileentities.TileEntityDinnerPlate;
import jds.bibliocraft.tileentities.TileEntityDiscRack;
import jds.bibliocraft.tileentities.TileEntityFancyWorkbench;
import jds.bibliocraft.tileentities.TileEntityFramedChest;
import jds.bibliocraft.tileentities.TileEntityFurniturePaneler;
import jds.bibliocraft.tileentities.TileEntityLabel;
import jds.bibliocraft.tileentities.TileEntityPotionShelf;
import jds.bibliocraft.tileentities.TileEntityPrintPress;
import jds.bibliocraft.tileentities.TileEntityShelf;
import jds.bibliocraft.tileentities.TileEntitySwordPedestal;
import jds.bibliocraft.tileentities.TileEntityTable;
import jds.bibliocraft.tileentities.TileEntityToolRack;
import jds.bibliocraft.tileentities.TileEntityTypeMachine;
import jds.bibliocraft.tileentities.TileEntityTypewriter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventBlockMarkerHighlight {
    private Minecraft mc = Minecraft.func_71410_x();
    private int counter = 0;
    private int particle = 0;

    @SubscribeEvent
    public void DrawBlockHighlightEvent(DrawBlockHighlightEvent event) {
        BiblioTileEntity tile;
        if (this.counter >= 80) {
            NBTTagList invList;
            NBTTagCompound tags;
            ItemStack playerhand = event.player.func_70694_bm();
            if (playerhand != null && playerhand.func_77973_b() instanceof ItemStockroomCatalog && (tags = playerhand.func_77978_p()) != null && (invList = tags.func_150295_c("inventoryList", 10)) != null && invList.func_74745_c() > 0) {
                for (int i = 0; i < invList.func_74745_c(); ++i) {
                    NBTTagCompound invTag = invList.func_150305_b(i);
                    if (invTag == null || !invTag.func_74764_b("x") || !invTag.func_74764_b("y") || !invTag.func_74764_b("z") || (tile = event.player.field_70170_p.func_175625_s(new BlockPos(invTag.func_74762_e("x"), invTag.func_74762_e("y"), invTag.func_74762_e("z")))) == null) continue;
                    this.spawnParticle(event.player.field_70170_p, invTag.func_74762_e("x"), invTag.func_74762_e("y"), invTag.func_74762_e("z"));
                }
            }
            this.counter = 0;
        } else {
            ++this.counter;
        }
        ItemStack headArmor = event.player.func_82169_q(3);
        if (headArmor != null && headArmor.func_77973_b() instanceof ItemReadingGlasses) {
            NBTTagCompound armorTags;
            TileEntity te;
            boolean hasText = false;
            BlockPos pos = event.target.func_178782_a();
            if (pos != null && (te = event.player.field_70170_p.func_175625_s(pos)) != null && te instanceof BiblioTileEntity) {
                ItemStack stack;
                TileEntityFramedChest chest;
                ArrayList<String> display = new ArrayList<String>();
                tile = (BiblioTileEntity)te;
                float hitX = (float)(event.target.field_72307_f.field_72450_a - (double)event.target.func_178782_a().func_177958_n());
                float hitY = (float)(event.target.field_72307_f.field_72448_b - (double)event.target.func_178782_a().func_177956_o());
                float hitZ = (float)(event.target.field_72307_f.field_72449_c - (double)event.target.func_178782_a().func_177952_p());
                boolean isFront = BiblioBlock.isBackOfBlock(tile.getAngle(), event.target.field_178784_b);
                int slot = -1;
                if (tile instanceof TileEntityBookcase && isFront) {
                    int yCheck = (int)(hitY * 2.0f);
                    slot = BlockBookcase.isWhatBook(tile.getAngle(), hitX, hitZ);
                    if (yCheck == 0) {
                        slot += 8;
                    }
                }
                if (tile instanceof TileEntityShelf || tile instanceof TileEntityToolRack) {
                    slot = BiblioBlock.getSlotNumberFromClickon2x2block(tile.getAngle(), hitX, hitY, hitZ);
                }
                if (tile instanceof TileEntityFancyWorkbench && isFront && hitY > 0.22f && hitY < 0.74f) {
                    slot = BlockBookcase.isWhatBook(tile.getAngle(), hitX, hitZ);
                    ++slot;
                }
                if ((tile instanceof TileEntityDesk || tile instanceof TileEntityTable) && event.target.field_178784_b == EnumFacing.UP) {
                    slot = 0;
                }
                if (tile instanceof TileEntityCase || tile instanceof TileEntitySwordPedestal || tile instanceof TileEntityTypewriter) {
                    slot = 0;
                }
                if (tile instanceof TileEntityPotionShelf) {
                    slot = BlockPotionShelf.getPotionShelfSlot(tile.getAngle(), event.target.field_178784_b, hitX, hitY, hitZ);
                }
                if (tile instanceof TileEntityLabel) {
                    float aimpos = 0.0f;
                    if (tile.func_70301_a(1) == null && tile.func_70301_a(2) == null) {
                        slot = 0;
                    } else {
                        switch (tile.getAngle()) {
                            case SOUTH: {
                                aimpos = hitZ;
                                break;
                            }
                            case WEST: {
                                aimpos = 1.0f - hitX;
                                break;
                            }
                            case NORTH: {
                                aimpos = 1.0f - hitZ;
                                break;
                            }
                            case EAST: {
                                aimpos = hitX;
                                break;
                            }
                        }
                        slot = aimpos < 0.42f ? 1 : (aimpos < 0.56f ? 0 : 2);
                    }
                }
                if (tile instanceof TileEntityFramedChest && (chest = (TileEntityFramedChest)tile) != null) {
                    slot = BiblioSortingHelper.getLargestStackSlotInList(BiblioSortingHelper.getStackForBuiltinLabel(chest));
                }
                if (tile instanceof TileEntityArmorStand) {
                    TileEntityArmorStand stand = (TileEntityArmorStand)tile;
                    if (stand.getIsBottomStand()) {
                        slot = hitY > 0.5f ? 2 : 3;
                    } else {
                        tile = (BiblioTileEntity)event.player.field_70170_p.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
                        if (tile == null) {
                            return;
                        }
                        slot = hitY > 0.5f ? 0 : 1;
                    }
                }
                if (tile instanceof TileEntityTypeMachine) {
                    TileEntityTypeMachine type = (TileEntityTypeMachine)tile;
                    slot = BlockTypesettingTable.getSlot((TileEntityTypeMachine)tile, event.target.field_178784_b, hitX, hitZ);
                    if (type.getLevels() > 0 && (type.enchantedBookCheck() || type.atlasBookCheck()) && slot == 0) {
                        display.add(EnumChatFormatting.LIGHT_PURPLE + StatCollector.func_74838_a((String)"typesetting.requires") + " " + type.getLevels() + " " + StatCollector.func_74838_a((String)"typesetting.levels"));
                    } else {
                        display.add(StatCollector.func_74838_a((String)"typesetting.selectbook") + ": " + type.getBookname());
                    }
                }
                if (tile instanceof TileEntityPrintPress) {
                    slot = BlockPrintingPress.getSlot((TileEntityPrintPress)tile, event.target.field_178784_b, hitX, hitZ);
                }
                if (tile instanceof TileEntityDinnerPlate) {
                    if (tile.func_70301_a(0) != null) {
                        slot = 0;
                    } else if (tile.func_70301_a(1) != null) {
                        slot = 1;
                    } else if (tile.func_70301_a(2) != null) {
                        slot = 2;
                    }
                }
                if (tile instanceof TileEntityDiscRack) {
                    slot = BlockDiscRack.getDiscSlot(hitX, hitY, hitZ, tile.getAngle(), tile.getVertPosition(), ((TileEntityDiscRack)tile).getWallRotation());
                }
                if (tile instanceof TileEntityFurniturePaneler) {
                    slot = BlockFurniturePaneler.checkTopClickedPlace(tile.getAngle(), hitX, hitY, hitZ);
                }
                if (slot >= 0 && slot < tile.func_70302_i_() && (stack = tile.func_70301_a(slot)) != null) {
                    NBTTagCompound tags;
                    ItemRecord record;
                    int stacksize = stack.field_77994_a;
                    if (stacksize > 1) {
                        display.add(stacksize + " " + stack.func_82833_r());
                    } else {
                        display.add(stack.func_82833_r());
                    }
                    if (stack.func_77973_b() instanceof ItemRecord && (record = (ItemRecord)stack.func_77973_b()) != null) {
                        display.add(record.func_150927_i());
                    }
                    if ((tags = stack.func_77978_p()) != null) {
                        if (tags.func_74764_b("bookName")) {
                            display.add(tags.func_74779_i("bookName"));
                        }
                        if (tags.func_74764_b("author")) {
                            display.add("by " + tags.func_74779_i("author"));
                        }
                        if (tags.func_74764_b("ench")) {
                            NBTTagList enchantments = (NBTTagList)stack.func_77978_p().func_74781_a("ench");
                            for (int i = 0; i < enchantments.func_74745_c(); ++i) {
                                short id = enchantments.func_150305_b(i).func_74765_d("id");
                                short lvl = enchantments.func_150305_b(i).func_74765_d("lvl");
                                String name = Enchantment.func_180306_c((int)id).func_77316_c((int)lvl);
                                if (name == null || name.length() <= 0) continue;
                                display.add(EnumChatFormatting.LIGHT_PURPLE + name);
                            }
                        }
                    }
                }
                if (display != null && !display.isEmpty()) {
                    NBTTagCompound armorTags2 = headArmor.func_77978_p();
                    if (armorTags2 == null) {
                        armorTags2 = new NBTTagCompound();
                    }
                    NBTTagList names = new NBTTagList();
                    for (int i = 0; i < display.size(); ++i) {
                        names.func_74742_a((NBTBase)new NBTTagString((String)display.get(i)));
                    }
                    armorTags2.func_74782_a("text", (NBTBase)names);
                    headArmor.func_77982_d(armorTags2);
                    event.player.func_70062_b(4, headArmor);
                    hasText = true;
                }
            }
            if (!hasText && (armorTags = headArmor.func_77978_p()) != null) {
                NBTTagList names = new NBTTagList();
                armorTags.func_74782_a("text", (NBTBase)names);
                headArmor.func_77982_d(armorTags);
                event.player.func_70062_b(4, headArmor);
            }
        }
    }

    private void spawnParticle(World world, double x, double y, double z) {
        EntityCatalogFX fx = new EntityCatalogFX(world, x + 0.5, y + 0.5, z + 0.5);
        double motion = 0.07;
        double altMotion = 0.01;
        switch (this.particle) {
            case 0: {
                fx.field_70159_w = motion;
                fx.field_70181_x = altMotion;
                fx.field_70179_y = altMotion;
                this.mc.field_71452_i.func_78873_a((EntityFX)fx);
                break;
            }
            case 1: {
                fx = new EntityCatalogFX(world, x + 0.5, y + 0.5, z + 0.5);
                fx.field_70159_w = -motion;
                fx.field_70181_x = altMotion;
                fx.field_70179_y = altMotion;
                this.mc.field_71452_i.func_78873_a((EntityFX)fx);
                break;
            }
            case 2: {
                fx = new EntityCatalogFX(world, x + 0.5, y + 0.5, z + 0.5);
                fx.field_70159_w = altMotion;
                fx.field_70181_x = motion;
                fx.field_70179_y = altMotion;
                this.mc.field_71452_i.func_78873_a((EntityFX)fx);
                break;
            }
            case 3: {
                fx = new EntityCatalogFX(world, x + 0.5, y + 0.5, z + 0.5);
                fx.field_70159_w = altMotion;
                fx.field_70181_x = altMotion;
                fx.field_70179_y = motion;
                this.mc.field_71452_i.func_78873_a((EntityFX)fx);
                break;
            }
            case 4: {
                fx = new EntityCatalogFX(world, x + 0.5, y + 0.5, z + 0.5);
                fx.field_70159_w = altMotion;
                fx.field_70181_x = altMotion;
                fx.field_70179_y = -motion;
                this.mc.field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
        this.particle = this.particle >= 4 ? 0 : ++this.particle;
    }
}

