/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.models;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.states.TextureProperty;
import jds.bibliocraft.states.TextureState;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public abstract class BiblioModelWood
implements IBakedModel,
ISmartBlockModel,
ISmartItemModel,
IPerspectiveAwareModel {
    private IModel model = null;
    private IBakedModel baseModel;
    private String modelLocation = " ";
    private String textureLocation = "none";
    private String customTextureLocation = "none";
    private BiblioWoodBlock.EnumWoodType wood;
    protected Function<ResourceLocation, TextureAtlasSprite> textureGetter = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(BiblioModelWood.this.getTextureLocation(location.toString(), BiblioModelWood.this.textureLocation));
        }
    };

    public BiblioModelWood(String modelLoc) {
        this.modelLocation = modelLoc;
    }

    private void getModel(IBlockState state, boolean isBlock) {
        if (this.model == null) {
            try {
                this.model = ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation(this.modelLocation));
            }
            catch (IOException e) {
                this.model = ModelLoaderRegistry.getMissingModel();
            }
        }
        IModel newModel = ((IModelCustomData)this.model).process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        OBJModel.OBJState modelState = new OBJModel.OBJState(this.getDefaultVisiableModelParts(), true);
        if (state != null && state instanceof IExtendedBlockState) {
            IExtendedBlockState exState = (IExtendedBlockState)state;
            if (exState.getUnlistedNames().contains(OBJModel.OBJProperty.instance)) {
                modelState = (OBJModel.OBJState)exState.getValue((IUnlistedProperty)OBJModel.OBJProperty.instance);
            }
            if (exState.getUnlistedNames().contains((Object)TextureProperty.instance)) {
                TextureState texString = (TextureState)exState.getValue((IUnlistedProperty)TextureProperty.instance);
                this.loadAdditionalTextureStateStuff(texString);
                this.customTextureLocation = texString.getTextureString();
            }
            this.getAdditionalBlockStateStuff(exState);
            this.wood = (BiblioWoodBlock.EnumWoodType)((Object)state.func_177229_b((IProperty)BiblioWoodBlock.WOOD_TYPE));
        } else {
            this.loadAdditionalTextureStateStuff(null);
        }
        switch (this.wood) {
            case OAK: {
                this.textureLocation = "minecraft:blocks/planks_oak";
                break;
            }
            case SPRUCE: {
                this.textureLocation = "minecraft:blocks/planks_spruce";
                break;
            }
            case BIRCH: {
                this.textureLocation = "minecraft:blocks/planks_birch";
                break;
            }
            case JUNGLE: {
                this.textureLocation = "minecraft:blocks/planks_jungle";
                break;
            }
            case ACACIA: {
                this.textureLocation = "minecraft:blocks/planks_acacia";
                break;
            }
            case DARKOAK: {
                this.textureLocation = "minecraft:blocks/planks_big_oak";
                break;
            }
            case FRAME: {
                if (this.customTextureLocation.contains("none") || this.customTextureLocation.contains("minecraft:white") || this.customTextureLocation.length() == 0) {
                    this.textureLocation = "bibliocraft:blocks/frame";
                    break;
                }
                this.textureLocation = this.customTextureLocation;
                break;
            }
            default: {
                this.textureLocation = "minecraft:blocks/planks_oak";
            }
        }
        IFlexibleBakedModel bakedModel = newModel.bake((IModelState)modelState, DefaultVertexFormats.field_176599_b, this.textureGetter);
        this.baseModel = bakedModel;
    }

    public void loadAdditionalTextureStateStuff(TextureState state) {
    }

    public void getAdditionalBlockStateStuff(IExtendedBlockState state) {
    }

    public abstract String getTextureLocation(String var1, String var2);

    public List<String> getDefaultVisiableModelParts() {
        return Lists.newArrayList((Object[])new String[]{"OBJModel.Group.All.Key"});
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_177553_d() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.baseModel.func_177554_e();
    }

    public List<BakedQuad> func_177551_a(EnumFacing face) {
        return this.baseModel.func_177551_a(face);
    }

    public List<BakedQuad> func_177550_a() {
        return this.baseModel.func_177550_a();
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public VertexFormat getFormat() {
        return Attributes.DEFAULT_BAKED_FORMAT;
    }

    public IBakedModel handleItemState(ItemStack stack) {
        NBTTagCompound tags;
        this.wood = BiblioWoodBlock.EnumWoodType.getEnum(stack.func_77952_i());
        this.customTextureLocation = "none";
        if (stack != null && (tags = stack.func_77978_p()) != null && tags.func_74764_b("renderTexture")) {
            this.customTextureLocation = tags.func_74779_i("renderTexture");
        }
        this.getModel(null, false);
        return this;
    }

    public IBakedModel handleBlockState(IBlockState state) {
        this.customTextureLocation = "none";
        this.getModel(state, true);
        return this;
    }

    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        TRSRTransformation transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
        switch (cameraTransformType) {
            case FIRST_PERSON: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.1f, -0.1f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f));
                break;
            }
            case THIRD_PERSON: {
                transform = new TRSRTransformation(new Vector3f(0.1f, 0.1f, -0.1f), new Quat4f(0.0f, -0.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 0.5f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(1.0f, 0.0f, 0.0f, 1.0f)));
                break;
            }
            case GUI: {
                transform = new TRSRTransformation(new Vector3f(-0.12f, -0.1f, 0.0f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.1f, 1.1f, 1.1f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                transform = this.getTweakedGUITransform(transform);
                break;
            }
            case GROUND: {
                transform = new TRSRTransformation(new Vector3f(0.15f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case FIXED: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, -0.15f), new Quat4f(0.0f, 1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
                break;
            }
            case NONE: {
                transform = new TRSRTransformation(new Vector3f(0.0f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f));
            }
        }
        transform = this.getTweakedMasterTransfer(transform);
        return Pair.of((Object)this, (Object)transform.getMatrix());
    }

    public TRSRTransformation getTweakedMasterTransfer(TRSRTransformation transform) {
        return transform;
    }

    public TRSRTransformation getTweakedGUITransform(TRSRTransformation transform) {
        return transform;
    }
}

